/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.AlignExportSettingI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureSettingsModelI;
import jalview.io.DataSourceType;
import jalview.util.MessageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.GZIPInputStream;

public class FileParse {
    protected static final String SPACE = " ";
    protected static final String TAB = "\t";
    private String dataName = "unknown source";
    public File inFile = null;
    private AlignViewportI viewport;
    private AlignExportSettingI exportSettings;
    public int index = 1;
    protected char suffixSeparator = (char)35;
    protected String newline = System.getProperty("line.separator");
    protected String suffix = null;
    protected DataSourceType dataSourceType = null;
    protected BufferedReader dataIn = null;
    protected String errormessage = "UNINITIALISED SOURCE";
    protected boolean error = true;
    protected String warningMessage = null;
    final int READAHEAD_LIMIT = 2048;

    public void setNewlineString(String nl) {
        this.newline = nl;
    }

    public String getNewlineString() {
        return this.newline;
    }

    public FileParse() {
    }

    public FileParse(FileParse from) throws IOException {
        if (from == null) {
            throw new Error(MessageManager.getString("error.implementation_error_null_fileparse"));
        }
        if (from == this) {
            return;
        }
        this.index = ++from.index;
        this.inFile = from.inFile;
        this.suffixSeparator = from.suffixSeparator;
        this.suffix = from.suffix;
        this.errormessage = from.errormessage;
        this.error = false;
        this.dataSourceType = from.dataSourceType;
        this.dataIn = from.dataIn;
        if (this.dataIn != null) {
            this.mark();
        }
        this.dataName = from.dataName;
    }

    private boolean checkFileSource(String fileStr) throws IOException {
        this.error = false;
        this.inFile = new File(fileStr);
        if (!this.inFile.exists()) {
            this.errormessage = "FILE NOT FOUND";
            this.error = true;
        }
        if (!this.inFile.canRead()) {
            this.errormessage = "FILE CANNOT BE OPENED FOR READING";
            this.error = true;
        }
        if (this.inFile.isDirectory()) {
            this.errormessage = "FILE IS A DIRECTORY";
            this.error = true;
        }
        if (!this.error) {
            if (fileStr.toLowerCase().endsWith(".gz")) {
                try {
                    this.dataIn = this.tryAsGzipSource(new FileInputStream(fileStr));
                    this.dataName = fileStr;
                    return this.error;
                }
                catch (Exception x) {
                    this.warningMessage = "Failed  to resolve as a GZ stream (" + x.getMessage() + ")";
                }
            }
            this.dataIn = new BufferedReader(new FileReader(fileStr));
            this.dataName = fileStr;
        }
        return this.error;
    }

    private BufferedReader tryAsGzipSource(InputStream inputStream) throws Exception {
        BufferedReader inData = new BufferedReader(new InputStreamReader(new GZIPInputStream(inputStream)));
        inData.mark(2048);
        inData.read();
        inData.reset();
        return inData;
    }

    private boolean checkURLSource(String fileStr) throws IOException, MalformedURLException {
        this.errormessage = "URL NOT FOUND";
        URL url = new URL(fileStr);
        Exception e = null;
        if (fileStr.toLowerCase().endsWith(".gz")) {
            try {
                InputStream inputStream = url.openStream();
                this.dataIn = this.tryAsGzipSource(inputStream);
                this.dataName = fileStr;
                return false;
            }
            catch (Exception ex) {
                e = ex;
            }
        }
        try {
            this.dataIn = new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (IOException q) {
            if (e != null) {
                throw new IOException(MessageManager.getString("exception.failed_to_resolve_gzip_stream"), e);
            }
            throw q;
        }
        this.dataName = fileStr;
        return false;
    }

    private String extractSuffix(String fileStr) {
        int sfpos = fileStr.lastIndexOf(this.suffixSeparator);
        if (sfpos > -1 && sfpos < fileStr.length() - 1) {
            this.suffix = fileStr.substring(sfpos + 1);
            return fileStr.substring(0, sfpos);
        }
        return null;
    }

    public FileParse(BufferedReader source, String originString, DataSourceType sourceType) {
        this.dataSourceType = sourceType;
        this.error = false;
        this.inFile = null;
        this.dataName = originString;
        this.dataIn = source;
        try {
            if (this.dataIn.markSupported()) {
                this.dataIn.mark(2048);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileParse(String fileStr, DataSourceType sourceType) throws MalformedURLException, IOException {
        this.dataSourceType = sourceType;
        this.error = false;
        if (sourceType == DataSourceType.FILE) {
            if (this.checkFileSource(fileStr)) {
                String suffixLess = this.extractSuffix(fileStr);
                if (suffixLess == null) throw new IOException(MessageManager.formatMessage("exception.problem_opening_file", new String[]{this.inFile.getName(), this.errormessage}));
                if (this.checkFileSource(suffixLess)) {
                    throw new IOException(MessageManager.formatMessage("exception.problem_opening_file_also_tried", new String[]{this.inFile.getName(), suffixLess, this.errormessage}));
                }
            }
        } else if (sourceType == DataSourceType.URL) {
            try {
                try {
                    this.checkURLSource(fileStr);
                    if (this.suffixSeparator == '#') {
                        this.extractSuffix(fileStr);
                    }
                }
                catch (IOException e) {
                    String suffixLess = this.extractSuffix(fileStr);
                    if (suffixLess == null) {
                        throw e;
                    }
                    try {
                        this.checkURLSource(suffixLess);
                    }
                    catch (IOException e2) {
                        this.errormessage = "BAD URL WITH OR WITHOUT SUFFIX";
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                this.errormessage = "CANNOT ACCESS DATA AT URL '" + fileStr + "' (" + e.getMessage() + ")";
                this.error = true;
            }
        } else if (sourceType == DataSourceType.PASTE) {
            this.errormessage = "PASTE INACCESSIBLE!";
            this.dataIn = new BufferedReader(new StringReader(fileStr));
            this.dataName = "Paste";
        } else if (sourceType == DataSourceType.CLASSLOADER) {
            String suffixLess;
            this.errormessage = "RESOURCE CANNOT BE LOCATED";
            InputStream is = this.getClass().getResourceAsStream("/" + fileStr);
            if (is == null && (suffixLess = this.extractSuffix(fileStr)) != null) {
                is = this.getClass().getResourceAsStream("/" + suffixLess);
            }
            if (is != null) {
                this.dataIn = new BufferedReader(new InputStreamReader(is));
                this.dataName = fileStr;
            } else {
                this.error = true;
            }
        } else {
            this.errormessage = "PROBABLE IMPLEMENTATION ERROR : Datasource Type given as '" + (Serializable)(sourceType != null ? sourceType : "null") + "'";
            this.error = true;
        }
        if (this.dataIn == null || this.error) {
            throw new IOException(MessageManager.formatMessage("exception.failed_to_read_data_from_source", new String[]{this.errormessage}));
        }
        this.error = false;
        this.dataIn.mark(2048);
    }

    public void mark() throws IOException {
        if (this.dataIn == null) {
            throw new IOException(MessageManager.getString("exception.no_init_source_stream"));
        }
        this.dataIn.mark(2048);
    }

    public String nextLine() throws IOException {
        if (!this.error) {
            return this.dataIn.readLine();
        }
        throw new IOException(MessageManager.formatMessage("exception.invalid_source_stream", new String[]{this.errormessage}));
    }

    public boolean isExporting() {
        return !this.error && this.dataIn == null;
    }

    public boolean isValid() {
        return !this.error;
    }

    public void close() throws IOException {
        this.errormessage = "EXCEPTION ON CLOSE";
        this.error = true;
        this.dataIn.close();
        this.dataIn = null;
        this.errormessage = "SOURCE IS CLOSED";
    }

    public void reset(int bytesRead) throws IOException {
        if (bytesRead >= 2048) {
            System.err.println(String.format("File reset error: read %d bytes but reset limit is %d", bytesRead, 2048));
        }
        if (this.dataIn == null || this.error) {
            throw new IOException(MessageManager.getString("error.implementation_error_reset_called_for_invalid_source"));
        }
        this.dataIn.reset();
    }

    public boolean hasWarningMessage() {
        return this.warningMessage != null && this.warningMessage.length() > 0;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getInFile() {
        if (this.inFile != null) {
            return this.inFile.getAbsolutePath() + " (" + this.index + ")";
        }
        return "From Paste + (" + this.index + ")";
    }

    public String getDataName() {
        return this.dataName;
    }

    protected void setDataName(String dataname) {
        this.dataName = dataname;
    }

    public Reader getReader() {
        if (this.dataIn != null) {
            return this.dataIn;
        }
        return null;
    }

    public AlignViewportI getViewport() {
        return this.viewport;
    }

    public void setViewport(AlignViewportI viewport) {
        this.viewport = viewport;
    }

    public AlignExportSettingI getExportSettings() {
        return this.exportSettings;
    }

    public void setExportSettings(AlignExportSettingI exportSettings) {
        this.exportSettings = exportSettings;
    }

    public void configureForView(AlignmentViewPanel avpanel) {
        if (avpanel != null) {
            this.setViewport(avpanel.getAlignViewport());
        }
    }

    public FeatureSettingsModelI getFeatureColourScheme() {
        return null;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }
}

