/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import MCview.PDBfile;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.ext.jmol.JmolParser;
import jalview.io.AMSAFile;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AlignmentFileWriterI;
import jalview.io.BLCFile;
import jalview.io.ClustalFile;
import jalview.io.FastaFile;
import jalview.io.FeaturesFile;
import jalview.io.FileFormatI;
import jalview.io.FileParse;
import jalview.io.HMMFile;
import jalview.io.HtmlFile;
import jalview.io.JPredFile;
import jalview.io.JSONFile;
import jalview.io.MSFfile;
import jalview.io.PIRFile;
import jalview.io.PfamFile;
import jalview.io.PhylipFile;
import jalview.io.PileUpfile;
import jalview.io.RnamlFile;
import jalview.io.ScoreMatrixFile;
import jalview.io.StockholmFile;
import jalview.structure.StructureImportSettings;
import java.io.IOException;

public enum FileFormat implements FileFormatI
{
    Fasta("Fasta", "fa, fasta, mfa, fastq", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new FastaFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new FastaFile();
        }
    }
    ,
    Pfam("PFAM", "pfam", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new PfamFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new PfamFile();
        }
    }
    ,
    Stockholm("Stockholm", "sto,stk", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new StockholmFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new StockholmFile(al);
        }
    }
    ,
    PIR("PIR", "pir", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new PIRFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new PIRFile();
        }
    }
    ,
    BLC("BLC", "BLC", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new BLCFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new BLCFile();
        }
    }
    ,
    AMSA("AMSA", "amsa", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new AMSAFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new AMSAFile(al);
        }
    }
    ,
    Html("HTML", "html", true, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new HtmlFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new HtmlFile();
        }

        @Override
        public boolean isComplexAlignFile() {
            return true;
        }
    }
    ,
    Rnaml("RNAML", "xml,rnaml", true, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new RnamlFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new RnamlFile();
        }
    }
    ,
    Json("JSON", "json", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new JSONFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new JSONFile();
        }

        @Override
        public boolean isComplexAlignFile() {
            return true;
        }
    }
    ,
    Pileup("PileUp", "pileup", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new PileUpfile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new PileUpfile();
        }
    }
    ,
    MSF("MSF", "msf", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new MSFfile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new MSFfile();
        }
    }
    ,
    Clustal("Clustal", "aln", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new ClustalFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new ClustalFile();
        }
    }
    ,
    Phylip("PHYLIP", "phy", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new PhylipFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new PhylipFile();
        }
    }
    ,
    Jnet("JnetFile", "", false, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            JPredFile af = new JPredFile(source);
            af.removeNonSequences();
            return af;
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return null;
        }
    }
    ,
    Features("GFF or Jalview features", "gff2,gff3", true, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new FeaturesFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new FeaturesFile();
        }
    }
    ,
    ScoreMatrix("Substitution matrix", "", false, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new ScoreMatrixFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return null;
        }
    }
    ,
    PDB("PDB", "pdb,ent", true, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            boolean isParseWithJMOL;
            boolean bl = isParseWithJMOL = StructureImportSettings.getDefaultStructureFileFormat() != PDBEntry.Type.PDB;
            if (isParseWithJMOL) {
                return new JmolParser(source);
            }
            StructureImportSettings.setShowSeqFeatures(true);
            return new PDBfile(StructureImportSettings.isVisibleChainAnnotation(), StructureImportSettings.isProcessSecondaryStructure(), StructureImportSettings.isExternalSecondaryStructure(), source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new JmolParser();
        }

        @Override
        public boolean isStructureFile() {
            return true;
        }
    }
    ,
    MMCif("mmCIF", "cif", true, false){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new JmolParser(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new JmolParser();
        }

        @Override
        public boolean isStructureFile() {
            return true;
        }
    }
    ,
    Jalview("Jalview", "jvp, jar", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return null;
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return null;
        }

        @Override
        public boolean isTextFormat() {
            return false;
        }

        @Override
        public boolean isIdentifiable() {
            return false;
        }
    }
    ,
    HMMER3("HMMER3", "hmm", true, true){

        @Override
        public AlignmentFileReaderI getReader(FileParse source) throws IOException {
            return new HMMFile(source);
        }

        @Override
        public AlignmentFileWriterI getWriter(AlignmentI al) {
            return new HMMFile();
        }
    };

    private boolean writable;
    private boolean readable;
    private String extensions;
    private String name;

    @Override
    public boolean isComplexAlignFile() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    private FileFormat(String shortName, String extensions, boolean isReadable, boolean isWritable) {
        this.name = shortName;
        this.extensions = extensions;
        this.readable = isReadable;
        this.writable = isWritable;
    }

    @Override
    public String getExtensions() {
        return this.extensions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTextFormat() {
        return true;
    }

    @Override
    public boolean isStructureFile() {
        return false;
    }

    public boolean isIdentifiable() {
        return true;
    }
}

