/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Jalview;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.FileParse;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.util.MessageManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.JFileChooser;

public class CountReader {
    public static ResidueCount getBackgroundFrequencies(AlignmentPanel ap, SequenceI seq) throws MalformedURLException, IOException {
        JFileChooser bkgdFreqChooser = new JFileChooser();
        bkgdFreqChooser.showOpenDialog(ap);
        File file = bkgdFreqChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        IdentifyFile identifier = new IdentifyFile();
        FileFormatI format = null;
        try {
            format = identifier.identify(file.getPath(), DataSourceType.FILE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (format == null && !Jalview.isHeadlessMode()) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("label.couldnt_read_data") + " in " + file + "\n" + AppletFormatAdapter.getSupportedFormats(), MessageManager.getString("label.couldnt_read_data"), 2);
        }
        FileParse parser = new FileParse(file.getPath(), DataSourceType.FILE);
        AlignmentI al = new FormatAdapter().readFromFile(parser, format);
        parser.close();
        ResidueCount counts = new ResidueCount(al.getSequences());
        return counts;
    }
}

