/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.BackupFilenameFilter;
import jalview.io.BackupFilenameParts;
import jalview.io.BackupFilesPresetEntry;
import jalview.util.MessageManager;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class BackupFiles {
    public static final String NS = "BACKUPFILES";
    public static final String ENABLED = "BACKUPFILES_ENABLED";
    public static final String NUM_PLACEHOLDER = "%n";
    private static final String DEFAULT_TEMP_FILE = "jalview_temp_file_BACKUPFILES";
    private static final String TEMP_FILE_EXT = ".tmp";
    private File file;
    private static boolean enabled;
    private static boolean confirmDelete;
    private String suffix;
    private boolean noMax;
    private int max;
    private int digits;
    private boolean reverseOrder;
    private File tempFile;
    private boolean tempFileWriteSuccess;
    private ArrayList<File> deleteFiles = new ArrayList();
    private static final SimpleDateFormat sdf;

    public BackupFiles(String filename) {
        this(new File(filename));
    }

    public BackupFiles(File file) {
        BackupFiles.classInit();
        this.file = file;
        BackupFilesPresetEntry bfpe = BackupFilesPresetEntry.getSavedBackupEntry();
        this.suffix = bfpe.suffix;
        this.noMax = bfpe.keepAll;
        this.max = bfpe.rollMax;
        this.digits = bfpe.digits;
        this.reverseOrder = bfpe.reverse;
        File temp = null;
        try {
            if (file != null) {
                String tempfilename = file.getName();
                File tempdir = file.getParentFile();
                temp = File.createTempFile(tempfilename, ".tmp_newfile", tempdir);
            } else {
                temp = File.createTempFile(DEFAULT_TEMP_FILE, TEMP_FILE_EXT);
            }
        }
        catch (IOException e) {
            System.out.println("Could not create temp file to save into (IOException)");
        }
        catch (Exception e) {
            System.out.println("Exception ctreating temp file for saving");
        }
        this.setTempFile(temp);
    }

    public static void classInit() {
        BackupFiles.setEnabled(Cache.getDefault(ENABLED, true));
        BackupFilesPresetEntry bfpe = BackupFilesPresetEntry.getSavedBackupEntry();
        BackupFiles.setConfirmDelete(bfpe.confirmDelete);
    }

    public static void setEnabled(boolean flag) {
        enabled = flag;
    }

    public static boolean getEnabled() {
        BackupFiles.classInit();
        return enabled;
    }

    public static void setConfirmDelete(boolean flag) {
        confirmDelete = flag;
    }

    public static boolean getConfirmDelete() {
        BackupFiles.classInit();
        return confirmDelete;
    }

    public void setTempFile(File temp) {
        this.tempFile = temp;
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public String getTempFilePath() {
        String path = null;
        try {
            path = this.getTempFile().getCanonicalPath();
        }
        catch (IOException e) {
            System.out.println("IOException when getting Canonical Path of temp file '" + this.getTempFile().getName() + "'");
        }
        return path;
    }

    public boolean setWriteSuccess(boolean flag) {
        boolean old = this.tempFileWriteSuccess;
        this.tempFileWriteSuccess = flag;
        return old;
    }

    public boolean getWriteSuccess() {
        return this.tempFileWriteSuccess;
    }

    public boolean renameTempFile() {
        return this.tempFile.renameTo(this.file);
    }

    public boolean rollBackupFiles() {
        return this.rollBackupFiles(true);
    }

    public boolean rollBackupFiles(boolean tidyUp) {
        String filename;
        File dirFile;
        if (!this.file.exists() || !enabled || this.max < 0 || this.suffix == null || this.suffix.length() == 0) {
            return true;
        }
        String dir = "";
        try {
            dirFile = this.file.getParentFile();
            dir = dirFile.getCanonicalPath();
        }
        catch (Exception e) {
            System.out.println("Could not get canonical path for file '" + this.file + "'");
            return false;
        }
        String basename = filename = this.file.getName();
        boolean ret = true;
        this.deleteFiles.clear();
        BackupFilenameFilter bff = new BackupFilenameFilter(basename, this.suffix, this.digits);
        File[] backupFiles = dirFile.listFiles(bff);
        int nextIndexNum = 0;
        if (backupFiles.length == 0) {
            nextIndexNum = 1;
        } else {
            TreeMap<Integer, File> bfTreeMap = this.sortBackupFilesAsTreeMap(backupFiles, basename);
            if (this.reverseOrder) {
                int tempMax = this.noMax ? -1 : this.max;
                for (int i = 1; tempMax < 0 || i <= this.max; ++i) {
                    if (bfTreeMap.containsKey(i)) continue;
                    tempMax = i;
                }
                File previousFile = null;
                File fileToBeDeleted = null;
                for (int n = tempMax; n > 0; --n) {
                    String backupfilename = dir + File.separatorChar + BackupFilenameParts.getBackupFilename(n, basename, this.suffix, this.digits);
                    File backupfile_n = new File(backupfilename);
                    if (!backupfile_n.exists()) {
                        previousFile = backupfile_n;
                        fileToBeDeleted = null;
                        continue;
                    }
                    if (fileToBeDeleted != null) {
                        File replacementFile = backupfile_n;
                        long fileToBeDeletedLMT = fileToBeDeleted.lastModified();
                        long replacementFileLMT = replacementFile.lastModified();
                        try {
                            File oldestTempFile = BackupFiles.nextTempFile(fileToBeDeleted.getName(), dirFile);
                            if (fileToBeDeletedLMT > replacementFileLMT) {
                                String fileToBeDeletedLMTString = sdf.format(fileToBeDeletedLMT);
                                String replacementFileLMTString = sdf.format(replacementFileLMT);
                                System.out.println("WARNING! I am set to delete backupfile " + fileToBeDeleted.getName() + " has modification time " + fileToBeDeletedLMTString + " which is newer than its replacement " + replacementFile.getName() + " with modification time " + replacementFileLMTString);
                                boolean delete = BackupFiles.confirmNewerDeleteFile(fileToBeDeleted, replacementFile, true);
                                if (delete) {
                                    fileToBeDeleted.delete();
                                } else {
                                    fileToBeDeleted.renameTo(oldestTempFile);
                                }
                            } else {
                                fileToBeDeleted.renameTo(oldestTempFile);
                                this.addDeleteFile(oldestTempFile);
                            }
                        }
                        catch (Exception e) {
                            System.out.println("Error occurred, probably making new temp file for '" + fileToBeDeleted.getName() + "'");
                            e.printStackTrace();
                        }
                        fileToBeDeleted = null;
                    }
                    if (!this.noMax && n == tempMax && backupfile_n.exists()) {
                        fileToBeDeleted = backupfile_n;
                    } else if (previousFile != null) {
                        ret = ret && backupfile_n.renameTo(previousFile);
                    }
                    previousFile = backupfile_n;
                }
                nextIndexNum = 1;
            } else {
                bfTreeMap.values().toArray(backupFiles);
                if (!this.noMax && bfTreeMap.size() >= this.max) {
                    int numToDelete = bfTreeMap.size() - this.max + 1;
                    File replacementFile = numToDelete < backupFiles.length ? backupFiles[numToDelete] : null;
                    for (int i = 0; i < numToDelete; ++i) {
                        File fileToBeDeleted = backupFiles[i];
                        boolean delete = true;
                        boolean newer = false;
                        if (replacementFile != null) {
                            long replacementFileLMT;
                            long fileToBeDeletedLMT = fileToBeDeleted.lastModified();
                            long l = replacementFileLMT = replacementFile != null ? replacementFile.lastModified() : Long.MAX_VALUE;
                            if (fileToBeDeletedLMT > replacementFileLMT) {
                                String fileToBeDeletedLMTString = sdf.format(fileToBeDeletedLMT);
                                String replacementFileLMTString = sdf.format(replacementFileLMT);
                                System.out.println("WARNING! I am set to delete backupfile '" + fileToBeDeleted.getName() + "' has modification time " + fileToBeDeletedLMTString + " which is newer than the oldest backupfile being kept '" + replacementFile.getName() + "' with modification time " + replacementFileLMTString);
                                delete = BackupFiles.confirmNewerDeleteFile(fileToBeDeleted, replacementFile, false);
                                if (delete) {
                                    fileToBeDeleted.delete();
                                    delete = false;
                                }
                            }
                        }
                        if (!delete) continue;
                        this.addDeleteFile(fileToBeDeleted);
                    }
                }
                nextIndexNum = bfTreeMap.lastKey() + 1;
            }
        }
        String latestBackupFilename = dir + File.separatorChar + BackupFilenameParts.getBackupFilename(nextIndexNum, basename, this.suffix, this.digits);
        ret |= this.file.renameTo(new File(latestBackupFilename));
        if (tidyUp) {
            this.tidyUpFiles();
        }
        return ret;
    }

    private static File nextTempFile(String filename, File dirFile) throws IOException {
        File temp = null;
        for (int i = 1; i < 1000; ++i) {
            File trythis = new File(dirFile, filename + "~" + Integer.toString(i));
            if (trythis.exists()) continue;
            temp = trythis;
            break;
        }
        if (temp == null) {
            temp = File.createTempFile(filename, TEMP_FILE_EXT, dirFile);
        }
        return temp;
    }

    private void tidyUpFiles() {
        this.deleteOldFiles();
    }

    private static boolean confirmNewerDeleteFile(File fileToBeDeleted, File replacementFile, boolean replace) {
        StringBuilder messageSB = new StringBuilder();
        File ftbd = fileToBeDeleted;
        String ftbdLMT = sdf.format(ftbd.lastModified());
        String ftbdSize = Long.toString(ftbd.length());
        File rf = replacementFile;
        String rfLMT = sdf.format(rf.lastModified());
        String rfSize = Long.toString(rf.length());
        int confirmButton = 1;
        if (replace) {
            File saveFile = null;
            try {
                saveFile = BackupFiles.nextTempFile(ftbd.getName(), ftbd.getParentFile());
            }
            catch (Exception e) {
                System.out.println("Error when confirming to keep backup file newer than other backup files.");
                e.printStackTrace();
            }
            messageSB.append(MessageManager.formatMessage("label.newerdelete_replacement_line", new String[]{ftbd.getName(), rf.getName(), ftbdLMT, rfLMT, ftbdSize, rfSize}));
            messageSB.append("\n\n");
            messageSB.append(MessageManager.formatMessage("label.confirm_deletion_or_rename", new String[]{ftbd.getName(), saveFile.getName()}));
            Object[] options = new String[]{MessageManager.getString("label.delete"), MessageManager.getString("label.rename")};
            confirmButton = JvOptionPane.showOptionDialog(Desktop.desktop, messageSB.toString(), MessageManager.getString("label.backupfiles_confirm_delete"), 0, 2, null, options, options[0]);
        } else {
            messageSB.append(MessageManager.formatMessage("label.newerdelete_line", new String[]{ftbd.getName(), rf.getName(), ftbdLMT, rfLMT, ftbdSize, rfSize}));
            messageSB.append("\n\n");
            messageSB.append(MessageManager.formatMessage("label.confirm_deletion", new String[]{ftbd.getName()}));
            Object[] options = new String[]{MessageManager.getString("label.delete"), MessageManager.getString("label.keep")};
            confirmButton = JvOptionPane.showOptionDialog(Desktop.desktop, messageSB.toString(), MessageManager.getString("label.backupfiles_confirm_delete"), 0, 2, null, options, options[0]);
        }
        return confirmButton == 0;
    }

    private void deleteOldFiles() {
        if (this.deleteFiles != null && !this.deleteFiles.isEmpty()) {
            int i;
            boolean doDelete = false;
            StringBuilder messageSB = null;
            if (confirmDelete && this.deleteFiles.size() > 0) {
                messageSB = new StringBuilder();
                messageSB.append(MessageManager.getString("label.backupfiles_confirm_delete_old_files"));
                for (i = 0; i < this.deleteFiles.size(); ++i) {
                    File df = this.deleteFiles.get(i);
                    messageSB.append("\n");
                    messageSB.append(df.getName());
                    messageSB.append(" ");
                    messageSB.append(MessageManager.formatMessage("label.file_info", new String[]{sdf.format(df.lastModified()), Long.toString(df.length())}));
                }
                int confirmButton = JvOptionPane.showConfirmDialog(Desktop.desktop, messageSB.toString(), MessageManager.getString("label.backupfiles_confirm_delete"), 0, 2);
                doDelete = confirmButton == 0;
            } else {
                doDelete = true;
            }
            if (doDelete) {
                for (i = 0; i < this.deleteFiles.size(); ++i) {
                    File fileToDelete = this.deleteFiles.get(i);
                    fileToDelete.delete();
                    System.out.println("DELETING '" + fileToDelete.getName() + "'");
                }
            }
        }
        this.deleteFiles.clear();
    }

    private TreeMap<Integer, File> sortBackupFilesAsTreeMap(File[] backupFiles, String basename) {
        HashMap<Integer, File> bfHashMap = new HashMap<Integer, File>();
        for (int i = 0; i < backupFiles.length; ++i) {
            File f = backupFiles[i];
            BackupFilenameParts bfp = new BackupFilenameParts(f, basename, this.suffix, this.digits);
            bfHashMap.put(bfp.indexNum(), f);
        }
        TreeMap<Integer, File> bfTreeMap = new TreeMap<Integer, File>();
        bfTreeMap.putAll(bfHashMap);
        return bfTreeMap;
    }

    public boolean rollBackupsAndRenameTempFile() {
        boolean okay;
        boolean write = this.getWriteSuccess();
        boolean roll = false;
        boolean rename = false;
        if (write) {
            roll = this.rollBackupFiles(false);
            rename = this.renameTempFile();
        }
        boolean bl = okay = roll && rename;
        if (!okay) {
            StringBuilder messageSB = new StringBuilder();
            messageSB.append(MessageManager.getString("label.backupfiles_confirm_save_file_backupfiles_roll_wrong"));
            if (rename) {
                if (messageSB.length() > 0) {
                    messageSB.append("\n");
                }
                messageSB.append(MessageManager.getString("label.backupfiles_confirm_save_new_saved_file_ok"));
            } else {
                if (messageSB.length() > 0) {
                    messageSB.append("\n");
                }
                messageSB.append(MessageManager.getString("label.backupfiles_confirm_save_new_saved_file_not_ok"));
            }
            int confirmButton = JvOptionPane.showConfirmDialog(Desktop.desktop, messageSB.toString(), MessageManager.getString("label.backupfiles_confirm_save_file"), 0, 2);
            boolean bl2 = okay = confirmButton == 0;
        }
        if (okay) {
            this.tidyUpFiles();
        }
        return rename;
    }

    public static TreeMap<Integer, File> getBackupFilesAsTreeMap(String fileName, String suffix, int digits) {
        String filename;
        File dirFile;
        File[] backupFiles = null;
        File file = new File(fileName);
        try {
            dirFile = file.getParentFile();
        }
        catch (Exception e) {
            System.out.println("Could not get canonical path for file '" + file + "'");
            return new TreeMap<Integer, File>();
        }
        String basename = filename = file.getName();
        BackupFilenameFilter bff = new BackupFilenameFilter(basename, suffix, digits);
        backupFiles = dirFile.listFiles(bff);
        HashMap<Integer, File> bfHashMap = new HashMap<Integer, File>();
        for (int i = 0; i < backupFiles.length; ++i) {
            File f = backupFiles[i];
            BackupFilenameParts bfp = new BackupFilenameParts(f, basename, suffix, digits);
            bfHashMap.put(bfp.indexNum(), f);
        }
        TreeMap<Integer, File> bfTreeMap = new TreeMap<Integer, File>();
        bfTreeMap.putAll(bfHashMap);
        return bfTreeMap;
    }

    private boolean addDeleteFile(File fileToBeDeleted) {
        boolean ret = false;
        int pos = this.deleteFiles.indexOf(fileToBeDeleted);
        if (pos > -1) {
            return true;
        }
        this.deleteFiles.add(fileToBeDeleted);
        return ret;
    }

    static {
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }
}

