/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import MCview.PDBfile;
import jalview.api.AlignExportSettingI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JmolParser;
import jalview.io.AlignmentFileReaderI;
import jalview.io.AlignmentFileWriterI;
import jalview.io.DataSourceType;
import jalview.io.FastaFile;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileParse;
import jalview.io.IdentifyFile;
import jalview.io.StructureFile;
import jalview.structure.StructureImportSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class AppletFormatAdapter {
    private AlignmentViewPanel viewpanel;
    boolean annotFromStructure = false;
    boolean localSecondaryStruct = false;
    boolean serviceSecondaryStruct = false;
    private AlignmentFileReaderI alignFile = null;
    String inFile;
    protected String newline = System.getProperty("line.separator");
    private AlignExportSettingI exportSettings;
    public static String INVALID_CHARACTERS = "Contains invalid characters";

    public static String getSupportedFormats() {
        return "Formats currently supported are\n" + AppletFormatAdapter.prettyPrint(FileFormats.getInstance().getReadableFormats());
    }

    public AppletFormatAdapter() {
    }

    public AppletFormatAdapter(AlignmentViewPanel viewpanel) {
        this.viewpanel = viewpanel;
    }

    public AppletFormatAdapter(AlignmentViewPanel alignPanel, AlignExportSettingI settings) {
        this.viewpanel = alignPanel;
        this.exportSettings = settings;
    }

    public static String prettyPrint(List<? extends Object> things) {
        StringBuffer list = new StringBuffer();
        int iSize = things.size() - 1;
        for (int i = 0; i < iSize; ++i) {
            list.append(things.get(i).toString());
            list.append(", ");
        }
        list.append(" and " + things.get(things.size() - 1).toString() + ".");
        return list.toString();
    }

    public void setNewlineString(String nl) {
        this.newline = nl;
    }

    public String getNewlineString() {
        return this.newline;
    }

    public AlignmentI readFile(String file, DataSourceType sourceType, FileFormatI fileFormat) throws IOException {
        this.inFile = file;
        try {
            if (fileFormat.isStructureFile()) {
                String structureParser = StructureImportSettings.getDefaultPDBFileParser();
                boolean isParseWithJMOL = structureParser.equalsIgnoreCase(StructureImportSettings.StructureParser.JMOL_PARSER.toString());
                StructureImportSettings.addSettings(this.annotFromStructure, this.localSecondaryStruct, this.serviceSecondaryStruct);
                if (isParseWithJMOL) {
                    this.alignFile = new JmolParser(this.inFile, sourceType);
                } else {
                    StructureImportSettings.setShowSeqFeatures(true);
                    this.alignFile = new PDBfile(this.annotFromStructure, this.localSecondaryStruct, this.serviceSecondaryStruct, this.inFile, sourceType);
                }
                ((StructureFile)this.alignFile).setDbRefType(FileFormat.PDB.equals(fileFormat) ? PDBEntry.Type.PDB : PDBEntry.Type.MMCIF);
            } else {
                this.alignFile = fileFormat.getReader(new FileParse(this.inFile, sourceType));
            }
            return this.buildAlignmentFromFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to read alignment using the '" + fileFormat + "' reader.\n" + e);
            if (e.getMessage() != null && e.getMessage().startsWith(INVALID_CHARACTERS)) {
                throw new IOException(e.getMessage());
            }
            if (sourceType == DataSourceType.PASTE) {
                try {
                    this.alignFile = new FastaFile(">UNKNOWN\n" + this.inFile, DataSourceType.PASTE);
                    return this.buildAlignmentFromFile();
                }
                catch (Exception ex) {
                    if (ex.toString().startsWith(INVALID_CHARACTERS)) {
                        throw new IOException(e.getMessage());
                    }
                    ex.printStackTrace();
                }
            }
            if (FileFormat.Html.equals(fileFormat)) {
                throw new IOException(e.getMessage());
            }
            throw new FileFormatException(AppletFormatAdapter.getSupportedFormats());
        }
    }

    public AlignmentI readFromFile(FileParse source, FileFormatI format) throws IOException {
        this.inFile = source.getInFile();
        DataSourceType type = source.dataSourceType;
        try {
            if (FileFormat.PDB.equals(format) || FileFormat.MMCif.equals(format)) {
                boolean isParseWithJMOL = false;
                if (isParseWithJMOL) {
                    StructureImportSettings.addSettings(this.annotFromStructure, this.localSecondaryStruct, this.serviceSecondaryStruct);
                    this.alignFile = new JmolParser(source);
                } else {
                    StructureImportSettings.setShowSeqFeatures(true);
                    this.alignFile = new PDBfile(this.annotFromStructure, this.localSecondaryStruct, this.serviceSecondaryStruct, source);
                }
                ((StructureFile)this.alignFile).setDbRefType(PDBEntry.Type.PDB);
            } else {
                this.alignFile = format.getReader(source);
            }
            return this.buildAlignmentFromFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Failed to read alignment using the '" + format + "' reader.\n" + e);
            if (e.getMessage() != null && e.getMessage().startsWith(INVALID_CHARACTERS)) {
                throw new FileFormatException(e.getMessage());
            }
            if (type == DataSourceType.PASTE) {
                try {
                    this.alignFile = new FastaFile(">UNKNOWN\n" + this.inFile, DataSourceType.PASTE);
                    return this.buildAlignmentFromFile();
                }
                catch (Exception ex) {
                    if (ex.toString().startsWith(INVALID_CHARACTERS)) {
                        throw new IOException(e.getMessage());
                    }
                    ex.printStackTrace();
                }
            }
            throw new FileFormatException(AppletFormatAdapter.getSupportedFormats());
        }
    }

    private AlignmentI buildAlignmentFromFile() {
        Alignment al = new Alignment(this.alignFile.getSeqsAsArray());
        this.alignFile.addAnnotations(al);
        this.alignFile.addGroups(al);
        return al;
    }

    public String formatSequences(FileFormatI format, boolean jvsuffix, AlignmentViewPanel ap, boolean selectedOnly) {
        AlignmentView selvew = ap.getAlignViewport().getAlignmentView(selectedOnly, false);
        AlignmentI aselview = selvew.getVisibleAlignment(ap.getAlignViewport().getGapCharacter());
        List<AlignmentAnnotation> ala = ap.getAlignViewport().getVisibleAlignmentAnnotation(selectedOnly);
        if (ala != null) {
            for (AlignmentAnnotation aa : ala) {
                aselview.addAnnotation(aa);
            }
        }
        this.viewpanel = ap;
        return this.formatSequences(format, aselview, jvsuffix);
    }

    public String formatSequences(FileFormatI format, AlignmentI alignment, boolean jvsuffix) {
        try {
            AlignmentFileWriterI afile = format.getWriter(alignment);
            afile.setNewlineString(this.newline);
            afile.setExportSettings(this.exportSettings);
            afile.configureForView(this.viewpanel);
            SequenceI[] seqs = null;
            seqs = this.viewpanel == null || this.viewpanel.getAlignment() == null || this.viewpanel.getAlignment() != alignment ? alignment.getSequencesArray() : this.viewpanel.getAlignment().getSequencesArray();
            String afileresp = afile.print(seqs, jvsuffix);
            if (afile.hasWarningMessage()) {
                System.err.println("Warning raised when writing as " + format + " : " + afile.getWarningMessage());
            }
            return afileresp;
        }
        catch (Exception e) {
            System.err.println("Failed to write alignment as a '" + format.getName() + "' file\n");
            e.printStackTrace();
            return null;
        }
    }

    public static DataSourceType checkProtocol(String data) {
        DataSourceType protocol = DataSourceType.PASTE;
        String ft = data.toLowerCase().trim();
        if (ft.indexOf("http:") == 0 || ft.indexOf("https:") == 0 || ft.indexOf("file:") == 0) {
            protocol = DataSourceType.URL;
        } else if (new File(data).exists()) {
            protocol = DataSourceType.FILE;
        }
        return protocol;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            if (f.exists()) {
                try {
                    System.out.println("Reading file: " + f);
                    AppletFormatAdapter afa = new AppletFormatAdapter();
                    Runtime r = Runtime.getRuntime();
                    System.gc();
                    long memf = -r.totalMemory() + r.freeMemory();
                    long t1 = -System.currentTimeMillis();
                    AlignmentI al = afa.readFile(args[i], DataSourceType.FILE, new IdentifyFile().identify(args[i], DataSourceType.FILE));
                    t1 += System.currentTimeMillis();
                    System.gc();
                    memf += r.totalMemory() - r.freeMemory();
                    if (al != null) {
                        System.out.println("Alignment contains " + al.getHeight() + " sequences and " + al.getWidth() + " columns.");
                        try {
                            System.out.println(new AppletFormatAdapter().formatSequences(FileFormat.Fasta, al, true));
                        }
                        catch (Exception e) {
                            System.err.println("Couln't format the alignment for output as a FASTA file.");
                            e.printStackTrace(System.err);
                        }
                    } else {
                        System.out.println("Couldn't read alignment");
                    }
                    System.out.println("Read took " + (double)t1 / 1000.0 + " seconds.");
                    System.out.println("Difference between free memory now and before is " + (double)memf / 1048576.0 * 1.0 + " MB");
                }
                catch (Exception e) {
                    System.err.println("Exception when dealing with " + i + "'th argument: " + args[i] + "\n" + e);
                }
                continue;
            }
            System.err.println("Ignoring argument '" + args[i] + "' (" + i + "'th)- not a readable file.");
        }
    }

    public static DataSourceType resolveProtocol(String file, FileFormatI format) {
        return AppletFormatAdapter.resolveProtocol(file, format, false);
    }

    public static DataSourceType resolveProtocol(String file, FileFormatI format, boolean debug) {
        DataSourceType protocol = null;
        if (debug) {
            System.out.println("resolving datasource started with:\n>>file\n" + file + ">>endfile");
        }
        try {
            boolean rtn = false;
            InputStream is = System.getSecurityManager().getClass().getResourceAsStream("/" + file);
            if (is != null) {
                rtn = true;
                is.close();
            }
            if (debug) {
                System.err.println("Resource '" + file + "' was " + (rtn ? "" : "not") + " located by classloader.");
            }
            if (rtn) {
                protocol = DataSourceType.CLASSLOADER;
            }
        }
        catch (Exception ex) {
            System.err.println("Exception checking resources: " + file + " " + ex);
        }
        protocol = file.indexOf("://") > -1 ? DataSourceType.URL : DataSourceType.FILE;
        FileParse fp = null;
        try {
            if (debug) {
                System.out.println("Trying to get contents of resource as " + protocol + ":");
            }
            if (!(fp = new FileParse(file, protocol)).isValid()) {
                fp = null;
            } else if (debug) {
                System.out.println("Successful.");
            }
        }
        catch (Exception e) {
            if (debug) {
                System.err.println("Exception when accessing content: " + e);
            }
            fp = null;
        }
        if (fp == null) {
            if (debug) {
                System.out.println("Accessing as paste.");
            }
            protocol = DataSourceType.PASTE;
            fp = null;
            try {
                fp = new FileParse(file, protocol);
                if (!fp.isValid()) {
                    fp = null;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to access content as paste!");
                e.printStackTrace();
                fp = null;
            }
        }
        if (fp == null) {
            return null;
        }
        if (format == null) {
            return protocol;
        }
        try {
            FileFormatI idformat = new IdentifyFile().identify(file, protocol);
            if (idformat == null) {
                if (debug) {
                    System.out.println("Format not identified. Inaccessible file.");
                }
                return null;
            }
            if (debug) {
                System.out.println("Format identified as " + idformat + "and expected as " + format);
            }
            if (idformat.equals(format)) {
                if (debug) {
                    System.out.println("Protocol identified as " + protocol);
                }
                return protocol;
            }
            if (debug) {
                System.out.println("File deemed not accessible via " + protocol);
            }
            fp.close();
            return null;
        }
        catch (Exception e) {
            if (debug) {
                System.err.println("File deemed not accessible via " + protocol);
                e.printStackTrace();
            }
            return null;
        }
    }

    public AlignmentFileReaderI getAlignFile() {
        return this.alignFile;
    }
}

