/*
 * Decompiled with CFR 0.152.
 */
package jalview.httpserver;

import jalview.httpserver.AbstractRequestHandler;
import jalview.rest.RestHandler;
import java.net.BindException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpServer {
    private static final String JALVIEW_PATH = "jalview";
    private static HttpServer instance;
    private Server server;
    private HandlerCollection contextHandlers;
    Map<Handler, ContextHandler> myHandlers = new HashMap<Handler, ContextHandler>();
    private URI contextRoot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServer getInstance() throws BindException {
        Class<HttpServer> clazz = HttpServer.class;
        synchronized (HttpServer.class) {
            if (instance == null) {
                instance = new HttpServer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HttpServer() throws BindException {
        this.startServer();
        this.registerHandler(RestHandler.getInstance());
    }

    private void startServer() throws BindException {
        try {
            QueuedThreadPool tp = new QueuedThreadPool(4, 1);
            this.server = new Server((ThreadPool)tp);
            ServerConnector connector = new ServerConnector(this.server, 0, 2);
            connector.setHost("localhost");
            this.server.addConnector((Connector)connector);
            this.server.setStopAtShutdown(true);
            this.contextHandlers = new HandlerCollection(true);
            this.server.setHandler((Handler)this.contextHandlers);
            this.server.start();
            this.contextRoot = this.server.getURI();
        }
        catch (Exception e) {
            System.err.println("Error trying to start HttpServer: " + e.getMessage());
            try {
                this.server.stop();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (this.server == null) {
            throw new BindException("HttpServer failed to allocate a port");
        }
    }

    public URI getUri() {
        return this.server == null ? null : this.server.getURI();
    }

    protected void dumpRequest(HttpServletRequest request, HttpServletResponse response) {
        for (String hdr : Collections.list(request.getHeaderNames())) {
            for (String val : Collections.list(request.getHeaders(hdr))) {
                System.out.println(hdr + ": " + val);
            }
        }
        for (String param : Collections.list(request.getParameterNames())) {
            for (String val : request.getParameterValues(param)) {
                System.out.println(param + "=" + val);
            }
        }
    }

    public void stopServer() {
        if (this.server != null && this.server.isStarted()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                System.err.println("Error stopping Http Server on " + this.server.getURI() + ": " + e.getMessage());
            }
        }
    }

    public void registerHandler(AbstractRequestHandler handler) {
        String path = handler.getPath();
        if (path == null) {
            throw new IllegalStateException("Must set handler path before registering handler");
        }
        ContextHandler ch = new ContextHandler();
        ch.setAllowNullPathInfo(true);
        ch.setContextPath("/jalview/" + path);
        ch.setResourceBase(".");
        ch.setClassLoader(Thread.currentThread().getContextClassLoader());
        ch.setHandler((Handler)handler);
        this.myHandlers.put((Handler)handler, ch);
        this.contextHandlers.addHandler((Handler)ch);
        try {
            ch.start();
        }
        catch (Exception e) {
            System.err.println("Error starting handler for " + path + ": " + e.getMessage());
        }
        handler.setUri(this.contextRoot + ch.getContextPath().substring(1));
        System.out.println("Jalview " + handler.getName() + " handler started on " + handler.getUri());
    }

    public void removeHandler(AbstractRequestHandler handler) {
        ContextHandler ch = this.myHandlers.get((Object)handler);
        if (ch != null) {
            this.contextHandlers.removeHandler((Handler)ch);
            this.myHandlers.remove((Object)handler);
            System.out.println("Stopped Jalview " + handler.getName() + " handler on " + handler.getUri());
        }
    }
}

