/*
 * Decompiled with CFR 0.152.
 */
package jalview.httpserver;

import jalview.httpserver.HttpServer;
import java.io.IOException;
import java.net.BindException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public abstract class AbstractRequestHandler
extends AbstractHandler {
    private String path;
    private String uri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.processRequest(request, response);
        }
        catch (Throwable t) {
            System.err.println("Exception handling request " + request.getRequestURI() + " : " + t.getMessage());
            if (response.isCommitted()) {
                System.err.println("Unable to return HTTP 500 as response already committed");
            } else {
                response.setStatus(500);
            }
        }
        finally {
            response.getWriter().flush();
            baseRequest.setHandled(true);
        }
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws IOException;

    protected void dumpRequest(HttpServletRequest request) {
        System.out.println(request.getMethod());
        System.out.println(request.getRequestURL());
        for (String hdr : Collections.list(request.getHeaderNames())) {
            for (String val : Collections.list(request.getHeaders(hdr))) {
                System.out.println(hdr + ": " + val);
            }
        }
        for (String param : Collections.list(request.getParameterNames())) {
            for (String val : request.getParameterValues(param)) {
                System.out.println(param + "=" + val);
            }
        }
    }

    public abstract String getName();

    public void shutdown() {
        try {
            HttpServer.getInstance().removeHandler(this);
            this.stop();
        }
        catch (Exception e) {
            System.err.println("Error stopping " + this.getName() + ": " + e.getMessage());
        }
    }

    public String getUri() {
        return this.uri;
    }

    protected void setUri(String u) {
        this.uri = u;
    }

    protected void setPath(String p) {
        this.path = p;
    }

    public String getPath() {
        return this.path;
    }

    protected void registerHandler() throws BindException {
        HttpServer.getInstance().registerHandler(this);
    }
}

