/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.hmmer.HmmerCommand;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Scanner;

public abstract class Search
extends HmmerCommand {
    static final String JACKHMMER = "jackhmmer";
    static final String HMMSEARCH = "hmmsearch";
    boolean realign = false;
    boolean trim = false;
    SequenceI[] seqs;
    String databaseName;
    boolean searchAlignment = true;
    Hashtable sequencesHash;

    public Search(AlignFrame alignFrame, List<ArgumentI> args) {
        super(alignFrame, args);
    }

    @Override
    public void run() {
    }

    void readDomainTable(File inputTableTemp, boolean includesQuery) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(inputTableTemp));
        String line = br.readLine();
        br.readLine();
        br.readLine();
        line = br.readLine();
        int index = includesQuery ? 1 : 0;
        while (!line.startsWith("#")) {
            if (line.contains("inclusion threshold")) {
                line = br.readLine();
                continue;
            }
            Scanner scanner = new Scanner(line);
            String name = scanner.next();
            for (int i = 0; i < 10; ++i) {
                scanner.next();
            }
            String evalue = scanner.next();
            scanner.next();
            String score = scanner.next();
            this.addScoreAnnotations(evalue, score, this.seqs[index]);
            ++index;
            scanner.close();
            line = br.readLine();
        }
        br.close();
    }

    void addScoreAnnotations(String eValue, String bitScore, SequenceI seq) {
        String label = "Search Scores";
        String description = "Full sequence bit score and E-Value";
        try {
            AlignmentAnnotation annot = new AlignmentAnnotation(label, description, null);
            annot.label = label;
            annot.description = description;
            annot.setCalcId(JACKHMMER);
            double dEValue = Double.parseDouble(eValue);
            annot.setEValue(dEValue);
            double dBitScore = Double.parseDouble(bitScore);
            annot.setBitScore(dBitScore);
            annot.setSequenceRef(seq);
            seq.addAlignmentAnnotation(annot);
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing " + label + " from " + eValue + " & " + bitScore);
        }
    }

    void buildArguments(List<String> args, File searchOutputFile, File hitsAlignmentFile, File queryFile) throws IOException {
        args.add("--domtblout");
        args.add(this.getFilePath(searchOutputFile, true));
        args.add("-A");
        args.add(this.getFilePath(hitsAlignmentFile, true));
        File databaseFile = null;
        boolean useEvalueCutoff = false;
        boolean useScoreCutoff = false;
        String seqReportingEvalueCutoff = null;
        String domReportingEvalueCutoff = null;
        String seqReportingScoreCutoff = null;
        String domReportingScoreCutoff = null;
        String seqInclusionEvalueCutoff = null;
        String domInclusionEvalueCutoff = null;
        String seqInclusionScoreCutoff = null;
        String domInclusionScoreCutoff = null;
        this.databaseName = "Alignment";
        if (this.params != null) {
            for (ArgumentI arg : this.params) {
                String name = arg.getName();
                if (MessageManager.getString("label.reporting_cutoff").equals(name)) {
                    if (MessageManager.getString("label.evalue").equals(arg.getValue())) {
                        useEvalueCutoff = true;
                        continue;
                    }
                    if (!MessageManager.getString("label.score").equals(arg.getValue())) continue;
                    useScoreCutoff = true;
                    continue;
                }
                if (MessageManager.getString("label.reporting_seq_evalue").equals(name)) {
                    seqReportingEvalueCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.reporting_seq_score").equals(name)) {
                    seqReportingScoreCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.reporting_dom_evalue").equals(name)) {
                    domReportingEvalueCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.reporting_dom_score").equals(name)) {
                    domReportingScoreCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.inclusion_seq_evalue").equals(name)) {
                    seqInclusionEvalueCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.inclusion_seq_score").equals(name)) {
                    seqInclusionScoreCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.inclusion_dom_evalue").equals(name)) {
                    domInclusionEvalueCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.inclusion_dom_score").equals(name)) {
                    domInclusionScoreCutoff = arg.getValue();
                    continue;
                }
                if (MessageManager.getString("label.database").equals(name)) {
                    databaseFile = new File(arg.getValue());
                    if (arg.getValue().isEmpty()) continue;
                    this.searchAlignment = false;
                    continue;
                }
                if (!MessageManager.getString("label.number_of_iterations").equals(name) || arg.getValue().isEmpty()) continue;
                args.add("-N");
                args.add(arg.getValue());
            }
        }
        if (useEvalueCutoff) {
            args.add("-E");
            args.add(seqReportingEvalueCutoff);
            args.add("--domE");
            args.add(domReportingEvalueCutoff);
            args.add("--incE");
            args.add(seqInclusionEvalueCutoff);
            args.add("--incdomE");
            args.add(domInclusionEvalueCutoff);
        } else if (useScoreCutoff) {
            args.add("-T");
            args.add(seqReportingScoreCutoff);
            args.add("--domT");
            args.add(domReportingScoreCutoff);
            args.add("--incT");
            args.add(seqInclusionEvalueCutoff);
            args.add("--incdomT");
            args.add(domInclusionEvalueCutoff);
        }
        if (this.searchAlignment) {
            databaseFile = FileUtils.createTempFile("database", ".sto");
            AlignmentI al = this.af.getViewport().getAlignment();
            Alignment copy = new Alignment(al);
            this.deleteHmmSequences(copy);
            if (this.searchAlignment) {
                this.sequencesHash = this.stashSequences(copy.getSequencesArray());
            }
            this.exportStockholm(copy.getSequencesArray(), databaseFile, null);
        }
        args.add(this.getFilePath(queryFile, true));
        args.add(this.getFilePath(databaseFile, true));
    }
}

