/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.bin.Cache;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.WsParamSetI;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.DoubleParameter;
import jalview.ws.params.simple.FileParameter;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws.params.simple.LogarithmicParameter;
import jalview.ws.params.simple.Option;
import jalview.ws.params.simple.RadioChoiceParameter;
import jalview.ws.params.simple.StringParameter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public final class HMMERParamStore
implements ParamDatastoreI {
    private static final String HMMBUILD = "hmmbuild";
    private static final String HMMALIGN = "hmmalign";
    private static final String HMMSEARCH = "hmmsearch";
    private static final String JACKHMMER = "jackhmmer";
    private String name;
    private List<WsParamSetI> presets = new ArrayList<WsParamSetI>();
    private AlignmentViewport viewport;

    private HMMERParamStore(String nam, AlignmentViewport av) {
        this.viewport = av;
        this.name = nam;
    }

    public static HMMERParamStore forBuild(AlignmentViewport viewport) {
        return new HMMERParamStore(HMMBUILD, viewport);
    }

    public static HMMERParamStore forAlign(AlignmentViewport viewport) {
        return new HMMERParamStore(HMMALIGN, viewport);
    }

    public static HMMERParamStore forSearch(AlignmentViewport viewport) {
        return new HMMERParamStore(HMMSEARCH, viewport);
    }

    public static HMMERParamStore forJackhmmer(AlignmentViewport viewport) {
        return new HMMERParamStore(JACKHMMER, viewport);
    }

    @Override
    public List<WsParamSetI> getPresets() {
        return this.presets;
    }

    @Override
    public WsParamSetI getPreset(String nam) {
        return null;
    }

    @Override
    public List<ArgumentI> getServiceParameters() {
        ArrayList<ArgumentI> args = new ArrayList<ArgumentI>();
        switch (this.name) {
            case "hmmsearch": {
                this.getHMMSearchParams(args);
                break;
            }
            case "hmmalign": {
                this.getHMMAlignParams(args);
                break;
            }
            case "hmmbuild": {
                this.getHMMBuildParams(args);
                break;
            }
            case "jackhmmer": {
                this.getJackhmmerParams(args);
            }
        }
        return args;
    }

    private void getHMMSearchParams(List<ArgumentI> args) {
        args.add(new BooleanOption(MessageManager.getString("label.auto_align_seqs"), MessageManager.getString("label.auto_align_seqs_desc"), false, false, false, null));
        args.add(new BooleanOption(MessageManager.getString("label.use_accessions"), MessageManager.getString("label.use_accessions_desc"), false, false, true, null));
        args.add(new BooleanOption(MessageManager.getString("label.trim_termini"), MessageManager.getString("label.trim_termini_desc"), false, false, true, null));
        args.add(new BooleanOption(MessageManager.getString("label.check_for_new_sequences"), MessageManager.getString("label.check_for_new_sequences_desc"), false, false, false, null));
        this.addChoiceOfHmm(args);
        String thisAlignment = MessageManager.getString("label.this_alignment");
        String database = MessageManager.getString("label.database");
        args.add(new FileParameter(database, "", false, "", ""));
        args.add(new IntegerParameter(MessageManager.getString("label.number_of_results"), MessageManager.getString("label.number_of_results_desc"), true, 100, 0, 100000));
        args.add(new RadioChoiceParameter(MessageManager.getString("label.reporting_cutoff"), null, Arrays.asList(MessageManager.getString("label.evalue"), MessageManager.getString("label.score")), MessageManager.getString("label.evalue")));
        args.add(new LogarithmicParameter(MessageManager.getString("label.reporting_seq_evalue"), MessageManager.getString("label.reporting_seq_e_value_desc"), false, 1.0, 1.0E-100, 10.0));
        args.add(new LogarithmicParameter(MessageManager.getString("label.reporting_dom_evalue"), MessageManager.getString("label.reporting_dom_e_value_desc"), false, 1.0, 1.0E-100, 10.0));
        args.add(new DoubleParameter(MessageManager.getString("label.reporting_seq_score"), MessageManager.getString("label.reporting_seq_score_desc"), false, 0.0, 0.0, 1000.0));
        args.add(new DoubleParameter(MessageManager.getString("label.reporting_dom_score"), MessageManager.getString("label.reporting_dom_score_desc"), false, 0.0, 0.0, 1000.0));
        args.add(new RadioChoiceParameter(MessageManager.getString("label.inclusion_threshold"), null, Arrays.asList(MessageManager.getString("label.evalue"), MessageManager.getString("label.score")), MessageManager.getString("label.evalue")));
        args.add(new LogarithmicParameter(MessageManager.getString("label.inclusion_seq_evalue"), MessageManager.getString("label.inclusion_seq_e_value_desc"), false, 1.0, 1.0E-100, 10.0));
        args.add(new LogarithmicParameter(MessageManager.getString("label.inclusion_dom_evalue"), MessageManager.getString("label.inclusion_dom_e_value_desc"), false, 1.0, 1.0E-100, 10.0));
        args.add(new DoubleParameter(MessageManager.getString("label.inclusion_seq_score"), MessageManager.getString("label.inclusion_seq_score_desc"), false, 0.0, 0.0, 1000.0));
        args.add(new DoubleParameter(MessageManager.getString("label.inclusion_dom_score"), MessageManager.getString("label.inclusion_dom_score_desc"), false, 0.0, 0.0, 1000.0));
    }

    private void getJackhmmerParams(List<ArgumentI> args) {
        this.addChoiceOfSequence(args);
        String database = MessageManager.getString("label.database");
        args.add(new FileParameter(database, "", false, "", ""));
        args.add(new IntegerParameter(MessageManager.getString("label.number_of_iterations"), MessageManager.getString("label.number_of_iterations_desc"), true, 5, 1, 20));
        args.add(new RadioChoiceParameter(MessageManager.getString("label.reporting_cutoff"), null, Arrays.asList(MessageManager.getString("label.default"), MessageManager.getString("label.evalue"), MessageManager.getString("label.score")), MessageManager.getString("label.evalue")));
        args.add(new LogarithmicParameter(MessageManager.getString("label.reporting_seq_evalue"), MessageManager.getString("label.reporting_seq_e_value_desc"), false, 1.0, 1.0E-38, 10.0));
        args.add(new LogarithmicParameter(MessageManager.getString("label.reporting_dom_evalue"), MessageManager.getString("label.reporting_dom_e_value_desc"), false, 1.0, 1.0E-38, 10.0));
        args.add(new DoubleParameter(MessageManager.getString("label.reporting_seq_score"), MessageManager.getString("label.reporting_seq_score_desc"), false, 0.0, 0.0, 1000.0));
        args.add(new DoubleParameter(MessageManager.getString("label.reporting_dom_score"), MessageManager.getString("label.reporting_dom_score_desc"), false, 0.0, 0.0, 1000.0));
        args.add(new RadioChoiceParameter(MessageManager.getString("label.inclusion_threshold"), null, Arrays.asList(MessageManager.getString("label.evalue"), MessageManager.getString("label.score")), MessageManager.getString("label.evalue")));
        args.add(new LogarithmicParameter(MessageManager.getString("label.inclusion_seq_evalue"), MessageManager.getString("label.inclusion_seq_e_value_desc"), false, 1.0, 1.0E-100, 10.0));
        args.add(new LogarithmicParameter(MessageManager.getString("label.inclusion_dom_evalue"), MessageManager.getString("label.inclusion_dom_e_value_desc"), false, 1.0, 1.0E-100, 10.0));
        args.add(new DoubleParameter(MessageManager.getString("label.inclusion_seq_score"), MessageManager.getString("label.inclusion_seq_score_desc"), false, 0.0, 0.0, 1000.0));
        args.add(new DoubleParameter(MessageManager.getString("label.inclusion_dom_score"), MessageManager.getString("label.inclusion_dom_score_desc"), false, 0.0, 0.0, 1000.0));
    }

    protected void addChoiceOfDatabase(List<ArgumentI> args) {
        String names = Cache.getProperty("HMMSEARCH_DBS");
        if (names == null || names.isEmpty()) {
            return;
        }
        ArrayList<String> filePaths = new ArrayList<String>();
        ArrayList<String> fileNames = new ArrayList<String>();
        String thisAlignment = MessageManager.getString("label.this_alignment");
        filePaths.add(thisAlignment);
        fileNames.add(thisAlignment);
        Scanner nameScanner = new Scanner(names);
        nameScanner.useDelimiter(",");
        while (nameScanner.hasNext()) {
            String next = nameScanner.next();
            if ("null".equals(next)) {
                Cache.setProperty("HMMSEARCH_DBS", "");
                continue;
            }
            filePaths.add(next);
            int pos = next.lastIndexOf(File.separator);
            String fileName = next.substring(pos + 1);
            fileNames.add(fileName);
        }
        nameScanner.close();
        StringParameter databasesOption = new StringParameter(MessageManager.getString("label.database"), MessageManager.getString("label.database_for_hmmsearch"), true, thisAlignment, thisAlignment, filePaths, fileNames);
        args.add(databasesOption);
    }

    private void getHMMAlignParams(List<ArgumentI> args) {
        this.addChoiceOfHmm(args);
        boolean def = Cache.getDefault("HMMALIGN_TRIM_TERMINI", false);
        args.add(new BooleanOption(MessageManager.getString("label.trim_termini"), MessageManager.getString("label.trim_termini_desc"), false, false, def, null));
    }

    protected void addChoiceOfHmm(List<ArgumentI> args) {
        List<SequenceI> hmms = this.viewport.getAlignment().getHmmSequences();
        if (!hmms.isEmpty()) {
            ArrayList<String> options = new ArrayList<String>();
            for (SequenceI hmmSeq : hmms) {
                options.add(hmmSeq.getName());
            }
            String defseq = (String)options.get(0);
            StringParameter arg = new StringParameter(MessageManager.getString("label.use_hmm"), null, true, defseq, defseq, (List<String>)options, null);
            args.add(arg);
        }
    }

    protected void addChoiceOfSequence(List<ArgumentI> args) {
        List<SequenceI> sequences = this.viewport.getAlignment().getSequences();
        ArrayList<String> options = new ArrayList<String>();
        for (SequenceI seq : sequences) {
            options.add(seq.getName());
        }
        String defseq = (String)options.get(0);
        StringParameter arg = new StringParameter(MessageManager.getString("label.use_sequence"), null, true, defseq, defseq, (List<String>)options, null);
        args.add(arg);
    }

    private void getHMMBuildParams(List<ArgumentI> args) {
        String defValue = "Alignment_HMM";
        StringParameter nameParam = new StringParameter(MessageManager.getString("label.hmm_name"), MessageManager.getString("label.hmm_name_desc"), true, defValue, defValue);
        args.add(nameParam);
        if (this.viewport.hasReferenceAnnotation()) {
            args.add(new BooleanOption(MessageManager.getString("label.use_reference"), MessageManager.getString("label.use_reference_desc"), true, true, true, null));
        }
        if (!this.viewport.getAlignment().getGroups().isEmpty()) {
            ArrayList<String> options = new ArrayList<String>();
            options.add(MessageManager.getString("label.alignment"));
            options.add(MessageManager.getString("label.groups_and_alignment"));
            options.add(MessageManager.getString("label.groups"));
            options.add(MessageManager.getString("label.selected_group"));
            args.add(new Option(MessageManager.getString("label.hmmbuild_for"), MessageManager.getString("label.hmmbuild_for_desc"), true, MessageManager.getString("label.alignment"), MessageManager.getString("label.alignment"), options, null));
        }
    }

    @Override
    public boolean presetExists(String forName) {
        return false;
    }

    @Override
    public void deletePreset(String forName) {
    }

    @Override
    public void storePreset(String presetName, String text, List<ArgumentI> jobParams) {
    }

    @Override
    public void updatePreset(String oldName, String presetName, String text, List<ArgumentI> jobParams) {
    }

    @Override
    public WsParamSetI parseServiceParameterFile(String forName, String description, String[] serviceURL, String parameters) throws IOException {
        return null;
    }

    @Override
    public String generateServiceParameterFile(WsParamSetI pset) throws IOException {
        return null;
    }
}

