/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.RestServiceEditorPane;
import jalview.jbgui.GWsPreferences;
import jalview.util.MessageManager;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.rest.RestClient;
import jalview.ws.rest.RestServiceDescription;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class WsPreferences
extends GWsPreferences {
    List<String> wsUrls;
    Vector<String> oldUrls;
    Vector<String> rsbsUrls;
    Vector<String> oldRsbsUrls;
    private boolean needWsMenuUpdate;
    private boolean oldJws1;
    private boolean oldJws2;
    private boolean oldIndexByHost;
    private boolean oldIndexByType;
    private boolean oldEnfin;
    private boolean oldWsWarning;
    ActionListener updateAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ++WsPreferences.this.update;
        }
    };
    private long update = 0L;
    private long lastrefresh = 0L;

    public WsPreferences() {
        this.initFromPreferences();
    }

    private void initFromPreferences() {
        this.wsUrls = Jws2Discoverer.getDiscoverer().getServiceUrls();
        if (!this.wsUrls.isEmpty()) {
            this.oldUrls = new Vector<String>(this.wsUrls);
        } else {
            this.oldUrls = null;
            this.wsUrls = new Vector<String>();
        }
        this.wsList.setDefaultRenderer(Integer.class, new JabaWSStatusRenderer());
        this.wsList.setAutoResizeMode(4);
        this.updateList();
        this.rsbsUrls = RestClient.getRsbsDescriptions();
        if (this.rsbsUrls != null) {
            this.oldRsbsUrls = new Vector<String>(this.rsbsUrls);
        } else {
            this.oldRsbsUrls = null;
            this.rsbsUrls = new Vector();
        }
        this.updateRsbsList();
        this.oldEnfin = Cache.getDefault("SHOW_ENFIN_SERVICES", true);
        this.enableEnfinServices.setSelected(this.oldEnfin);
        this.enableEnfinServices.addActionListener(this.updateAction);
        this.oldJws2 = Cache.getDefault("SHOW_JWS2_SERVICES", true);
        this.enableJws2Services.setSelected(this.oldJws2);
        this.enableJws2Services.addActionListener(this.updateAction);
        this.oldIndexByHost = Cache.getDefault("WSMENU_BYHOST", false);
        this.indexByHost.setSelected(this.oldIndexByHost);
        this.indexByHost.addActionListener(this.updateAction);
        this.oldIndexByType = Cache.getDefault("WSMENU_BYTYPE", false);
        this.indexByType.setSelected(this.oldIndexByType);
        this.indexByType.addActionListener(this.updateAction);
        this.oldWsWarning = Cache.getDefault("SHOW_WSDISCOVERY_ERRORS", true);
        this.displayWsWarning.setSelected(this.oldWsWarning);
    }

    private void updateList() {
        Object[][] tdat = new Object[this.wsUrls.size()][2];
        int r = 0;
        for (String url : this.wsUrls) {
            int status = Jws2Discoverer.getDiscoverer().getServerStatusFor(url);
            tdat[r][1] = status;
            tdat[r++][0] = url;
        }
        this.wsList.setModel(new WsUrlTableModel(tdat));
        this.wsList.getColumn(MessageManager.getString("label.status")).setMinWidth(10);
    }

    private void updateRsbsList() {
        this.sbrsList.setListData(this.rsbsUrls);
    }

    private void updateServiceList() {
        Jws2Discoverer.getDiscoverer().setServiceUrls(this.wsUrls);
    }

    private void updateRsbsServiceList() {
        RestClient.setRsbsServices(this.rsbsUrls);
    }

    @Override
    protected void deleteWsUrl_actionPerformed(ActionEvent e) {
        int sel = this.wsList.getSelectedRow();
        if (sel > -1) {
            this.wsUrls.remove(sel);
            ++this.update;
            this.updateList();
        }
    }

    @Override
    protected void editWsUrl_actionPerformed(ActionEvent e) {
        String url;
        int sel = this.wsList.getSelectedRow();
        if (sel > -1 && (url = this.editUrl(this.wsUrls.get(sel), MessageManager.getString("label.edit_jabaws_url"))) != null) {
            int present = this.wsUrls.indexOf(url);
            if (present == -1) {
                ++this.update;
                this.wsUrls.set(sel, url);
                this.updateList();
            } else if (present != sel) {
                this.wsUrls.remove(sel);
                this.updateList();
            }
        }
    }

    @Override
    protected void newSbrsUrl_actionPerformed(ActionEvent e) {
        RestServiceEditorPane rse = new RestServiceEditorPane();
        rse.showDialog(MessageManager.getString("label.add_new_sbrs_service"));
        String rservice = rse.getEditedRestService();
        if (rservice != null && !this.rsbsUrls.contains(rservice)) {
            this.rsbsUrls.add(rservice);
            ++this.update;
            this.updateRsbsList();
        }
    }

    @Override
    protected void editSbrsUrl_actionPerformed(ActionEvent e) {
        int sel = this.sbrsList.getSelectedIndex();
        if (sel > -1) {
            RestServiceEditorPane rse = new RestServiceEditorPane(new RestServiceDescription(this.rsbsUrls.elementAt(sel)));
            rse.showDialog(MessageManager.getString("label.edit_sbrs_entry"));
            String rservice = rse.getEditedRestService();
            if (rservice != null) {
                int present = this.rsbsUrls.indexOf(rservice);
                if (present == -1) {
                    ++this.update;
                    this.rsbsUrls.setElementAt(rservice, sel);
                    this.updateRsbsList();
                } else if (present != sel) {
                    this.rsbsUrls.removeElementAt(sel);
                    ++this.update;
                    this.updateRsbsList();
                }
            }
        }
    }

    void updateWsMenuConfig(boolean old) {
        if (old) {
            if (this.oldUrls != this.wsUrls || this.wsUrls != null && this.oldUrls != null && !this.wsUrls.equals(this.oldUrls)) {
                ++this.update;
            }
            Vector<String> vector = this.wsUrls = this.oldUrls == null ? null : new Vector<String>(this.oldUrls);
            if (this.oldRsbsUrls != this.rsbsUrls || this.rsbsUrls != null && this.oldRsbsUrls != null && !this.oldRsbsUrls.equals(this.rsbsUrls)) {
                ++this.update;
            }
            this.oldRsbsUrls = this.oldRsbsUrls == null ? null : new Vector<String>(this.oldRsbsUrls);
        }
        Cache.setProperty("SHOW_ENFIN_SERVICES", Boolean.valueOf(old ? this.oldEnfin : this.enableEnfinServices.isSelected()).toString());
        Cache.setProperty("SHOW_JWS2_SERVICES", Boolean.valueOf(old ? this.oldJws2 : this.enableJws2Services.isSelected()).toString());
        Cache.setProperty("WSMENU_BYHOST", Boolean.valueOf(old ? this.oldIndexByHost : this.indexByHost.isSelected()).toString());
        Cache.setProperty("WSMENU_BYTYPE", Boolean.valueOf(old ? this.oldIndexByType : this.indexByType.isSelected()).toString());
        Cache.setProperty("SHOW_WSDISCOVERY_ERRORS", Boolean.valueOf(old ? this.oldWsWarning : this.displayWsWarning.isSelected()).toString());
        this.updateServiceList();
        this.updateRsbsServiceList();
    }

    @Override
    protected void moveWsUrlDown_actionPerformed(ActionEvent e) {
        int p = this.wsList.getSelectedRow();
        if (p > -1 && p < this.wsUrls.size() - 1) {
            String t = this.wsUrls.get(p + 1);
            this.wsUrls.set(p + 1, this.wsUrls.get(p));
            this.wsUrls.set(p, t);
            this.updateList();
            this.wsList.getSelectionModel().setSelectionInterval(p + 1, p + 1);
            ++this.update;
        }
    }

    @Override
    protected void moveWsUrlUp_actionPerformed(ActionEvent e) {
        int p = this.wsList.getSelectedRow();
        if (p > 0) {
            String t = this.wsUrls.get(p - 1);
            this.wsUrls.set(p - 1, this.wsUrls.get(p));
            this.wsUrls.set(p, t);
            this.updateList();
            this.wsList.getSelectionModel().setSelectionInterval(p - 1, p - 1);
            ++this.update;
        }
    }

    private String editUrl(String initUrl, String title) {
        String url = initUrl;
        URL foo = null;
        if (url == null) {
            url = "";
        }
        JTextField urltf = new JTextField(url, 40);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel pane12 = new JPanel(new BorderLayout());
        pane12.add((Component)new JLabel(MessageManager.getString("label.url:")), "Center");
        pane12.add((Component)urltf, "East");
        panel.add((Component)pane12, "North");
        boolean valid = false;
        int resp = 2;
        while (!valid && (resp = JvOptionPane.showInternalConfirmDialog(Desktop.desktop, panel, title, 2)) == 0) {
            try {
                String tx = urltf.getText().trim();
                while (tx.length() > 0 && tx.lastIndexOf(47) == tx.length() - 1) {
                    tx = tx.substring(0, tx.length() - 1);
                }
                foo = new URL(tx);
                valid = true;
                urltf.setText(tx);
            }
            catch (Exception e) {
                valid = false;
                JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("label.invalid_url"));
            }
        }
        if (valid && resp == 0) {
            int validate = JvOptionPane.showInternalConfirmDialog(Desktop.desktop, MessageManager.getString("info.validate_jabaws_server"), MessageManager.getString("label.test_server"), 0);
            if (validate == 0) {
                if (Jws2Discoverer.testServiceUrl(foo)) {
                    return foo.toString();
                }
                int opt = JvOptionPane.showInternalOptionDialog(Desktop.desktop, "The Server  '" + foo.toString() + "' failed validation,\ndo you want to add it anyway? ", "Server Validation Failed", 0, 1, null, null, null);
                if (opt == 0) {
                    return foo.toString();
                }
                JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("warn.server_didnt_pass_validation"));
            } else {
                return foo.toString();
            }
        }
        return initUrl;
    }

    @Override
    protected void newWsUrl_actionPerformed(ActionEvent e) {
        String url = this.editUrl(null, MessageManager.getString("label.add_jabaws_url"));
        if (url != null && !this.wsUrls.contains(url)) {
            int selind = this.wsList.getSelectedRow();
            if (selind > -1) {
                this.wsUrls.add(selind, url);
            } else {
                this.wsUrls.add(url);
            }
            ++this.update;
            this.updateList();
        }
    }

    @Override
    protected void refreshWs_actionPerformed(ActionEvent e) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WsPreferences.this.lastrefresh = WsPreferences.this.update - 1L;
                WsPreferences.this.updateWsMenuConfig(false);
                WsPreferences.this.refreshWsMenu(true);
            }
        }).start();
    }

    protected void refreshWsMenu(boolean showProgress) {
        if (showProgress) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    WsPreferences.this.progressBar.setVisible(true);
                    WsPreferences.this.validate();
                    WsPreferences.this.progressBar.setIndeterminate(true);
                    if (WsPreferences.this.lastrefresh != WsPreferences.this.update) {
                        WsPreferences.this.lastrefresh = WsPreferences.this.update;
                        Desktop.instance.startServiceDiscovery(true);
                        WsPreferences.this.updateList();
                    }
                    WsPreferences.this.progressBar.setIndeterminate(false);
                    WsPreferences.this.progressBar.setVisible(false);
                    WsPreferences.this.validate();
                }
            }).start();
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long ct = System.currentTimeMillis();
                    Desktop.instance.setProgressBar(MessageManager.getString("status.refreshing_web_service_menus"), ct);
                    if (WsPreferences.this.lastrefresh != WsPreferences.this.update) {
                        WsPreferences.this.lastrefresh = WsPreferences.this.update;
                        Desktop.instance.startServiceDiscovery(true);
                        WsPreferences.this.updateList();
                    }
                    Desktop.instance.setProgressBar(null, ct);
                }
            }).start();
        }
    }

    @Override
    protected void resetWs_actionPerformed(ActionEvent e) {
        Jws2Discoverer.getDiscoverer().setServiceUrls(null);
        List<String> nwsUrls = Jws2Discoverer.getDiscoverer().getServiceUrls();
        if (!this.wsUrls.equals(nwsUrls)) {
            ++this.update;
        }
        this.wsUrls = nwsUrls;
        this.updateList();
        this.updateAndRefreshWsMenuConfig(true);
    }

    protected void ok_ActionPerformed(ActionEvent e) {
        this.updateAndRefreshWsMenuConfig(false);
    }

    public void updateAndRefreshWsMenuConfig(final boolean showProgressInDialog) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WsPreferences.this.updateWsMenuConfig(false);
                WsPreferences.this.refreshWsMenu(showProgressInDialog);
            }
        }).start();
    }

    private class WsUrlTableModel
    extends AbstractTableModel {
        private Object[][] data;
        private String[] columnNames = new String[]{MessageManager.getString("label.service_url"), MessageManager.getString("label.status")};

        public WsUrlTableModel(Object[][] tdat) {
            this.data = tdat;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][columnIndex];
        }
    }

    private class JabaWSStatusRenderer
    extends JPanel
    implements TableCellRenderer {
        public JabaWSStatusRenderer() {
            this.setOpaque(true);
            this.setMinimumSize(new Dimension(10, 10));
        }

        @Override
        public Component getTableCellRendererComponent(JTable arg0, Object status, boolean isSelected, boolean hasFocus, int row, int column) {
            Color c;
            String t = new String("");
            switch ((Integer)status) {
                case 1: {
                    c = Color.green;
                    break;
                }
                case 0: {
                    c = Color.lightGray;
                    break;
                }
                case -1: {
                    c = Color.red;
                    break;
                }
                default: {
                    c = Color.orange;
                }
            }
            this.setBackground(c);
            return this;
        }
    }
}

