/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignmentSorter;
import jalview.analysis.AverageDistanceTree;
import jalview.analysis.NJTree;
import jalview.analysis.TreeBuilder;
import jalview.analysis.TreeModel;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Cache;
import jalview.commands.CommandI;
import jalview.commands.OrderCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.NodeTransformI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.EPSOptions;
import jalview.gui.FontChooser;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.TreeCanvas;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.NewickFile;
import jalview.jbgui.GTreePanel;
import jalview.util.DBRefUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jibble.epsgraphics.EpsGraphics2D;

public class TreePanel
extends GTreePanel {
    String treeType;
    String scoreModelName;
    String treeTitle;
    SimilarityParamsI similarityParams;
    private TreeCanvas treeCanvas;
    TreeModel tree;
    private AlignViewport av;

    public TreePanel(AlignmentPanel ap, String type, String modelName, SimilarityParamsI options) {
        this.similarityParams = options;
        this.initTreePanel(ap, type, modelName, null, null);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile newtree, String theTitle, AlignmentView inputData) {
        this.treeTitle = theTitle;
        this.initTreePanel(alignPanel, null, null, newtree, inputData);
    }

    public AlignmentI getAlignment() {
        return this.getTreeCanvas().getViewport().getAlignment();
    }

    public AlignmentViewport getViewPort() {
        return this.getTreeCanvas().getViewport();
    }

    void initTreePanel(AlignmentPanel ap, String type, String modelName, NewickFile newTree, AlignmentView inputData) {
        this.setViewport(ap.av);
        this.treeType = type;
        this.scoreModelName = modelName;
        this.treeCanvas = new TreeCanvas(this, ap, this.scrollPane);
        this.scrollPane.setViewportView(this.getTreeCanvas());
        PaintRefresher.Register(this, ap.av.getSequenceSetId());
        this.buildAssociatedViewMenu();
        final PropertyChangeListener listener = this.addAlignmentListener();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                if (TreePanel.this.getViewport() != null) {
                    TreePanel.this.getViewport().removePropertyChangeListener(listener);
                }
            }
        });
        TreeLoader tl = new TreeLoader(newTree, inputData);
        tl.start();
    }

    protected PropertyChangeListener addAlignmentListener() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    if (TreePanel.this.tree == null) {
                        System.out.println("tree is null");
                        return;
                    }
                    if (evt.getNewValue() == null) {
                        System.out.println("new alignment sequences vector value is null");
                    }
                    TreePanel.this.tree.updatePlaceHolders((List)evt.getNewValue());
                    TreePanel.this.getTreeCanvas().nameHash.clear();
                    TreePanel.this.repaint();
                }
            }
        };
        this.getViewport().addPropertyChangeListener(listener);
        return listener;
    }

    @Override
    public void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.getViewport().getSequenceSetId());
        if (aps.length == 1 && this.getTreeCanvas().getAssociatedPanel() == aps[0]) {
            this.associateLeavesMenu.setVisible(false);
            return;
        }
        this.associateLeavesMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateLeavesMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        int iSize = aps.length;
        final TreePanel thisTreePanel = this;
        for (int i = 0; i < iSize; ++i) {
            final AlignmentPanel ap = aps[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ap.av.getViewName(), ap == this.getTreeCanvas().getAssociatedPanel());
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TreePanel.this.getTreeCanvas().applyToAllViews = false;
                    TreePanel.this.getTreeCanvas().setAssociatedPanel(ap);
                    TreePanel.this.getTreeCanvas().setViewport(ap.av);
                    PaintRefresher.Register(thisTreePanel, ap.av.getSequenceSetId());
                }
            });
            this.associateLeavesMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem(MessageManager.getString("label.all_views"));
        buttonGroup.add(itemf);
        itemf.setSelected(this.getTreeCanvas().applyToAllViews);
        itemf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePanel.this.getTreeCanvas().applyToAllViews = itemf.isSelected();
            }
        });
        this.associateLeavesMenu.add(itemf);
    }

    public void showDistances(boolean b) {
        this.getTreeCanvas().setShowDistances(b);
        this.distanceMenu.setSelected(b);
    }

    public void showBootstrap(boolean b) {
        this.getTreeCanvas().setShowBootstrap(b);
        this.bootstrapMenu.setSelected(b);
    }

    public void showPlaceholders(boolean b) {
        this.placeholdersMenu.setState(b);
        this.getTreeCanvas().setMarkPlaceholders(b);
    }

    public TreeModel getTree() {
        return this.tree;
    }

    @Override
    public void textbox_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        String newTitle = this.getPanelTitle();
        NewickFile fout = new NewickFile(this.tree.getTopNode());
        try {
            cap.setText(fout.print(this.tree.hasBootstrap(), this.tree.hasDistances(), this.tree.hasRootDistance()));
            Desktop.addInternalFrame(cap, newTitle, 500, 100);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("generating newick tree file", oom);
            cap.dispose();
        }
    }

    @Override
    public void saveAsNewick_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_tree_as_newick"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            try {
                NewickFile fout = new NewickFile(this.tree.getTopNode());
                String output = fout.print(this.tree.hasBootstrap(), this.tree.hasDistances(), this.tree.hasRootDistance());
                PrintWriter out = new PrintWriter(new FileWriter(choice));
                out.println(output);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void printMenu_actionPerformed(ActionEvent e) {
        this.getTreeCanvas().startPrinting();
    }

    @Override
    public void originalSeqData_actionPerformed(ActionEvent e) {
        AlignmentView originalData = this.tree.getOriginalData();
        if (originalData == null) {
            Cache.log.info((Object)"Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.getViewport().getGapCharacter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] alAndColsel = originalData.getAlignmentAndHiddenColumns(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            AlignmentI dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignmentI alignmentI = dataset = this.getViewport() != null && this.getViewport().getAlignment() != null ? this.getViewport().getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame((AlignmentI)al, (HiddenColumns)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, MessageManager.formatMessage("label.original_data_for_params", this.title), 700, 500);
        }
    }

    @Override
    public void fitToWindow_actionPerformed(ActionEvent e) {
        this.getTreeCanvas().fitToWindow = this.fitToWindow.isSelected();
        this.repaint();
    }

    @Override
    public void sortByTree_actionPerformed() {
        if (this.getTreeCanvas().applyToAllViews) {
            final ArrayList<CommandI> commands = new ArrayList<CommandI>();
            for (AlignmentPanel ap : PaintRefresher.getAssociatedPanels(this.getViewport().getSequenceSetId())) {
                commands.add(this.sortAlignmentIn(ap.av.getAlignPanel()));
            }
            this.getViewport().getAlignPanel().alignFrame.addHistoryItem(new CommandI(){

                @Override
                public void undoCommand(AlignmentI[] views) {
                    for (CommandI tsort : commands) {
                        tsort.undoCommand(views);
                    }
                }

                @Override
                public int getSize() {
                    return commands.size();
                }

                @Override
                public String getDescription() {
                    return "Tree Sort (many views)";
                }

                @Override
                public void doCommand(AlignmentI[] views) {
                    for (CommandI tsort : commands) {
                        tsort.doCommand(views);
                    }
                }
            });
            for (AlignmentPanel ap : PaintRefresher.getAssociatedPanels(this.getViewport().getSequenceSetId())) {
                ap.alignFrame.updateEditMenuBar();
            }
        } else {
            this.getTreeCanvas().getAssociatedPanel().alignFrame.addHistoryItem(this.sortAlignmentIn(this.getTreeCanvas().getAssociatedPanel()));
        }
    }

    public CommandI sortAlignmentIn(AlignmentPanel ap) {
        AlignViewport viewport = ap.av;
        SequenceI[] oldOrder = viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByTree(viewport.getAlignment(), this.tree);
        OrderCommand undo = new OrderCommand("Tree Sort", oldOrder, viewport.getAlignment());
        ap.paintAlignment(true, false);
        return undo;
    }

    @Override
    public void font_actionPerformed(ActionEvent e) {
        if (this.getTreeCanvas() == null) {
            return;
        }
        new FontChooser(this);
    }

    public Font getTreeFont() {
        return this.getTreeCanvas().font;
    }

    public void setTreeFont(Font f) {
        if (this.getTreeCanvas() != null) {
            this.getTreeCanvas().setFont(f);
        }
    }

    @Override
    public void distanceMenu_actionPerformed(ActionEvent e) {
        this.getTreeCanvas().setShowDistances(this.distanceMenu.isSelected());
    }

    @Override
    public void bootstrapMenu_actionPerformed(ActionEvent e) {
        this.getTreeCanvas().setShowBootstrap(this.bootstrapMenu.isSelected());
    }

    @Override
    public void placeholdersMenu_actionPerformed(ActionEvent e) {
        this.getTreeCanvas().setMarkPlaceholders(this.placeholdersMenu.isSelected());
    }

    @Override
    public void epsTree_actionPerformed(ActionEvent e) {
        EPSOptions eps;
        boolean accurateText = true;
        String renderStyle = Cache.getDefault("EPS_RENDERING", "Prompt each time");
        if (!(!renderStyle.equalsIgnoreCase("Prompt each time") || System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true") || (renderStyle = (eps = new EPSOptions()).getValue()) != null && !eps.cancelled)) {
            return;
        }
        if (renderStyle.equalsIgnoreCase("text")) {
            accurateText = false;
        }
        int width = this.getTreeCanvas().getWidth();
        int height = this.getTreeCanvas().getHeight();
        try {
            JalviewFileChooser chooser = new JalviewFileChooser("eps", "eps");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(MessageManager.getString("label.create_eps_from_tree"));
            chooser.setToolTipText(MessageManager.getString("action.save"));
            int value = chooser.showSaveDialog(this);
            if (value != 0) {
                return;
            }
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
            EpsGraphics2D pg = new EpsGraphics2D("Tree", out, 0, 0, width, height);
            pg.setAccurateTextMode(accurateText);
            this.getTreeCanvas().draw(pg, width, height);
            pg.flush();
            pg.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void pngTree_actionPerformed(ActionEvent e) {
        int width = this.getTreeCanvas().getWidth();
        int height = this.getTreeCanvas().getHeight();
        try {
            JalviewFileChooser chooser = new JalviewFileChooser("png", "Portable  network graphics");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(MessageManager.getString("label.create_png_from_tree"));
            chooser.setToolTipText(MessageManager.getString("action.save"));
            int value = chooser.showSaveDialog(this);
            if (value != 0) {
                return;
            }
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            FileOutputStream out = new FileOutputStream(chooser.getSelectedFile());
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics png = bi.getGraphics();
            this.getTreeCanvas().draw(png, width, height);
            ImageIO.write((RenderedImage)bi, "png", out);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void changeNames(final String labelClass) {
        this.tree.applyToNodes(new NodeTransformI(){

            @Override
            public void transform(BinaryNode node) {
                if (node instanceof SequenceNode && !((SequenceNode)node).isPlaceholder() && !((SequenceNode)node).isDummy()) {
                    Object newname = null;
                    SequenceI sq = (SequenceI)((SequenceNode)node).element();
                    if (sq != null) {
                        DBRefEntry[] refs = DBRefUtils.selectRefs(sq.getDBRefs(), new String[]{labelClass.toUpperCase()});
                        if (refs != null) {
                            for (int i = 0; i < refs.length; ++i) {
                                newname = newname == null ? new String(refs[i].getAccessionId()) : newname + "; " + refs[i].getAccessionId();
                            }
                        }
                        if (newname == null) {
                            List<SequenceFeature> features = sq.getFeatures().getPositionalFeatures(labelClass);
                            for (SequenceFeature feature : features) {
                                if (newname == null) {
                                    newname = feature.getDescription();
                                    continue;
                                }
                                newname = (String)newname + "; " + feature.getDescription();
                            }
                        }
                    }
                    if (newname != null) {
                        ((SequenceNode)node).setName((String)newname);
                    }
                }
            }
        });
    }

    public String getPanelTitle() {
        if (this.treeTitle != null) {
            return this.treeTitle;
        }
        String treecalcnm = MessageManager.getString("label.tree_calc_" + this.treeType.toLowerCase());
        String smn = this.scoreModelName;
        String ttl = MessageManager.formatMessage("label.calc_title", treecalcnm, smn);
        return ttl;
    }

    public AlignViewport getViewport() {
        return this.av;
    }

    public void setViewport(AlignViewport av) {
        this.av = av;
    }

    public TreeCanvas getTreeCanvas() {
        return this.treeCanvas;
    }

    class TreeLoader
    extends Thread {
        private NewickFile newtree;
        private AlignmentView odata = null;

        public TreeLoader(NewickFile newickFile, AlignmentView inputData) {
            this.newtree = newickFile;
            this.odata = inputData;
            if (newickFile != null) {
                TreePanel.this.showBootstrap(newickFile.HasBootstrap());
                TreePanel.this.showDistances(newickFile.HasDistances());
            }
        }

        @Override
        public void run() {
            if (this.newtree != null) {
                TreePanel.this.tree = new TreeModel(TreePanel.this.getViewport().getAlignment().getSequencesArray(), this.odata, this.newtree);
                if (TreePanel.this.tree.getOriginalData() == null) {
                    TreePanel.this.originalSeqData.setVisible(false);
                }
            } else {
                ScoreModelI sm = ScoreModels.getInstance().getScoreModel(TreePanel.this.scoreModelName, TreePanel.this.getTreeCanvas().getAssociatedPanel());
                TreeBuilder njtree = TreePanel.this.treeType.equals("NJ") ? new NJTree(TreePanel.this.getViewport(), sm, TreePanel.this.similarityParams) : new AverageDistanceTree(TreePanel.this.getViewport(), sm, TreePanel.this.similarityParams);
                TreePanel.this.tree = new TreeModel(njtree);
                TreePanel.this.showDistances(true);
            }
            TreePanel.this.tree.reCount(TreePanel.this.tree.getTopNode());
            TreePanel.this.tree.findHeight(TreePanel.this.tree.getTopNode());
            TreePanel.this.getTreeCanvas().setTree(TreePanel.this.tree);
            TreePanel.this.getTreeCanvas().repaint();
            TreePanel.this.getViewport().setCurrentTree(TreePanel.this.tree);
            if (TreePanel.this.getViewport().getSortByTree()) {
                TreePanel.this.sortByTree_actionPerformed();
            }
        }
    }
}

