/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignmentPanel;
import jalview.gui.JvOptionPane;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TextColourChooser {
    AlignmentPanel ap;
    SequenceGroup sg;
    Color original1;
    Color original2;
    int originalThreshold;
    Map<SequenceGroup, Color> groupColour1;
    Map<SequenceGroup, Color> groupColour2;
    Map<SequenceGroup, Integer> groupThreshold;

    public void chooseColour(AlignmentPanel alignPanel, SequenceGroup sequenceGroup) {
        this.ap = alignPanel;
        this.sg = sequenceGroup;
        this.saveInitialSettings();
        final JSlider slider = new JSlider(0, 750, this.originalThreshold);
        final JPanel col1 = new JPanel();
        col1.setPreferredSize(new Dimension(40, 20));
        col1.setBorder(BorderFactory.createEtchedBorder());
        col1.setToolTipText(MessageManager.getString("label.dark_colour"));
        col1.setBackground(this.original1);
        final JPanel col2 = new JPanel();
        col2.setPreferredSize(new Dimension(40, 20));
        col2.setBorder(BorderFactory.createEtchedBorder());
        col2.setToolTipText(MessageManager.getString("label.light_colour"));
        col2.setBackground(this.original2);
        final JPanel bigpanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel();
        bigpanel.add((Component)panel, "Center");
        bigpanel.add((Component)new JLabel("<html>" + MessageManager.getString("label.select_dark_light_set_threshold") + "</html>"), "North");
        panel.add(col1);
        panel.add(slider);
        panel.add(col2);
        col1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Color col = JColorChooser.showDialog(bigpanel, MessageManager.getString("label.select_colour_for_text"), col1.getBackground());
                if (col != null) {
                    TextColourChooser.this.colour1Changed(col);
                    col1.setBackground(col);
                }
            }
        });
        col2.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Color col = JColorChooser.showDialog(bigpanel, MessageManager.getString("label.select_colour_for_text"), col2.getBackground());
                if (col != null) {
                    TextColourChooser.this.colour2Changed(col);
                    col2.setBackground(col);
                }
            }
        });
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TextColourChooser.this.thresholdChanged(slider.getValue());
            }
        });
        int reply = JvOptionPane.showInternalOptionDialog(alignPanel, bigpanel, MessageManager.getString("label.adjunst_foreground_text_colour_threshold"), 2, 3, null, null, null);
        if (reply == 2) {
            this.restoreInitialSettings();
        }
    }

    protected void restoreInitialSettings() {
        if (this.sg == null) {
            this.ap.av.setTextColour(this.original1);
            this.ap.av.setTextColour2(this.original2);
            this.ap.av.setThresholdTextColour(this.originalThreshold);
        } else {
            this.sg.textColour = this.original1;
            this.sg.textColour2 = this.original2;
            this.sg.thresholdTextColour = this.originalThreshold;
        }
        for (SequenceGroup group : this.groupColour1.keySet()) {
            group.textColour = this.groupColour1.get(group);
            group.textColour2 = this.groupColour2.get(group);
            group.thresholdTextColour = this.groupThreshold.get(group);
        }
    }

    protected void saveInitialSettings() {
        this.groupColour1 = new HashMap<SequenceGroup, Color>();
        this.groupColour2 = new HashMap<SequenceGroup, Color>();
        this.groupThreshold = new HashMap<SequenceGroup, Integer>();
        if (this.sg == null) {
            this.original1 = this.ap.av.getTextColour();
            this.original2 = this.ap.av.getTextColour2();
            this.originalThreshold = this.ap.av.getThresholdTextColour();
            if (this.ap.av.getColourAppliesToAllGroups() && this.ap.av.getAlignment().getGroups() != null) {
                for (SequenceGroup group : this.ap.av.getAlignment().getGroups()) {
                    this.groupColour1.put(group, group.textColour);
                    this.groupColour2.put(group, group.textColour2);
                    this.groupThreshold.put(group, group.thresholdTextColour);
                }
            }
        } else {
            this.original1 = this.sg.textColour;
            this.original2 = this.sg.textColour2;
            this.originalThreshold = this.sg.thresholdTextColour;
        }
    }

    void colour1Changed(Color col) {
        if (this.sg == null) {
            this.ap.av.setTextColour(col);
            if (this.ap.av.getColourAppliesToAllGroups()) {
                this.setGroupTextColour();
            }
        } else {
            this.sg.textColour = col;
        }
        this.ap.paintAlignment(false, false);
    }

    void colour2Changed(Color col) {
        if (this.sg == null) {
            this.ap.av.setTextColour2(col);
            if (this.ap.av.getColourAppliesToAllGroups()) {
                this.setGroupTextColour();
            }
        } else {
            this.sg.textColour2 = col;
        }
        this.ap.paintAlignment(false, false);
    }

    void thresholdChanged(int value) {
        if (this.sg == null) {
            this.ap.av.setThresholdTextColour(value);
            if (this.ap.av.getColourAppliesToAllGroups()) {
                this.setGroupTextColour();
            }
        } else {
            this.sg.thresholdTextColour = value;
        }
        this.ap.paintAlignment(false, false);
    }

    void setGroupTextColour() {
        if (this.ap.av.getAlignment().getGroups() == null) {
            return;
        }
        for (SequenceGroup group : this.ap.av.getAlignment().getGroups()) {
            group.textColour = this.ap.av.getTextColour();
            group.textColour2 = this.ap.av.getTextColour2();
            group.thresholdTextColour = this.ap.av.getThresholdTextColour();
        }
    }
}

