/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.service.pdb.PDBFTSRestClient;
import jalview.gui.AlignmentPanel;
import jalview.gui.AssociatePdbFileWithSeq;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.ProgressBar;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.io.DataSourceType;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GStructureChooser;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import jalview.ws.DBRefFetcher;
import jalview.ws.sifts.SiftsSettings;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class StructureChooser
extends GStructureChooser
implements IProgressIndicator {
    private static final String AUTOSUPERIMPOSE = "AUTOSUPERIMPOSE";
    private static int MAX_QLENGTH = 7820;
    private SequenceI selectedSequence;
    private SequenceI[] selectedSequences;
    private IProgressIndicator progressIndicator;
    private Collection<FTSData> discoveredStructuresSet;
    private FTSRestRequest lastPdbRequest;
    private FTSRestClientI pdbRestCleint;
    private String selectedPdbFileName;
    private boolean isValidPBDEntry;
    private boolean cachedPDBExists;
    private static StructureViewer lastTargetedView = null;
    private StructureViewer sViewer = null;
    private IProgressIndicator progressBar;

    public StructureChooser(SequenceI[] selectedSeqs, SequenceI selectedSeq, AlignmentPanel ap) {
        this.ap = ap;
        this.selectedSequence = selectedSeq;
        this.selectedSequences = selectedSeqs;
        this.progressIndicator = ap == null ? null : ap.alignFrame;
        this.init();
    }

    protected void init() {
        if (!Jalview.isHeadlessMode()) {
            this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        }
        this.chk_superpose.setSelected(Cache.getDefault(AUTOSUPERIMPOSE, true));
        this.populateFilterComboBox(true, this.cachedPDBExists);
        Thread discoverPDBStructuresThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                StructureChooser.this.updateProgressIndicator(MessageManager.getString("status.loading_cached_pdb_entries"), startTime);
                StructureChooser.this.loadLocalCachedPDBEntries();
                StructureChooser.this.updateProgressIndicator(null, startTime);
                StructureChooser.this.updateProgressIndicator(MessageManager.getString("status.searching_for_pdb_structures"), startTime);
                StructureChooser.this.fetchStructuresMetaData();
                StructureChooser.this.populateFilterComboBox(StructureChooser.this.isStructuresDiscovered(), StructureChooser.this.cachedPDBExists);
                StructureChooser.this.discoverStructureViews();
                StructureChooser.this.updateProgressIndicator(null, startTime);
                StructureChooser.this.mainFrame.setVisible(true);
                StructureChooser.this.updateCurrentView();
            }
        });
        discoverPDBStructuresThread.start();
    }

    private void discoverStructureViews() {
        if (Desktop.instance != null) {
            this.targetView.removeAllItems();
            if (lastTargetedView != null && !lastTargetedView.isVisible()) {
                lastTargetedView = null;
            }
            int linkedViewsAt = 0;
            for (StructureViewerBase view : Desktop.instance.getStructureViewers(null, null)) {
                StructureViewer viewHandler;
                StructureViewer structureViewer = viewHandler = lastTargetedView != null && StructureChooser.lastTargetedView.sview == view ? lastTargetedView : StructureViewer.reconfigure(view);
                if (view.isLinkedWith(this.ap)) {
                    this.targetView.insertItemAt(viewHandler, linkedViewsAt++);
                    continue;
                }
                this.targetView.addItem(viewHandler);
            }
            this.targetView.setVisible(false);
            if (this.targetView.getItemCount() > 0) {
                this.targetView.setVisible(true);
                if (lastTargetedView != null) {
                    this.targetView.setSelectedItem(lastTargetedView);
                } else {
                    this.targetView.setSelectedIndex(0);
                }
            }
            this.btn_add.setVisible(this.targetView.isVisible());
        }
    }

    protected void updateProgressIndicator(String message, long id) {
        if (this.progressIndicator != null) {
            this.progressIndicator.setProgressBar(message, id);
        }
    }

    void fetchStructuresMetaData() {
        long startTime = System.currentTimeMillis();
        this.pdbRestCleint = PDBFTSRestClient.getInstance();
        Collection<FTSDataColumnI> wantedFields = this.pdbDocFieldPrefs.getStructureSummaryFields();
        this.discoveredStructuresSet = new LinkedHashSet<FTSData>();
        HashSet<String> errors = new HashSet<String>();
        for (SequenceI seq : this.selectedSequences) {
            FTSRestResponse resultList;
            FTSRestRequest pdbRequest = new FTSRestRequest();
            pdbRequest.setAllowEmptySeq(false);
            pdbRequest.setResponseSize(500);
            pdbRequest.setFieldToSearchBy("(");
            GStructureChooser.FilterOption selectedFilterOpt = (GStructureChooser.FilterOption)this.cmb_filterOption.getSelectedItem();
            pdbRequest.setFieldToSortBy(selectedFilterOpt.getValue(), !this.chk_invertFilter.isSelected());
            pdbRequest.setWantedFields(wantedFields);
            pdbRequest.setSearchTerm(StructureChooser.buildQuery(seq) + ")");
            pdbRequest.setAssociatedSequence(seq);
            try {
                resultList = this.pdbRestCleint.executeRequest(pdbRequest);
            }
            catch (Exception e) {
                e.printStackTrace();
                errors.add(e.getMessage());
                continue;
            }
            this.lastPdbRequest = pdbRequest;
            if (resultList.getSearchSummary() == null || resultList.getSearchSummary().isEmpty()) continue;
            this.discoveredStructuresSet.addAll(resultList.getSearchSummary());
        }
        int noOfStructuresFound = 0;
        String totalTime = System.currentTimeMillis() - startTime + " milli secs";
        if (this.discoveredStructuresSet != null && !this.discoveredStructuresSet.isEmpty()) {
            this.getResultTable().setModel(FTSRestResponse.getTableModel(this.lastPdbRequest, this.discoveredStructuresSet));
            noOfStructuresFound = this.discoveredStructuresSet.size();
            this.mainFrame.setTitle(MessageManager.formatMessage("label.structure_chooser_no_of_structures", noOfStructuresFound, totalTime));
        } else {
            this.mainFrame.setTitle(MessageManager.getString("label.structure_chooser_manual_association"));
            if (errors.size() > 0) {
                StringBuilder errorMsg = new StringBuilder();
                for (String error : errors) {
                    errorMsg.append(error).append("\n");
                }
                JvOptionPane.showMessageDialog(this, errorMsg.toString(), MessageManager.getString("label.pdb_web-service_error"), 0);
            }
        }
    }

    protected void loadLocalCachedPDBEntries() {
        ArrayList<CachedPDB> entries = new ArrayList<CachedPDB>();
        for (SequenceI seq : this.selectedSequences) {
            if (seq.getDatasetSequence() == null || seq.getDatasetSequence().getAllPDBEntries() == null) continue;
            for (PDBEntry pdbEntry : seq.getDatasetSequence().getAllPDBEntries()) {
                if (pdbEntry.getFile() == null) continue;
                entries.add(new CachedPDB(seq, pdbEntry));
            }
        }
        this.cachedPDBExists = !entries.isEmpty();
        PDBEntryTableModel tableModelx = new PDBEntryTableModel(entries);
        this.tbl_local_pdb.setModel(tableModelx);
    }

    static String buildQuery(SequenceI seq) {
        boolean isPDBRefsFound = false;
        boolean isUniProtRefsFound = false;
        StringBuilder queryBuilder = new StringBuilder();
        LinkedHashSet<String> seqRefs = new LinkedHashSet<String>();
        HashSet<String> pdbids = new HashSet<String>();
        if (seq.getAllPDBEntries() != null && queryBuilder.length() < MAX_QLENGTH) {
            for (PDBEntry entry : seq.getAllPDBEntries()) {
                if (!StructureChooser.isValidSeqName(entry.getId())) continue;
                String id = entry.getId().toLowerCase();
                queryBuilder.append("pdb_id:").append(id).append(" OR ");
                isPDBRefsFound = true;
                pdbids.add(id);
            }
        }
        if (seq.getDBRefs() != null && seq.getDBRefs().length != 0) {
            for (DBRefEntry dbRef : seq.getDBRefs()) {
                if (!StructureChooser.isValidSeqName(StructureChooser.getDBRefId(dbRef)) || queryBuilder.length() >= MAX_QLENGTH) continue;
                if (dbRef.getSource().equalsIgnoreCase("UNIPROT")) {
                    queryBuilder.append("uniprot_accession:").append(StructureChooser.getDBRefId(dbRef)).append(" OR ");
                    queryBuilder.append("uniprot_id:").append(StructureChooser.getDBRefId(dbRef)).append(" OR ");
                    isUniProtRefsFound = true;
                    continue;
                }
                if (dbRef.getSource().equalsIgnoreCase("PDB")) {
                    String id = StructureChooser.getDBRefId(dbRef).toLowerCase();
                    if (pdbids.contains(id)) continue;
                    queryBuilder.append("pdb_id:").append(id).append(" OR ");
                    isPDBRefsFound = true;
                    pdbids.add(id);
                    continue;
                }
                seqRefs.add(StructureChooser.getDBRefId(dbRef));
            }
        }
        if (!isPDBRefsFound && !isUniProtRefsFound) {
            String seqName = seq.getName();
            seqName = StructureChooser.sanitizeSeqName(seqName);
            String[] names = seqName.toLowerCase().split("\\|");
            for (String name : names) {
                name.trim();
                if (!StructureChooser.isValidSeqName(name)) continue;
                seqRefs.add(name);
            }
            for (String seqRef : seqRefs) {
                queryBuilder.append("text:").append(seqRef).append(" OR ");
            }
        }
        int endIndex = queryBuilder.lastIndexOf(" OR ");
        if (queryBuilder.toString().length() < 6) {
            return null;
        }
        String query = queryBuilder.toString().substring(0, endIndex);
        return query;
    }

    static String sanitizeSeqName(String seqName) {
        Objects.requireNonNull(seqName);
        return seqName.replaceAll("\\[\\d*\\]", "").replaceAll("[^\\dA-Za-z|_]", "").replaceAll("\\s+", "+");
    }

    static boolean isValidSeqName(String seqName) {
        String ignoreList = "pdb,uniprot,swiss-prot";
        if (seqName.length() < 3) {
            return false;
        }
        if (seqName.contains(":")) {
            return false;
        }
        seqName = seqName.toLowerCase();
        for (String ignoredEntry : ignoreList.split(",")) {
            if (!seqName.contains(ignoredEntry)) continue;
            return false;
        }
        return true;
    }

    static String getDBRefId(DBRefEntry dbRef) {
        String ref = dbRef.getAccessionId().replaceAll("GO:", "");
        return ref;
    }

    void filterResultSet(final String fieldToFilterBy) {
        Thread filterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                StructureChooser.this.pdbRestCleint = PDBFTSRestClient.getInstance();
                StructureChooser.this.lbl_loading.setVisible(true);
                Collection<FTSDataColumnI> wantedFields = StructureChooser.this.pdbDocFieldPrefs.getStructureSummaryFields();
                HashSet<FTSData> filteredResponse = new HashSet<FTSData>();
                HashSet<String> errors = new HashSet<String>();
                for (SequenceI seq : StructureChooser.this.selectedSequences) {
                    FTSRestResponse resultList;
                    FTSRestRequest pdbRequest = new FTSRestRequest();
                    if (fieldToFilterBy.equalsIgnoreCase("uniprot_coverage")) {
                        pdbRequest.setAllowEmptySeq(false);
                        pdbRequest.setResponseSize(1);
                        pdbRequest.setFieldToSearchBy("(");
                        pdbRequest.setSearchTerm(StructureChooser.buildQuery(seq) + ")");
                        pdbRequest.setWantedFields(wantedFields);
                        pdbRequest.setAssociatedSequence(seq);
                        pdbRequest.setFacet(true);
                        pdbRequest.setFacetPivot(fieldToFilterBy + ",entry_entity");
                        pdbRequest.setFacetPivotMinCount(1);
                    } else {
                        pdbRequest.setAllowEmptySeq(false);
                        pdbRequest.setResponseSize(1);
                        pdbRequest.setFieldToSearchBy("(");
                        pdbRequest.setFieldToSortBy(fieldToFilterBy, !StructureChooser.this.chk_invertFilter.isSelected());
                        pdbRequest.setSearchTerm(StructureChooser.buildQuery(seq) + ")");
                        pdbRequest.setWantedFields(wantedFields);
                        pdbRequest.setAssociatedSequence(seq);
                    }
                    try {
                        resultList = StructureChooser.this.pdbRestCleint.executeRequest(pdbRequest);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.add(e.getMessage());
                        continue;
                    }
                    StructureChooser.this.lastPdbRequest = pdbRequest;
                    if (resultList.getSearchSummary() == null || resultList.getSearchSummary().isEmpty()) continue;
                    filteredResponse.addAll(resultList.getSearchSummary());
                }
                String totalTime = System.currentTimeMillis() - startTime + " milli secs";
                if (!filteredResponse.isEmpty()) {
                    int filterResponseCount = filteredResponse.size();
                    LinkedHashSet<FTSData> reorderedStructuresSet = new LinkedHashSet<FTSData>();
                    reorderedStructuresSet.addAll(filteredResponse);
                    reorderedStructuresSet.addAll(StructureChooser.this.discoveredStructuresSet);
                    StructureChooser.this.getResultTable().setModel(FTSRestResponse.getTableModel(StructureChooser.this.lastPdbRequest, reorderedStructuresSet));
                    FTSRestResponse.configureTableColumn(StructureChooser.this.getResultTable(), wantedFields, tempUserPrefs);
                    StructureChooser.this.getResultTable().getColumn("Ref Sequence").setPreferredWidth(120);
                    StructureChooser.this.getResultTable().getColumn("Ref Sequence").setMinWidth(100);
                    StructureChooser.this.getResultTable().getColumn("Ref Sequence").setMaxWidth(200);
                    StructureChooser.this.getResultTable().addRowSelectionInterval(0, filterResponseCount - 1);
                    StructureChooser.this.mainFrame.setTitle(MessageManager.formatMessage("label.structure_chooser_filter_time", totalTime));
                } else {
                    StructureChooser.this.mainFrame.setTitle(MessageManager.formatMessage("label.structure_chooser_filter_time", totalTime));
                    if (errors.size() > 0) {
                        StringBuilder errorMsg = new StringBuilder();
                        for (String error : errors) {
                            errorMsg.append(error).append("\n");
                        }
                        JvOptionPane.showMessageDialog(null, errorMsg.toString(), MessageManager.getString("label.pdb_web-service_error"), 0);
                    }
                }
                StructureChooser.this.lbl_loading.setVisible(false);
                StructureChooser.this.validateSelections();
            }
        });
        filterThread.start();
    }

    @Override
    protected void pdbFromFile_actionPerformed() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.formatMessage("label.select_pdb_file_for", this.selectedSequence.getDisplayId(false)));
        chooser.setToolTipText(MessageManager.formatMessage("label.load_pdb_file_associate_with_sequence", this.selectedSequence.getDisplayId(false)));
        int value = chooser.showOpenDialog(null);
        if (value == 0) {
            this.selectedPdbFileName = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", this.selectedPdbFileName);
            this.validateSelections();
        }
    }

    protected void populateFilterComboBox(boolean haveData, boolean cachedPDBExist) {
        this.cmb_filterOption.removeItemListener(this);
        this.cmb_filterOption.removeAllItems();
        if (haveData) {
            this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.best_quality"), "overall_quality", "VIEWS_FILTER", false));
            this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.best_resolution"), "resolution", "VIEWS_FILTER", false));
            this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.most_protein_chain"), "number_of_protein_chains", "VIEWS_FILTER", false));
            this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.most_bound_molecules"), "number_of_bound_molecules", "VIEWS_FILTER", false));
            this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.most_polymer_residues"), "number_of_polymer_residues", "VIEWS_FILTER", true));
        }
        this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.enter_pdb_id"), "-", "VIEWS_ENTER_ID", false));
        this.cmb_filterOption.addItem(new GStructureChooser.FilterOption(MessageManager.getString("label.from_file"), "-", "VIEWS_FROM_FILE", false));
        if (cachedPDBExist) {
            GStructureChooser.FilterOption cachedOption = new GStructureChooser.FilterOption(MessageManager.getString("label.cached_structures"), "-", "VIEWS_LOCAL_PDB", false);
            this.cmb_filterOption.addItem(cachedOption);
            this.cmb_filterOption.setSelectedItem(cachedOption);
        }
        this.cmb_filterOption.addItemListener(this);
    }

    protected void updateCurrentView() {
        GStructureChooser.FilterOption selectedFilterOpt = (GStructureChooser.FilterOption)this.cmb_filterOption.getSelectedItem();
        this.layout_switchableViews.show(this.pnl_switchableViews, selectedFilterOpt.getView());
        String filterTitle = this.mainFrame.getTitle();
        this.mainFrame.setTitle(this.frameTitle);
        this.chk_invertFilter.setVisible(false);
        if (selectedFilterOpt.getView() == "VIEWS_FILTER") {
            this.mainFrame.setTitle(filterTitle);
            this.chk_invertFilter.setVisible(true);
            this.filterResultSet(selectedFilterOpt.getValue());
        } else if (selectedFilterOpt.getView() == "VIEWS_ENTER_ID" || selectedFilterOpt.getView() == "VIEWS_FROM_FILE") {
            this.mainFrame.setTitle(MessageManager.getString("label.structure_chooser_manual_association"));
            this.idInputAssSeqPanel.loadCmbAssSeq();
            this.fileChooserAssSeqPanel.loadCmbAssSeq();
        }
        this.validateSelections();
    }

    @Override
    protected void validateSelections() {
        GStructureChooser.FilterOption selectedFilterOpt = (GStructureChooser.FilterOption)this.cmb_filterOption.getSelectedItem();
        this.btn_add.setEnabled(false);
        String currentView = selectedFilterOpt.getView();
        int selectedCount = 0;
        if (currentView == "VIEWS_FILTER") {
            selectedCount = this.getResultTable().getSelectedRows().length;
            if (selectedCount > 0) {
                this.btn_add.setEnabled(true);
            }
        } else if (currentView == "VIEWS_LOCAL_PDB") {
            selectedCount = this.tbl_local_pdb.getSelectedRows().length;
            if (selectedCount > 0) {
                this.btn_add.setEnabled(true);
            }
        } else if (currentView == "VIEWS_ENTER_ID") {
            this.validateAssociationEnterPdb();
        } else if (currentView == "VIEWS_FROM_FILE") {
            this.validateAssociationFromFile();
        }
        this.btn_newView.setEnabled(this.btn_add.isEnabled());
        this.chk_superpose.setEnabled(selectedCount > 1 || this.targetView.getItemCount() > 0);
    }

    protected void validateAssociationEnterPdb() {
        GStructureChooser.AssociateSeqOptions assSeqOpt = (GStructureChooser.AssociateSeqOptions)this.idInputAssSeqPanel.getCmb_assSeq().getSelectedItem();
        this.lbl_pdbManualFetchStatus.setIcon(this.errorImage);
        this.lbl_pdbManualFetchStatus.setToolTipText("");
        if (this.txt_search.getText().length() > 0) {
            this.lbl_pdbManualFetchStatus.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("info.no_pdb_entry_found_for", this.txt_search.getText())));
        }
        if (this.errorWarning.length() > 0) {
            this.lbl_pdbManualFetchStatus.setIcon(this.warningImage);
            this.lbl_pdbManualFetchStatus.setToolTipText(JvSwingUtils.wrapTooltip(true, this.errorWarning.toString()));
        }
        if (this.selectedSequences.length == 1 || !assSeqOpt.getName().equalsIgnoreCase("-Select Associated Seq-")) {
            this.txt_search.setEnabled(true);
            if (this.isValidPBDEntry) {
                this.btn_add.setEnabled(true);
                this.lbl_pdbManualFetchStatus.setToolTipText("");
                this.lbl_pdbManualFetchStatus.setIcon(this.goodImage);
            }
        } else {
            this.txt_search.setEnabled(false);
            this.lbl_pdbManualFetchStatus.setIcon(this.errorImage);
        }
    }

    protected void validateAssociationFromFile() {
        GStructureChooser.AssociateSeqOptions assSeqOpt = (GStructureChooser.AssociateSeqOptions)this.fileChooserAssSeqPanel.getCmb_assSeq().getSelectedItem();
        this.lbl_fromFileStatus.setIcon(this.errorImage);
        if (this.selectedSequences.length == 1 || assSeqOpt != null && !assSeqOpt.getName().equalsIgnoreCase("-Select Associated Seq-")) {
            this.btn_pdbFromFile.setEnabled(true);
            if (this.selectedPdbFileName != null && this.selectedPdbFileName.length() > 0) {
                this.btn_add.setEnabled(true);
                this.lbl_fromFileStatus.setIcon(this.goodImage);
            }
        } else {
            this.btn_pdbFromFile.setEnabled(false);
            this.lbl_fromFileStatus.setIcon(this.errorImage);
        }
    }

    @Override
    protected void cmbAssSeqStateChanged() {
        this.validateSelections();
    }

    @Override
    protected void stateChanged(ItemEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.updateCurrentView();
        } else if (e.getStateChange() == 1) {
            this.updateCurrentView();
        }
    }

    public boolean selectStructure(String ... pdbids) {
        JTable restable;
        boolean found = false;
        GStructureChooser.FilterOption selectedFilterOpt = (GStructureChooser.FilterOption)this.cmb_filterOption.getSelectedItem();
        String currentView = selectedFilterOpt.getView();
        JTable jTable = currentView == "VIEWS_FILTER" ? this.getResultTable() : (restable = currentView == "VIEWS_LOCAL_PDB" ? this.tbl_local_pdb : null);
        if (restable == null) {
            return false;
        }
        int pdbIdColIndex = restable.getColumn("PDB Id").getModelIndex();
        for (int r = 0; r < restable.getRowCount(); ++r) {
            for (int p = 0; p < pdbids.length; ++p) {
                if (!String.valueOf(restable.getValueAt(r, pdbIdColIndex)).equalsIgnoreCase(pdbids[p])) continue;
                restable.setRowSelectionInterval(r, r);
                found = true;
            }
        }
        return found;
    }

    @Override
    protected void newView_ActionPerformed() {
        this.targetView.setSelectedItem(null);
        this.showStructures(false);
    }

    @Override
    protected void add_ActionPerformed() {
        this.showStructures(false);
    }

    public void showStructures(boolean waitUntilFinished) {
        final StructureSelectionManager ssm = this.ap.getStructureSelectionManager();
        final int preferredHeight = this.pnl_filter.getHeight();
        Runnable viewStruc = new Runnable(){

            @Override
            public void run() {
                JTable restable;
                GStructureChooser.FilterOption selectedFilterOpt = (GStructureChooser.FilterOption)StructureChooser.this.cmb_filterOption.getSelectedItem();
                String currentView = selectedFilterOpt.getView();
                JTable jTable = restable = currentView == "VIEWS_FILTER" ? StructureChooser.this.getResultTable() : StructureChooser.this.tbl_local_pdb;
                if (currentView == "VIEWS_FILTER") {
                    int pdbIdColIndex = restable.getColumn("PDB Id").getModelIndex();
                    int refSeqColIndex = restable.getColumn("Ref Sequence").getModelIndex();
                    int[] selectedRows = restable.getSelectedRows();
                    PDBEntry[] pdbEntriesToView = new PDBEntry[selectedRows.length];
                    int count = 0;
                    ArrayList<SequenceI> selectedSeqsToView = new ArrayList<SequenceI>();
                    for (int row : selectedRows) {
                        String pdbIdStr = restable.getValueAt(row, pdbIdColIndex).toString();
                        SequenceI selectedSeq = (SequenceI)restable.getValueAt(row, refSeqColIndex);
                        selectedSeqsToView.add(selectedSeq);
                        PDBEntry pdbEntry = selectedSeq.getPDBEntry(pdbIdStr);
                        if (pdbEntry == null) {
                            pdbEntry = StructureChooser.this.getFindEntry(pdbIdStr, selectedSeq.getAllPDBEntries());
                        }
                        if (pdbEntry == null) {
                            pdbEntry = new PDBEntry();
                            pdbEntry.setId(pdbIdStr);
                            pdbEntry.setType(PDBEntry.Type.PDB);
                            selectedSeq.getDatasetSequence().addPDBId(pdbEntry);
                        }
                        pdbEntriesToView[count++] = pdbEntry;
                    }
                    SequenceI[] sequenceIArray = selectedSeqsToView.toArray(new SequenceI[selectedSeqsToView.size()]);
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, pdbEntriesToView, StructureChooser.this.ap, sequenceIArray);
                } else if (currentView == "VIEWS_LOCAL_PDB") {
                    int[] selectedRows = StructureChooser.this.tbl_local_pdb.getSelectedRows();
                    PDBEntry[] pdbEntriesToView = new PDBEntry[selectedRows.length];
                    int count = 0;
                    int pdbIdColIndex = StructureChooser.this.tbl_local_pdb.getColumn("PDB Id").getModelIndex();
                    int refSeqColIndex = StructureChooser.this.tbl_local_pdb.getColumn("Ref Sequence").getModelIndex();
                    ArrayList<SequenceI> selectedSeqsToView = new ArrayList<SequenceI>();
                    for (int row : selectedRows) {
                        PDBEntry pdbEntry = (PDBEntry)StructureChooser.this.tbl_local_pdb.getValueAt(row, pdbIdColIndex);
                        pdbEntriesToView[count++] = pdbEntry;
                        SequenceI selectedSeq = (SequenceI)StructureChooser.this.tbl_local_pdb.getValueAt(row, refSeqColIndex);
                        selectedSeqsToView.add(selectedSeq);
                    }
                    SequenceI[] sequenceIArray = selectedSeqsToView.toArray(new SequenceI[selectedSeqsToView.size()]);
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, pdbEntriesToView, StructureChooser.this.ap, sequenceIArray);
                } else if (currentView == "VIEWS_ENTER_ID") {
                    String pdbIdStr;
                    PDBEntry pdbEntry;
                    SequenceI userSelectedSeq = ((GStructureChooser.AssociateSeqOptions)StructureChooser.this.idInputAssSeqPanel.getCmb_assSeq().getSelectedItem()).getSequence();
                    if (userSelectedSeq != null) {
                        StructureChooser.this.selectedSequence = userSelectedSeq;
                    }
                    if ((pdbEntry = StructureChooser.this.selectedSequence.getPDBEntry(pdbIdStr = StructureChooser.this.txt_search.getText())) == null) {
                        pdbEntry = new PDBEntry();
                        if (pdbIdStr.split(":").length > 1) {
                            pdbEntry.setId(pdbIdStr.split(":")[0]);
                            pdbEntry.setChainCode(pdbIdStr.split(":")[1].toUpperCase());
                        } else {
                            pdbEntry.setId(pdbIdStr);
                        }
                        pdbEntry.setType(PDBEntry.Type.PDB);
                        StructureChooser.this.selectedSequence.getDatasetSequence().addPDBId(pdbEntry);
                    }
                    PDBEntry[] pdbEntriesToView = new PDBEntry[]{pdbEntry};
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, pdbEntriesToView, StructureChooser.this.ap, new SequenceI[]{StructureChooser.this.selectedSequence});
                } else if (currentView == "VIEWS_FROM_FILE") {
                    SequenceI userSelectedSeq = ((GStructureChooser.AssociateSeqOptions)StructureChooser.this.fileChooserAssSeqPanel.getCmb_assSeq().getSelectedItem()).getSequence();
                    if (userSelectedSeq != null) {
                        StructureChooser.this.selectedSequence = userSelectedSeq;
                    }
                    PDBEntry fileEntry = new AssociatePdbFileWithSeq().associatePdbWithSeq(StructureChooser.this.selectedPdbFileName, DataSourceType.FILE, StructureChooser.this.selectedSequence, true, Desktop.instance);
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, new PDBEntry[]{fileEntry}, StructureChooser.this.ap, new SequenceI[]{StructureChooser.this.selectedSequence});
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructureChooser.this.closeAction(preferredHeight);
                        StructureChooser.this.mainFrame.dispose();
                    }
                });
            }
        };
        Thread runner = new Thread(viewStruc);
        runner.start();
        if (waitUntilFinished) {
            while (this.sViewer == null ? runner.isAlive() : this.sViewer.sview == null || !this.sViewer.sview.hasMapping()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private PDBEntry getFindEntry(String id, Vector<PDBEntry> pdbEntries) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(pdbEntries);
        PDBEntry foundEntry = null;
        for (PDBEntry entry : pdbEntries) {
            if (!entry.getId().equalsIgnoreCase(id)) continue;
            return entry;
        }
        return foundEntry;
    }

    StructureViewer getTargetedStructureViewer(StructureSelectionManager ssm) {
        Object sv = this.targetView.getSelectedItem();
        return sv == null ? new StructureViewer(ssm) : (StructureViewer)sv;
    }

    private StructureViewer launchStructureViewer(StructureSelectionManager ssm, PDBEntry[] pdbEntriesToView, AlignmentPanel alignPanel, SequenceI[] sequences) {
        long progressId = sequences.hashCode();
        this.setProgressBar(MessageManager.getString("status.launching_3d_structure_viewer"), progressId);
        StructureViewer theViewer = this.getTargetedStructureViewer(ssm);
        boolean superimpose = this.chk_superpose.isSelected();
        theViewer.setSuperpose(superimpose);
        Cache.setProperty(AUTOSUPERIMPOSE, Boolean.valueOf(superimpose).toString());
        this.setProgressBar(null, progressId);
        if (SiftsSettings.isMapWithSifts()) {
            ArrayList<SequenceI> seqsWithoutSourceDBRef = new ArrayList<SequenceI>();
            int p = 0;
            for (SequenceI seq : sequences) {
                StructureMapping[] smm;
                PDBEntry pdbe;
                if ((pdbe = pdbEntriesToView[p++]) != null && pdbe.getFile() != null && (smm = ssm.getMapping(pdbe.getFile())) != null && smm.length > 0) {
                    for (StructureMapping sm : smm) {
                        if (sm.getSequence() != seq) continue;
                    }
                }
                if (!seq.getPrimaryDBRefs().isEmpty()) continue;
                seqsWithoutSourceDBRef.add(seq);
            }
            if (!seqsWithoutSourceDBRef.isEmpty()) {
                int y = seqsWithoutSourceDBRef.size();
                this.setProgressBar(MessageManager.formatMessage("status.fetching_dbrefs_for_sequences_without_valid_refs", y), progressId);
                SequenceI[] seqWithoutSrcDBRef = seqsWithoutSourceDBRef.toArray(new SequenceI[y]);
                DBRefFetcher dbRefFetcher = new DBRefFetcher(seqWithoutSrcDBRef);
                dbRefFetcher.fetchDBRefs(true);
                this.setProgressBar("Fetch complete.", progressId);
            }
        }
        if (pdbEntriesToView.length > 1) {
            this.setProgressBar(MessageManager.getString("status.fetching_3d_structures_for_selected_entries"), progressId);
            theViewer.viewStructures(pdbEntriesToView, sequences, alignPanel);
        } else {
            this.setProgressBar(MessageManager.formatMessage("status.fetching_3d_structures_for", pdbEntriesToView[0].getId()), progressId);
            theViewer.viewStructures(pdbEntriesToView[0], sequences, alignPanel);
        }
        this.setProgressBar(null, progressId);
        lastTargetedView = theViewer;
        return theViewer;
    }

    @Override
    protected void populateCmbAssociateSeqOptions(JComboBox<GStructureChooser.AssociateSeqOptions> cmb_assSeq, JLabel lbl_associateSeq) {
        cmb_assSeq.removeAllItems();
        cmb_assSeq.addItem(new GStructureChooser.AssociateSeqOptions("-Select Associated Seq-", null));
        lbl_associateSeq.setVisible(false);
        if (this.selectedSequences.length > 1) {
            for (SequenceI seq : this.selectedSequences) {
                cmb_assSeq.addItem(new GStructureChooser.AssociateSeqOptions(seq));
            }
        } else {
            String seqName = this.selectedSequence.getDisplayId(false);
            seqName = seqName.length() <= 40 ? seqName : seqName.substring(0, 39);
            lbl_associateSeq.setText(seqName);
            lbl_associateSeq.setVisible(true);
            cmb_assSeq.setVisible(false);
        }
    }

    protected boolean isStructuresDiscovered() {
        return this.discoveredStructuresSet != null && !this.discoveredStructuresSet.isEmpty();
    }

    @Override
    protected void txt_search_ActionPerformed() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StructureChooser.this.errorWarning.setLength(0);
                StructureChooser.this.isValidPBDEntry = false;
                if (StructureChooser.this.txt_search.getText().length() > 0) {
                    FTSRestResponse resultList;
                    String searchTerm = StructureChooser.this.txt_search.getText().toLowerCase();
                    searchTerm = searchTerm.split(":")[0];
                    ArrayList<FTSDataColumnI> wantedFields = new ArrayList<FTSDataColumnI>();
                    FTSRestRequest pdbRequest = new FTSRestRequest();
                    pdbRequest.setAllowEmptySeq(false);
                    pdbRequest.setResponseSize(1);
                    pdbRequest.setFieldToSearchBy("(pdb_id:");
                    pdbRequest.setWantedFields(wantedFields);
                    pdbRequest.setSearchTerm(searchTerm + ")");
                    pdbRequest.setAssociatedSequence(StructureChooser.this.selectedSequence);
                    StructureChooser.this.pdbRestCleint = PDBFTSRestClient.getInstance();
                    wantedFields.add(StructureChooser.this.pdbRestCleint.getPrimaryKeyColumn());
                    try {
                        resultList = StructureChooser.this.pdbRestCleint.executeRequest(pdbRequest);
                    }
                    catch (Exception e) {
                        StructureChooser.this.errorWarning.append(e.getMessage());
                        return;
                    }
                    finally {
                        StructureChooser.this.validateSelections();
                    }
                    if (resultList.getSearchSummary() != null && resultList.getSearchSummary().size() > 0) {
                        StructureChooser.this.isValidPBDEntry = true;
                    }
                }
                StructureChooser.this.validateSelections();
            }
        }.start();
    }

    @Override
    protected void tabRefresh() {
        if (this.selectedSequences != null) {
            Thread refreshThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StructureChooser.this.fetchStructuresMetaData();
                    StructureChooser.this.filterResultSet(((GStructureChooser.FilterOption)StructureChooser.this.cmb_filterOption.getSelectedItem()).getValue());
                }
            });
            refreshThread.start();
        }
    }

    @Override
    public void setProgressBar(String message, long id) {
        this.progressBar.setProgressBar(message, id);
    }

    @Override
    public void registerHandler(long id, IProgressIndicatorHandler handler) {
        this.progressBar.registerHandler(id, handler);
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBar.operationInProgress();
    }

    public JalviewStructureDisplayI getOpenedStructureViewer() {
        return this.sViewer == null ? null : this.sViewer.sview;
    }

    private class CachedPDB {
        private SequenceI sequence;
        private PDBEntry pdbEntry;

        public CachedPDB(SequenceI sequence, PDBEntry pdbEntry) {
            this.sequence = sequence;
            this.pdbEntry = pdbEntry;
        }

        public SequenceI getSequence() {
            return this.sequence;
        }

        public PDBEntry getPdbEntry() {
            return this.pdbEntry;
        }
    }

    public class PDBEntryTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"Ref Sequence", "PDB Id", "Chain", "Type", "File"};
        private List<CachedPDB> pdbEntries;

        public PDBEntryTableModel(List<CachedPDB> pdbEntries) {
            this.pdbEntries = new ArrayList<CachedPDB>(pdbEntries);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.pdbEntries.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = "??";
            CachedPDB entry = this.pdbEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value = entry.getSequence();
                    break;
                }
                case 1: {
                    value = entry.getPdbEntry();
                    break;
                }
                case 2: {
                    value = entry.getPdbEntry().getChainCode() == null ? "_" : entry.getPdbEntry().getChainCode();
                    break;
                }
                case 3: {
                    value = entry.getPdbEntry().getType();
                    break;
                }
                case 4: {
                    value = entry.getPdbEntry().getFile();
                }
            }
            return value;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? SequenceI.class : PDBEntry.class;
        }

        public CachedPDB getPDBEntryAt(int row) {
            return this.pdbEntries.get(row);
        }
    }
}

