/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SplashScreen
extends JPanel
implements Runnable,
HyperlinkListener {
    boolean visible = true;
    JPanel iconimg = new JPanel(new BorderLayout());
    JTextPane authlist = new JTextPane();
    JInternalFrame iframe;
    Image image;
    int fontSize = 11;
    int yoffset = 30;
    private boolean interactiveDialog = false;
    MouseAdapter closer = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent evt) {
            try {
                if (!SplashScreen.this.interactiveDialog) {
                    SplashScreen.this.visible = false;
                    SplashScreen.this.closeSplash();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    long oldtext = -1L;

    public SplashScreen() {
        this(false);
    }

    public SplashScreen(boolean interactive) {
        this.interactiveDialog = interactive;
        Thread t = new Thread(this);
        t.start();
    }

    void initSplashScreenWindow() {
        block5: {
            this.addMouseListener(this.closer);
            try {
                URL url = this.getClass().getResource("/images/Jalview_Logo.png");
                URL urllogo = this.getClass().getResource("/images/Jalview_Logo_small.png");
                if (url == null) break block5;
                this.image = Toolkit.getDefaultToolkit().createImage(url);
                Image logo = Toolkit.getDefaultToolkit().createImage(urllogo);
                MediaTracker mt = new MediaTracker(this);
                mt.addImage(this.image, 0);
                mt.addImage(logo, 1);
                do {
                    try {
                        mt.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!mt.isErrorAny()) continue;
                    System.err.println("Error when loading images!");
                } while (!mt.checkAll());
                Desktop.instance.setIconImage(logo);
            }
            catch (Exception url) {
                // empty catch block
            }
        }
        this.iframe = new JInternalFrame();
        this.iframe.setFrameIcon(null);
        this.iframe.setClosable(this.interactiveDialog);
        this.setLayout(new BorderLayout());
        this.iframe.setContentPane(this);
        this.iframe.setLayer(JLayeredPane.PALETTE_LAYER);
        SplashImage splashimg = new SplashImage(this.image);
        this.iconimg.add((Component)splashimg, "Center");
        this.add((Component)this.iconimg, "North");
        this.add((Component)this.authlist, "Center");
        this.authlist.setEditable(false);
        this.authlist.addMouseListener(this.closer);
        Desktop.desktop.add(this.iframe);
        this.refreshText();
    }

    protected boolean refreshText() {
        String newtext = Desktop.instance.getAboutMessage(true).toString();
        if (this.oldtext != (long)newtext.length()) {
            this.iframe.setVisible(false);
            this.oldtext = newtext.length();
            this.authlist = new JTextPane();
            this.authlist.setEditable(false);
            this.authlist.addMouseListener(this.closer);
            this.authlist.addHyperlinkListener(this);
            this.authlist.setContentType("text/html");
            this.authlist.setText(newtext);
            this.authlist.setVisible(true);
            this.authlist.setSize(new Dimension(750, 375));
            this.add((Component)this.authlist, "Center");
            this.revalidate();
            this.iframe.setBounds((Desktop.instance.getWidth() - 750) / 2, (Desktop.instance.getHeight() - 375) / 2, 750, this.authlist.getHeight() + this.iconimg.getHeight());
            this.iframe.validate();
            this.iframe.setVisible(true);
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.initSplashScreenWindow();
        long startTime = System.currentTimeMillis() / 1000L;
        while (this.visible) {
            this.iframe.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.interactiveDialog && System.currentTimeMillis() / 1000L - startTime > 5L) {
                this.visible = false;
            }
            if (this.visible && this.refreshText()) {
                this.iframe.repaint();
            }
            if (!this.interactiveDialog) continue;
            return;
        }
        this.closeSplash();
        Desktop.instance.startDialogQueue();
    }

    public void closeSplash() {
        try {
            this.iframe.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Desktop.hyperlinkUpdate(e);
    }

    public class SplashImage
    extends JPanel {
        Image image;

        public SplashImage(Image todisplay) {
            this.image = todisplay;
            this.setPreferredSize(new Dimension(this.image.getWidth(this) + 8, this.image.getHeight(this)));
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(this) + 8, this.image.getHeight(this));
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.setFont(new Font("Verdana", 1, SplashScreen.this.fontSize + 6));
            if (this.image != null) {
                g.drawImage(this.image, (this.getWidth() - this.image.getWidth(this)) / 2, (this.getHeight() - this.image.getHeight(this)) / 2, this);
            }
        }
    }
}

