/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.gui.OptsParametersContainerI;
import jalview.io.DataSourceType;
import jalview.io.FileLoader;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.MessageManager;
import jalview.ws.jws2.dm.JabaOption;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.OptionI;
import jalview.ws.params.ParameterI;
import jalview.ws.params.ValueConstrainI;
import jalview.ws.params.simple.FileParameter;
import jalview.ws.params.simple.LogarithmicParameter;
import jalview.ws.params.simple.RadioChoiceParameter;
import jalview.ws.params.simple.StringParameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;

public class OptsAndParamsPage {
    public static final int PARAM_WIDTH = 340;
    public static final int PARAM_HEIGHT = 150;
    public static final int PARAM_CLOSEDHEIGHT = 80;
    URL linkImageURL = this.getClass().getResource("/images/link.gif");
    Map<String, OptionBox> optSet = new LinkedHashMap<String, OptionBox>();
    Map<String, ParamBox> paramSet = new LinkedHashMap<String, ParamBox>();
    boolean compact = false;
    OptsParametersContainerI poparent;

    public OptsAndParamsPage(OptsParametersContainerI paramContainer, boolean compact) {
        this.poparent = paramContainer;
        this.compact = compact;
    }

    public static void showUrlPopUp(JComponent invoker, final String finfo, int x, int y) {
        JPopupMenu mnu = new JPopupMenu();
        JMenuItem mitem = new JMenuItem(MessageManager.formatMessage("label.view_params", new String[]{finfo}));
        mitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Desktop.showUrl(finfo);
            }
        });
        mnu.add(mitem);
        mnu.show(invoker, x, y);
    }

    public Map<String, OptionBox> getOptSet() {
        return this.optSet;
    }

    public void setOptSet(Map<String, OptionBox> optSet) {
        this.optSet = optSet;
    }

    public Map<String, ParamBox> getParamSet() {
        return this.paramSet;
    }

    public void setParamSet(Map<String, ParamBox> paramSet) {
        this.paramSet = paramSet;
    }

    OptionBox addOption(OptionI opt) {
        OptionBox cb = this.optSet.get(opt.getName());
        if (cb == null) {
            cb = new OptionBox(opt);
            this.optSet.put(opt.getName(), cb);
        }
        return cb;
    }

    ParamBox addParameter(ParameterI arg) {
        ParamBox pb = this.paramSet.get(arg.getName());
        if (pb == null) {
            pb = new ParamBox(this.poparent, arg);
            this.paramSet.put(arg.getName(), pb);
        }
        pb.init();
        pb.updateControls(arg);
        return pb;
    }

    void selectOption(OptionI option, String string) {
        OptionBox cb = this.optSet.get(option.getName());
        if (cb == null) {
            cb = this.addOption(option);
        }
        cb.enabled.setSelected(string != null);
        if (string != null) {
            if (option.getPossibleValues().contains(string)) {
                cb.val.setSelectedItem(string);
            } else {
                throw new Error(String.format("Invalid value '%s' for option '%s'", string, option.getName()));
            }
        }
        if (!option.isRequired() || !cb.enabled.isSelected()) {
            // empty if block
        }
        cb.setInitialValue();
    }

    void setParameter(ParameterI arg) {
        ParamBox pb = this.paramSet.get(arg.getName());
        if (pb == null) {
            this.addParameter(arg);
        } else {
            pb.updateControls(arg);
        }
    }

    public List<ArgumentI> getCurrentSettings() {
        ArrayList<ArgumentI> argSet = new ArrayList<ArgumentI>();
        for (OptionBox opts : this.getOptSet().values()) {
            ArgumentI opt = opts.getSelectedOption();
            if (opt == null) continue;
            argSet.add(opt);
        }
        for (ParamBox parambox : this.getParamSet().values()) {
            ArgumentI parm = parambox.getParameter();
            if (parm == null) continue;
            argSet.add(parm);
        }
        return argSet;
    }

    protected static JComboBox<Object> buildComboBox(OptionI opt) {
        JComboBox<Object> cb = null;
        List<String> displayNames = opt.getDisplayNames();
        if (displayNames != null) {
            ArrayList<Object> displayNamesObjects = new ArrayList<Object>();
            displayNamesObjects.addAll(displayNames);
            cb = JvSwingUtils.buildComboWithTooltips(displayNamesObjects, opt.getPossibleValues());
        } else {
            cb = new JComboBox<Object>();
            for (String v : opt.getPossibleValues()) {
                cb.addItem(v);
            }
        }
        return cb;
    }

    protected static String getSelectedValue(OptionI opt, int sel) {
        List<String> possibleValues = opt.getPossibleValues();
        String value = null;
        if (possibleValues != null && possibleValues.size() == 1) {
            value = possibleValues.get(0);
        } else if (sel >= 0 && sel < possibleValues.size()) {
            value = possibleValues.get(sel);
        }
        return value;
    }

    public class ParamBox
    extends JPanel
    implements ChangeListener,
    ActionListener,
    MouseListener {
        private int sliderScaleFactor = 1;
        boolean isLogarithmicParameter;
        boolean isChoiceParameter;
        boolean isIntegerParameter;
        boolean isStringParameter;
        boolean adjusting;
        JComboBox<Object> choicebox;
        ButtonGroup buttonGroup;
        JPanel controlsPanel = new JPanel();
        boolean descriptionIsVisible = false;
        JScrollPane descPanel = new JScrollPane();
        final URL finfo;
        Object lastVal;
        ParameterI parameter;
        final OptsParametersContainerI pmdialogbox;
        JPanel settingPanel = new JPanel();
        JSlider slider;
        JTextArea descriptionText = new JTextArea();
        ValueConstrainI validator;
        JTextField valueField;
        private String descTooltip;

        public ParamBox(OptsParametersContainerI paramContainer, ParameterI parm) {
            List<String> possibleValues;
            this.pmdialogbox = paramContainer;
            this.finfo = parm.getFurtherDetails();
            this.validator = parm.getValidValue();
            this.parameter = parm;
            this.isLogarithmicParameter = parm instanceof LogarithmicParameter;
            if (this.validator != null) {
                ValueConstrainI.ValueType type = this.validator.getType();
                this.isIntegerParameter = type == ValueConstrainI.ValueType.Integer;
                boolean bl = this.isStringParameter = type == ValueConstrainI.ValueType.String || type == ValueConstrainI.ValueType.File;
                if (this.validator.getMin() != null && this.validator.getMax() != null && !this.isStringParameter) {
                    double min = this.validator.getMin().doubleValue();
                    double max = this.validator.getMax().doubleValue();
                    if (this.isLogarithmicParameter) {
                        min = Math.log(min);
                        max = Math.log(max);
                    }
                    this.sliderScaleFactor = (int)(1000000.0 / (max - min));
                }
            }
            boolean bl = this.isChoiceParameter = (possibleValues = this.parameter.getPossibleValues()) != null && !possibleValues.isEmpty();
            if (OptsAndParamsPage.this.compact) {
                this.addCompactParameter(parm);
            } else {
                this.addExpandableParam(parm);
            }
        }

        private void addCompactParameter(ParameterI parm) {
            this.setLayout((LayoutManager)new MigLayout("", "[][grow]"));
            String ttipText = null;
            this.controlsPanel.setLayout(new BorderLayout());
            if (parm.getDescription() != null && parm.getDescription().trim().length() > 0) {
                ttipText = JvSwingUtils.wrapTooltip(true, parm.getDescription() + (String)(this.finfo != null ? "<br><img src=\"" + OptsAndParamsPage.this.linkImageURL + "\"/>" + MessageManager.getString("label.opt_and_params_further_details") : ""));
            }
            JvSwingUtils.addtoLayout(this, ttipText, new JLabel(parm.getName()), this.controlsPanel, "");
            this.updateControls(parm);
            this.validate();
        }

        private void addExpandableParam(ParameterI parm) {
            this.setPreferredSize(new Dimension(340, 80));
            this.setBorder(new TitledBorder(parm.getName()));
            this.setLayout(null);
            this.descriptionText.setFont(new Font("Verdana", 0, 11));
            this.descriptionText.setBackground(this.getBackground());
            this.descriptionText.setEditable(false);
            this.descPanel.getViewport().setView(this.descriptionText);
            this.descPanel.setVisible(false);
            JPanel firstrow = new JPanel();
            firstrow.setLayout(null);
            this.controlsPanel.setLayout(new BorderLayout());
            this.controlsPanel.setBounds(new Rectangle(39, 10, 270, 30));
            firstrow.add(this.controlsPanel);
            firstrow.setBounds(new Rectangle(10, 20, 310, 50));
            if (parm.getDescription() != null && parm.getDescription().trim().length() > 0) {
                this.addExpandableHelp(firstrow, parm);
            }
            this.add(firstrow);
            this.validator = parm.getValidValue();
            this.parameter = parm;
            if (this.validator != null) {
                this.isIntegerParameter = this.validator.getType() == ValueConstrainI.ValueType.Integer;
            } else if (this.parameter.getPossibleValues() != null) {
                this.isChoiceParameter = true;
            }
            this.updateControls(parm);
            this.descPanel.setBounds(new Rectangle(10, 80, 320, 65));
            this.add(this.descPanel);
            this.validate();
        }

        protected void addExpandableHelp(JPanel container, ParameterI param) {
            final JButton showDescBtn = new JButton("+");
            showDescBtn.setFont(new Font("Verdana", 0, 8));
            if (this.finfo != null) {
                this.descTooltip = JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("label.opt_and_params_show_brief_desc_image_link", new String[]{OptsAndParamsPage.this.linkImageURL.toExternalForm()}));
                showDescBtn.addMouseListener(this);
            } else {
                this.descTooltip = JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.opt_and_params_show_brief_desc"));
            }
            showDescBtn.setToolTipText(this.descTooltip);
            showDescBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamBox.this.descriptionIsVisible = !ParamBox.this.descriptionIsVisible;
                    showDescBtn.setText(ParamBox.this.descriptionIsVisible ? "-" : "+");
                    showDescBtn.setToolTipText(ParamBox.this.descriptionIsVisible ? null : ParamBox.this.descTooltip);
                    ParamBox.this.descPanel.setVisible(ParamBox.this.descriptionIsVisible);
                    ParamBox.this.descPanel.getVerticalScrollBar().setValue(0);
                    ParamBox.this.setPreferredSize(new Dimension(340, ParamBox.this.descriptionIsVisible ? 150 : 80));
                    ParamBox.this.validate();
                    ParamBox.this.pmdialogbox.refreshParamLayout();
                }
            });
            this.descriptionText.setWrapStyleWord(true);
            this.descriptionText.setLineWrap(true);
            this.descriptionText.setColumns(32);
            this.descriptionText.setText(param.getDescription());
            showDescBtn.setBounds(new Rectangle(10, 10, 16, 16));
            container.add(showDescBtn);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.adjusting) {
                return;
            }
            this.checkIfModified();
        }

        private void checkIfModified() {
            Object newValue = this.updateSliderFromValueField();
            boolean modified = true;
            if (newValue.getClass() == this.lastVal.getClass()) {
                modified = !newValue.equals(this.lastVal);
            }
            this.pmdialogbox.argSetModified(this, modified);
        }

        @Override
        public int getBaseline(int width, int height) {
            return 0;
        }

        @Override
        public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
            return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
        }

        public ArgumentI getParameter() {
            ParameterI prm = this.parameter.copy();
            String value = null;
            value = this.parameter instanceof RadioChoiceParameter ? this.buttonGroup.getSelection().getActionCommand() : (this.isChoiceParameter ? OptsAndParamsPage.getSelectedValue(this.parameter, this.choicebox.getSelectedIndex()) : this.valueField.getText());
            prm.setValue(value);
            return prm;
        }

        public void init() {
            this.lastVal = null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.adjusting) {
                return;
            }
            try {
                this.adjusting = true;
                if (!this.isLogarithmicParameter) {
                    this.valueField.setText(this.isIntegerParameter ? String.valueOf(this.slider.getValue()) : this.formatDouble((float)this.slider.getValue() / (float)this.sliderScaleFactor));
                } else {
                    double value = Math.pow(Math.E, (double)this.slider.getValue() / (double)this.sliderScaleFactor);
                    this.valueField.setText(this.formatDouble(value));
                }
                this.checkIfModified();
            }
            finally {
                this.adjusting = false;
            }
        }

        String formatDouble(double value) {
            String format = value < 0.001 ? "%3.1E" : "%3.3f";
            return String.format(format, value);
        }

        String formatNumber(Number n) {
            return n instanceof Integer ? String.valueOf(n.intValue()) : this.formatDouble(n.doubleValue());
        }

        void updateControls(ParameterI parm) {
            String value;
            boolean init;
            this.adjusting = true;
            boolean bl = init = this.choicebox == null && this.valueField == null && this.buttonGroup == null;
            if (init) {
                if (parm instanceof RadioChoiceParameter) {
                    this.buttonGroup = this.addRadioButtons(this.parameter, this.controlsPanel);
                } else if (this.isChoiceParameter) {
                    this.choicebox = OptsAndParamsPage.buildComboBox(parm);
                    this.choicebox.addActionListener(this);
                    this.controlsPanel.add(this.choicebox, "Center");
                } else {
                    this.slider = new JSlider();
                    this.slider.addChangeListener(this);
                    int cols = parm instanceof StringParameter ? 20 : 0;
                    this.valueField = new JTextField(cols);
                    this.valueField.addActionListener(this);
                    this.valueField.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            int keyCode = e.getKeyCode();
                            if (e.isActionKey() && keyCode != 37 && keyCode != 39 && ParamBox.this.valueField.getText().trim().length() > 0) {
                                ParamBox.this.actionPerformed(null);
                            }
                        }
                    });
                    this.valueField.setPreferredSize(new Dimension(65, 25));
                    if (parm instanceof FileParameter) {
                        this.valueField.setToolTipText(MessageManager.getString("label.double_click_to_browse"));
                        this.valueField.addMouseListener(new MouseAdapter(){

                            @Override
                            public void mouseClicked(MouseEvent e) {
                                if (e.getClickCount() == 2) {
                                    String dir = Cache.getProperty("LAST_DIRECTORY");
                                    JalviewFileChooser chooser = new JalviewFileChooser(dir);
                                    chooser.setFileView(new JalviewFileView());
                                    chooser.setDialogTitle(MessageManager.getString("action.select_ddbb"));
                                    int val = chooser.showOpenDialog(ParamBox.this);
                                    if (val == 0) {
                                        File choice = chooser.getSelectedFile();
                                        String path = choice.getPath();
                                        ParamBox.this.valueField.setText(path);
                                        Cache.setProperty("LAST_DIRECTORY", choice.getParent());
                                        FileLoader.updateRecentlyOpened(path, DataSourceType.FILE);
                                    }
                                }
                            }
                        });
                    }
                    this.controlsPanel.add((Component)this.slider, "West");
                    this.controlsPanel.add((Component)this.valueField, "East");
                }
            }
            if ((value = parm.getValue()) != null) {
                if (this.isChoiceParameter) {
                    if (!(parm instanceof RadioChoiceParameter)) {
                        this.choicebox.setSelectedItem(value);
                    }
                } else {
                    this.valueField.setText(value);
                }
            }
            this.lastVal = this.updateSliderFromValueField();
            this.adjusting = false;
        }

        protected ButtonGroup addRadioButtons(OptionI option, Container comp) {
            ButtonGroup bg = new ButtonGroup();
            JPanel radioPanel = new JPanel();
            radioPanel.add(new JLabel(option.getDescription()));
            String value = option.getValue();
            for (String opt : option.getPossibleValues()) {
                JRadioButton btn = new JRadioButton(opt);
                btn.setActionCommand(opt);
                boolean selected = opt.equals(value);
                btn.setSelected(selected);
                btn.addActionListener(this);
                bg.add(btn);
                radioPanel.add(btn);
            }
            comp.add(radioPanel);
            return bg;
        }

        Object updateSliderFromValueField() {
            if (this.validator == null || this.isStringParameter) {
                if (this.isChoiceParameter) {
                    if (this.parameter instanceof RadioChoiceParameter) {
                        return this.buttonGroup.getSelection().getActionCommand();
                    }
                    return OptsAndParamsPage.getSelectedValue(this.parameter, this.choicebox.getSelectedIndex());
                }
                this.slider.setVisible(false);
                return this.valueField.getText().trim();
            }
            this.valueField.setText(this.valueField.getText().trim());
            try {
                this.valueField.setBackground(Color.WHITE);
                double d = Double.parseDouble(this.valueField.getText());
                if (this.validator.getMin() != null && this.validator.getMin().doubleValue() > d) {
                    this.valueField.setText(this.formatNumber(this.validator.getMin()));
                }
                if (this.validator.getMax() != null && this.validator.getMax().doubleValue() < d) {
                    this.valueField.setText(this.formatNumber(this.validator.getMax()));
                }
            }
            catch (NumberFormatException e) {
                this.valueField.setBackground(Color.yellow);
                return Float.valueOf(Float.NaN);
            }
            if (this.isIntegerParameter) {
                int iVal = 0;
                try {
                    iVal = Integer.valueOf(this.valueField.getText());
                }
                catch (Exception e) {
                    this.valueField.setBackground(Color.yellow);
                    return 0;
                }
                if (this.validator.getMin() != null && this.validator.getMax() != null) {
                    this.slider.getModel().setRangeProperties(iVal, 1, this.validator.getMin().intValue(), this.validator.getMax().intValue() + 1, true);
                } else {
                    this.slider.setVisible(false);
                }
                return new Integer(iVal);
            }
            if (this.isLogarithmicParameter) {
                double dVal = 0.0;
                try {
                    double eValue = Double.valueOf(this.valueField.getText());
                    dVal = Math.log(eValue) * (double)this.sliderScaleFactor;
                }
                catch (Exception e) {
                    this.valueField.setBackground(Color.yellow);
                    return Double.NaN;
                }
                if (this.validator.getMin() != null && this.validator.getMax() != null) {
                    double scaleMin = Math.log(this.validator.getMin().doubleValue()) * (double)this.sliderScaleFactor;
                    double scaleMax = Math.log(this.validator.getMax().doubleValue()) * (double)this.sliderScaleFactor;
                    this.slider.getModel().setRangeProperties((int)dVal, 1, (int)scaleMin, 1 + (int)scaleMax, true);
                } else {
                    this.slider.setVisible(false);
                }
                return new Double(dVal);
            }
            float fVal = 0.0f;
            try {
                fVal = Float.valueOf(this.valueField.getText()).floatValue();
            }
            catch (Exception e) {
                return Float.valueOf(0.0f);
            }
            if (this.validator.getMin() != null && this.validator.getMax() != null) {
                float scaleMin = this.validator.getMin().floatValue() * (float)this.sliderScaleFactor;
                float scaleMax = this.validator.getMax().floatValue() * (float)this.sliderScaleFactor;
                this.slider.getModel().setRangeProperties((int)(fVal * (float)this.sliderScaleFactor), 1, (int)scaleMin, 1 + (int)scaleMax, true);
            } else {
                this.slider.setVisible(false);
            }
            return new Float(fVal);
        }
    }

    public class OptionBox
    extends JPanel
    implements MouseListener,
    ActionListener {
        JCheckBox enabled;
        final URL finfo;
        boolean hasLink = false;
        boolean initEnabled = false;
        String initVal = null;
        OptionI option;
        JComboBox<Object> val;

        public OptionBox(OptionI opt) {
            this.option = opt;
            this.setLayout(new FlowLayout(0));
            this.enabled = new JCheckBox(opt.getName());
            this.enabled.setSelected(opt.isRequired());
            if (opt.isRequired() && !(opt instanceof JabaOption)) {
                this.finfo = null;
                this.add(new JLabel(opt.getName()));
            } else {
                this.finfo = this.option.getFurtherDetails();
                this.configureCheckbox(opt);
                this.add(this.enabled);
            }
            this.val = OptsAndParamsPage.buildComboBox(opt);
            this.val.setSelectedItem(opt.getValue());
            if (opt.getPossibleValues().size() > 1 || opt.isRequired()) {
                this.val.addActionListener(this);
                this.add(this.val);
            }
            this.setInitialValue();
        }

        protected void configureCheckbox(OptionI opt) {
            this.enabled.setFont(new Font("Verdana", 0, 11));
            this.enabled.addActionListener(this);
            String desc = opt.getDescription();
            if (this.finfo != null) {
                this.hasLink = true;
                Object description = desc;
                if (desc == null || desc.trim().isEmpty()) {
                    description = MessageManager.getString("label.opt_and_params_further_details");
                }
                description = (String)description + "<br><img src=\"" + OptsAndParamsPage.this.linkImageURL + "\"/>";
                String text = JvSwingUtils.wrapTooltip(true, (String)description);
                this.enabled.setToolTipText(text);
                this.enabled.addMouseListener(this);
            } else if (desc != null && desc.trim().length() > 0) {
                this.enabled.setToolTipText(JvSwingUtils.wrapTooltip(true, desc));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != this.enabled) {
                this.enabled.setSelected(true);
            }
            this.checkIfModified();
        }

        private void checkIfModified() {
            boolean notmod;
            boolean bl = notmod = this.initEnabled == this.enabled.isSelected();
            notmod = this.enabled.isSelected() ? (this.initVal != null ? (notmod &= this.initVal.equals(this.val.getSelectedItem())) : (notmod &= this.option.getValue() == null || this.option.getValue().equals(this.val.getSelectedItem()))) : (notmod &= this.initVal != null ? this.initVal.equals(this.val.getSelectedItem()) : this.val.getSelectedItem() != this.initVal);
            OptsAndParamsPage.this.poparent.argSetModified(this, !notmod);
        }

        public ArgumentI getSelectedOption() {
            if (!this.enabled.isSelected()) {
                return null;
            }
            String value = OptsAndParamsPage.getSelectedValue(this.option, this.val.getSelectedIndex());
            OptionI opt = this.option.copy();
            opt.setValue(value);
            return opt;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                OptsAndParamsPage.showUrlPopUp(this, this.finfo.toString(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        public void resetToDefault(boolean setDefaultParams) {
            this.enabled.setSelected(false);
            if (this.option.isRequired() || setDefaultParams && this.option.getValue() != null) {
                OptsAndParamsPage.this.selectOption(this.option, this.option.getValue());
            }
        }

        public void setInitialValue() {
            this.initEnabled = this.enabled.isSelected();
            this.initVal = this.option.getPossibleValues() != null && this.option.getPossibleValues().size() > 1 ? (String)this.val.getSelectedItem() : (this.initEnabled ? (String)this.val.getSelectedItem() : null);
        }

        @Override
        public String toString() {
            return this.option == null ? super.toString() : this.option.toString();
        }
    }
}

