/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.gui.AlignmentPanel;
import jalview.gui.SplitFrame;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class IdwidthAdjuster
extends JPanel
implements MouseListener,
MouseMotionListener {
    boolean active = false;
    int oldX = 0;
    AlignmentPanel ap;

    public IdwidthAdjuster(AlignmentPanel ap) {
        this.ap = ap;
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.oldX = evt.getX();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.active = false;
        this.repaint();
        AlignViewportI viewport = this.ap.getAlignViewport();
        if (viewport.getCodingComplement() != null && viewport.isScaleProteinAsCdna()) {
            viewport.getCodingComplement().setIdWidth(viewport.getIdWidth());
            SplitFrame sf = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
            sf.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.active = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.active = false;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int dif;
        this.active = true;
        AlignViewportI viewport = this.ap.getAlignViewport();
        int curwidth = viewport.getIdWidth();
        int newWidth = curwidth + (dif = evt.getX() - this.oldX);
        if (newWidth > 20 || dif > 0) {
            viewport.setIdWidth(newWidth);
            this.ap.paintAlignment(true, false);
        }
        this.oldX = evt.getX();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.active) {
            this.setCursor(Cursor.getPredefinedCursor(10));
        }
    }
}

