/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.api.FinderI;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.jbgui.GFinder;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.KeyStroke;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class Finder
extends GFinder {
    private static final int MIN_WIDTH = 350;
    private static final int MIN_HEIGHT = 120;
    private static final int MY_HEIGHT = 120;
    private static final int MY_WIDTH = 400;
    private AlignViewportI av;
    private AlignmentPanel ap;
    private JInternalFrame frame;
    private Map<AlignViewportI, FinderI> finders;
    private SearchResultsI searchResults;
    private boolean focusfixed;

    public Finder() {
        this(null, null);
    }

    public Finder(AlignmentViewport viewport, AlignmentPanel alignPanel) {
        this.av = viewport;
        this.ap = alignPanel;
        this.finders = new HashMap<AlignViewportI, FinderI>();
        this.focusfixed = viewport != null;
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                Finder.this.closeAction();
            }
        });
        this.addEscapeHandler();
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.find"), 400, 120);
        this.frame.setMinimumSize(new Dimension(350, 120));
        this.searchBox.requestFocus();
    }

    private void addEscapeHandler() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getRootPane().getActionMap().put("Cancel", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Finder.this.closeAction();
            }
        });
    }

    @Override
    public void findNext_actionPerformed() {
        if (this.getFocusedViewport()) {
            this.doSearch(false);
        }
    }

    @Override
    public void findAll_actionPerformed() {
        if (this.getFocusedViewport()) {
            this.doSearch(true);
        }
    }

    boolean getFocusedViewport() {
        if (this.focusfixed || Desktop.desktop == null) {
            return this.ap != null && this.av != null;
        }
        JInternalFrame[] frames = Desktop.desktop.getAllFrames();
        for (int f = 0; f < frames.length; ++f) {
            JInternalFrame alignFrame = frames[f];
            if (alignFrame == null || !(alignFrame instanceof AlignFrame) || alignFrame.isIcon()) continue;
            this.av = ((AlignFrame)alignFrame).viewport;
            this.ap = ((AlignFrame)alignFrame).alignPanel;
            return true;
        }
        return false;
    }

    @Override
    public void createFeatures_actionPerformed() {
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        ArrayList<SequenceFeature> features = new ArrayList<SequenceFeature>();
        String searchString = this.searchBox.getEditor().getItem().toString().trim();
        String desc = "Search Results";
        for (SearchResultMatchI match : this.searchResults.getResults()) {
            seqs.add(match.getSequence().getDatasetSequence());
            features.add(new SequenceFeature(searchString, desc, match.getStart(), match.getEnd(), desc));
        }
        if (this.ap.getSeqPanel().seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, true, this.ap)) {
            this.ap.alignFrame.showSeqFeatures.setSelected(true);
            this.av.setShowSequenceFeatures(true);
            this.ap.highlightSearchResults(null);
        }
    }

    void doSearch(boolean doFindAll) {
        this.createFeatures.setEnabled(false);
        String searchString = this.searchBox.getUserInput().trim();
        if (this.isInvalidSearchString(searchString)) {
            return;
        }
        FinderI finder = this.finders.get(this.av);
        if (finder == null) {
            finder = new jalview.analysis.Finder(this.av);
            this.finders.put(this.av, finder);
        }
        boolean isCaseSensitive = this.caseSensitive.isSelected();
        boolean doSearchDescription = this.searchDescription.isSelected();
        if (doFindAll) {
            finder.findAll(searchString, isCaseSensitive, doSearchDescription);
        } else {
            finder.findNext(searchString, isCaseSensitive, doSearchDescription);
        }
        this.searchResults = finder.getSearchResults();
        List<SequenceI> idMatch = finder.getIdMatches();
        this.ap.getIdPanel().highlightSearchResults(idMatch);
        if (this.searchResults.isEmpty()) {
            this.searchResults = null;
        } else {
            this.createFeatures.setEnabled(true);
        }
        this.ap.highlightSearchResults(this.searchResults);
        if (idMatch.isEmpty() && this.searchResults == null) {
            JvOptionPane.showInternalMessageDialog(this, MessageManager.getString("label.finished_searching"), null, 1);
        } else if (doFindAll) {
            Object message;
            Object object = message = idMatch.size() > 0 ? idMatch.size() + " IDs" : "";
            if (this.searchResults != null) {
                if (idMatch.size() > 0 && this.searchResults.getSize() > 0) {
                    message = (String)message + " and ";
                }
                message = (String)message + this.searchResults.getSize() + " subsequence matches found.";
            }
            JvOptionPane.showInternalMessageDialog(this, message, null, 1);
        }
        this.searchBox.updateCache();
    }

    protected boolean isInvalidSearchString(String searchString) {
        String error = this.getSearchValidationError(searchString);
        if (error == null) {
            return false;
        }
        JvOptionPane.showInternalMessageDialog(this, error, MessageManager.getString("label.invalid_search"), 0);
        return true;
    }

    protected String getSearchValidationError(String searchString) {
        Object error = null;
        if (searchString == null || searchString.length() == 0) {
            error = MessageManager.getString("label.invalid_search");
        }
        try {
            Pattern.compile(searchString);
        }
        catch (PatternSyntaxException e) {
            error = MessageManager.getString("error.invalid_regex") + ": " + e.getDescription();
        }
        return error;
    }

    protected void closeAction() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.searchBox.persistCache();
        if (this.getFocusedViewport()) {
            this.ap.alignFrame.requestFocus();
        }
    }
}

