/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureColourI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.FeatureSettings;
import jalview.gui.FeatureTypeSettings;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.io.FeaturesFile;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FeatureRenderer
extends jalview.renderer.seqfeatures.FeatureRenderer {
    static String lastFeatureAdded = "feature_1";
    static String lastFeatureGroupAdded = "Jalview";
    Color resBoxColour;
    AlignmentPanel ap;
    FeatureColourI oldcol;
    FeatureColourI fcol;
    int featureIndex = 0;

    public FeatureRenderer(AlignmentPanel alignPanel) {
        super(alignPanel.av);
        this.ap = alignPanel;
        if (alignPanel.getSeqPanel() != null && alignPanel.getSeqPanel().seqCanvas != null && alignPanel.getSeqPanel().seqCanvas.fr != null) {
            this.transferSettings(alignPanel.getSeqPanel().seqCanvas.fr);
        }
    }

    protected boolean amendFeatures(final List<SequenceI> sequences, final List<SequenceFeature> features, boolean create, final AlignmentPanel alignPanel) {
        this.featureIndex = 0;
        final JPanel mainPanel = new JPanel(new BorderLayout());
        final JTextField name = new JTextField(25);
        name.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FeatureRenderer.this.warnIfTypeHidden(mainPanel, name.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FeatureRenderer.this.warnIfTypeHidden(mainPanel, name.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FeatureRenderer.this.warnIfTypeHidden(mainPanel, name.getText());
            }
        });
        final JTextField group = new JTextField(25);
        group.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FeatureRenderer.this.warnIfGroupHidden(mainPanel, group.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FeatureRenderer.this.warnIfGroupHidden(mainPanel, group.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FeatureRenderer.this.warnIfGroupHidden(mainPanel, group.getText());
            }
        });
        final JTextArea description = new JTextArea(3, 25);
        final JSpinner start = new JSpinner();
        final JSpinner end = new JSpinner();
        start.setPreferredSize(new Dimension(80, 20));
        end.setPreferredSize(new Dimension(80, 20));
        final JLabel colour = new JLabel();
        colour.setOpaque(true);
        colour.setMaximumSize(new Dimension(30, 16));
        colour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (FeatureRenderer.this.fcol.isSimpleColour()) {
                    Color col = JColorChooser.showDialog(Desktop.desktop, MessageManager.getString("label.select_feature_colour"), FeatureRenderer.this.fcol.getColour());
                    if (col != null) {
                        FeatureRenderer.this.fcol = new FeatureColour(col);
                        FeatureRenderer.this.updateColourButton(mainPanel, colour, FeatureRenderer.this.fcol);
                    }
                } else {
                    final String ft = ((SequenceFeature)features.get(FeatureRenderer.this.featureIndex)).getType();
                    final String type = ft == null ? lastFeatureAdded : ft;
                    FeatureTypeSettings fcc = new FeatureTypeSettings(FeatureRenderer.this, type);
                    fcc.setRequestFocusEnabled(true);
                    fcc.requestFocus();
                    fcc.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FeatureRenderer.this.fcol = FeatureRenderer.this.getFeatureStyle(ft);
                            FeatureRenderer.this.setColour(type, FeatureRenderer.this.fcol);
                            FeatureRenderer.this.updateColourButton(mainPanel, colour, FeatureRenderer.this.fcol);
                        }
                    });
                }
            }
        });
        JPanel gridPanel = new JPanel(new GridLayout(3, 1));
        if (!create && features.size() > 1) {
            gridPanel = new JPanel(new GridLayout(4, 1));
            JPanel choosePanel = new JPanel();
            choosePanel.add(new JLabel(MessageManager.getString("label.select_feature") + ":"));
            final JComboBox<String> overlaps = new JComboBox<String>();
            ArrayList<Object> added = new ArrayList<Object>();
            for (SequenceFeature sf : features) {
                Object text = String.format("%s/%d-%d (%s)", sf.getType(), sf.getBegin(), sf.getEnd(), sf.getFeatureGroup());
                while (added.contains(text)) {
                    text = (String)text + " ";
                }
                overlaps.addItem((String)text);
                added.add(text);
            }
            choosePanel.add(overlaps);
            overlaps.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FeatureColourI col;
                    int index = overlaps.getSelectedIndex();
                    if (index != -1) {
                        FeatureRenderer.this.featureIndex = index;
                        SequenceFeature sf = (SequenceFeature)features.get(index);
                        name.setText(sf.getType());
                        description.setText(sf.getDescription());
                        group.setText(sf.getFeatureGroup());
                        start.setValue(sf.getBegin());
                        end.setValue(sf.getEnd());
                        SearchResults highlight = new SearchResults();
                        highlight.addResult((SequenceI)sequences.get(0), sf.getBegin(), sf.getEnd());
                        alignPanel.getSeqPanel().seqCanvas.highlightSearchResults(highlight, false);
                    }
                    if ((col = FeatureRenderer.this.getFeatureStyle(name.getText())) == null) {
                        col = new FeatureColour(ColorUtils.createColourFromName(name.getText()));
                    }
                    FeatureRenderer.this.oldcol = FeatureRenderer.this.fcol = col;
                    FeatureRenderer.this.updateColourButton(mainPanel, colour, col);
                }
            });
            gridPanel.add(choosePanel);
        }
        JPanel namePanel = new JPanel();
        gridPanel.add(namePanel);
        namePanel.add(new JLabel(MessageManager.getString("label.name:"), 4));
        namePanel.add(name);
        JPanel groupPanel = new JPanel();
        gridPanel.add(groupPanel);
        groupPanel.add(new JLabel(MessageManager.getString("label.group:"), 4));
        groupPanel.add(group);
        JPanel colourPanel = new JPanel();
        gridPanel.add(colourPanel);
        colourPanel.add(new JLabel(MessageManager.getString("label.colour"), 4));
        colourPanel.add(colour);
        colour.setPreferredSize(new Dimension(150, 15));
        colour.setFont(new Font("Verdana", 0, 9));
        colour.setForeground(Color.black);
        colour.setHorizontalAlignment(0);
        colour.setVerticalAlignment(0);
        colour.setHorizontalTextPosition(0);
        colour.setVerticalTextPosition(0);
        mainPanel.add((Component)gridPanel, "North");
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.add(new JLabel(MessageManager.getString("label.description:"), 4));
        description.setFont(JvSwingUtils.getTextAreaFont());
        description.setLineWrap(true);
        descriptionPanel.add(new JScrollPane(description));
        if (!create) {
            mainPanel.add((Component)descriptionPanel, "South");
            JPanel startEndPanel = new JPanel();
            startEndPanel.add(new JLabel(MessageManager.getString("label.start"), 4));
            startEndPanel.add(start);
            startEndPanel.add(new JLabel(MessageManager.getString("label.end"), 4));
            startEndPanel.add(end);
            mainPanel.add((Component)startEndPanel, "Center");
        } else {
            mainPanel.add((Component)descriptionPanel, "Center");
        }
        SequenceFeature firstFeature = features.get(0);
        boolean useLastDefaults = firstFeature.getType() == null;
        String featureType = useLastDefaults ? lastFeatureAdded : firstFeature.getType();
        String featureGroup = useLastDefaults ? lastFeatureGroupAdded : firstFeature.getFeatureGroup();
        name.setText(featureType);
        group.setText(featureGroup);
        start.setValue(firstFeature.getBegin());
        end.setValue(firstFeature.getEnd());
        description.setText(firstFeature.getDescription());
        this.oldcol = this.fcol = this.getFeatureStyle(featureType);
        this.updateColourButton(mainPanel, colour, this.fcol);
        Object[] options = !create ? new Object[]{MessageManager.getString("label.amend"), MessageManager.getString("action.delete"), MessageManager.getString("action.cancel")} : new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
        String title = create ? MessageManager.getString("label.create_new_sequence_features") : MessageManager.formatMessage("label.amend_delete_features", new String[]{sequences.get(0).getName()});
        int reply = JvOptionPane.showInternalOptionDialog(Desktop.desktop, mainPanel, title, 1, 3, null, options, MessageManager.getString("action.ok"));
        FeaturesFile ffile = new FeaturesFile();
        String enteredType = name.getText().trim();
        String enteredGroup = group.getText().trim();
        String enteredDescription = description.getText().replaceAll("\n", " ");
        if (reply == 0 && enteredType.length() > 0 && useLastDefaults) {
            lastFeatureAdded = enteredType;
            lastFeatureGroupAdded = enteredGroup;
            if (lastFeatureGroupAdded.length() < 1) {
                lastFeatureGroupAdded = null;
            }
        }
        if (!create) {
            SequenceFeature sf = features.get(this.featureIndex);
            if (reply == 1) {
                sequences.get(0).getDatasetSequence().deleteFeature(sf);
                this.featuresAdded();
            } else if (reply == 0) {
                boolean refreshSettings = !featureType.equals(enteredType) || !featureGroup.equals(enteredGroup);
                refreshSettings |= this.fcol != this.oldcol;
                this.setColour(enteredType, this.fcol);
                int newBegin = sf.begin;
                int newEnd = sf.end;
                try {
                    newBegin = (Integer)start.getValue();
                    newEnd = (Integer)end.getValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sequences.get(0).deleteFeature(sf);
                SequenceFeature newSf = new SequenceFeature(sf, enteredType, newBegin, newEnd, enteredGroup, sf.getScore());
                newSf.setDescription(enteredDescription);
                ffile.parseDescriptionHTML(newSf, false);
                sequences.get(0).addSequenceFeature(newSf);
                if (refreshSettings) {
                    this.featuresAdded();
                }
            }
        } else {
            if (reply == 0 && enteredType.length() > 0) {
                for (int i = 0; i < sequences.size(); ++i) {
                    SequenceFeature sf = features.get(i);
                    SequenceFeature sf2 = new SequenceFeature(enteredType, enteredDescription, sf.getBegin(), sf.getEnd(), enteredGroup);
                    ffile.parseDescriptionHTML(sf2, false);
                    sequences.get(i).addSequenceFeature(sf2);
                }
                this.setColour(enteredType, this.fcol);
                this.featuresAdded();
                alignPanel.paintAlignment(true, true);
                return true;
            }
            return false;
        }
        alignPanel.paintAlignment(true, true);
        return true;
    }

    protected void warnIfTypeHidden(JPanel panel, String type) {
        if (this.getRenderOrder().contains(type) && !this.showFeatureOfType(type)) {
            String msg = MessageManager.formatMessage("label.warning_hidden", MessageManager.getString("label.feature_type"), type);
            JvOptionPane.showMessageDialog(panel, msg, "", 0);
        }
    }

    protected void warnIfGroupHidden(JPanel panel, String group) {
        if (this.featureGroups.containsKey(group) && !((Boolean)this.featureGroups.get(group)).booleanValue()) {
            String msg = MessageManager.formatMessage("label.warning_hidden", MessageManager.getString("label.group"), group);
            JvOptionPane.showMessageDialog(panel, msg, "", 0);
        }
    }

    protected void updateColourButton(JPanel bigPanel, JLabel colour, FeatureColourI col) {
        colour.removeAll();
        colour.setIcon(null);
        colour.setToolTipText(null);
        colour.setText("");
        if (col.isSimpleColour()) {
            colour.setBackground(col.getColour());
        } else {
            colour.setBackground(bigPanel.getBackground());
            colour.setForeground(Color.black);
            FeatureSettings.renderGraduatedColor(colour, col);
        }
    }

    public void orderFeatures(Comparator<String> order) {
        Arrays.sort(this.renderOrder, order);
    }
}

