/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GCutAndPasteHtmlTransfer;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class CutAndPasteHtmlTransfer
extends GCutAndPasteHtmlTransfer {
    AlignmentViewport viewport;

    public CutAndPasteHtmlTransfer() {
        this.displaySource.setSelected(false);
        this.textarea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
                arg0.consume();
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
        this.textarea.setEditable(false);
        this.textarea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    Desktop.showUrl(e.getURL().toExternalForm());
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CutAndPasteHtmlTransfer.this.textarea.requestFocus();
            }
        });
    }

    public void setForInput(AlignmentViewport viewport) {
        this.viewport = viewport;
        if (viewport != null) {
            this.ok.setText(MessageManager.getString("action.add"));
        }
        this.getContentPane().add((Component)this.inputButtonPanel, "South");
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String text) {
        this.textarea.setDocument(this.textarea.getEditorKit().createDefaultDocument());
        this.textarea.setText(text);
        this.textarea.setCaretPosition(0);
    }

    @Override
    public void save_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_text_to_file"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(chooser.getSelectedFile()));
                out.print(this.getText());
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void toggleHtml_actionPerformed(ActionEvent e) {
        String txt = this.textarea.getText();
        this.textarea.setContentType(this.displaySource.isSelected() ? "text/text" : "text/html");
        this.textarea.setText(txt);
    }

    @Override
    public void copyItem_actionPerformed(ActionEvent e) {
        Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringWriter sw = new StringWriter();
        try {
            this.textarea.getEditorKit().write(sw, this.textarea.getDocument(), this.textarea.getSelectionStart(), this.textarea.getSelectionEnd() - this.textarea.getSelectionStart());
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringSelection ssel = new StringSelection(sw.getBuffer().toString());
        c.setContents(ssel, ssel);
    }

    @Override
    public void cancel_actionPerformed(ActionEvent e) {
        try {
            this.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void textarea_mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = new JPopupMenu(MessageManager.getString("action.edit"));
            JMenuItem item = new JMenuItem(MessageManager.getString("action.copy"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CutAndPasteHtmlTransfer.this.copyItem_actionPerformed(e);
                }
            });
            popup.add(item);
            popup.show(this, e.getX() + 10, e.getY() + this.textarea.getY() + 40);
        }
    }
}

