/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.CrossRef;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureSettingsModelI;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblInfo;
import jalview.ext.ensembl.EnsemblMap;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.SplitFrame;
import jalview.structure.StructureSelectionManager;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.ws.SequenceFetcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CrossRefAction
implements Runnable {
    private AlignFrame alignFrame;
    private SequenceI[] sel;
    private final boolean _odna;
    private String source;
    List<AlignmentViewPanel> xrefViews = new ArrayList<AlignmentViewPanel>();

    List<AlignmentViewPanel> getXrefViews() {
        return this.xrefViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    public void run() {
        block17: {
            AlignFrame newFrame;
            AlignmentI copyAlignment;
            FeatureSettingsModelI featureColourScheme;
            boolean dna;
            long sttime;
            block16: {
                AlignmentI xrefsAlignment;
                block15: {
                    Alignment xrefs;
                    AlignmentI dataset;
                    AlignmentI alignment;
                    block14: {
                        sttime = System.currentTimeMillis();
                        this.alignFrame.setProgressBar(MessageManager.formatMessage("status.searching_for_sequences_from", this.source), sttime);
                        alignment = this.alignFrame.getViewport().getAlignment();
                        dataset = alignment.getDataset() == null ? alignment : alignment.getDataset();
                        dna = alignment.isNucleotide();
                        if (this._odna != dna) {
                            System.err.println("Conflict: showProducts for alignment originally thought to be " + (this._odna ? "DNA" : "Protein") + " now searching for " + (dna ? "DNA" : "Protein") + " Context.");
                        }
                        if ((xrefs = new CrossRef(this.sel, dataset).findXrefSequences(this.source, dna)) != null) break block14;
                        this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
                        return;
                    }
                    CrossRefAction.findGeneLoci(xrefs.getSequences());
                    featureColourScheme = new SequenceFetcher().getFeatureColourScheme(this.source);
                    if (dna && AlignmentUtils.looksLikeEnsembl(alignment)) {
                        featureColourScheme = new SequenceFetcher().getFeatureColourScheme("ENSEMBL");
                    }
                    xrefsAlignment = this.makeCrossReferencesAlignment(dataset, xrefs);
                    if (!dna) {
                        xrefsAlignment = AlignmentUtils.makeCdsAlignment(xrefsAlignment.getSequencesArray(), dataset, this.sel);
                        xrefsAlignment.alignAs(alignment);
                    }
                    copyAlignment = null;
                    if (!Cache.getDefault("ENABLE_SPLIT_FRAME", true) || (copyAlignment = this.copyAlignmentForSplitFrame(alignment, dataset, dna, xrefs, xrefsAlignment)) != null) break block15;
                    this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
                    return;
                }
                newFrame = new AlignFrame(xrefsAlignment, 700, 500);
                if (Cache.getDefault("HIDE_INTRONS", true)) {
                    newFrame.hideFeatureColumns("exon", false);
                }
                String newtitle = String.format("%s %s %s", dna ? MessageManager.getString("label.proteins") : MessageManager.getString("label.nucleotides"), MessageManager.getString("label.for"), this.alignFrame.getTitle());
                newFrame.setTitle(newtitle);
                if (copyAlignment != null) break block16;
                Desktop.addInternalFrame(newFrame, newtitle, 700, 500);
                this.xrefViews.add(newFrame.alignPanel);
                this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
                return;
            }
            try {
                AlignFrame copyThis = new AlignFrame(copyAlignment, 700, 500);
                copyThis.setTitle(this.alignFrame.getTitle());
                boolean showSequenceFeatures = this.alignFrame.getViewport().isShowSequenceFeatures();
                newFrame.setShowSeqFeatures(showSequenceFeatures);
                copyThis.setShowSeqFeatures(showSequenceFeatures);
                FeatureRenderer myFeatureStyling = this.alignFrame.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer();
                FeatureRenderer fr1 = newFrame.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer();
                fr1.transferSettings(myFeatureStyling);
                fr1.findAllFeatures(true);
                FeatureRenderer fr2 = copyThis.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer();
                fr2.transferSettings(myFeatureStyling);
                fr2.findAllFeatures(true);
                newFrame.getViewport().applyFeaturesStyle(featureColourScheme);
                copyThis.getViewport().applyFeaturesStyle(featureColourScheme);
                for (AlignmentViewPanel origpanel : this.alignFrame.getAlignPanels()) {
                    origpanel.getAlignViewport().mergeFeaturesStyle(featureColourScheme);
                }
                SplitFrame sf = new SplitFrame(dna ? copyThis : newFrame, dna ? newFrame : copyThis);
                newFrame.setVisible(true);
                copyThis.setVisible(true);
                String linkedTitle = MessageManager.getString("label.linked_view_title");
                Desktop.addInternalFrame(sf, linkedTitle, -1, -1);
                sf.adjustInitialLayout();
                this.xrefViews.add(dna ? copyThis.alignPanel : newFrame.alignPanel);
                this.xrefViews.add(!dna ? copyThis.alignPanel : newFrame.alignPanel);
            }
            catch (OutOfMemoryError e) {
                new OOMWarning("whilst fetching crossreferences", e);
                this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
                break block17;
            }
            catch (Throwable e2) {
                Cache.log.error((Object)"Error when finding crossreferences", e2);
                {
                    catch (Throwable throwable) {
                        this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
                        throw throwable;
                    }
                }
                this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
            }
            this.alignFrame.setProgressBar(MessageManager.formatMessage("status.finished_searching_for_sequences_from", this.source), sttime);
        }
    }

    public static void findGeneLoci(List<SequenceI> sequences) {
        HashMap<DBRefEntry, GeneLociI> retrievedLoci = new HashMap<DBRefEntry, GeneLociI>();
        for (SequenceI seq : sequences) {
            CrossRefAction.findGeneLoci(seq, retrievedLoci);
        }
    }

    static void findGeneLoci(SequenceI seq, Map<DBRefEntry, GeneLociI> retrievedLoci) {
        if (seq == null || seq.isProtein() || seq.getGeneLoci() != null || seq.getDBRefs() == null) {
            return;
        }
        Set<String> ensemblDivisions = new EnsemblInfo().getDivisions();
        String[] divisionsArray = ensemblDivisions.toArray(new String[ensemblDivisions.size()]);
        DBRefEntry[] seqRefs = seq.getDBRefs();
        DBRefEntry[] directEnsemblRefs = DBRefUtils.selectRefs(seqRefs, divisionsArray);
        if (directEnsemblRefs != null) {
            for (DBRefEntry ensemblRef : directEnsemblRefs) {
                if (!CrossRefAction.fetchGeneLoci(seq, ensemblRef, retrievedLoci)) continue;
                return;
            }
        }
        for (DBRefEntry dbref : seq.getDBRefs()) {
            DBRefEntry[] dbrefs;
            DBRefEntry[] indirectEnsemblRefs;
            if (dbref.getMap() == null || dbref.getMap().getTo() == null || (indirectEnsemblRefs = DBRefUtils.selectRefs(dbrefs = dbref.getMap().getTo().getDBRefs(), divisionsArray)) == null) continue;
            for (DBRefEntry ensemblRef : indirectEnsemblRefs) {
                if (!CrossRefAction.fetchGeneLoci(seq, ensemblRef, retrievedLoci)) continue;
                return;
            }
        }
    }

    static boolean fetchGeneLoci(SequenceI seq, DBRefEntry dbref, Map<DBRefEntry, GeneLociI> retrievedLoci) {
        MapList map;
        int mappedFromLength;
        String accession = dbref.getAccessionId();
        String division = dbref.getSource();
        if (accession.startsWith("ENSP")) {
            return false;
        }
        EnsemblMap mapper = new EnsemblMap();
        GeneLociI geneLoci = mapper.getCdsMapping(division, accession, 1, seq.getLength());
        if (geneLoci != null && (mappedFromLength = MappingUtils.getLength((map = geneLoci.getMapping()).getFromRanges())) == seq.getLength()) {
            seq.setGeneLoci(geneLoci.getSpeciesId(), geneLoci.getAssemblyId(), geneLoci.getChromosomeId(), map);
            retrievedLoci.put(dbref, geneLoci);
            return true;
        }
        geneLoci = mapper.getCdnaMapping(division, accession, 1, seq.getLength());
        if (geneLoci != null && (mappedFromLength = MappingUtils.getLength((map = geneLoci.getMapping()).getFromRanges())) == seq.getLength()) {
            seq.setGeneLoci(geneLoci.getSpeciesId(), geneLoci.getAssemblyId(), geneLoci.getChromosomeId(), map);
            retrievedLoci.put(dbref, geneLoci);
            return true;
        }
        return false;
    }

    protected AlignmentI copyAlignmentForSplitFrame(AlignmentI alignment, AlignmentI dataset, boolean dna, AlignmentI xrefs, AlignmentI xrefsAlignment) {
        AlignmentI copyAlignment;
        boolean copyAlignmentIsAligned = false;
        if (dna) {
            copyAlignment = AlignmentUtils.makeCdsAlignment(this.sel, dataset, xrefsAlignment.getSequencesArray());
            if (copyAlignment.getHeight() == 0) {
                JvOptionPane.showMessageDialog(this.alignFrame, MessageManager.getString("label.cant_map_cds"), MessageManager.getString("label.operation_failed"), 0);
                System.err.println("Failed to make CDS alignment");
                return null;
            }
            if ("ENSEMBL".equalsIgnoreCase(this.source) || AlignmentUtils.looksLikeEnsembl(alignment)) {
                copyAlignment.alignAs(alignment);
                copyAlignmentIsAligned = true;
            }
        } else {
            copyAlignment = AlignmentUtils.makeCopyAlignment(this.sel, xrefs.getSequencesArray(), dataset);
        }
        copyAlignment.setGapCharacter(this.alignFrame.viewport.getGapCharacter());
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
        ssm.registerMappings(dataset.getCodonFrames());
        if (copyAlignment.getHeight() <= 0) {
            System.err.println("No Sequences generated for xRef type " + this.source);
            return null;
        }
        if (dna && copyAlignmentIsAligned) {
            xrefsAlignment.alignAs(copyAlignment);
        } else if (dna && "ENSEMBL".equalsIgnoreCase(this.source)) {
            copyAlignment.alignAs(xrefsAlignment);
        }
        return copyAlignment;
    }

    protected AlignmentI makeCrossReferencesAlignment(AlignmentI dataset, AlignmentI seqs) {
        SequenceI[] sprods = new SequenceI[seqs.getHeight()];
        for (int s = 0; s < sprods.length; ++s) {
            sprods[s] = seqs.getSequenceAt(s).deriveSequence();
            if (dataset.getSequences() == null || !dataset.getSequences().contains(sprods[s].getDatasetSequence())) {
                dataset.addSequence(sprods[s].getDatasetSequence());
            }
            sprods[s].updatePDBIds();
        }
        Alignment al = new Alignment(sprods);
        al.setDataset(dataset);
        return al;
    }

    CrossRefAction(AlignFrame af, SequenceI[] seqs, boolean fromDna, String dbSource) {
        this.alignFrame = af;
        this.sel = seqs;
        this._odna = fromDna;
        this.source = dbSource;
    }

    public static CrossRefAction getHandlerFor(SequenceI[] sel, boolean fromDna, String source, AlignFrame alignFrame) {
        return new CrossRefAction(alignFrame, sel, fromDna, source);
    }
}

