/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.gui.JalviewAppender;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class Console
extends WindowAdapter
implements WindowListener,
ActionListener,
Runnable {
    private JFrame frame;
    private JTextArea textArea;
    int byteslim = 102400;
    int bytescut = 76800;
    private Thread reader;
    private Thread reader2;
    private Thread textAppender;
    private boolean quit;
    private final PrintStream stdout = System.out;
    private final PrintStream stderr = System.err;
    private PipedInputStream pin = new PipedInputStream();
    private PipedInputStream pin2 = new PipedInputStream();
    private StringBuffer displayPipe = new StringBuffer();
    Thread errorThrower;
    Desktop parent = null;
    private int MIN_WIDTH = 300;
    private int MIN_HEIGHT = 250;
    PipedOutputStream pout = null;
    PipedOutputStream perr = null;
    private String header = null;
    private boolean updateConsole = false;

    public Console() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame = this.initFrame("Java Console", screenSize.width / 2, screenSize.height / 2, -1, -1);
        this.initConsole(true);
    }

    private void initConsole(boolean visible) {
        this.initConsole(visible, true);
    }

    private void initConsole(boolean visible, boolean redirect) {
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        JButton button = new JButton(MessageManager.getString("action.clear"));
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
        this.frame.getContentPane().add((Component)button, "South");
        this.frame.setVisible(visible);
        this.updateConsole = visible;
        this.frame.addWindowListener(this);
        button.addActionListener(this);
        if (redirect) {
            this.redirectStreams();
        } else {
            this.unredirectStreams();
        }
        this.quit = false;
        this.reader = new Thread(this);
        this.reader.setDaemon(true);
        this.reader.start();
        this.reader2 = new Thread(this);
        this.reader2.setDaemon(true);
        this.reader2.start();
        this.textAppender = new Thread(this);
        this.textAppender.setDaemon(true);
        this.textAppender.start();
    }

    public void redirectStreams() {
        if (this.pout == null) {
            try {
                this.pout = new PipedOutputStream(this.pin);
                System.setOut(new PrintStream(this.pout, true));
            }
            catch (IOException io) {
                this.textArea.append("Couldn't redirect STDOUT to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't redirect STDOUT to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
            try {
                this.perr = new PipedOutputStream(this.pin2);
                System.setErr(new PrintStream(this.perr, true));
            }
            catch (IOException io) {
                this.textArea.append("Couldn't redirect STDERR to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't redirect STDERR to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
        }
    }

    public void unredirectStreams() {
        if (this.pout != null) {
            try {
                System.setOut(this.stdout);
                this.pout.flush();
                this.pout.close();
                this.pin = new PipedInputStream();
                this.pout = null;
            }
            catch (IOException io) {
                this.textArea.append("Couldn't unredirect STDOUT to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't unredirect STDOUT to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
            try {
                System.setErr(this.stderr);
                this.perr.flush();
                this.perr.close();
                this.pin2 = new PipedInputStream();
                this.perr = null;
            }
            catch (IOException io) {
                this.textArea.append("Couldn't unredirect STDERR to this console\n" + io.getMessage());
                io.printStackTrace(this.stderr);
            }
            catch (SecurityException se) {
                this.textArea.append("Couldn't unredirect STDERR to this console\n" + se.getMessage());
                se.printStackTrace(this.stderr);
            }
        }
    }

    public void test() {
        System.out.println("Hello World 2");
        System.out.println("All fonts available to Graphic2D:\n");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = ge.getAvailableFontFamilyNames();
        for (int n = 0; n < fontNames.length; ++n) {
            System.out.println(fontNames[n]);
        }
        System.out.println("\nLets throw an error on this console");
        this.errorThrower = new Thread(this);
        this.errorThrower.setDaemon(true);
        this.errorThrower.start();
    }

    private JFrame initFrame(String string, int i, int j, int x, int y) {
        JFrame frame = new JFrame(string);
        frame.setName(string);
        if (x == -1) {
            x = i / 2;
        }
        if (y == -1) {
            y = j / 2;
        }
        frame.setBounds(x, y, i, j);
        return frame;
    }

    public Console(Desktop desktop) {
        this(desktop, true);
    }

    public Console(Desktop desktop, boolean showjconsole) {
        this.parent = desktop;
        Rectangle bounds = desktop.getLastKnownDimensions("JAVA_CONSOLE_");
        this.frame = bounds == null ? this.initFrame("Jalview Java Console", desktop.getWidth() / 2, desktop.getHeight() / 4, desktop.getX(), desktop.getY()) : this.initFrame("Jalview Java Console", bounds.width, bounds.height, bounds.x, bounds.y);
        this.frame.setMinimumSize(new Dimension(this.MIN_WIDTH, this.MIN_HEIGHT));
        this.initConsole(false);
        JalviewAppender jappender = new JalviewAppender();
        jappender.setLayout((Layout)new SimpleLayout());
        JalviewAppender.setTextArea(this.textArea);
        Logger.getRootLogger().addAppender((Appender)jappender);
    }

    public synchronized void stopConsole() {
        this.quit = true;
        this.notifyAll();
        if (this.pout != null) {
            try {
                this.reader.join(10L);
                this.pin.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.reader2.join(10L);
                this.pin2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.textAppender.join(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.frame.isVisible()) {
            this.frame.dispose();
        }
    }

    @Override
    public synchronized void windowClosed(WindowEvent evt) {
        this.frame.setVisible(false);
        this.closeConsoleGui();
    }

    private void closeConsoleGui() {
        this.updateConsole = false;
        if (this.parent == null) {
            this.stopConsole();
        } else {
            this.parent.showConsole(false);
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent evt) {
        this.frame.setVisible(false);
        this.closeConsoleGui();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent evt) {
        this.trimBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        try {
            long time;
            String input2;
            while (Thread.currentThread() == this.reader) {
                if (this.pin == null || this.pin.available() == 0) {
                    try {
                        this.wait(100L);
                        if (this.pin.available() == 0) {
                            this.trimBuffer(false);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                while (this.pin.available() != 0) {
                    input2 = this.readLine(this.pin);
                    this.stdout.print(input2);
                    time = System.nanoTime();
                    this.appendToTextArea(input2);
                }
                if (!this.quit) continue;
                return;
            }
            while (Thread.currentThread() == this.reader2) {
                if (this.pin2.available() == 0) {
                    try {
                        this.wait(100L);
                        if (this.pin2.available() == 0) {
                            this.trimBuffer(false);
                        }
                    }
                    catch (InterruptedException input2) {
                        // empty catch block
                    }
                }
                while (this.pin2.available() != 0) {
                    input2 = this.readLine(this.pin2);
                    this.stderr.print(input2);
                    time = System.nanoTime();
                    this.appendToTextArea(input2);
                }
                if (!this.quit) continue;
                return;
            }
            while (Thread.currentThread() == this.textAppender) {
                if (this.updateConsole) {
                    while (this.displayPipe.length() > 0) {
                        StringBuffer replace;
                        long count = 0L;
                        StringBuffer tmp = new StringBuffer();
                        StringBuffer stringBuffer = this.displayPipe;
                        synchronized (stringBuffer) {
                            replace = this.displayPipe;
                            this.displayPipe = tmp;
                        }
                        this.textArea.append(replace.toString());
                        if ((count += (long)replace.length()) <= (long)this.byteslim) continue;
                        this.trimBuffer(false);
                    }
                    if (this.displayPipe.length() == 0) {
                        try {
                            this.wait(100L);
                            if (this.displayPipe.length() == 0) {
                                this.trimBuffer(false);
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                } else {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException count) {
                        // empty catch block
                    }
                }
                if (!this.quit) continue;
                return;
            }
        }
        catch (Exception e) {
            this.textArea.append("\nConsole reports an Internal error.");
            this.textArea.append("The error is: " + e.getMessage());
            this.stderr.println("Console reports an Internal error.\nThe error is: " + e);
        }
        if (Thread.currentThread() == this.errorThrower) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            throw new NullPointerException(MessageManager.getString("exception.application_test_npe"));
        }
    }

    private void appendToTextArea(final String input) {
        if (!this.updateConsole) {
            return;
        }
        long time = System.nanoTime();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Console.this.displayPipe.append(input);
            }
        });
    }

    private synchronized void trimBuffer(boolean clear) {
        if (this.header == null && this.textArea.getLineCount() > 5) {
            try {
                this.header = this.textArea.getText(0, this.textArea.getLineStartOffset(5)) + "\nTruncated...\n";
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int tlength = this.textArea.getDocument().getLength();
        if (this.header != null && (clear || tlength > this.byteslim)) {
            try {
                if (!clear) {
                    long time = System.nanoTime();
                    this.textArea.replaceRange(this.header, 0, tlength - this.bytescut);
                } else {
                    this.textArea.setText(this.header);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized String readLine(PipedInputStream in) throws IOException {
        int available;
        Object input = "";
        int lp = -1;
        while ((available = in.available()) != 0) {
            byte[] b = new byte[available];
            in.read(b);
            if (!((String)(input = (String)input + new String(b, 0, b.length))).endsWith("\n") && !((String)input).endsWith("\r\n") && !this.quit) continue;
        }
        return input;
    }

    public static void main(String[] arg) {
        new Console().test();
    }

    public void setVisible(boolean selected) {
        this.frame.setVisible(selected);
        if (selected) {
            this.redirectStreams();
            this.updateConsole = true;
            this.frame.toFront();
        } else {
            this.unredirectStreams();
            this.updateConsole = false;
        }
    }

    public Rectangle getBounds() {
        if (this.frame != null) {
            return this.frame.getBounds();
        }
        return null;
    }

    public void setHeader(String string) {
        this.header = string;
        if (this.header.charAt(this.header.length() - 1) != '\n') {
            this.header = this.header + "\n";
        }
        this.textArea.insert(this.header, 0);
    }

    public String getHeader() {
        return this.header;
    }
}

