/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureRenderer;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.rbvi.chimera.JalviewChimeraBinding;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JalviewChimeraBindingModel;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.gui.ProgressBar;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.dbsources.Pdb;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ChimeraViewFrame
extends StructureViewerBase {
    private JalviewChimeraBinding jmb;
    private IProgressIndicator progressBar = null;
    private String chimeraSessionFile = null;
    private Random random = new Random();
    private int myWidth = 500;
    private int myHeight = 150;

    @Override
    protected void initMenus() {
        super.initMenus();
        this.viewerActionMenu.setText(MessageManager.getString("label.chimera"));
        this.viewerColour.setText(MessageManager.getString("label.colour_with_chimera"));
        this.viewerColour.setToolTipText(MessageManager.getString("label.let_chimera_manage_structure_colours"));
        this.helpItem.setText(MessageManager.getString("label.chimera_help"));
        this.savemenu.setVisible(false);
        this.viewMenu.add(this.fitToWindow);
        JMenuItem writeFeatures = new JMenuItem(MessageManager.getString("label.create_chimera_attributes"));
        writeFeatures.setToolTipText(MessageManager.getString("label.create_chimera_attributes_tip"));
        writeFeatures.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChimeraViewFrame.this.sendFeaturesToChimera();
            }
        });
        this.viewerActionMenu.add(writeFeatures);
        final JMenu fetchAttributes = new JMenu(MessageManager.getString("label.fetch_chimera_attributes"));
        fetchAttributes.setToolTipText(MessageManager.getString("label.fetch_chimera_attributes_tip"));
        fetchAttributes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ChimeraViewFrame.this.buildAttributesMenu(fetchAttributes);
            }
        });
        this.viewerActionMenu.add(fetchAttributes);
    }

    protected void buildAttributesMenu(JMenu attributesMenu) {
        List<String> atts = this.jmb.sendChimeraCommand("list resattr", true);
        if (atts == null) {
            return;
        }
        attributesMenu.removeAll();
        Collections.sort(atts);
        for (String att : atts) {
            final String attName = att.split(" ")[1];
            if (attName.startsWith("jv_")) continue;
            JMenuItem menuItem = new JMenuItem(attName);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChimeraViewFrame.this.getChimeraAttributes(attName);
                }
            });
            attributesMenu.add(menuItem);
        }
    }

    protected void getChimeraAttributes(String attName) {
        this.jmb.copyStructureAttributesToFeatures(attName, this.getAlignmentPanel());
    }

    protected void sendFeaturesToChimera() {
        int count = this.jmb.sendFeaturesToViewer(this.getAlignmentPanel());
        this.statusBar.setText(MessageManager.formatMessage("label.attributes_set", count));
    }

    public ChimeraViewFrame(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap) {
        this();
        this.openNewChimera(ap, new PDBEntry[]{pdbentry}, new SequenceI[][]{seq});
    }

    protected void createProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        }
    }

    private void openNewChimera(AlignmentPanel ap, PDBEntry[] pdbentrys, SequenceI[][] seqs) {
        this.createProgressBar();
        this.jmb = new JalviewChimeraBindingModel(this, ap.getStructureSelectionManager(), pdbentrys, seqs, null);
        this.addAlignmentPanel(ap);
        this.useAlignmentPanelForColourbyseq(ap);
        if (pdbentrys.length > 1) {
            this.useAlignmentPanelForSuperposition(ap);
        }
        this.jmb.setColourBySequence(true);
        this.setSize(this.myWidth, this.myHeight);
        this.initMenus();
        this.addingStructures = false;
        this.worker = new Thread(this);
        this.worker.start();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ChimeraViewFrame.this.closeViewer(false);
            }
        });
    }

    public ChimeraViewFrame(String chimeraSessionFile, AlignmentPanel alignPanel, PDBEntry[] pdbArray, SequenceI[][] seqsArray, boolean colourByChimera, boolean colourBySequence, String newViewId) {
        this();
        this.setViewId(newViewId);
        this.chimeraSessionFile = chimeraSessionFile;
        this.openNewChimera(alignPanel, pdbArray, seqsArray);
        if (colourByChimera) {
            this.jmb.setColourBySequence(false);
            this.seqColour.setSelected(false);
            this.viewerColour.setSelected(true);
        } else if (colourBySequence) {
            this.jmb.setColourBySequence(true);
            this.seqColour.setSelected(true);
            this.viewerColour.setSelected(false);
        }
    }

    public ChimeraViewFrame(PDBEntry[] pe, boolean alignAdded, SequenceI[][] seqs, AlignmentPanel ap) {
        this();
        this.setAlignAddedStructures(alignAdded);
        this.openNewChimera(ap, pe, seqs);
    }

    public ChimeraViewFrame() {
        this.setDefaultCloseOperation(0);
    }

    void initChimera() {
        boolean opened;
        this.jmb.setFinishedInit(false);
        Desktop.addInternalFrame(this, this.jmb.getViewerTitle(this.getViewerName(), true), this.getBounds().width, this.getBounds().height);
        if (!this.jmb.launchChimera()) {
            JvOptionPane.showMessageDialog(Desktop.desktop, MessageManager.getString("label.chimera_failed"), MessageManager.getString("label.error_loading_file"), 0);
            this.dispose();
            return;
        }
        if (this.chimeraSessionFile != null && !(opened = this.jmb.openSession(this.chimeraSessionFile))) {
            System.err.println("An error occurred opening Chimera session file " + this.chimeraSessionFile);
        }
        this.jmb.startChimeraListener();
    }

    @Override
    void showSelectedChains() {
        ArrayList<String> toshow = new ArrayList<String>();
        for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item;
            if (!(this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)this.chainMenu.getItem(i)).isSelected()) continue;
            toshow.add(item.getText());
        }
        this.jmb.showChains(toshow);
    }

    @Override
    public void closeViewer(boolean closeChimera) {
        if (this.jmb != null && this.jmb.isChimeraRunning()) {
            if (!closeChimera) {
                String prompt = MessageManager.formatMessage("label.confirm_close_chimera", this.jmb.getViewerTitle(this.getViewerName(), false));
                int confirm = JvOptionPane.showConfirmDialog(this, prompt = JvSwingUtils.wrapTooltip(true, prompt), MessageManager.getString("label.close_viewer"), 1);
                if (confirm == 2 || confirm == -1) {
                    return;
                }
                closeChimera = confirm == 0;
            }
            this.jmb.closeViewer(closeChimera);
        }
        this.setAlignmentPanel(null);
        this._aps.clear();
        this._alignwith.clear();
        this._colourwith.clear();
        this.jmb = null;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._started = true;
        StringBuilder errormsgs = new StringBuilder(128);
        StringBuilder files = new StringBuilder(128);
        ArrayList<PDBEntry> filePDB = new ArrayList<PDBEntry>();
        ArrayList<Integer> filePDBpos = new ArrayList<Integer>();
        PDBEntry thePdbEntry = null;
        StructureFile pdb = null;
        try {
            String[] curfiles = this.jmb.getStructureFiles();
            for (int pi = 0; pi < this.jmb.getPdbCount(); ++pi) {
                String file;
                block30: {
                    block29: {
                        file = null;
                        thePdbEntry = this.jmb.getPdbEntry(pi);
                        if (thePdbEntry.getFile() != null) break block29;
                        file = this.fetchPdbFile(thePdbEntry);
                        if (file != null) break block30;
                        errormsgs.append("'" + thePdbEntry.getId() + "' ");
                        break block30;
                    }
                    file = new File(thePdbEntry.getFile()).getAbsoluteFile().getPath();
                    if (curfiles != null && curfiles.length > 0) {
                        this.addingStructures = true;
                        for (int c = 0; c < curfiles.length; ++c) {
                            if (!curfiles[c].equals(file)) continue;
                            file = null;
                            break;
                        }
                    }
                }
                if (file == null) continue;
                filePDB.add(thePdbEntry);
                filePDBpos.add(pi);
                files.append(" \"" + Platform.escapeBackslashes(file) + "\"");
            }
        }
        catch (OutOfMemoryError oomerror) {
            new OOMWarning("Retrieving PDB files: " + thePdbEntry.getId(), oomerror);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errormsgs.append("When retrieving pdbfiles for '" + thePdbEntry.getId() + "'");
        }
        if (errormsgs.length() > 0) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.formatMessage("label.pdb_entries_couldnt_be_retrieved", errormsgs.toString()), MessageManager.getString("label.couldnt_load_file"), 0);
        }
        if (files.length() > 0) {
            this.jmb.setFinishedInit(false);
            if (!this.addingStructures) {
                try {
                    this.initChimera();
                }
                catch (Exception ex) {
                    Cache.log.error((Object)"Couldn't open Chimera viewer!", (Throwable)ex);
                }
            }
            int num = -1;
            for (PDBEntry pe : filePDB) {
                ++num;
                if (pe.getFile() == null) continue;
                try {
                    int pos = (Integer)filePDBpos.get(num);
                    long startTime = this.startProgressBar(this.getViewerName() + " " + MessageManager.getString("status.opening_file_for") + " " + pe.getId());
                    this.jmb.openFile(pe);
                    this.jmb.addSequence(pos, this.jmb.getSequence()[pos]);
                    File fl = new File(pe.getFile());
                    DataSourceType protocol = DataSourceType.URL;
                    try {
                        if (fl.exists()) {
                            protocol = DataSourceType.FILE;
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        this.stopProgressBar("", startTime);
                    }
                    pdb = this.jmb.getSsm().setMapping(this.jmb.getSequence()[pos], this.jmb.getChains()[pos], pe.getFile(), protocol, this.progressBar);
                    this.stashFoundChains(pdb, pe.getFile());
                }
                catch (OutOfMemoryError oomerror) {
                    new OOMWarning("When trying to open and map structures from Chimera!", oomerror);
                }
                catch (Exception ex) {
                    Cache.log.error((Object)("Couldn't open " + pe.getFile() + " in Chimera viewer!"), (Throwable)ex);
                }
                finally {
                    Cache.log.debug((Object)("File locations are " + files));
                }
            }
            this.jmb.refreshGUI();
            this.jmb.setFinishedInit(true);
            this.jmb.setLoadingFromArchive(false);
            FeatureRenderer fr = this.getBinding().getFeatureRenderer(null);
            if (fr != null) {
                fr.featuresAdded();
            }
            for (AlignmentPanel ap : this._colourwith) {
                this.jmb.updateColours(ap);
            }
            if (this.alignAddedStructures) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ChimeraViewFrame.this.alignStructs_withAllAlignPanels();
                    }
                }).start();
            }
            this.addingStructures = false;
        }
        this._started = false;
        this.worker = null;
    }

    private void stashFoundChains(StructureFile pdb, String file) {
        for (int i = 0; i < pdb.getChains().size(); ++i) {
            String chid = new String(pdb.getId() + ":" + pdb.getChains().elementAt((int)i).id);
            this.jmb.getChainNames().add(chid);
            this.jmb.getChainFile().put(chid, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchPdbFile(PDBEntry processingEntry) throws Exception {
        String filePath = null;
        Pdb pdbclient = new Pdb();
        AlignmentI pdbseq = null;
        String pdbid = processingEntry.getId();
        long handle = System.currentTimeMillis() + (long)Thread.currentThread().hashCode();
        Object msg = MessageManager.formatMessage("status.fetching_pdb", pdbid);
        this.getAlignmentPanel().alignFrame.setProgressBar((String)msg, handle);
        try {
            pdbseq = pdbclient.getSequenceRecords(pdbid);
        }
        catch (OutOfMemoryError oomerror) {
            new OOMWarning("Retrieving PDB id " + pdbid, oomerror);
        }
        finally {
            msg = pdbid + " " + MessageManager.getString("label.state_completed");
            this.getAlignmentPanel().alignFrame.setProgressBar((String)msg, handle);
        }
        if (pdbseq != null && pdbseq.getHeight() > 0) {
            filePath = new File(pdbseq.getSequenceAt(0).getAllPDBEntries().elementAt(0).getFile()).getAbsolutePath();
            processingEntry.setFile(filePath);
        }
        return filePath;
    }

    public long startProgressBar(String msg) {
        long tm = this.random.nextLong();
        if (this.progressBar != null) {
            this.progressBar.setProgressBar(msg, tm);
        }
        return tm;
    }

    public void stopProgressBar(String msg, long handle) {
        if (this.progressBar != null) {
            this.progressBar.setProgressBar(msg, handle);
        }
    }

    @Override
    public void eps_actionPerformed(ActionEvent e) {
        throw new Error(MessageManager.getString("error.eps_generation_not_implemented"));
    }

    @Override
    public void png_actionPerformed(ActionEvent e) {
        throw new Error(MessageManager.getString("error.png_generation_not_implemented"));
    }

    @Override
    public void showHelp_actionPerformed(ActionEvent actionEvent) {
        try {
            BrowserLauncher.openURL("https://www.cgl.ucsf.edu/chimera/docs/UsersGuide");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public AAStructureBindingModel getBinding() {
        return this.jmb;
    }

    protected String saveSession(String filepath) {
        String pathUsed = filepath;
        try {
            boolean result;
            if (pathUsed == null) {
                File tempFile = File.createTempFile("chimera", ".py");
                tempFile.deleteOnExit();
                pathUsed = tempFile.getPath();
            }
            if (result = this.jmb.saveSession(pathUsed)) {
                this.chimeraSessionFile = pathUsed;
                return pathUsed;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStateInfo() {
        String sessionFile = this.saveSession(null);
        if (sessionFile == null) {
            return "";
        }
        InputStream is = null;
        try {
            File f = new File(sessionFile);
            byte[] bytes = new byte[(int)f.length()];
            is = new FileInputStream(sessionFile);
            is.read(bytes);
            String string = new String(bytes);
            return string;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void fitToWindow_actionPerformed() {
        this.jmb.focusView();
    }

    @Override
    public StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.CHIMERA;
    }

    @Override
    protected String getViewerName() {
        return "Chimera";
    }

    @Override
    protected String alignStructs_withAllAlignPanels() {
        String reply = super.alignStructs_withAllAlignPanels();
        if (reply != null) {
            this.statusBar.setText("Superposition failed: " + reply);
        }
        return reply;
    }

    @Override
    protected IProgressIndicator getIProgressIndicator() {
        return this.progressBar;
    }
}

