/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.ItemsRenderer;
import jalview.gui.JalviewDialog;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.robsite.jswingreader.action.MarkChannelAsRead;
import org.robsite.jswingreader.action.MarkChannelAsUnread;
import org.robsite.jswingreader.action.MarkItemAsRead;
import org.robsite.jswingreader.action.MarkItemAsUnread;
import org.robsite.jswingreader.action.UpdatableAction;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.ChannelListModel;
import org.robsite.jswingreader.model.Item;
import org.robsite.jswingreader.model.SimpleRSSParser;
import org.robsite.jswingreader.ui.BlogContentPane;
import org.robsite.jswingreader.ui.ItemReadTimer;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.util.ContextMenuMouseAdapter;

public class BlogReader
extends JPanel {
    private JButton buttonRefresh = new JButton();
    private JToolBar toolBar = new JToolBar();
    private JLabel statusBar = new JLabel();
    private JPanel panelMain = new JPanel();
    private BorderLayout layoutMain = new BorderLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel topPanel = new JPanel();
    private JPanel bottomPanel = new JPanel();
    private JSplitPane topBottomSplitPane = new JSplitPane();
    private JList listItems = new JList(new DefaultListModel());
    private BlogContentPane textDescription = new BlogContentPane();
    private BorderLayout borderLayout4 = new BorderLayout();
    private BorderLayout borderLayout5 = new BorderLayout();
    private ChannelListModel _channelModel = null;
    private JList listChannels = new JList();
    private Action exitAction = new Action(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (BlogReader.this.xf != null) {
                BlogReader.this.xf.dispose();
            }
            BlogReader.this.xf = null;
            BlogReader.this.jd = null;
            if (BlogReader.this.parent != null) {
                BlogReader.this.parent.showNews(false);
            }
        }

        @Override
        public void setEnabled(boolean arg0) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener arg0) {
        }

        @Override
        public void putValue(String arg0, Object arg1) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public Object getValue(String arg0) {
            return null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener arg0) {
        }
    };
    private JFrame xf = null;
    private JalviewDialog jd = null;
    private JLabel lblChannels = new JLabel();
    private List _updatableActions = new ArrayList();
    private ItemReadTimer _itemTimer = null;
    private JPopupMenu _popupItems = null;
    private JPopupMenu _popupChannels = null;
    private String lastm = "";
    private boolean newsnew = false;
    private Desktop parent = null;
    private boolean updating = false;
    Date lastDate = null;

    private JalviewDialog createDialog() {
        this.jd = new JalviewDialog(){

            @Override
            protected void raiseClosed() {
                if (BlogReader.this.parent != null) {
                    Cache.log.debug((Object)"News window closed.");
                    BlogReader.this.jd = null;
                    BlogReader.this.parent.showNews(false);
                }
            }

            @Override
            protected void okPressed() {
            }

            @Override
            protected void cancelPressed() {
            }
        };
        return this.jd;
    }

    BlogReader() {
        this((Desktop)null);
    }

    public BlogReader(Desktop desktop) {
        Cache.log.debug((Object)"Constructing news reader.");
        this.parent = desktop;
        this._channelModel = new ChannelListModel();
        Channel chan = new Channel();
        chan.setURL(Cache.getDefault("JALVIEW_NEWS_RSS", Cache.getDefault("www.jalview.org", "http://www.jalview.org") + "/feeds/desktop/rss"));
        this.loadLastM();
        this._channelModel.addChannel(chan);
        this.updating = true;
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initItems(chan);
        this.updating = false;
        boolean setvisible = this.checkForNew(chan, true);
        if (setvisible) {
            Cache.log.debug((Object)"Will show jalview news automatically");
            this.showNews();
        }
        Cache.log.debug((Object)"Completed construction of reader.");
    }

    @Override
    public boolean isVisible() {
        if (this.parent == null) {
            return this.xf != null && this.xf.isVisible();
        }
        return this.jd != null && this.jd.isVisible();
    }

    public void showNews() {
        final BlogReader me = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle bounds = new Rectangle(5, 5, 550, 350);
                if (BlogReader.this.parent == null) {
                    BlogReader.this.xf = new JFrame();
                    BlogReader.this.xf.setContentPane(me);
                    BlogReader.this.xf.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            ActionEvent actionEvent = new ActionEvent(this, 1001, (String)BlogReader.this.exitAction.getValue("Name"));
                            BlogReader.this.exitAction.actionPerformed(actionEvent);
                        }

                        @Override
                        public void windowOpened(WindowEvent e) {
                        }
                    });
                    me.setSize(new Dimension(550, 350));
                    BlogReader.this.xf.setVisible(true);
                } else {
                    BlogReader.this.createDialog();
                    bounds = new Rectangle(5, 5, 550, 350);
                    BlogReader.this.jd.initDialogFrame(me, false, false, MessageManager.getString("label.news_from_jalview"), bounds.width, bounds.height);
                    BlogReader.this.jd.frame.setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
                    Cache.log.debug((Object)"Displaying news.");
                    BlogReader.this.jd.waitForInput();
                }
            }
        });
    }

    private boolean checkForNew(Channel chan, boolean updateItems) {
        if (!this.updating || updateItems) {
            this.newsnew = false;
        }
        Date earliest = null;
        try {
            earliest = new SimpleDateFormat("YYYY-MM-DD").parse(chan.getHTTPLastModified());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chan != null && chan.getItems() != null) {
            Cache.log.debug((Object)("Scanning news items: newsnew=" + this.newsnew + " and lastDate is " + this.lastDate));
            for (Item i : chan.getItems()) {
                boolean isread;
                Date published = i.getPublishDate();
                boolean bl = this.lastDate == null ? false : (isread = published != null && !this.lastDate.before(published));
                if (!this.updating || updateItems) {
                    this.newsnew |= !isread;
                }
                if (updateItems) {
                    i.setRead(isread);
                }
                if (published == null || i.isRead() || earliest != null && !earliest.after(published)) continue;
                earliest = published;
            }
        }
        if (!updateItems && !this.updating && this.lastDate == null) {
            this.lastDate = earliest;
        }
        return this.newsnew;
    }

    private void loadLastM() {
        this.lastDate = Cache.getDateProperty("JALVIEW_NEWS_RSS_LASTMODIFIED");
    }

    private void saveLastM(Item item) {
        if (item != null) {
            if (item.getPublishDate() != null && (this.lastDate == null || item.getPublishDate().after(this.lastDate))) {
                this.lastDate = item.getPublishDate();
            }
            if (this._channelModel.getElementAt(0) != null) {
                this.checkForNew((Channel)this._channelModel.getElementAt(0), false);
            }
            if (this.lastDate != null) {
                String formatted = Cache.setDateProperty("JALVIEW_NEWS_RSS_LASTMODIFIED", this.lastDate);
                Cache.log.debug((Object)("Saved last read date as " + formatted));
            }
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layoutMain);
        this.panelMain.setLayout(this.borderLayout1);
        this.topPanel.setLayout(this.borderLayout5);
        this.bottomPanel.setLayout(this.borderLayout4);
        this.topBottomSplitPane.setOrientation(0);
        this.topBottomSplitPane.setDividerLocation(100);
        this.topBottomSplitPane.setTopComponent(this.topPanel);
        this.topBottomSplitPane.setBottomComponent(this.bottomPanel);
        JScrollPane spTextDescription = new JScrollPane((Component)this.textDescription);
        this.textDescription.setText("");
        this.statusBar.setText(new StringBuffer("[").append(MessageManager.getString("label.status")).append("]").toString());
        this.buttonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BlogReader.this.refreshNews();
            }
        });
        this.add((Component)this.statusBar, "South");
        this.toolBar.add(this.buttonRefresh);
        this.toolBar.addSeparator();
        JLabel about = new JLabel("brought to you by JSwingReader (jswingreader.sourceforge.net)");
        this.toolBar.add(about);
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        this.panelMain.add((Component)this.topBottomSplitPane, "Center");
        this.add((Component)this.panelMain, "Center");
        JScrollPane spListItems = new JScrollPane(this.listItems);
        this.listItems.setSelectionMode(1);
        this.topPanel.add((Component)spListItems, "Center");
        this.bottomPanel.add((Component)spTextDescription, "Center");
        this.listChannels.setModel(this._channelModel);
        this.listItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BlogReader.this.listItems_mouseClicked(e);
            }
        });
        this._popupItems = this._buildItemsPopupMenu();
        this._popupChannels = this._buildChannelsPopupMenu();
        ContextMenuMouseAdapter popupAdapter = new ContextMenuMouseAdapter(this._popupItems);
        ContextMenuMouseAdapter popupChannelsAdapter = new ContextMenuMouseAdapter(this._popupChannels);
        this.listItems.addMouseListener((MouseListener)popupAdapter);
        this.listItems.setCellRenderer(new ItemsRenderer());
        this.lblChannels.setText(MessageManager.getString("label.channels"));
    }

    private void postInit() {
        for (HyperlinkListener hll : this.textDescription.getHyperlinkListeners()) {
            this.textDescription.removeHyperlinkListener(hll);
        }
        this.textDescription.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Desktop.showUrl(e.getURL().toExternalForm());
                }
            }
        });
        this.listItems.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    BlogReader.this._itemsValueChanged(BlogReader.this.listItems);
                }
            }
        });
        this.listChannels.setSelectedIndex(1);
        this._updateAllActions();
        this._updateToolbarButtons();
        this._itemTimer = new ItemReadTimer(this.listChannels, this.listItems);
        this._itemsValueChanged(this.listItems);
    }

    private JPopupMenu _buildItemsPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(new LaunchJvBrowserOnItem(this.listItems)));
        popup.addSeparator();
        popup.add(new JMenuItem((Action)new MarkItemAsRead(this.listItems)));
        popup.add(new JMenuItem((Action)new MarkItemAsUnread(this.listItems)));
        return popup;
    }

    private JPopupMenu _buildChannelsPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem((Action)new MarkChannelAsRead(this.listChannels, this.listItems)));
        popup.add(new JMenuItem((Action)new MarkChannelAsUnread(this.listChannels, this.listItems)));
        return popup;
    }

    private void initItems(Channel channel) {
        Iterator iter;
        if (channel == null) {
            channel = new Channel();
        }
        if (!channel.isOpen() && channel.getURL() != null) {
            try {
                SimpleRSSParser.parse((Channel)channel);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DefaultListModel itemsModel = (DefaultListModel)this.listItems.getModel();
        itemsModel.clear();
        Iterator iterator = iter = channel.getItems() != null ? channel.getItems().iterator() : Collections.EMPTY_LIST.iterator();
        while (iter.hasNext()) {
            itemsModel.addElement(iter.next());
        }
        if (itemsModel.getSize() > 0) {
            this.listItems.setSelectedIndex(0);
            this._itemsValueChanged(this.listItems);
        }
        this.setStatusBarText(channel.getURL());
        this._updateAllActions();
    }

    private void _itemsValueChanged(JList itemList) {
        Item item = (Item)itemList.getSelectedValue();
        if (item == null) {
            if (itemList.getModel().getSize() > 0) {
                item = (Item)itemList.getModel().getElementAt(0);
            }
            if (item == null) {
                item = new Item();
            } else {
                itemList.setSelectedIndex(0);
            }
        }
        if (this._itemTimer != null) {
            this._itemTimer.setDelay(300);
            this._itemTimer.start();
            this._itemTimer.setLastItem(item);
            final Item lastitem = item;
            this._itemTimer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BlogReader.this.saveLastM(lastitem);
                }
            });
        }
        this.setStatusBarText(item.getLink());
        this.textDescription.setBlogText(item);
        this._updateAllActions();
    }

    public void setStatusBarText(String text) {
        this.statusBar.setText(text);
    }

    private void _updateAllActions() {
        for (UpdatableAction action : this._updatableActions) {
            action.update((Object)this);
        }
    }

    private void _updateToolbarButtons() {
        Map general = (Map)Main.getPreferences().get("general");
        if (general == null) {
            return;
        }
        Component[] components = this.toolBar.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (!(component instanceof JButton)) continue;
            JButton button = (JButton)component;
            if (Boolean.toString(false).equals(general.get("useToolBarText"))) {
                button.setText("");
            }
            if (Boolean.toString(true).equals(general.get("radioTextBelow"))) {
                button.setVerticalTextPosition(3);
                button.setHorizontalTextPosition(0);
                continue;
            }
            if (!Boolean.toString(true).equals(general.get("radioTextRight"))) continue;
            button.setVerticalTextPosition(0);
            button.setHorizontalTextPosition(4);
        }
    }

    private void listItems_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getModifiersEx() == 0) {
            Item item = (Item)this.listItems.getSelectedValue();
            item.setRead(true);
            this.saveLastM(item);
            if (this._itemTimer != null) {
                this._itemTimer.stop();
            }
            LaunchJvBrowserOnItem action = new LaunchJvBrowserOnItem(this.listItems);
            ActionEvent event = new ActionEvent(this, 1001, "LaunchBrowserOnItem");
            action.actionPerformed(event);
        }
    }

    public void refreshNews() {
        try {
            this.initItems((Channel)this._channelModel.getElementAt(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Cache.loadProperties(null);
        Cache.initLogger();
        Calendar today = Calendar.getInstance();
        Calendar lastread = Calendar.getInstance();
        lastread.set(1983, 1, 1);
        while (lastread.before(today)) {
            String formattedDate = Cache.setDateProperty("JALVIEW_NEWS_RSS_LASTMODIFIED", lastread.getTime());
            BlogReader me = new BlogReader();
            System.out.println("Set last date to " + formattedDate);
            if (me.isNewsNew()) {
                Cache.log.debug((Object)"There is news to read.");
            } else {
                Cache.log.debug((Object)"There is no new news.");
                me.xf.setTitle("Testing : Last read is " + me.lastDate);
                me.showNews();
                me.xf.toFront();
            }
            Cache.log.debug((Object)"Waiting for closure.");
            do {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (me.isVisible());
            if (me.isNewsNew()) {
                Cache.log.debug((Object)"Still new news after reader displayed.");
            }
            if (lastread.getTime().before(me.lastDate)) {
                Cache.log.debug((Object)"The news was read.");
                lastread.setTime(me.lastDate);
                continue;
            }
            lastread.add(2, 1);
        }
    }

    boolean isNewsNew() {
        return this.newsnew;
    }

    public class LaunchJvBrowserOnItem
    extends AbstractAction
    implements UpdatableAction {
        JList _listItems;

        public LaunchJvBrowserOnItem(JList listItems) {
            super("Open in Browser");
            this._listItems = null;
            this.putValue("MnemonicKey", 79);
            this.putValue("LongDescription", "Open in Browser");
            this._listItems = listItems;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = this._listItems.getSelectedValue();
            if (o instanceof Item) {
                Item item = (Item)o;
                item.setRead(true);
                this._listItems.repaint();
                Desktop.showUrl(item.getLink());
            }
        }

        public void update(Object o) {
            this.setEnabled(true);
            if (this._listItems == null || this._listItems.getModel().getSize() == 0) {
                this.setEnabled(false);
            } else if (this._listItems.getSelectedIndex() == -1) {
                this.setEnabled(false);
            }
        }
    }
}

