/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import java.awt.Container;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.JInternalFrame;

public class AquaInternalFrameManager
extends DefaultDesktopManager {
    JInternalFrame fCurrentFrame;
    JInternalFrame fInitialFrame;
    Vector<JInternalFrame> fChildFrames = new Vector(1);
    private DesktopManager ourManager;

    public AquaInternalFrameManager(DesktopManager desktopManager) {
        this.ourManager = desktopManager;
    }

    @Override
    public void closeFrame(JInternalFrame f) {
        if (f == this.fCurrentFrame) {
            boolean mostRecentFrame;
            boolean bl = mostRecentFrame = this.fChildFrames.indexOf(f) == this.fChildFrames.size() - 1;
            if (!mostRecentFrame) {
                this.activateNextFrame();
            } else {
                this.activatePreviousFrame();
            }
        }
        this.fChildFrames.removeElement(f);
        super.closeFrame(f);
    }

    @Override
    public void deiconifyFrame(JInternalFrame f) {
        JInternalFrame.JDesktopIcon desktopIcon = f.getDesktopIcon();
        f.reshape(desktopIcon.getX(), desktopIcon.getY(), f.getWidth(), f.getHeight());
        this.ourManager.deiconifyFrame(f);
    }

    void addIcon(Container c, JInternalFrame.JDesktopIcon desktopIcon) {
        c.add(desktopIcon);
    }

    @Override
    public void iconifyFrame(JInternalFrame f) {
        this.ourManager.iconifyFrame(f);
    }

    @Override
    public void activateFrame(JInternalFrame f) {
        try {
            if (f != null) {
                super.activateFrame(f);
            }
            if (this.fChildFrames.indexOf(f) != -1) {
                this.fChildFrames.remove(f);
            }
            this.fChildFrames.addElement(f);
            if (this.fCurrentFrame != null && f != this.fCurrentFrame && this.fCurrentFrame.isSelected()) {
                this.fCurrentFrame.setSelected(false);
            }
            if (f != null && !f.isSelected()) {
                f.setSelected(true);
            }
            this.fCurrentFrame = f;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void switchFrame(boolean next) {
        int nextIndex;
        if (this.fCurrentFrame == null) {
            if (this.fInitialFrame != null) {
                this.activateFrame(this.fInitialFrame);
            }
            return;
        }
        int count = this.fChildFrames.size();
        if (count <= 1) {
            return;
        }
        int currentIndex = this.fChildFrames.indexOf(this.fCurrentFrame);
        if (currentIndex == -1) {
            this.fCurrentFrame = null;
            return;
        }
        if (next) {
            nextIndex = currentIndex + 1;
            if (nextIndex == count) {
                nextIndex = 0;
            }
        } else {
            nextIndex = currentIndex - 1;
            if (nextIndex == -1) {
                nextIndex = count - 1;
            }
        }
        JInternalFrame f = this.fChildFrames.elementAt(nextIndex);
        this.activateFrame(f);
        this.fCurrentFrame = f;
    }

    public void activateNextFrame() {
        this.switchFrame(true);
    }

    public void activateNextFrame(JInternalFrame f) {
        this.fInitialFrame = f;
        this.switchFrame(true);
    }

    public void activatePreviousFrame() {
        this.switchFrame(false);
    }
}

