/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmolBinding;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.BrowserLauncher;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.dbsources.Pdb;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class AppJmol
extends StructureViewerBase {
    private static final int JMOL_LOAD_TIMEOUT = 20000;
    private static final String SPACE = " ";
    private static final String QUOTE = "\"";
    AppJmolBinding jmb;
    JPanel scriptWindow;
    JSplitPane splitPane;
    RenderPanel renderPanel;
    IProgressIndicator progressBar = null;

    public AppJmol(String[] files, String[] ids, SequenceI[][] seqs, AlignmentPanel ap, boolean usetoColour, boolean useToAlign, boolean leaveColouringToJmol, String loadStatus, Rectangle bounds, String viewid) {
        PDBEntry[] pdbentrys = new PDBEntry[files.length];
        for (int i = 0; i < pdbentrys.length; ++i) {
            PDBEntry pdbentry;
            pdbentrys[i] = pdbentry = new PDBEntry(ids[i], null, PDBEntry.Type.PDB, files[i]);
        }
        this.jmb = new AppJmolBinding(this, ap.getStructureSelectionManager(), pdbentrys, seqs, null);
        this.jmb.setLoadingFromArchive(true);
        this.addAlignmentPanel(ap);
        if (useToAlign) {
            this.useAlignmentPanelForSuperposition(ap);
        }
        this.initMenus();
        if (leaveColouringToJmol || !usetoColour) {
            this.jmb.setColourBySequence(false);
            this.seqColour.setSelected(false);
            this.viewerColour.setSelected(true);
        } else if (usetoColour) {
            this.useAlignmentPanelForColourbyseq(ap);
            this.jmb.setColourBySequence(true);
            this.seqColour.setSelected(true);
            this.viewerColour.setSelected(false);
        }
        this.setBounds(bounds);
        this.setViewId(viewid);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                AppJmol.this.closeViewer(false);
            }
        });
        this.initJmol(loadStatus);
    }

    @Override
    protected void initMenus() {
        super.initMenus();
        this.viewerActionMenu.setText(MessageManager.getString("label.jmol"));
        this.viewerColour.setText(MessageManager.getString("label.colour_with_jmol"));
        this.viewerColour.setToolTipText(MessageManager.getString("label.let_jmol_manage_structure_colours"));
    }

    @Override
    protected IProgressIndicator getIProgressIndicator() {
        return this.progressBar;
    }

    public AppJmol(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap) {
        this.progressBar = ap.alignFrame;
        this.openNewJmol(ap, this.alignAddedStructures, new PDBEntry[]{pdbentry}, new SequenceI[][]{seq});
    }

    private void openNewJmol(AlignmentPanel ap, boolean alignAdded, PDBEntry[] pdbentrys, SequenceI[][] seqs) {
        this.progressBar = ap.alignFrame;
        this.jmb = new AppJmolBinding(this, ap.getStructureSelectionManager(), pdbentrys, seqs, null);
        this.addAlignmentPanel(ap);
        this.useAlignmentPanelForColourbyseq(ap);
        this.alignAddedStructures = alignAdded;
        this.useAlignmentPanelForSuperposition(ap);
        this.jmb.setColourBySequence(true);
        this.setSize(400, 400);
        this.initMenus();
        this.addingStructures = false;
        this.worker = new Thread(this);
        this.worker.start();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                AppJmol.this.closeViewer(false);
            }
        });
    }

    public AppJmol(AlignmentPanel ap, boolean alignAdded, PDBEntry[] pe, SequenceI[][] seqs) {
        this.openNewJmol(ap, alignAdded, pe, seqs);
    }

    void initJmol(String command) {
        this.jmb.setFinishedInit(false);
        this.renderPanel = new RenderPanel();
        this.getContentPane().add((Component)this.renderPanel, "Center");
        Desktop.addInternalFrame(this, this.jmb.getViewerTitle(), this.getBounds().width, this.getBounds().height);
        if (this.scriptWindow == null) {
            BorderLayout bl = new BorderLayout();
            bl.setHgap(0);
            bl.setVgap(0);
            this.scriptWindow = new JPanel(bl);
            this.scriptWindow.setVisible(false);
        }
        this.jmb.allocateViewer(this.renderPanel, true, "", null, null, "", this.scriptWindow, null);
        if (command == null) {
            command = "";
        }
        this.jmb.evalStateCommand(command);
        this.jmb.evalStateCommand("set hoverDelay=0.1");
        this.jmb.setFinishedInit(true);
    }

    @Override
    void showSelectedChains() {
        Vector<String> toshow = new Vector<String>();
        for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
            JCheckBoxMenuItem item;
            if (!(this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem) || !(item = (JCheckBoxMenuItem)this.chainMenu.getItem(i)).isSelected()) continue;
            toshow.addElement(item.getText());
        }
        this.jmb.centerViewer(toshow);
    }

    @Override
    public void closeViewer(boolean closeExternalViewer) {
        if (this.jmb != null) {
            this.jmb.closeViewer();
        }
        this.setAlignmentPanel(null);
        this._aps.clear();
        this._alignwith.clear();
        this._colourwith.clear();
        this.jmb = null;
    }

    @Override
    public void run() {
        this._started = true;
        try {
            List<String> files = this.fetchPdbFiles();
            if (files.size() > 0) {
                this.showFilesInViewer(files);
            }
        }
        finally {
            this._started = false;
            this.worker = null;
        }
    }

    void showFilesInViewer(List<String> files) {
        long lastnotify = this.jmb.getLoadNotifiesHandled();
        StringBuilder fileList = new StringBuilder();
        for (String s : files) {
            fileList.append(SPACE).append(QUOTE).append(Platform.escapeBackslashes(s)).append(QUOTE);
        }
        String filesString = fileList.toString();
        if (!this.addingStructures) {
            try {
                this.initJmol("load FILES " + filesString);
            }
            catch (OutOfMemoryError oomerror) {
                new OOMWarning("When trying to open the Jmol viewer!", oomerror);
                Cache.log.debug((Object)("File locations are " + filesString));
            }
            catch (Exception ex) {
                Cache.log.error((Object)"Couldn't open Jmol viewer!", (Throwable)ex);
            }
        } else {
            StringBuilder cmd = new StringBuilder();
            cmd.append("loadingJalviewdata=true\nload APPEND ");
            cmd.append(filesString);
            cmd.append("\nloadingJalviewdata=null");
            String command = cmd.toString();
            lastnotify = this.jmb.getLoadNotifiesHandled();
            try {
                this.jmb.evalStateCommand(command);
            }
            catch (OutOfMemoryError oomerror) {
                new OOMWarning("When trying to add structures to the Jmol viewer!", oomerror);
                Cache.log.debug((Object)("File locations are " + filesString));
            }
            catch (Exception ex) {
                Cache.log.error((Object)"Couldn't add files to Jmol viewer!", (Throwable)ex);
            }
        }
        int waitMax = 20000;
        int waitFor = 35;
        int waitTotal = 0;
        while (this.addingStructures ? lastnotify >= this.jmb.getLoadNotifiesHandled() : !this.jmb.isFinishedInit() || this.jmb.getStructureFiles() == null || this.jmb.getStructureFiles().length != files.size()) {
            try {
                Cache.log.debug((Object)"Waiting around for jmb notify.");
                Thread.sleep(waitFor);
                waitTotal += waitFor;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (waitTotal <= waitMax) continue;
            System.err.println("Timed out waiting for Jmol to load files after " + waitTotal + "ms");
            this.jmb.getStructureFiles();
            break;
        }
        for (AlignmentPanel ap : this._colourwith) {
            this.jmb.updateColours(ap);
        }
        if (this.alignAddedStructures) {
            this.alignAddedStructures();
        }
        this.addingStructures = false;
    }

    void alignAddedStructures() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AppJmol.this.jmb.viewer.isScriptExecuting()) {
                    SwingUtilities.invokeLater(this);
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return;
                }
                AppJmol.this.alignStructs_withAllAlignPanels();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> fetchPdbFiles() {
        StringBuilder errormsgs = new StringBuilder();
        ArrayList<String> files = new ArrayList<String>();
        String pdbid = "";
        try {
            String[] filesInViewer = this.jmb.getStructureFiles();
            Pdb pdbclient = new Pdb();
            for (int pi = 0; pi < this.jmb.getPdbCount(); ++pi) {
                String file = this.jmb.getPdbEntry(pi).getFile();
                if (file == null) {
                    AlignmentI pdbseq = null;
                    pdbid = this.jmb.getPdbEntry(pi).getId();
                    long hdl = (long)pdbid.hashCode() - System.currentTimeMillis();
                    if (this.progressBar != null) {
                        this.progressBar.setProgressBar(MessageManager.formatMessage("status.fetching_pdb", new String[]{pdbid}), hdl);
                    }
                    try {
                        pdbseq = pdbclient.getSequenceRecords(pdbid);
                    }
                    catch (OutOfMemoryError oomerror) {
                        new OOMWarning("Retrieving PDB id " + pdbid, oomerror);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        errormsgs.append("'").append(pdbid).append("'");
                    }
                    finally {
                        if (this.progressBar != null) {
                            this.progressBar.setProgressBar(MessageManager.getString("label.state_completed"), hdl);
                        }
                    }
                    if (pdbseq != null) {
                        file = new File(pdbseq.getSequenceAt(0).getAllPDBEntries().elementAt(0).getFile()).getAbsolutePath();
                        this.jmb.getPdbEntry(pi).setFile(file);
                        files.add(file);
                        continue;
                    }
                    errormsgs.append("'").append(pdbid).append("' ");
                    continue;
                }
                if (filesInViewer != null && filesInViewer.length > 0) {
                    this.addingStructures = true;
                    for (int c = 0; c < filesInViewer.length; ++c) {
                        if (!Platform.pathEquals(filesInViewer[c], file)) continue;
                        file = null;
                        break;
                    }
                }
                if (file == null) continue;
                files.add(file);
            }
        }
        catch (OutOfMemoryError oomerror) {
            new OOMWarning("Retrieving PDB files: " + pdbid, oomerror);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errormsgs.append("When retrieving pdbfiles : current was: '").append(pdbid).append("'");
        }
        if (errormsgs.length() > 0) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.formatMessage("label.pdb_entries_couldnt_be_retrieved", new String[]{errormsgs.toString()}), MessageManager.getString("label.couldnt_load_file"), 0);
        }
        return files;
    }

    @Override
    public void eps_actionPerformed(ActionEvent e) {
        this.makePDBImage(ImageMaker.TYPE.EPS);
    }

    @Override
    public void png_actionPerformed(ActionEvent e) {
        this.makePDBImage(ImageMaker.TYPE.PNG);
    }

    void makePDBImage(ImageMaker.TYPE type) {
        int width = this.getWidth();
        int height = this.getHeight();
        ImageMaker im = type == ImageMaker.TYPE.PNG ? new ImageMaker(this, ImageMaker.TYPE.PNG, "Make PNG image from view", width, height, null, null, null, 0L, false) : (type == ImageMaker.TYPE.EPS ? new ImageMaker(this, ImageMaker.TYPE.EPS, "Make EPS file from view", width, height, null, this.getTitle(), null, 0L, false) : new ImageMaker(this, ImageMaker.TYPE.SVG, "Make SVG file from PCA", width, height, null, this.getTitle(), null, 0L, false));
        if (im.getGraphics() != null) {
            this.jmb.viewer.renderScreenImage((Object)im.getGraphics(), width, height);
            im.writeImage();
        }
    }

    @Override
    public void showHelp_actionPerformed(ActionEvent actionEvent) {
        try {
            BrowserLauncher.openURL("http://jmol.sourceforge.net/docs/JmolUserGuide/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showConsole(boolean showConsole) {
        if (showConsole) {
            if (this.splitPane == null) {
                this.splitPane = new JSplitPane(0);
                this.splitPane.setTopComponent(this.renderPanel);
                this.splitPane.setBottomComponent(this.scriptWindow);
                this.getContentPane().add((Component)this.splitPane, "Center");
                this.splitPane.setDividerLocation(this.getHeight() - 200);
                this.scriptWindow.setVisible(true);
                this.scriptWindow.validate();
                this.splitPane.validate();
            }
        } else {
            if (this.splitPane != null) {
                this.splitPane.setVisible(false);
            }
            this.splitPane = null;
            this.getContentPane().add((Component)this.renderPanel, "Center");
        }
        this.validate();
    }

    @Override
    public AAStructureBindingModel getBinding() {
        return this.jmb;
    }

    @Override
    public String getStateInfo() {
        return this.jmb == null ? null : this.jmb.viewer.getStateInfo();
    }

    @Override
    public StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.JMOL;
    }

    @Override
    protected String getViewerName() {
        return "Jmol";
    }

    class RenderPanel
    extends JPanel {
        final Dimension currentSize = new Dimension();

        RenderPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            this.getSize(this.currentSize);
            if (AppJmol.this.jmb != null && AppJmol.this.jmb.hasFileLoadingError()) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString(MessageManager.getString("label.error_loading_file") + "...", 20, this.currentSize.height / 2);
                StringBuffer sb = new StringBuffer();
                int lines = 0;
                for (int e = 0; e < AppJmol.this.jmb.getPdbCount(); ++e) {
                    sb.append(AppJmol.this.jmb.getPdbEntry(e).getId());
                    if (e < AppJmol.this.jmb.getPdbCount() - 1) {
                        sb.append(",");
                    }
                    if (e != AppJmol.this.jmb.getPdbCount() - 1 && sb.length() <= 20) continue;
                    g.drawString(sb.toString(), 20, this.currentSize.height / 2 - ++lines * g.getFontMetrics().getHeight());
                }
            } else if (AppJmol.this.jmb == null || AppJmol.this.jmb.viewer == null || !AppJmol.this.jmb.isFinishedInit()) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString(MessageManager.getString("label.retrieving_pdb_data"), 20, this.currentSize.height / 2);
            } else {
                AppJmol.this.jmb.viewer.renderScreenImage((Object)g, this.currentSize.width, this.currentSize.height);
            }
        }
    }
}

