/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.pdb;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSRestClient;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PDBFTSRestClient
extends FTSRestClient {
    private static FTSRestClientI instance = null;
    public static final String PDB_SEARCH_ENDPOINT = "https://www.ebi.ac.uk/pdbe/search/pdb/select?";
    private Collection<FTSDataColumnI> allDefaultDisplayedStructureDataColumns;

    protected PDBFTSRestClient() {
    }

    @Override
    public FTSRestResponse executeRequest(FTSRestRequest pdbRestRequest) throws Exception {
        try {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            Client client = Client.create((ClientConfig)clientConfig);
            String wantedFields = this.getDataColumnsFieldsAsCommaDelimitedString(pdbRestRequest.getWantedFields());
            int responseSize = pdbRestRequest.getResponseSize() == 0 ? this.getDefaultResponsePageSize() : pdbRestRequest.getResponseSize();
            int offSet = pdbRestRequest.getOffSet();
            Object sortParam = null;
            sortParam = pdbRestRequest.getFieldToSortBy() == null || pdbRestRequest.getFieldToSortBy().trim().isEmpty() ? "" : (pdbRestRequest.getFieldToSortBy().equalsIgnoreCase("Resolution") ? pdbRestRequest.getFieldToSortBy() + (pdbRestRequest.isAscending() ? " asc" : " desc") : pdbRestRequest.getFieldToSortBy() + (pdbRestRequest.isAscending() ? " desc" : " asc"));
            String facetPivot = pdbRestRequest.getFacetPivot() == null || pdbRestRequest.getFacetPivot().isEmpty() ? "" : pdbRestRequest.getFacetPivot();
            String facetPivotMinCount = String.valueOf(pdbRestRequest.getFacetPivotMinCount());
            String query = pdbRestRequest.getFieldToSearchBy() + pdbRestRequest.getSearchTerm() + (pdbRestRequest.isAllowEmptySeq() ? "" : " AND molecule_sequence:['' TO *]") + (pdbRestRequest.isAllowUnpublishedEntries() ? "" : " AND status:REL");
            WebResource webResource = null;
            webResource = pdbRestRequest.isFacet() ? client.resource(PDB_SEARCH_ENDPOINT).queryParam("wt", "json").queryParam("fl", wantedFields).queryParam("rows", String.valueOf(responseSize)).queryParam("q", query).queryParam("start", String.valueOf(offSet)).queryParam("sort", (String)sortParam).queryParam("facet", "true").queryParam("facet.pivot", facetPivot).queryParam("facet.pivot.mincount", facetPivotMinCount) : client.resource(PDB_SEARCH_ENDPOINT).queryParam("wt", "json").queryParam("fl", wantedFields).queryParam("rows", String.valueOf(responseSize)).queryParam("start", String.valueOf(offSet)).queryParam("q", query).queryParam("sort", (String)sortParam);
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            String responseString = (String)clientResponse.getEntity(String.class);
            int responseStatus = clientResponse.getStatus();
            if (responseStatus != 200) {
                String errorMessage = "";
                if (responseStatus == 400) {
                    errorMessage = PDBFTSRestClient.parseJsonExceptionString(responseString);
                    throw new Exception(errorMessage);
                }
                errorMessage = PDBFTSRestClient.getMessageByHTTPStatusCode(responseStatus, "PDB");
                throw new Exception(errorMessage);
            }
            clientResponse = null;
            client = null;
            return PDBFTSRestClient.parsePDBJsonResponse(responseString, pdbRestRequest);
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg.contains("SocketException")) {
                throw new Exception(MessageManager.getString("exception.unable_to_detect_internet_connection"));
            }
            if (exceptionMsg.contains("UnknownHostException")) {
                throw new Exception(MessageManager.formatMessage("exception.fts_server_unreachable", "PDB Solr"));
            }
            throw e;
        }
    }

    public static String parseJsonExceptionString(String jsonErrorResponse) {
        StringBuilder errorMessage = new StringBuilder("\n============= PDB Rest Client RunTime error =============\n");
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObj = (JSONObject)jsonParser.parse(jsonErrorResponse);
            JSONObject errorResponse = (JSONObject)jsonObj.get((Object)"error");
            JSONObject responseHeader = (JSONObject)jsonObj.get((Object)"responseHeader");
            JSONObject paramsObj = (JSONObject)responseHeader.get((Object)"params");
            String status = responseHeader.get((Object)"status").toString();
            String message = errorResponse.get((Object)"msg").toString();
            String query = paramsObj.get((Object)"q").toString();
            String fl = paramsObj.get((Object)"fl").toString();
            errorMessage.append("Status: ").append(status).append("\n");
            errorMessage.append("Message: ").append(message).append("\n");
            errorMessage.append("query: ").append(query).append("\n");
            errorMessage.append("fl: ").append(fl).append("\n");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return errorMessage.toString();
    }

    public static FTSRestResponse parsePDBJsonResponse(String pdbJsonResponseString, FTSRestRequest pdbRestRequest) {
        FTSRestResponse searchResult = new FTSRestResponse();
        ArrayList<FTSData> result = null;
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObj = (JSONObject)jsonParser.parse(pdbJsonResponseString);
            JSONObject pdbResponse = (JSONObject)jsonObj.get((Object)"response");
            String queryTime = ((JSONObject)jsonObj.get((Object)"responseHeader")).get((Object)"QTime").toString();
            int numFound = Integer.valueOf(pdbResponse.get((Object)"numFound").toString());
            if (numFound > 0) {
                result = new ArrayList<FTSData>();
                JSONArray docs = (JSONArray)pdbResponse.get((Object)"docs");
                for (JSONObject doc : docs) {
                    result.add(PDBFTSRestClient.getFTSData(doc, pdbRestRequest));
                }
                searchResult.setNumberOfItemsFound(numFound);
                searchResult.setResponseTime(queryTime);
                searchResult.setSearchSummary(result);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return searchResult;
    }

    public static FTSData getFTSData(JSONObject pdbJsonDoc, FTSRestRequest request) {
        String primaryKey = null;
        Collection<FTSDataColumnI> diplayFields = request.getWantedFields();
        SequenceI associatedSeq = request.getAssociatedSequence();
        int colCounter = 0;
        Object[] summaryRowData = new Object[associatedSeq != null ? diplayFields.size() + 1 : diplayFields.size()];
        if (associatedSeq != null) {
            SequenceI associatedSequence = associatedSeq;
            summaryRowData[0] = associatedSequence;
            colCounter = 1;
        }
        for (FTSDataColumnI field : diplayFields) {
            String fieldData;
            String string = fieldData = pdbJsonDoc.get((Object)field.getCode()) == null ? "" : pdbJsonDoc.get((Object)field.getCode()).toString();
            if (field.isPrimaryKeyColumn()) {
                primaryKey = fieldData;
                summaryRowData[colCounter++] = primaryKey;
                continue;
            }
            if (fieldData == null || fieldData.isEmpty()) {
                summaryRowData[colCounter++] = null;
                continue;
            }
            try {
                summaryRowData[colCounter++] = field.getDataType().getDataTypeClass() == Integer.class ? Integer.valueOf(fieldData) : (field.getDataType().getDataTypeClass() == Double.class ? Double.valueOf(fieldData) : PDBFTSRestClient.sanitiseData(fieldData));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("offending value:" + fieldData);
            }
        }
        final String primaryKey1 = primaryKey;
        final Object[] summaryRowData1 = summaryRowData;
        return new FTSData(){

            @Override
            public Object[] getSummaryData() {
                return summaryRowData1;
            }

            @Override
            public Object getPrimaryKey() {
                return primaryKey1;
            }

            public String toString() {
                StringBuilder summaryFieldValues = new StringBuilder();
                for (Object summaryField : summaryRowData1) {
                    summaryFieldValues.append(summaryField == null ? " " : summaryField.toString()).append("\t");
                }
                return summaryFieldValues.toString();
            }

            public int hashCode() {
                return Objects.hash(primaryKey1, this.toString());
            }

            public boolean equals(Object that) {
                return this.toString().equals(that.toString());
            }
        };
    }

    private static String sanitiseData(String data) {
        String cleanData = data.replaceAll("\\[\"", "").replaceAll("\\]\"", "").replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\",\"", ", ").replaceAll("\"", "");
        return cleanData;
    }

    @Override
    public String getColumnDataConfigFileName() {
        return "/fts/pdb_data_columns.txt";
    }

    public static FTSRestClientI getInstance() {
        if (instance == null) {
            instance = new PDBFTSRestClient();
        }
        return instance;
    }

    public Collection<FTSDataColumnI> getAllDefaultDisplayedStructureDataColumns() {
        if (this.allDefaultDisplayedStructureDataColumns == null || this.allDefaultDisplayedStructureDataColumns.isEmpty()) {
            this.allDefaultDisplayedStructureDataColumns = new ArrayList<FTSDataColumnI>();
            this.allDefaultDisplayedStructureDataColumns.addAll(super.getAllDefaultDisplayedFTSDataColumns());
        }
        return this.allDefaultDisplayedStructureDataColumns;
    }
}

