/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.so;

import jalview.io.gff.SequenceOntologyI;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.biojava.nbio.ontology.Ontology;
import org.biojava.nbio.ontology.Term;
import org.biojava.nbio.ontology.Triple;
import org.biojava.nbio.ontology.io.OboParser;
import org.biojava.nbio.ontology.utils.Annotation;

public class SequenceOntology
implements SequenceOntologyI {
    private Ontology ontology;
    private Term isA;
    private Map<String, Term> termsByDescription;
    private Map<Term, List<Term>> termIsA;
    private List<String> termsFound = new ArrayList<String>();
    private List<String> termsNotFound = new ArrayList<String>();

    public SequenceOntology() {
        this.termsByDescription = new HashMap<String, Term>();
        this.termIsA = new HashMap<Term, List<Term>>();
        this.loadOntologyZipFile("so-xp-simple.obo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadOntologyZipFile(String ontologyFile) {
        long now = System.currentTimeMillis();
        ZipInputStream zipStream = null;
        try {
            ZipEntry entry;
            String zipFile = ontologyFile + ".zip";
            InputStream inStream = this.getClass().getResourceAsStream("/" + zipFile);
            zipStream = new ZipInputStream(new BufferedInputStream(inStream));
            while ((entry = zipStream.getNextEntry()) != null) {
                if (!entry.getName().equals(ontologyFile)) continue;
                this.loadOboFile(zipStream);
            }
            long elapsed = System.currentTimeMillis() - now;
            System.out.println("Loaded Sequence Ontology from " + zipFile + " (" + elapsed + "ms)");
            this.closeStream(zipStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.closeStream(zipStream);
        }
    }

    protected void closeStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void loadOboFile(InputStream is) throws ParseException, IOException {
        BufferedReader oboFile = new BufferedReader(new InputStreamReader(is));
        OboParser parser = new OboParser();
        this.ontology = parser.parseOBO(oboFile, "SO", "the SO ontology");
        this.isA = this.ontology.getTerm("is_a");
        this.storeTermNames();
    }

    protected void storeTermNames() {
        for (Term term : this.ontology.getTerms()) {
            String description;
            if (!(term instanceof Term.Impl) || (description = term.getDescription()) == null) continue;
            Term replaced = this.termsByDescription.get(description);
            if (replaced != null) {
                boolean newTermIsObsolete = SequenceOntology.isObsolete(term);
                boolean oldTermIsObsolete = SequenceOntology.isObsolete(replaced);
                if (newTermIsObsolete && !oldTermIsObsolete) {
                    System.err.println("Ignoring " + term.getName() + " as obsolete and duplicated by " + replaced.getName());
                    term = replaced;
                } else if (!newTermIsObsolete && oldTermIsObsolete) {
                    System.err.println("Ignoring " + replaced.getName() + " as obsolete and duplicated by " + term.getName());
                } else {
                    System.err.println("Warning: " + term.getName() + " has replaced " + replaced.getName() + " for lookup of '" + description + "'");
                }
            }
            this.termsByDescription.put(description, term);
        }
    }

    public static boolean isObsolete(Term term) {
        Annotation ann = term.getAnnotation();
        if (ann != null) {
            try {
                if (Boolean.TRUE.equals(ann.getProperty((Object)"is_obsolete"))) {
                    return true;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isNucleotideMatch(String soTerm) {
        return this.isA(soTerm, "nucleotide_match");
    }

    public boolean isProteinMatch(String soTerm) {
        return this.isA(soTerm, "protein_match");
    }

    public boolean isPolypeptide(String soTerm) {
        return this.isA(soTerm, "polypeptide");
    }

    @Override
    public boolean isA(String child, String parent) {
        if (child == null || parent == null) {
            return false;
        }
        if (child.equals(parent)) {
            this.termFound(child);
            return true;
        }
        Term childTerm = this.getTerm(child);
        if (childTerm != null) {
            this.termFound(child);
        } else {
            this.termNotFound(child);
        }
        Term parentTerm = this.getTerm(parent);
        return this.termIsA(childTerm, parentTerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void termFound(String term) {
        List<String> list = this.termsFound;
        synchronized (list) {
            if (!this.termsFound.contains(term)) {
                this.termsFound.add(term);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void termNotFound(String term) {
        List<String> list = this.termsNotFound;
        synchronized (list) {
            if (!this.termsNotFound.contains(term)) {
                System.err.println("SO term " + term + " invalid");
                this.termsNotFound.add(term);
            }
        }
    }

    protected synchronized boolean termIsA(Term childTerm, Term parentTerm) {
        if (childTerm == null || parentTerm == null) {
            return false;
        }
        if (childTerm == parentTerm) {
            return true;
        }
        if (!this.termIsA.containsKey(childTerm)) {
            this.findParents(childTerm);
        }
        List<Term> parents = this.termIsA.get(childTerm);
        for (Term parent : parents) {
            if (!this.termIsA(parent, parentTerm)) continue;
            if (!parents.contains(parentTerm)) {
                parents.add(parentTerm);
            }
            return true;
        }
        return false;
    }

    protected synchronized void findParents(Term childTerm) {
        ArrayList<Term> result = new ArrayList<Term>();
        for (Triple triple : this.ontology.getTriples(childTerm, null, this.isA)) {
            Term parent = triple.getObject();
            result.add(parent);
            this.findParents(parent);
        }
        this.termIsA.put(childTerm, result);
    }

    protected Term getTerm(String nameOrDescription) {
        Term t = this.termsByDescription.get(nameOrDescription);
        if (t == null) {
            try {
                t = this.ontology.getTerm(nameOrDescription);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return t;
    }

    public boolean isSequenceVariant(String soTerm) {
        return this.isA(soTerm, "sequence_variant");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> termsFound() {
        List<String> list = this.termsFound;
        synchronized (list) {
            Collections.sort(this.termsFound, String.CASE_INSENSITIVE_ORDER);
            return this.termsFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> termsNotFound() {
        List<String> list = this.termsNotFound;
        synchronized (list) {
            Collections.sort(this.termsNotFound, String.CASE_INSENSITIVE_ORDER);
            return this.termsNotFound;
        }
    }
}

