/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.jmol;

import MCview.PDBChain;
import MCview.Residue;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StructureFile;
import jalview.schemes.ResidueProperties;
import jalview.util.Format;
import jalview.util.MessageManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.c.CBK;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

public class JmolParser
extends StructureFile
implements JmolStatusListener {
    Viewer viewer = null;
    String lastConsoleEcho = "";
    String lastConsoleMessage = "";
    int lastScriptTermination = -1;
    String lastScriptMessage = "";

    public JmolParser(boolean immediate, String inFile, DataSourceType sourceType) throws IOException {
        super(immediate, inFile, sourceType);
    }

    public JmolParser(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public JmolParser(FileParse fp) throws IOException {
        super(fp);
    }

    public JmolParser() {
    }

    @Override
    public void parse() throws IOException {
        this.setChains(new Vector<PDBChain>());
        Viewer jmolModel = this.getJmolData();
        jmolModel.openReader(this.getDataName(), this.getDataName(), (Object)this.getReader());
        this.waitForScript(jmolModel);
        if (jmolModel.ms.mc > 0) {
            this.setStructureFileType(this.getDataName().toLowerCase().endsWith(".cif") ? PDBEntry.Type.MMCIF.toString() : "PDB");
            this.transformJmolModelToJalview(jmolModel.ms);
        }
    }

    private Viewer getJmolData() {
        if (this.viewer == null) {
            try {
                this.viewer = (Viewer)JmolViewer.allocateViewer(null, null, null, null, null, (String)"-x -o -n", (JmolStatusListener)this);
                this.viewer.setBooleanProperty("defaultStructureDSSP", true);
            }
            catch (ClassCastException x) {
                throw new Error(MessageManager.formatMessage("error.jmol_version_not_compatible_with_jalview_version", new String[]{JmolViewer.getJmolVersion()}), x);
            }
        }
        return this.viewer;
    }

    public void transformJmolModelToJalview(ModelSet ms) throws IOException {
        try {
            String lastID = "";
            ArrayList<SequenceI> rna = new ArrayList<SequenceI>();
            ArrayList<SequenceI> prot = new ArrayList<SequenceI>();
            String pdbId = (String)ms.getInfo(0, "title");
            if (pdbId == null) {
                this.setId(this.safeName(this.getDataName()));
                this.setPDBIdAvailable(false);
            } else {
                this.setId(pdbId);
                this.setPDBIdAvailable(true);
            }
            List<MCview.Atom> significantAtoms = this.convertSignificantAtoms(ms);
            for (MCview.Atom tmpatom : significantAtoms) {
                PDBChain tmpchain;
                try {
                    tmpchain = this.findChain(tmpatom.chain);
                    if (tmpatom.resNumIns.trim().equals(lastID)) continue;
                    tmpchain.atoms.addElement(tmpatom);
                }
                catch (Exception e) {
                    tmpchain = new PDBChain(this.getId(), tmpatom.chain);
                    this.getChains().add(tmpchain);
                    tmpchain.atoms.addElement(tmpatom);
                }
                lastID = tmpatom.resNumIns.trim();
            }
            if (this.isParseImmediately()) {
                this.xferSettings();
            }
            this.makeResidueList();
            this.makeCaBondList();
            for (PDBChain chain : this.getChains()) {
                SequenceI chainseq = this.postProcessChain(chain);
                if (JmolParser.isRNA(chainseq)) {
                    rna.add(chainseq);
                } else {
                    prot.add(chainseq);
                }
                if (!this.predictSecondaryStructure) continue;
                this.createAnnotation(chainseq, chain, ms.at);
            }
        }
        catch (OutOfMemoryError er) {
            System.out.println("OUT OF MEMORY LOADING TRANSFORMING JMOL MODEL TO JALVIEW MODEL");
            throw new IOException(MessageManager.getString("exception.outofmemory_loading_mmcif_file"));
        }
    }

    private List<MCview.Atom> convertSignificantAtoms(ModelSet ms) {
        ArrayList<MCview.Atom> significantAtoms = new ArrayList<MCview.Atom>();
        HashMap<String, Atom> chainTerMap = new HashMap<String, Atom>();
        Atom prevAtom = null;
        for (Atom atom : ms.at) {
            if (!atom.getAtomName().equalsIgnoreCase("CA") && !atom.getAtomName().equalsIgnoreCase("P") || !this.atomValidated(atom, prevAtom, chainTerMap)) continue;
            MCview.Atom curAtom = new MCview.Atom(atom.x, atom.y, atom.z);
            curAtom.atomIndex = atom.getIndex();
            curAtom.chain = atom.getChainIDStr();
            curAtom.insCode = (char)(atom.group.getInsertionCode() == '\u0000' ? 32 : (int)atom.group.getInsertionCode());
            curAtom.name = atom.getAtomName();
            curAtom.number = atom.getAtomNumber();
            curAtom.resName = atom.getGroup3(true);
            curAtom.resNumber = atom.getResno();
            curAtom.occupancy = ms.occupancies != null ? ms.occupancies[atom.getIndex()] : Float.valueOf(atom.getOccupancy100()).floatValue();
            String fmt = new Format("%4i").form(curAtom.resNumber);
            curAtom.resNumIns = fmt + curAtom.insCode;
            curAtom.tfactor = (float)atom.getBfactor100() / 100.0f;
            curAtom.type = 0;
            if (!significantAtoms.contains(curAtom)) {
                significantAtoms.add(curAtom);
            }
            prevAtom = atom;
        }
        return significantAtoms;
    }

    private boolean atomValidated(Atom curAtom, Atom prevAtom, HashMap<String, Atom> chainTerMap) {
        if (chainTerMap == null || prevAtom == null) {
            return true;
        }
        String curAtomChId = curAtom.getChainIDStr();
        String prevAtomChId = prevAtom.getChainIDStr();
        if (!prevAtomChId.equals(curAtomChId)) {
            if (!chainTerMap.containsKey(prevAtomChId)) {
                chainTerMap.put(prevAtomChId, prevAtom);
            }
            if (chainTerMap.containsKey(curAtomChId)) {
                if (curAtom.getResno() < chainTerMap.get(curAtomChId).getResno()) {
                    return false;
                }
                if (curAtom.getResno() - chainTerMap.get(curAtomChId).getResno() < 5) {
                    chainTerMap.put(curAtomChId, curAtom);
                    return true;
                }
                return false;
            }
        } else if (chainTerMap.containsKey(curAtomChId)) {
            if (curAtom.getResno() < chainTerMap.get(curAtomChId).getResno()) {
                return false;
            }
            if (curAtom.getResno() - chainTerMap.get(curAtomChId).getResno() < 5) {
                chainTerMap.put(curAtomChId, curAtom);
                return true;
            }
            return false;
        }
        return !curAtom.isHetero() || curAtom.getResno() - prevAtom.getResno() <= 2;
    }

    private void createAnnotation(SequenceI sequence, PDBChain chain, Atom[] jmolAtoms) {
        char[] secstr = new char[sequence.getLength()];
        char[] secstrcode = new char[sequence.getLength()];
        if (chain.residues.size() != sequence.getLength()) {
            return;
        }
        int annotIndex = 0;
        for (Residue residue : chain.residues) {
            MCview.Atom repAtom = residue.getAtoms().get(0);
            STR proteinStructureSubType = jmolAtoms[repAtom.atomIndex].group.getProteinStructureSubType();
            this.setSecondaryStructure(proteinStructureSubType, annotIndex, secstr, secstrcode);
            ++annotIndex;
        }
        this.addSecondaryStructureAnnotation(chain.pdbid, sequence, secstr, secstrcode, chain.id, sequence.getStart());
    }

    protected void addSecondaryStructureAnnotation(String modelTitle, SequenceI sq, char[] secstr, char[] secstrcode, String chainId, int firstResNum) {
        int length = sq.getLength();
        boolean ssFound = false;
        Annotation[] asecstr = new Annotation[length + firstResNum - 1];
        for (int p = 0; p < length; ++p) {
            if (secstr[p] < 'A' || secstr[p] > 'z') continue;
            try {
                asecstr[p] = new Annotation(String.valueOf(secstr[p]), null, secstrcode[p], Float.NaN);
                ssFound = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ssFound) {
            Object mt = modelTitle == null ? this.getDataName() : modelTitle;
            mt = (String)mt + chainId;
            AlignmentAnnotation ann = new AlignmentAnnotation("Secondary Structure", "Secondary Structure for " + (String)mt, asecstr);
            ann.belowAlignment = true;
            ann.visible = true;
            ann.autoCalculated = false;
            ann.setCalcId(this.getClass().getName());
            ann.adjustForAlignment();
            ann.validateRangeAndDisplay();
            this.annotations.add(ann);
            sq.addAlignmentAnnotation(ann);
        }
    }

    private void waitForScript(Viewer jmd) {
        while (jmd.isScriptExecuting()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void setSecondaryStructure(STR proteinStructureSubType, int pos, char[] secstr, char[] secstrcode) {
        switch (proteinStructureSubType) {
            case HELIX310: {
                secstr[pos] = 51;
                break;
            }
            case HELIX: 
            case HELIXALPHA: {
                secstr[pos] = 72;
                break;
            }
            case HELIXPI: {
                secstr[pos] = 80;
                break;
            }
            case SHEET: {
                secstr[pos] = 69;
                break;
            }
            default: {
                secstr[pos] = '\u0000';
            }
        }
        switch (proteinStructureSubType) {
            case HELIX310: 
            case HELIX: 
            case HELIXALPHA: 
            case HELIXPI: {
                secstrcode[pos] = 72;
                break;
            }
            case SHEET: {
                secstrcode[pos] = 69;
                break;
            }
            default: {
                secstrcode[pos] = '\u0000';
            }
        }
    }

    protected void replaceNonCanonicalResidue(String threeLetterCode, char[] seq, int pos) {
        String canonical = ResidueProperties.getCanonicalAminoAcid(threeLetterCode);
        if (canonical != null && !canonical.equalsIgnoreCase(threeLetterCode)) {
            seq[pos] = ResidueProperties.getSingleCharacterCode(canonical);
        }
    }

    @Override
    public String print(SequenceI[] seqs, boolean jvSuffix) {
        return null;
    }

    public void setCallbackFunction(String callbackType, String callbackFunction) {
    }

    public void notifyCallback(CBK cbType, Object[] data) {
        String strInfo = data == null || data[1] == null ? null : data[1].toString();
        switch (cbType) {
            case ECHO: {
                this.sendConsoleEcho(strInfo);
                break;
            }
            case SCRIPT: {
                this.notifyScriptTermination((String)data[2], (Integer)data[3]);
                break;
            }
            case MEASURE: {
                String mystatus = (String)data[3];
                if (mystatus.indexOf("Picked") >= 0 || mystatus.indexOf("Sequence") >= 0) {
                    this.sendConsoleMessage(strInfo);
                    break;
                }
                if (mystatus.indexOf("Completed") < 0) break;
                this.sendConsoleEcho(strInfo.substring(strInfo.lastIndexOf(",") + 2, strInfo.length() - 1));
                break;
            }
            case MESSAGE: {
                this.sendConsoleMessage(data == null ? null : strInfo);
                break;
            }
            case PICK: {
                this.sendConsoleMessage(strInfo);
                break;
            }
        }
    }

    private void sendConsoleEcho(String string) {
        this.lastConsoleEcho = this.lastConsoleEcho + string;
        this.lastConsoleEcho = this.lastConsoleEcho + "\n";
    }

    private void sendConsoleMessage(String string) {
        this.lastConsoleMessage = this.lastConsoleMessage + string;
        this.lastConsoleMessage = this.lastConsoleMessage + "\n";
    }

    private void notifyScriptTermination(String string, int intValue) {
        this.lastScriptMessage = this.lastScriptMessage + string;
        this.lastScriptMessage = this.lastScriptMessage + "\n";
        this.lastScriptTermination = intValue;
    }

    public boolean notifyEnabled(CBK callbackPick) {
        switch (callbackPick) {
            case ECHO: 
            case SCRIPT: 
            case MESSAGE: 
            case LOADSTRUCT: 
            case ERROR: {
                return true;
            }
        }
        return false;
    }

    public String eval(String strEval) {
        return null;
    }

    public float[][] functionXY(String functionName, int x, int y) {
        return null;
    }

    public float[][][] functionXYZ(String functionName, int nx, int ny, int nz) {
        return null;
    }

    public String createImage(String fileName, String imageType, Object text_or_bytes, int quality) {
        return null;
    }

    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    public void showUrl(String url) {
    }

    public int[] resizeInnerPanel(String data) {
        return null;
    }

    public Map<String, Object> getJSpecViewProperty(String arg0) {
        return null;
    }

    public boolean isPredictSecondaryStructure() {
        return this.predictSecondaryStructure;
    }

    public void setPredictSecondaryStructure(boolean predictSecondaryStructure) {
        this.predictSecondaryStructure = predictSecondaryStructure;
    }

    public boolean isVisibleChainAnnotation() {
        return this.visibleChainAnnotation;
    }

    public void setVisibleChainAnnotation(boolean visibleChainAnnotation) {
        this.visibleChainAnnotation = visibleChainAnnotation;
    }
}

