/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.jmol;

import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JmolCommands;
import jalview.gui.IProgressIndicator;
import jalview.io.DataSourceType;
import jalview.io.StructureFile;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.structure.AtomSpec;
import jalview.structure.StructureMappingcommandSet;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.MessageManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.c.CBK;
import org.jmol.viewer.Viewer;

public abstract class JalviewJmolBinding
extends AAStructureBindingModel
implements JmolStatusListener,
JmolSelectionListener,
ComponentListener {
    private String lastMessage;
    boolean allChainsSelected = false;
    private boolean associateNewStructs = false;
    Vector<String> atomsPicked = new Vector();
    private List<String> chainNames;
    Hashtable<String, String> chainFile;
    int frameNo = 0;
    String lastCommand;
    boolean loadedInline;
    StringBuffer resetLastRes = new StringBuffer();
    public Viewer viewer;
    Thread colourby = null;
    private int[] _modelFileNameMap;
    boolean debug = true;
    private long loadNotifiesHandled = 0L;
    protected JmolAppConsoleInterface console = null;

    public JalviewJmolBinding(StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(ssm, pdbentry, sequenceIs, protocol);
    }

    public JalviewJmolBinding(StructureSelectionManager ssm, SequenceI[][] seqs, Viewer theViewer) {
        super(ssm, seqs);
        this.viewer = theViewer;
        this.viewer.setJmolStatusListener((JmolStatusListener)this);
        this.viewer.addSelectionListener((JmolSelectionListener)this);
    }

    public String getViewerTitle() {
        return this.getViewerTitle("Jmol", true);
    }

    public void centerViewer(Vector<String> chainList) {
        StringBuilder cmd = new StringBuilder(128);
        for (String lbl : chainList) {
            int p;
            int mlength = 0;
            while ((p = mlength) < (mlength = lbl.indexOf(":", p)) && mlength < lbl.length() - 2) {
            }
            cmd.append(":" + lbl.substring(mlength + 1) + " /" + (1 + this.getModelNum(this.chainFile.get(lbl))) + " or ");
        }
        if (cmd.length() > 0) {
            cmd.setLength(cmd.length() - 4);
        }
        this.evalStateCommand("select *;restrict " + cmd + ";cartoon;center " + cmd);
    }

    public void closeViewer() {
        this.getSsm().removeStructureViewerListener(this, this.getStructureFiles());
        this.viewer.dispose();
        this.lastCommand = null;
        this.viewer = null;
        this.releaseUIResources();
    }

    @Override
    public void colourByChain() {
        this.colourBySequence = false;
        this.evalStateCommand("select *;color chain");
    }

    @Override
    public void colourByCharge() {
        this.colourBySequence = false;
        this.evalStateCommand("select *;color white;select ASP,GLU;color red;select LYS,ARG;color blue;select CYS;color yellow");
    }

    public void superposeStructures(AlignmentI alignment) {
        this.superposeStructures(alignment, -1, null);
    }

    public void superposeStructures(AlignmentI alignment, int refStructure) {
        this.superposeStructures(alignment, refStructure, null);
    }

    public void superposeStructures(AlignmentI alignment, int refStructure, HiddenColumns hiddenCols) {
        this.superposeStructures(new AlignmentI[]{alignment}, new int[]{refStructure}, new HiddenColumns[]{hiddenCols});
    }

    @Override
    public String superposeStructures(AlignmentI[] _alignment, int[] _refStructure, HiddenColumns[] _hiddenCols) {
        while (this.viewer.isScriptExecuting()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String[] files = this.getStructureFiles();
        if (!this.waitForFileLoad(files)) {
            return null;
        }
        StringBuilder selectioncom = new StringBuilder(256);
        Object nSeconds = " ";
        nSeconds = files.length > 10 ? " 0.005 " : " " + 2.0 / (double)files.length + " ";
        for (int a = 0; a < _alignment.length; ++a) {
            int refStructure = _refStructure[a];
            AlignmentI alignment = _alignment[a];
            HiddenColumns hiddenCols = _hiddenCols[a];
            if (a > 0 && selectioncom.length() > 0 && !selectioncom.substring(selectioncom.length() - 1).equals("|")) {
                selectioncom.append("|");
            }
            if (refStructure >= files.length) {
                System.err.println("Invalid reference structure value " + refStructure);
                refStructure = -1;
            }
            BitSet matched = new BitSet();
            for (int m = 0; m < alignment.getWidth(); ++m) {
                if (hiddenCols != null && !hiddenCols.isVisible(m)) continue;
                matched.set(m);
            }
            AAStructureBindingModel.SuperposeData[] structures = new AAStructureBindingModel.SuperposeData[files.length];
            for (int f = 0; f < files.length; ++f) {
                structures[f] = new AAStructureBindingModel.SuperposeData(this, alignment.getWidth());
            }
            int candidateRefStructure = this.findSuperposableResidues(alignment, matched, structures);
            if (refStructure < 0) {
                refStructure = candidateRefStructure;
            }
            String[] selcom = new String[files.length];
            int nmatched = matched.cardinality();
            if (nmatched < 4) {
                return MessageManager.formatMessage("label.insufficient_residues", nmatched);
            }
            for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
                String chainCd = ":" + structures[pdbfnum].chain;
                int lpos = -1;
                boolean run = false;
                StringBuilder molsel = new StringBuilder();
                molsel.append("{");
                int nextColumnMatch = matched.nextSetBit(0);
                while (nextColumnMatch != -1) {
                    int pdbResNo = structures[pdbfnum].pdbResNo[nextColumnMatch];
                    if (lpos != pdbResNo - 1) {
                        if (lpos != -1) {
                            molsel.append(lpos);
                            molsel.append(chainCd);
                            molsel.append("|");
                        }
                        run = false;
                    } else {
                        if (!run) {
                            molsel.append(lpos);
                            molsel.append("-");
                        }
                        run = true;
                    }
                    lpos = pdbResNo;
                    nextColumnMatch = matched.nextSetBit(nextColumnMatch + 1);
                }
                if (lpos != -1) {
                    molsel.append(lpos);
                    molsel.append(chainCd);
                    molsel.append("}");
                }
                if (molsel.length() > 1) {
                    selcom[pdbfnum] = molsel.toString();
                    selectioncom.append("((");
                    selectioncom.append(selcom[pdbfnum].substring(1, selcom[pdbfnum].length() - 1));
                    selectioncom.append(" )& ");
                    selectioncom.append(pdbfnum + 1);
                    selectioncom.append(".1)");
                    if (pdbfnum >= files.length - 1) continue;
                    selectioncom.append("|");
                    continue;
                }
                selcom[pdbfnum] = null;
            }
            StringBuilder command = new StringBuilder(256);
            for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
                if (pdbfnum == refStructure || selcom[pdbfnum] == null || selcom[refStructure] == null) continue;
                command.append("echo ");
                command.append("\"Superposing (");
                command.append(structures[pdbfnum].pdbId);
                command.append(") against reference (");
                command.append(structures[refStructure].pdbId);
                command.append(")\";\ncompare " + (String)nSeconds);
                command.append("{");
                command.append(Integer.toString(1 + pdbfnum));
                command.append(".1} {");
                command.append(Integer.toString(1 + refStructure));
                command.append(".1} SUBSET {(*.CA | *.P) and conformation=1} ATOMS ");
                command.append(selcom[pdbfnum]);
                command.append(selcom[refStructure]);
                command.append(" ROTATE TRANSLATE;\n");
            }
            if (selectioncom.length() <= 0) continue;
            this.evalStateCommand("select *; cartoons off; backbone; select (" + selectioncom.toString() + "); cartoons; ");
            String cmdString = command.toString();
            this.evalStateCommand(cmdString);
        }
        if (selectioncom.length() > 0) {
            if (selectioncom.substring(selectioncom.length() - 1).equals("|")) {
                selectioncom.setLength(selectioncom.length() - 1);
            }
            this.evalStateCommand("select *; cartoons off; backbone; select (" + selectioncom.toString() + "); cartoons; ");
        }
        return null;
    }

    public void evalStateCommand(String command) {
        this.jmolHistory(false);
        if (this.lastCommand == null || !this.lastCommand.equals(command)) {
            this.viewer.evalStringQuiet(command + "\n");
        }
        this.jmolHistory(true);
        this.lastCommand = command;
    }

    @Override
    protected void colourBySequence(final StructureMappingcommandSet[] colourBySequenceCommands) {
        if (this.colourby != null) {
            this.colourby.interrupt();
            this.colourby = null;
        }
        this.colourby = new Thread(new Runnable(){

            @Override
            public void run() {
                for (StructureMappingcommandSet cpdbbyseq : colourBySequenceCommands) {
                    for (String cbyseq : cpdbbyseq.commands) {
                        JalviewJmolBinding.this.executeWhenReady(cbyseq);
                    }
                }
            }
        });
        this.colourby.start();
    }

    @Override
    protected StructureMappingcommandSet[] getColourBySequenceCommands(String[] files, SequenceRenderer sr, AlignmentViewPanel viewPanel) {
        return JmolCommands.getColourBySequenceCommand(this.getSsm(), files, this.getSequence(), sr, viewPanel);
    }

    protected void executeWhenReady(String command) {
        this.evalStateCommand(command);
    }

    public void createImage(String file, String type, int quality) {
        System.out.println("JMOL CREATE IMAGE");
    }

    public String createImage(String fileName, String type, Object textOrBytes, int quality) {
        System.out.println("JMOL CREATE IMAGE");
        return null;
    }

    public String eval(String strEval) {
        return null;
    }

    public float[][] functionXY(String functionName, int x, int y) {
        return null;
    }

    public float[][][] functionXYZ(String functionName, int nx, int ny, int nz) {
        return null;
    }

    public Color getColour(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        if (this.getModelNum(pdbfile) < 0) {
            return null;
        }
        int colour = this.viewer.ms.at[atomIndex].atomPropertyInt(1765808134);
        return new Color(colour);
    }

    public abstract void refreshPdbEntries();

    private int getModelNum(String modelFileName) {
        String[] mfn = this.getStructureFiles();
        if (mfn == null) {
            return -1;
        }
        for (int i = 0; i < mfn.length; ++i) {
            if (!mfn[i].equalsIgnoreCase(modelFileName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized String[] getStructureFiles() {
        ArrayList<String> mset = new ArrayList<String>();
        if (this.viewer == null) {
            return new String[0];
        }
        if (this.modelFileNames == null) {
            int modelCount = this.viewer.ms.mc;
            String filePath = null;
            for (int i = 0; i < modelCount; ++i) {
                filePath = this.viewer.ms.getModelFileName(i);
                if (mset.contains(filePath)) continue;
                mset.add(filePath);
            }
            this.modelFileNames = mset.toArray(new String[mset.size()]);
        }
        return this.modelFileNames;
    }

    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    public void handlePopupMenu(int x, int y) {
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
        if (atoms != null) {
            if (this.resetLastRes.length() > 0) {
                this.viewer.evalStringQuiet(this.resetLastRes.toString());
                this.resetLastRes.setLength(0);
            }
            for (AtomSpec atom : atoms) {
                this.highlightAtom(atom.getAtomIndex(), atom.getPdbResNum(), atom.getChain(), atom.getPdbFile());
            }
        }
    }

    public void highlightAtom(int atomIndex, int pdbResNum, String chain, String pdbfile) {
        int mdlNum;
        if (this.modelFileNames == null) {
            return;
        }
        for (mdlNum = 0; mdlNum < this.modelFileNames.length && !pdbfile.equals(this.modelFileNames[mdlNum]); ++mdlNum) {
        }
        if (mdlNum == this.modelFileNames.length) {
            return;
        }
        this.jmolHistory(false);
        StringBuilder cmd = new StringBuilder(64);
        cmd.append("select " + pdbResNum);
        this.resetLastRes.append("select " + pdbResNum);
        cmd.append(":");
        this.resetLastRes.append(":");
        if (!chain.equals(" ")) {
            cmd.append(chain);
            this.resetLastRes.append(chain);
        }
        cmd.append(" /" + (mdlNum + 1));
        this.resetLastRes.append("/" + (mdlNum + 1));
        cmd.append(";wireframe 100;" + cmd.toString() + " and not hetero;");
        this.resetLastRes.append(";wireframe 0;" + this.resetLastRes.toString() + " and not hetero; spacefill 0;");
        cmd.append("spacefill 200;select none");
        this.viewer.evalStringQuiet(cmd.toString());
        this.jmolHistory(true);
    }

    private void jmolHistory(boolean enable) {
        this.viewer.evalStringQuiet("History " + (this.debug || enable ? "on" : "off"));
    }

    public void loadInline(String string) {
        this.loadedInline = true;
        this.viewer.openStringInline(string);
    }

    protected void mouseOverStructure(int atomIndex, String strInfo) {
        String label;
        int alocsep = strInfo.indexOf("^");
        int mdlSep = strInfo.indexOf("/");
        int chainSeparator = strInfo.indexOf(":");
        int chainSeparator1 = -1;
        if (chainSeparator == -1) {
            chainSeparator = strInfo.indexOf(".");
            if (mdlSep > -1 && mdlSep < chainSeparator) {
                chainSeparator1 = chainSeparator;
                chainSeparator = mdlSep;
            }
        }
        int pdbResNum = alocsep != -1 ? Integer.parseInt(strInfo.substring(strInfo.indexOf("]") + 1, alocsep)) : Integer.parseInt(strInfo.substring(strInfo.indexOf("]") + 1, chainSeparator));
        String chainId = strInfo.indexOf(":") > -1 ? strInfo.substring(strInfo.indexOf(":") + 1, strInfo.indexOf(".")) : " ";
        String pdbfilename = this.modelFileNames[this.frameNo];
        if (mdlSep > -1) {
            if (chainSeparator1 == -1) {
                chainSeparator1 = strInfo.indexOf(".", mdlSep);
            }
            String mdlId = chainSeparator1 > -1 ? strInfo.substring(mdlSep + 1, chainSeparator1) : strInfo.substring(mdlSep + 1);
            try {
                int mnumber = Integer.valueOf(mdlId) - 1;
                if (this._modelFileNameMap != null) {
                    int _mp = this._modelFileNameMap.length - 1;
                    while (mnumber < this._modelFileNameMap[_mp]) {
                        --_mp;
                    }
                    pdbfilename = this.modelFileNames[_mp];
                } else {
                    if (mnumber >= 0 && mnumber < this.modelFileNames.length) {
                        pdbfilename = this.modelFileNames[mnumber];
                    }
                    if (pdbfilename == null) {
                        pdbfilename = new File(this.viewer.ms.getModelFileName(mnumber)).getAbsolutePath();
                    }
                }
            }
            catch (Exception mnumber) {
                // empty catch block
            }
        }
        if ((label = this.getSsm().mouseOverStructure(pdbResNum, chainId, pdbfilename)) != null) {
            label = label.replace(',', '|');
            StringTokenizer toks = new StringTokenizer(strInfo, " ");
            StringBuilder sb = new StringBuilder();
            sb.append("select ").append(String.valueOf(pdbResNum)).append(":").append(chainId).append("/1");
            sb.append(";set hoverLabel \"").append(toks.nextToken()).append(" ").append(toks.nextToken());
            sb.append("|").append(label).append("\"");
            this.evalStateCommand(sb.toString());
        }
    }

    public void notifyAtomHovered(int atomIndex, String strInfo, String data) {
        if (strInfo.equals(this.lastMessage)) {
            return;
        }
        this.lastMessage = strInfo;
        if (data != null) {
            System.err.println("Ignoring additional hover info: " + data + " (other info: '" + strInfo + "' pos " + atomIndex + ")");
        }
        this.mouseOverStructure(atomIndex, strInfo);
    }

    public void notifyAtomPicked(int atomIndex, String strInfo, String strData) {
        if (strData != null) {
            System.err.println("Ignoring additional pick data string " + strData);
        }
        int chainSeparator = strInfo.indexOf(":");
        int p = 0;
        if (chainSeparator == -1) {
            chainSeparator = strInfo.indexOf(".");
        }
        Object picked = strInfo.substring(strInfo.indexOf("]") + 1, chainSeparator);
        Object mdlString = "";
        p = strInfo.indexOf(":");
        if (p > -1) {
            picked = (String)picked + strInfo.substring(p, strInfo.indexOf("."));
        }
        if ((p = strInfo.indexOf("/")) > -1) {
            mdlString = (String)mdlString + strInfo.substring(p, strInfo.indexOf(" #"));
        }
        picked = "((" + (String)picked + ".CA" + (String)mdlString + ")|(" + (String)picked + ".P" + (String)mdlString + "))";
        this.jmolHistory(false);
        if (!this.atomsPicked.contains(picked)) {
            this.viewer.evalStringQuiet("select " + (String)picked + ";label %n %r:%c");
            this.atomsPicked.addElement((String)picked);
        } else {
            this.viewer.evalString("select " + (String)picked + ";label off");
            this.atomsPicked.removeElement(picked);
        }
        this.jmolHistory(true);
    }

    public void notifyCallback(CBK type, Object[] data) {
        try {
            switch (type) {
                case LOADSTRUCT: {
                    this.notifyFileLoaded((String)data[1], (String)data[2], (String)data[3], (String)data[4], (Integer)data[5]);
                    break;
                }
                case PICK: {
                    this.notifyAtomPicked((Integer)data[2], (String)data[1], (String)data[0]);
                }
                case HOVER: {
                    this.notifyAtomHovered((Integer)data[2], (String)data[1], (String)data[0]);
                    break;
                }
                case SCRIPT: {
                    this.notifyScriptTermination((String)data[2], (Integer)data[3]);
                    break;
                }
                case ECHO: {
                    this.sendConsoleEcho((String)data[1]);
                    break;
                }
                case MESSAGE: {
                    this.sendConsoleMessage(data == null ? (String)null : (String)data[1]);
                    break;
                }
                case ERROR: {
                    break;
                }
                case SYNC: 
                case RESIZE: {
                    this.refreshGUI();
                    break;
                }
                default: {
                    System.err.println("Unhandled callback " + type + " " + data[1].toString());
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Squashed Jmol callback handler error:");
            e.printStackTrace();
        }
    }

    public boolean notifyEnabled(CBK callbackPick) {
        switch (callbackPick) {
            case LOADSTRUCT: 
            case PICK: 
            case HOVER: 
            case SCRIPT: 
            case ECHO: 
            case MESSAGE: 
            case ERROR: 
            case MEASURE: {
                return true;
            }
        }
        return false;
    }

    public long getLoadNotifiesHandled() {
        return this.loadNotifiesHandled;
    }

    public void notifyFileLoaded(String fullPathName, String fileName2, String modelName, String errorMsg, int modelParts) {
        if (errorMsg != null) {
            this.fileLoadingError = errorMsg;
            this.refreshGUI();
            return;
        }
        this.fileLoadingError = null;
        String[] oldmodels = this.modelFileNames;
        this.modelFileNames = null;
        this.chainNames = new ArrayList<String>();
        this.chainFile = new Hashtable();
        boolean notifyLoaded = false;
        String[] modelfilenames = this.getStructureFiles();
        if (oldmodels != null && oldmodels.length > 0) {
            int oldm = 0;
            for (int i = 0; i < oldmodels.length; ++i) {
                for (int n = 0; n < modelfilenames.length; ++n) {
                    if (modelfilenames[n] != oldmodels[i]) continue;
                    oldmodels[i] = null;
                    break;
                }
                if (oldmodels[i] == null) continue;
                ++oldm;
            }
            if (oldm > 0) {
                String[] oldmfn = new String[oldm];
                oldm = 0;
                for (int i = 0; i < oldmodels.length; ++i) {
                    if (oldmodels[i] == null) continue;
                    oldmfn[oldm++] = oldmodels[i];
                }
                this.getSsm().removeStructureViewerListener(this, oldmfn);
            }
        }
        this.refreshPdbEntries();
        for (int modelnum = 0; modelnum < modelfilenames.length; ++modelnum) {
            String fileName = modelfilenames[modelnum];
            boolean foundEntry = false;
            StructureFile pdb = null;
            String pdbfile = null;
            if (this.loadedInline) {
                pdbfile = this.viewer.getData(1 + this._modelFileNameMap[modelnum] + ".0", "PDB");
            }
            for (int pe = 0; pe < this.getPdbCount(); ++pe) {
                File fl;
                boolean matches = false;
                this.addSequence(pe, this.getSequence()[pe]);
                if (fileName != null && (matches = (fl = new File(this.getPdbEntry(pe).getFile())).equals(new File(fileName)))) {
                    foundEntry = true;
                    DataSourceType protocol = DataSourceType.URL;
                    try {
                        if (fl.exists()) {
                            protocol = DataSourceType.FILE;
                        }
                    }
                    catch (Exception exception) {
                    }
                    catch (Error error) {
                        // empty catch block
                    }
                    pdb = this.getSsm().setMapping(this.getSequence()[pe], this.getChains()[pe], fileName, protocol, this.getIProgressIndicator());
                }
                if (!matches) continue;
                for (int i = 0; i < pdb.getChains().size(); ++i) {
                    String chid = new String(pdb.getId() + ":" + pdb.getChains().elementAt((int)i).id);
                    this.chainFile.put(chid, fileName);
                    this.chainNames.add(chid);
                }
                notifyLoaded = true;
            }
            if (foundEntry || !this.associateNewStructs) continue;
            String pdbcontent = this.viewer.getData("/" + (modelnum + 1) + ".1", "PDB");
            notifyLoaded = true;
        }
        if (!this.isLoadingFromArchive()) {
            this.viewer.evalStringQuiet("model *; select backbone;restrict;cartoon;wireframe off;spacefill off");
        }
        this.getSsm().addStructureViewerListener(this);
        if (notifyLoaded) {
            FeatureRenderer fr = this.getFeatureRenderer(null);
            if (fr != null) {
                fr.featuresAdded();
            }
            this.refreshGUI();
            ++this.loadNotifiesHandled;
        }
        this.setLoadingFromArchive(false);
    }

    @Override
    public List<String> getChainNames() {
        return this.chainNames;
    }

    protected IProgressIndicator getIProgressIndicator() {
        return null;
    }

    public void notifyNewPickingModeMeasurement(int iatom, String strMeasure) {
        this.notifyAtomPicked(iatom, strMeasure, null);
    }

    public abstract void notifyScriptTermination(String var1, int var2);

    public abstract void sendConsoleEcho(String var1);

    public abstract void sendConsoleMessage(String var1);

    public void setCallbackFunction(String callbackType, String callbackFunction) {
        System.err.println("Ignoring set-callback request to associate " + callbackType + " with function " + callbackFunction);
    }

    @Override
    public void setJalviewColourScheme(ColourSchemeI cs) {
        this.colourBySequence = false;
        if (cs == null) {
            return;
        }
        this.jmolHistory(false);
        StringBuilder command = new StringBuilder(128);
        command.append("select *;color white;");
        List<String> residueSet = ResidueProperties.getResidues(this.isNucleotide(), false);
        for (String resName : residueSet) {
            char res = resName.length() == 3 ? ResidueProperties.getSingleCharacterCode(resName) : resName.charAt(0);
            Color col = cs.findColour(res, 0, null, null, 0.0f);
            command.append("select " + resName + ";color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "];");
        }
        this.evalStateCommand(command.toString());
        this.jmolHistory(true);
    }

    public void showHelp() {
        this.showUrl("http://jmol.sourceforge.net/docs/JmolUserGuide/", "jmolHelp");
    }

    public abstract void showUrl(String var1, String var2);

    public abstract void refreshGUI();

    public abstract void showConsole(boolean var1);

    public void allocateViewer(Container renderPanel, boolean jmolfileio, String htmlName, URL documentBase, URL codeBase, String commandOptions) {
        this.allocateViewer(renderPanel, jmolfileio, htmlName, documentBase, codeBase, commandOptions, null, null);
    }

    public void allocateViewer(Container renderPanel, boolean jmolfileio, String htmlName, URL documentBase, URL codeBase, String commandOptions, Container consolePanel, String buttonsToShow) {
        if (commandOptions == null) {
            commandOptions = "";
        }
        this.viewer = (Viewer)JmolViewer.allocateViewer((Object)renderPanel, (JmolAdapter)(jmolfileio ? new SmarterJmolAdapter() : null), (String)(htmlName + this.toString()), (URL)documentBase, (URL)codeBase, (String)commandOptions, (JmolStatusListener)this);
        this.viewer.setJmolStatusListener((JmolStatusListener)this);
        this.console = this.createJmolConsole(consolePanel, buttonsToShow);
        if (consolePanel != null) {
            consolePanel.addComponentListener(this);
        }
    }

    protected abstract JmolAppConsoleInterface createJmolConsole(Container var1, String var2);

    @Override
    public void setBackgroundColour(Color col) {
        this.jmolHistory(false);
        this.viewer.evalStringQuiet("background [" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "];");
        this.jmolHistory(true);
    }

    public int[] resizeInnerPanel(String data) {
        return null;
    }

    protected void closeConsole() {
        if (this.console != null) {
            try {
                this.console.setVisible(false);
            }
            catch (Error error) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.console = null;
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.showConsole(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.showConsole(false);
    }
}

