/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.util.DBRefUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

class EnsemblXref
extends EnsemblRestClient {
    private static final String GO_GENE_ONTOLOGY = "GO";
    private String dbName = "ENSEMBL (xref)";
    private String xrefVersion = "ENSEMBL:0";

    public EnsemblXref(String d, String dbSource, String version) {
        super(d);
        this.dbName = dbSource;
        this.xrefVersion = dbSource + ":" + version;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        return this.getUrl(ids.get(0));
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DBRefEntry> getCrossReferences(String identifier) {
        List<DBRefEntry> result = new ArrayList<DBRefEntry>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(identifier);
        BufferedReader br = null;
        try {
            URL url = this.getUrl(identifier);
            if (url != null && (br = this.getHttpResponse(url, ids)) != null) {
                result = this.parseResponse(br);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    protected List<DBRefEntry> parseResponse(BufferedReader br) throws IOException {
        JSONParser jp = new JSONParser();
        ArrayList<DBRefEntry> result = new ArrayList<DBRefEntry>();
        try {
            JSONArray responses = (JSONArray)jp.parse((Reader)br);
            for (JSONObject val : responses) {
                String db = val.get((Object)"dbname").toString();
                String id = val.get((Object)"primary_id").toString();
                if (db == null || id == null || GO_GENE_ONTOLOGY.equals(db)) continue;
                db = DBRefUtils.getCanonicalName(db);
                DBRefEntry dbref = new DBRefEntry(db, this.getXRefVersion(), id);
                result.add(dbref);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    public String getXRefVersion() {
        return this.xrefVersion;
    }

    protected URL getUrl(String identifier) {
        String url = this.getDomain() + "/xrefs/id/" + identifier + "?content-type=application/json&all_levels=1";
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

