/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.ext.ensembl.EnsemblXref;
import jalview.ext.ensembl.Species;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EnsemblSymbol
extends EnsemblXref {
    private static final String GENE = "gene";
    private static final String TYPE = "type";

    public EnsemblSymbol(String domain, String dbName, String dbVersion) {
        super(domain, dbName, dbVersion);
    }

    protected String parseSymbolResponse(BufferedReader br) throws IOException {
        JSONParser jp = new JSONParser();
        String result = null;
        try {
            JSONArray responses = (JSONArray)jp.parse((Reader)br);
            for (JSONObject val : responses) {
                String id = val.get((Object)"id").toString();
                String type = val.get((Object)TYPE).toString();
                if (id == null || !GENE.equals(type)) continue;
                result = id;
                break;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return result;
    }

    protected URL getUrl(String id, Species species, String ... type) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDomain()).append("/xrefs/symbol/").append(species.toString()).append("/").append(id).append("?content-type=application/json");
        for (String t : type) {
            sb.append("&object_type=").append(t);
        }
        try {
            String url = sb.toString();
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGeneIds(String identifier) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(identifier);
        String[] queries = identifier.split(this.getAccessionSeparator());
        BufferedReader br = null;
        try {
            for (String query : queries) {
                for (Species taxon : Species.getModelOrganisms()) {
                    String geneId;
                    URL url = this.getUrl(query, taxon, GENE);
                    if (url == null || (br = this.getHttpResponse(url, ids)) == null || (geneId = this.parseSymbolResponse(br)) == null || result.contains(geneId)) continue;
                    result.add(geneId);
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

