/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.ext.ensembl.EnsemblData;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.util.StringUtils;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

abstract class EnsemblRestClient
extends EnsemblSequenceFetcher {
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int CONNECT_TIMEOUT_MS = 10000;
    private static final int MAX_RETRIES = 3;
    private static final int HTTP_OK = 200;
    private static final int HTTP_OVERLOAD = 429;
    private static final String LATEST_ENSEMBLGENOMES_REST_VERSION = "10.0";
    private static final String LATEST_ENSEMBL_REST_VERSION = "10.0";
    private static final String REST_CHANGE_LOG = "https://github.com/Ensembl/ensembl-rest/wiki/Change-log";
    private static Map<String, EnsemblData> domainData = new HashMap<String, EnsemblData>();
    private static final long AVAILABILITY_RETEST_INTERVAL = 10000L;
    private static final long VERSION_RETEST_INTERVAL = 3600000L;
    protected static final String CONTENT_TYPE_JSON = "?content-type=application/json";
    protected volatile boolean inProgress = false;

    public EnsemblRestClient() {
        if (!domainData.containsKey(this.ensemblDomain)) {
            domainData.put(this.ensemblDomain, new EnsemblData(this.ensemblDomain, "10.0"));
        }
        if (!domainData.containsKey(this.ensemblGenomesDomain)) {
            domainData.put(this.ensemblGenomesDomain, new EnsemblData(this.ensemblGenomesDomain, "10.0"));
        }
    }

    public EnsemblRestClient(String d) {
        this.setDomain(d);
    }

    @Override
    public boolean queryInProgress() {
        return this.inProgress;
    }

    @Override
    public StringBuffer getRawRecords() {
        return null;
    }

    protected abstract URL getUrl(List<String> var1) throws MalformedURLException;

    protected abstract boolean useGetRequest();

    protected String getRequestMimeType() {
        return "application/json";
    }

    protected String getResponseMimeType() {
        return "application/json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkEnsembl() {
        block16: {
            boolean bl;
            BufferedReader br = null;
            String pingUrl = this.getDomain() + "/info/ping?content-type=application/json";
            try {
                URL ping = new URL(pingUrl);
                br = this.getHttpResponse(ping, null, 2000);
                if (br == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                JSONParser jp = new JSONParser();
                JSONObject val = (JSONObject)jp.parse((Reader)br);
                String pingString = val.get((Object)"ping").toString();
                bl = pingString != null;
            }
            catch (Throwable t) {
                System.err.println("Error connecting to " + pingUrl + ": " + t.getMessage());
                break block16;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    protected BufferedReader getSequenceReader(List<String> ids) throws IOException {
        URL url = this.getUrl(ids);
        BufferedReader reader = this.getHttpResponse(url, ids);
        return reader;
    }

    protected BufferedReader getHttpResponse(URL url, List<String> ids) throws IOException {
        return this.getHttpResponse(url, ids, 300000);
    }

    protected BufferedReader getHttpResponse(URL url, List<String> ids, int readTimeout) throws IOException {
        int retriesLeft = 3;
        URLConnection connection = null;
        int responseCode = 0;
        while (retriesLeft > 0) {
            connection = this.tryConnection(url, ids, readTimeout);
            responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode == 429) {
                --retriesLeft;
                this.checkRetryAfter((HttpURLConnection)connection);
                continue;
            }
            retriesLeft = 0;
        }
        if (responseCode != 200) {
            System.err.println("Response code " + responseCode + " for " + url);
            return null;
        }
        InputStream response = connection.getInputStream();
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(response, "UTF-8"));
        return reader;
    }

    protected HttpURLConnection tryConnection(URL url, List<String> ids, int readTimeout) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        boolean multipleIds = ids != null && ids.size() > 1;
        connection.setRequestMethod(multipleIds ? "POST" : "GET");
        connection.setRequestProperty("Content-Type", this.getRequestMimeType());
        connection.setRequestProperty("Accept", this.getResponseMimeType());
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setDoOutput(multipleIds);
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(readTimeout);
        if (multipleIds) {
            this.writePostBody(connection, ids);
        }
        return connection;
    }

    void checkRetryAfter(HttpURLConnection connection) {
        String retryDelay = connection.getHeaderField("Retry-After");
        if (retryDelay != null) {
            try {
                int retrySecs = Integer.valueOf(retryDelay);
                if (retrySecs > 0 && retrySecs < 10) {
                    System.err.println("Ensembl REST service rate limit exceeded, waiting " + retryDelay + " seconds before retrying");
                    Thread.sleep(1000 * retrySecs);
                }
            }
            catch (InterruptedException | NumberFormatException e) {
                System.err.println("Error handling Retry-After: " + e.getMessage());
            }
        }
    }

    protected boolean isEnsemblAvailable() {
        boolean refetchVersion;
        boolean retestAvailability;
        EnsemblData info = domainData.get(this.getDomain());
        long now = System.currentTimeMillis();
        boolean bl = retestAvailability = now - info.lastAvailableCheckTime > 10000L;
        if (!info.restAvailable || retestAvailability) {
            info.restAvailable = this.checkEnsembl();
            info.lastAvailableCheckTime = now;
        }
        boolean bl2 = refetchVersion = now - info.lastVersionCheckTime > 3600000L;
        if (refetchVersion) {
            this.checkEnsemblRestVersion();
            this.checkEnsemblDataVersion();
            info.lastVersionCheckTime = now;
        }
        return info.restAvailable;
    }

    protected void writePostBody(HttpURLConnection connection, List<String> ids) throws IOException {
        StringBuilder postBody = new StringBuilder(64);
        postBody.append("{\"ids\":[");
        boolean first = true;
        for (String id : ids) {
            if (!first) {
                postBody.append(",");
            }
            first = false;
            postBody.append("\"");
            postBody.append(id.trim());
            postBody.append("\"");
        }
        postBody.append("]}");
        byte[] thepostbody = postBody.toString().getBytes();
        connection.setRequestProperty("Content-Length", Integer.toString(thepostbody.length));
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.write(thepostbody);
        wr.flush();
        wr.close();
    }

    private void checkEnsemblRestVersion() {
        EnsemblData info = domainData.get(this.getDomain());
        JSONParser jp = new JSONParser();
        URL url = null;
        try {
            boolean laterVersion;
            url = new URL(this.getDomain() + "/info/rest?content-type=application/json");
            BufferedReader br = this.getHttpResponse(url, null);
            if (br == null) {
                return;
            }
            JSONObject val = (JSONObject)jp.parse((Reader)br);
            String version = val.get((Object)"release").toString();
            String majorVersion = version.substring(0, version.indexOf("."));
            String expected = info.expectedRestVersion;
            String expectedMajorVersion = expected.substring(0, expected.indexOf("."));
            info.restMajorVersionMismatch = false;
            try {
                if (Float.valueOf(majorVersion).floatValue() > Float.valueOf(expectedMajorVersion).floatValue()) {
                    info.restMajorVersionMismatch = true;
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Error in REST version: " + e.toString());
            }
            boolean bl = laterVersion = StringUtils.compareVersions(version, expected) == 1;
            if (laterVersion) {
                System.err.println(String.format("EnsemblRestClient expected %s REST version %s but found %s, see %s", this.getDbSource(), expected, version, REST_CHANGE_LOG));
            }
            info.restVersion = version;
        }
        catch (Throwable t) {
            System.err.println("Error checking Ensembl REST version: " + t.getMessage());
        }
    }

    public boolean isRestMajorVersionMismatch() {
        return EnsemblRestClient.domainData.get((Object)this.getDomain()).restMajorVersionMismatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkEnsemblDataVersion() {
        JSONParser jp = new JSONParser();
        URL url = null;
        BufferedReader br = null;
        try {
            url = new URL(this.getDomain() + "/info/data?content-type=application/json");
            br = this.getHttpResponse(url, null);
            if (br != null) {
                JSONObject val = (JSONObject)jp.parse((Reader)br);
                JSONArray versions = (JSONArray)val.get((Object)"releases");
                EnsemblRestClient.domainData.get((Object)this.getDomain()).dataVersion = versions.get(0).toString();
            }
        }
        catch (Throwable t) {
            System.err.println("Error checking Ensembl data version: " + t.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException val) {}
            }
        }
    }

    public String getEnsemblDataVersion() {
        return EnsemblRestClient.domainData.get((Object)this.getDomain()).dataVersion;
    }

    @Override
    public String getDbVersion() {
        return this.getEnsemblDataVersion();
    }

    static {
        domainData.put("https://rest.ensembl.org", new EnsemblData("https://rest.ensembl.org", "10.0"));
        domainData.put("https://rest.ensembl.org", new EnsemblData("https://rest.ensembl.org", "10.0"));
    }
}

