/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.GeneLocus;
import jalview.datamodel.Mapping;
import jalview.ext.ensembl.EnsemblInfo;
import jalview.ext.ensembl.EnsemblLookup;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.util.MapList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EnsemblMap
extends EnsemblRestClient {
    private static final String MAPPED = "mapped";
    private static final String MAPPINGS = "mappings";
    private static final String CDS = "cds";
    private static final String CDNA = "cdna";

    public EnsemblMap() {
    }

    public EnsemblMap(String domain) {
        super(domain);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    protected URL getAssemblyMapUrl(String species, String chromosome, String fromRef, String toRef, int startPos, int endPos) throws MalformedURLException {
        boolean forward = startPos <= endPos;
        int start = forward ? startPos : endPos;
        int end = forward ? endPos : startPos;
        String strand = forward ? "1" : "-1";
        String url = String.format("%s/map/%s/%s/%s:%d..%d:%s/%s?content-type=application/json", this.getDomain(), species, fromRef, chromosome, start, end, strand, toRef);
        return new URL(url);
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] getAssemblyMapping(String species, String chromosome, String fromRef, String toRef, int[] queryRange) {
        int[] nArray;
        URL url = null;
        BufferedReader br = null;
        try {
            url = this.getAssemblyMapUrl(species, chromosome, fromRef, toRef, queryRange[0], queryRange[1]);
            br = this.getHttpResponse(url, null);
            nArray = this.parseAssemblyMappingResponse(br);
            if (br == null) return nArray;
        }
        catch (Throwable t) {
            try {
                System.out.println("Error calling " + url + ": " + t.getMessage());
                int[] nArray2 = null;
                return nArray2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        try {
            br.close();
            return nArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return nArray;
    }

    protected int[] parseAssemblyMappingResponse(BufferedReader br) {
        int[] result = null;
        JSONParser jp = new JSONParser();
        try {
            JSONObject parsed = (JSONObject)jp.parse((Reader)br);
            JSONArray mappings = (JSONArray)parsed.get((Object)MAPPINGS);
            for (JSONObject val : mappings) {
                JSONObject mapped = (JSONObject)val.get((Object)MAPPED);
                int start = Integer.parseInt(mapped.get((Object)"start").toString());
                int end = Integer.parseInt(mapped.get((Object)"end").toString());
                String strand = mapped.get((Object)"strand").toString();
                if ("1".equals(strand)) {
                    result = new int[]{start, end};
                    continue;
                }
                result = new int[]{end, start};
            }
        }
        catch (IOException | NumberFormatException | ParseException throwable) {
            // empty catch block
        }
        return result;
    }

    public GeneLociI getCdsMapping(String division, String accession, int start, int end) {
        return this.getIdMapping(division, accession, start, end, CDS);
    }

    public GeneLociI getCdnaMapping(String division, String accession, int start, int end) {
        return this.getIdMapping(division, accession, start, end, CDNA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    GeneLociI getIdMapping(String division, String accession, int start, int end, String cdsOrCdna) {
        GeneLociI geneLociI;
        BufferedReader br;
        URL url;
        block17: {
            block15: {
                GeneLociI geneLociI2;
                block16: {
                    url = null;
                    br = null;
                    String domain = new EnsemblInfo().getDomain(division);
                    if (domain == null || (br = this.getHttpResponse(url = this.getIdMapUrl(domain, accession, start, end, cdsOrCdna), null)) == null) break block15;
                    geneLociI2 = this.parseIdMappingResponse(br, accession, domain);
                    if (br == null) break block16;
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return geneLociI2;
            }
            geneLociI = null;
            if (br == null) break block17;
            try {
                br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return geneLociI;
        catch (Throwable t) {
            try {
                System.out.println("Error calling " + url + ": " + t.getMessage());
                GeneLociI geneLociI3 = null;
                return geneLociI3;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    URL getIdMapUrl(String domain, String accession, int start, int end, String cdsOrCdna) throws MalformedURLException {
        String url = String.format("%s/map/%s/%s/%d..%d?include_original_region=1&content-type=application/json", domain, cdsOrCdna, accession, start, end);
        return new URL(url);
    }

    GeneLociI parseIdMappingResponse(BufferedReader br, String accession, String domain) {
        JSONParser jp = new JSONParser();
        try {
            JSONObject parsed = (JSONObject)jp.parse((Reader)br);
            JSONArray mappings = (JSONArray)parsed.get((Object)MAPPINGS);
            Iterator rvals = mappings.iterator();
            String assembly = null;
            String chromosome = null;
            int fromEnd = 0;
            ArrayList<int[]> regions = new ArrayList<int[]>();
            while (rvals.hasNext()) {
                JSONObject val = (JSONObject)rvals.next();
                JSONObject original = (JSONObject)val.get((Object)"original");
                fromEnd = Integer.parseInt(original.get((Object)"end").toString());
                JSONObject mapped = (JSONObject)val.get((Object)MAPPED);
                int start = Integer.parseInt(mapped.get((Object)"start").toString());
                int end = Integer.parseInt(mapped.get((Object)"end").toString());
                String ass = mapped.get((Object)"assembly_name").toString();
                if (assembly != null && !assembly.equals(ass)) {
                    System.err.println("EnsemblMap found multiple assemblies - can't resolve");
                    return null;
                }
                assembly = ass;
                String chr = mapped.get((Object)"seq_region_name").toString();
                if (chromosome != null && !chromosome.equals(chr)) {
                    System.err.println("EnsemblMap found multiple chromosomes - can't resolve");
                    return null;
                }
                chromosome = chr;
                String strand = mapped.get((Object)"strand").toString();
                if ("-1".equals(strand)) {
                    regions.add(new int[]{end, start});
                    continue;
                }
                regions.add(new int[]{start, end});
            }
            String species = new EnsemblLookup(domain).getSpecies(accession);
            String as = assembly;
            String chr = chromosome;
            List<int[]> fromRange = Collections.singletonList(new int[]{1, fromEnd});
            Mapping mapping = new Mapping(new MapList(fromRange, regions, 1, 1));
            return new GeneLocus(species == null ? "" : species, as, chr, mapping);
        }
        catch (IOException | NumberFormatException | ParseException throwable) {
            return null;
        }
    }
}

