/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.AlignmentI;
import jalview.ext.ensembl.EnsemblRestClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EnsemblInfo
extends EnsemblRestClient {
    private static Map<String, String> divisions;

    @Override
    public String getDbName() {
        return "ENSEMBL";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        return null;
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    public String getDomain(String division) {
        if (divisions == null) {
            this.fetchDivisions();
        }
        return divisions.get(division.toUpperCase());
    }

    void fetchDivisions() {
        divisions = new HashMap<String, String>();
        divisions.put("ENSEMBL".toUpperCase(), this.ensemblDomain);
        BufferedReader br = null;
        try {
            URL url = this.getDivisionsUrl(this.ensemblGenomesDomain);
            if (url != null) {
                br = this.getHttpResponse(url, null);
            }
            this.parseResponse(br, this.ensemblGenomesDomain);
        }
        catch (IOException iOException) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void parseResponse(BufferedReader br, String domain) {
        JSONParser jp = new JSONParser();
        try {
            JSONArray parsed = (JSONArray)jp.parse((Reader)br);
            Iterator rvals = parsed.iterator();
            while (rvals.hasNext()) {
                String division = rvals.next().toString();
                divisions.put(division.toUpperCase(), domain);
            }
        }
        catch (IOException | NumberFormatException | ParseException throwable) {
            // empty catch block
        }
    }

    URL getDivisionsUrl(String domain) throws MalformedURLException {
        return new URL(domain + "/info/divisions?content-type=application/json");
    }

    public Set<String> getDivisions() {
        if (divisions == null) {
            this.fetchDivisions();
        }
        return divisions.keySet();
    }
}

