/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.HMMNode;
import jalview.datamodel.Mapping;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.MapList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HiddenMarkovModel {
    private static final char GAP_DASH = '-';
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final int MATCHTOMATCH = 0;
    public static final int MATCHTOINSERT = 1;
    public static final int MATCHTODELETE = 2;
    public static final int INSERTTOMATCH = 3;
    public static final int INSERTTOINSERT = 4;
    public static final int DELETETOMATCH = 5;
    public static final int DELETETODELETE = 6;
    private static final double LOG2 = Math.log(2.0);
    private Map<String, String> fileProperties = new HashMap<String, String>();
    private String fileHeader;
    private String alphabet;
    private int[] symbolIndexLookup = new int[26];
    private List<HMMNode> nodes = new ArrayList<HMMNode>();
    private SequenceI hmmSeq;
    private Mapping mapToHmmConsensus;
    private Map<Character, Float> backgroundFrequencies;

    public HiddenMarkovModel() {
    }

    public HiddenMarkovModel(HiddenMarkovModel hmm, SequenceI sq) {
        this.fileProperties = new HashMap<String, String>(hmm.fileProperties);
        this.alphabet = hmm.alphabet;
        this.nodes = new ArrayList<HMMNode>(hmm.nodes);
        this.symbolIndexLookup = hmm.symbolIndexLookup;
        this.fileHeader = new String(hmm.fileHeader);
        this.hmmSeq = sq;
        this.backgroundFrequencies = hmm.getBackgroundFrequencies();
        this.mapToHmmConsensus = sq.getDatasetSequence() == hmm.mapToHmmConsensus.getTo() ? hmm.mapToHmmConsensus : new Mapping(sq.getDatasetSequence(), hmm.mapToHmmConsensus.getMap());
    }

    public float getInformationContent(int column) {
        float informationContent = 0.0f;
        for (char symbol : this.getSymbols().toCharArray()) {
            float freq = ResidueProperties.backgroundFrequencies.get(this.getAlphabetType()).get(Character.valueOf(symbol)).floatValue();
            float prob = (float)this.getMatchEmissionProbability(column, symbol);
            informationContent = (float)((double)informationContent + (double)prob * Math.log(prob / freq));
        }
        return informationContent /= (float)LOG2;
    }

    public String getFileHeader() {
        return this.fileHeader;
    }

    public void setFileHeader(String header) {
        this.fileHeader = header;
    }

    public String getSymbols() {
        return this.alphabet;
    }

    public HMMNode getNode(int nodeIndex) {
        return this.nodes.get(nodeIndex);
    }

    public String getName() {
        return this.fileProperties.get("NAME");
    }

    public String getProperty(String key) {
        return this.fileProperties.get(key);
    }

    public boolean getBooleanProperty(String key) {
        return YES.equalsIgnoreCase(this.fileProperties.get(key));
    }

    public int getLength() {
        if (this.fileProperties.get("LENG") == null) {
            return this.nodes.size() - 1;
        }
        return Integer.parseInt(this.fileProperties.get("LENG"));
    }

    public String getAlphabetType() {
        return this.fileProperties.get("ALPH");
    }

    public int setAlphabet(String symbols) {
        String trimmed = symbols.toUpperCase().replaceAll("\\s", "");
        int count = trimmed.length();
        this.alphabet = trimmed;
        this.symbolIndexLookup = new int[26];
        Arrays.fill(this.symbolIndexLookup, -1);
        int ignored = 0;
        for (int i = 0; i < count; i = (int)((short)(i + 1))) {
            char symbol = trimmed.charAt(i);
            if (symbol >= 'A' && symbol <= 'Z' && this.symbolIndexLookup[symbol - 65] == -1) {
                this.symbolIndexLookup[symbol - 65] = i;
                continue;
            }
            System.err.println("Unexpected or duplicated character in HMM ALPHabet: " + symbol);
            ++ignored;
        }
        return count - ignored;
    }

    HMMNode getNodeForColumn(int column) {
        if (Comparison.isGap(this.hmmSeq.getCharAt(column))) {
            return null;
        }
        int seqPos = this.hmmSeq.findPosition(column);
        int[] nodeNo = this.mapToHmmConsensus.getMap().locateInFrom(seqPos, seqPos);
        if (nodeNo != null) {
            return this.getNode(nodeNo[0]);
        }
        return null;
    }

    public double getMatchEmissionProbability(int alignColumn, char symbol) {
        HMMNode node = this.getNodeForColumn(alignColumn);
        int symbolIndex = this.getSymbolIndex(symbol);
        if (node != null && symbolIndex != -1) {
            return node.getMatchEmission(symbolIndex);
        }
        return 0.0;
    }

    public double getInsertEmissionProbability(int alignColumn, char symbol) {
        HMMNode node = this.getNodeForColumn(alignColumn);
        int symbolIndex = this.getSymbolIndex(symbol);
        if (node != null && symbolIndex != -1) {
            return node.getInsertEmission(symbolIndex);
        }
        return 0.0;
    }

    public double getStateTransitionProbability(int alignColumn, int transition) {
        HMMNode node = this.getNodeForColumn(alignColumn);
        if (node != null) {
            return node.getStateTransition(transition);
        }
        return 0.0;
    }

    public int getNodeMapPosition(int nodeIndex) {
        return this.nodes.get(nodeIndex).getResidueNumber();
    }

    public char getConsensusResidue(int nodeIndex) {
        char value = this.nodes.get(nodeIndex).getConsensusResidue();
        return value;
    }

    public char getReferenceAnnotation(int nodeIndex) {
        char value = this.nodes.get(nodeIndex).getReferenceAnnotation();
        return value;
    }

    public char getMaskedValue(int nodeIndex) {
        char value = this.nodes.get(nodeIndex).getMaskValue();
        return value;
    }

    public char getConsensusStructure(int nodeIndex) {
        char value = this.nodes.get(nodeIndex).getConsensusStructure();
        return value;
    }

    public void setProperty(String key, String value) {
        this.fileProperties.put(key, value);
    }

    public String getViterbi() {
        String value = this.fileProperties.get("VITERBI");
        return value;
    }

    public String getMSV() {
        String value = this.fileProperties.get("MSV");
        return value;
    }

    public String getForward() {
        String value = this.fileProperties.get("FORWARD");
        return value;
    }

    void buildConsensusSequence() {
        ArrayList<int[]> toResidues = new ArrayList<int[]>();
        boolean hasMap = this.getBooleanProperty("MAP");
        int start = hasMap ? this.getNode(1).getResidueNumber() : 1;
        int endResNo = hasMap ? this.getNode(this.nodes.size() - 1).getResidueNumber() : start + this.getLength() - 1;
        char[] sequence = new char[endResNo];
        int lastResNo = start - 1;
        int seqOffset = -1;
        int gapCount = 0;
        for (int seqN = 0; seqN < start; ++seqN) {
            sequence[seqN] = 45;
            ++seqOffset;
        }
        for (int nodeNo = 1; nodeNo < this.nodes.size(); ++nodeNo) {
            int resNo;
            HMMNode node = this.nodes.get(nodeNo);
            int n = resNo = hasMap ? node.getResidueNumber() : lastResNo + 1;
            while (resNo > lastResNo + 1) {
                sequence[seqOffset++] = 45;
                ++lastResNo;
                ++gapCount;
            }
            char consensusResidue = node.getConsensusResidue();
            if ('-' == consensusResidue) {
                int symbolIndex = node.getMaxMatchEmissionIndex();
                consensusResidue = this.alphabet.charAt(symbolIndex);
                if (node.getMatchEmission(symbolIndex) < 0.5) {
                    consensusResidue = Character.toLowerCase(consensusResidue);
                }
            }
            sequence[seqOffset++] = consensusResidue;
            lastResNo = resNo;
        }
        Sequence seq = new Sequence(this.getName(), sequence, start, lastResNo - gapCount);
        seq.createDatasetSequence();
        seq.setHMM(this);
        this.hmmSeq = seq;
        ArrayList<int[]> fromNodes = new ArrayList<int[]>();
        fromNodes.add(new int[]{1, this.getLength()});
        toResidues.add(new int[]{seq.getStart(), seq.getEnd()});
        MapList mapList = new MapList(fromNodes, toResidues, 1, 1);
        this.mapToHmmConsensus = new Mapping(seq.getDatasetSequence(), mapList);
    }

    public SequenceI getConsensusSequence() {
        return this.hmmSeq;
    }

    private int getSymbolIndex(char symbol) {
        char c = Character.toUpperCase(symbol);
        if ('A' <= c && c <= 'Z') {
            return this.symbolIndexLookup[c - 65];
        }
        return -1;
    }

    public void setNodes(List<HMMNode> nodeList) {
        this.nodes = nodeList;
        if (this.nodes.size() > 1) {
            this.buildConsensusSequence();
        }
    }

    public void setHmmSeq(SequenceI hmmSeq) {
        this.hmmSeq = hmmSeq;
    }

    public void setBackgroundFrequencies(Map<Character, Float> bkgdFreqs) {
        this.backgroundFrequencies = bkgdFreqs;
    }

    public void setBackgroundFrequencies(ResidueCount bkgdFreqs) {
        this.backgroundFrequencies = new HashMap<Character, Float>();
        int total = bkgdFreqs.getTotalResidueCount();
        for (char c : bkgdFreqs.getSymbolCounts().symbols) {
            this.backgroundFrequencies.put(Character.valueOf(c), Float.valueOf((float)bkgdFreqs.getCount(c) * 1.0f / (float)total));
        }
    }

    public Map<Character, Float> getBackgroundFrequencies() {
        return this.backgroundFrequencies;
    }
}

