/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.api.DBRefEntryI;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import java.util.Arrays;
import java.util.List;

public class DBRefEntry
implements DBRefEntryI {
    String source = "";
    String version = "";
    String accessionId = "";
    Mapping map = null;

    public DBRefEntry() {
    }

    public DBRefEntry(String source, String version, String accessionId) {
        this(source, version, accessionId, null);
    }

    public DBRefEntry(String source, String version, String accessionId, Mapping map) {
        this.source = source.toUpperCase();
        this.version = version;
        this.accessionId = accessionId;
        this.map = map;
    }

    public DBRefEntry(DBRefEntryI entry) {
        this(entry.getSource() == null ? "" : new String(entry.getSource()), entry.getVersion() == null ? "" : new String(entry.getVersion()), entry.getAccessionId() == null ? "" : new String(entry.getAccessionId()), entry.getMap() == null ? null : new Mapping(entry.getMap()));
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DBRefEntry)) {
            return false;
        }
        DBRefEntry entry = (DBRefEntry)o;
        if (entry == this) {
            return true;
        }
        return this.equalRef(entry) && (this.map == null && entry.map == null || this.map != null && entry.map != null && this.map.equals(entry.map));
    }

    @Override
    public boolean updateFrom(DBRefEntryI other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        String otherSource = other.getSource();
        if (this.source == null && otherSource != null || this.source != null && otherSource == null || this.source != null && !this.source.equalsIgnoreCase(otherSource)) {
            return false;
        }
        String otherAccession = other.getAccessionId();
        if (this.accessionId == null && otherAccession != null || this.accessionId != null && otherAccession == null || this.accessionId != null && !this.accessionId.equalsIgnoreCase(otherAccession)) {
            return false;
        }
        String otherVersion = other.getVersion();
        if ((this.version == null || this.version.equals("0") || this.version.endsWith(":0")) && otherVersion != null) {
            this.setVersion(otherVersion);
        } else if (!(this.version == null || otherVersion != null && this.version.equalsIgnoreCase(otherVersion))) {
            return false;
        }
        if (this.map == null) {
            this.setMap(other.getMap());
        }
        return true;
    }

    @Override
    public boolean equalRef(DBRefEntryI entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        return entry != null && this.source != null && entry.getSource() != null && this.source.equalsIgnoreCase(entry.getSource()) && this.accessionId != null && entry.getAccessionId() != null && this.accessionId.equalsIgnoreCase(entry.getAccessionId()) && this.version != null && entry.getVersion() != null && this.version.equalsIgnoreCase(entry.getVersion());
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAccessionId() {
        return this.accessionId;
    }

    @Override
    public void setAccessionId(String accessionId) {
        this.accessionId = accessionId;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Mapping getMap() {
        return this.map;
    }

    public void setMap(Mapping map) {
        this.map = map;
    }

    public boolean hasMap() {
        return this.map != null;
    }

    public String getSrcAccString() {
        return (this.source != null ? this.source : "") + ":" + (this.accessionId != null ? this.accessionId : "");
    }

    public String toString() {
        return this.getSrcAccString();
    }

    @Override
    public boolean isPrimaryCandidate() {
        if (this.map != null) {
            if (this.map.getTo() != null) {
                return false;
            }
            if (this.map.getMap().getFromRatio() != this.map.getMap().getToRatio() || this.map.getMap().getFromRatio() != 1) {
                return false;
            }
            List<int[]> fromRanges = this.map.getMap().getFromRanges();
            List<int[]> toRanges = this.map.getMap().getToRanges();
            if (fromRanges.size() != 1 || toRanges.size() != 1) {
                return false;
            }
            if (fromRanges.get(0)[0] != toRanges.get(0)[0] || fromRanges.get(0)[1] != toRanges.get(0)[1]) {
                return false;
            }
        }
        if (this.version == null) {
            return false;
        }
        String ucv = this.version.toUpperCase();
        for (String primsrc : Arrays.asList(DBRefSource.allSources())) {
            if (!ucv.startsWith(primsrc.toUpperCase())) continue;
            return false;
        }
        return true;
    }
}

