/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.analysis.AlignSeq;
import jalview.commands.CommandI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.Range;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.SequenceFeaturesI;
import jalview.util.Comparison;
import jalview.util.ReverseListIterator;
import jalview.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class EditCommand
implements CommandI {
    private List<Edit> edits = new ArrayList<Edit>();
    String description;

    public EditCommand() {
    }

    public EditCommand(String desc) {
        this.description = desc;
    }

    public EditCommand(String desc, Action command, SequenceI[] seqs, int position, int number, AlignmentI al) {
        this.description = desc;
        if (command == Action.CUT || command == Action.PASTE) {
            this.setEdit(new Edit(command, seqs, position, number, al));
        }
        this.performEdit(0, null);
    }

    public EditCommand(String desc, Action command, String replace, SequenceI[] seqs, int position, int number, AlignmentI al) {
        this.description = desc;
        if (command == Action.REPLACE) {
            this.setEdit(new Edit(command, seqs, position, number, al, replace));
        }
        this.performEdit(0, null);
    }

    protected void setEdit(Edit e) {
        this.edits.clear();
        this.edits.add(e);
    }

    public void addEdit(Edit e) {
        if (!EditCommand.expandEdit(this.edits, e)) {
            this.edits.add(e);
        }
    }

    protected static boolean expandEdit(List<Edit> edits, Edit e) {
        boolean contiguous;
        if (edits == null || edits.isEmpty()) {
            return false;
        }
        Edit lastEdit = edits.get(edits.size() - 1);
        Action action = e.command;
        if (lastEdit.command != action) {
            return false;
        }
        if (lastEdit.seqs.length != e.seqs.length) {
            return false;
        }
        for (int i = 0; i < e.seqs.length; ++i) {
            if (lastEdit.seqs[i].getDatasetSequence() == e.seqs[i].getDatasetSequence()) continue;
            return false;
        }
        boolean bl = contiguous = action == Action.INSERT_GAP && e.position == lastEdit.position + lastEdit.number || action == Action.DELETE_GAP && e.position + e.number == lastEdit.position;
        if (contiguous) {
            lastEdit.number += e.number;
            lastEdit.seqs = e.seqs;
            if (action == Action.DELETE_GAP) {
                --lastEdit.position;
            }
            return true;
        }
        return false;
    }

    protected void clearEdits() {
        this.edits.clear();
    }

    protected Edit getEdit(int i) {
        if (i >= 0 && i < this.edits.size()) {
            return this.edits.get(i);
        }
        return null;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public int getSize() {
        return this.edits.size();
    }

    public final AlignmentI getAlignment() {
        return this.edits.isEmpty() ? null : this.edits.get((int)0).al;
    }

    public final void appendEdit(Action command, SequenceI[] seqs, int position, int number, AlignmentI al, boolean performEdit) {
        this.appendEdit(command, seqs, position, number, al, performEdit, null);
    }

    public final void appendEdit(Action command, SequenceI[] seqs, int position, int number, AlignmentI al, boolean performEdit, AlignmentI[] views) {
        Edit edit = new Edit(command, seqs, position, number, al);
        this.appendEdit(edit, al, performEdit, views);
    }

    public final void appendEdit(Edit edit, AlignmentI al, boolean performEdit, AlignmentI[] views) {
        if (al.getHeight() == edit.seqs.length) {
            edit.al = al;
            edit.fullAlignmentHeight = true;
        }
        this.addEdit(edit);
        if (performEdit) {
            EditCommand.performEdit(edit, views);
        }
    }

    public final void performEdit(int commandIndex, AlignmentI[] views) {
        ListIterator<Edit> iterator = this.edits.listIterator(commandIndex);
        while (iterator.hasNext()) {
            Edit edit = iterator.next();
            EditCommand.performEdit(edit, views);
        }
    }

    protected static void performEdit(Edit edit, AlignmentI[] views) {
        switch (edit.command) {
            case INSERT_GAP: {
                EditCommand.insertGap(edit);
                break;
            }
            case DELETE_GAP: {
                EditCommand.deleteGap(edit);
                break;
            }
            case CUT: {
                EditCommand.cut(edit, views);
                break;
            }
            case PASTE: {
                EditCommand.paste(edit, views);
                break;
            }
            case REPLACE: {
                EditCommand.replace(edit);
                break;
            }
            case INSERT_NUC: {
                break;
            }
        }
    }

    @Override
    public final void doCommand(AlignmentI[] views) {
        this.performEdit(0, views);
    }

    @Override
    public final void undoCommand(AlignmentI[] views) {
        ListIterator<Edit> iterator = this.edits.listIterator(this.edits.size());
        while (iterator.hasPrevious()) {
            Edit e = iterator.previous();
            switch (e.command) {
                case INSERT_GAP: {
                    EditCommand.deleteGap(e);
                    break;
                }
                case DELETE_GAP: {
                    EditCommand.insertGap(e);
                    break;
                }
                case CUT: {
                    EditCommand.paste(e, views);
                    break;
                }
                case PASTE: {
                    EditCommand.cut(e, views);
                    break;
                }
                case REPLACE: {
                    EditCommand.replace(e);
                    break;
                }
                case INSERT_NUC: {
                    break;
                }
            }
        }
    }

    private static final void insertGap(Edit command) {
        for (int s = 0; s < command.seqs.length; ++s) {
            command.seqs[s].insertCharAt(command.position, command.number, command.gapChar);
        }
        EditCommand.adjustAnnotations(command, true, false, null);
    }

    private static final void deleteGap(Edit command) {
        for (int s = 0; s < command.seqs.length; ++s) {
            command.seqs[s].deleteChars(command.position, command.position + command.number);
        }
        EditCommand.adjustAnnotations(command, false, false, null);
    }

    static void cut(Edit command, AlignmentI[] views) {
        boolean seqDeleted = false;
        command.string = new char[command.seqs.length][];
        for (int i = 0; i < command.seqs.length; ++i) {
            SequenceI sequence = command.seqs[i];
            if (sequence.getLength() > command.position) {
                command.string[i] = sequence.getSequence(command.position, command.position + command.number);
                SequenceI oldds = sequence.getDatasetSequence();
                ContiguousI cutPositions = sequence.findPositions(command.position + 1, command.position + command.number);
                boolean cutIsInternal = cutPositions != null && sequence.getStart() != cutPositions.getBegin() && sequence.getEnd() != cutPositions.getEnd();
                SequenceI ds = sequence.getDatasetSequence();
                sequence.deleteChars(command.position, command.position + command.number);
                if (command.oldds != null && command.oldds[i] != null) {
                    sequence.setDatasetSequence(command.oldds[i]);
                    command.oldds[i] = oldds;
                } else {
                    if (command.oldds == null) {
                        command.oldds = new SequenceI[command.seqs.length];
                    }
                    command.oldds[i] = oldds;
                    if ((oldds != sequence.getDatasetSequence() || cutIsInternal && sequence.getFeatures().hasFeatures()) && cutPositions != null) {
                        EditCommand.cutFeatures(command, sequence, cutPositions.getBegin(), cutPositions.getEnd(), cutIsInternal);
                    }
                }
                SequenceI newDs = sequence.getDatasetSequence();
                if (newDs != ds && command.al != null && command.al.getDataset() != null && !command.al.getDataset().getSequences().contains(newDs)) {
                    command.al.getDataset().addSequence(newDs);
                }
            }
            if (sequence.getLength() >= 1) continue;
            command.al.deleteSequence(sequence);
            seqDeleted = true;
        }
        EditCommand.adjustAnnotations(command, false, seqDeleted, views);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void paste(Edit command, AlignmentI[] views) {
        boolean seqWasDeleted = false;
        int i = 0;
        while (true) {
            if (i >= command.seqs.length) {
                EditCommand.adjustAnnotations(command, true, seqWasDeleted, views);
                command.string = null;
                return;
            }
            boolean newDSNeeded = false;
            boolean newDSWasNeeded = command.oldds != null && command.oldds[i] != null;
            SequenceI sequence = command.seqs[i];
            if (sequence.getLength() < 1) {
                if (command.alIndex[i] < command.al.getHeight()) {
                    List<SequenceI> sequences;
                    List<SequenceI> list = sequences = command.al.getSequences();
                    // MONITORENTER : sequences
                    if (command.alIndex[i] >= 0) {
                        sequences.add(command.alIndex[i], sequence);
                    }
                    // MONITOREXIT : list
                } else {
                    command.al.addSequence(sequence);
                }
                seqWasDeleted = true;
            }
            int newStart = sequence.getStart();
            int newEnd = sequence.getEnd();
            StringBuilder tmp = new StringBuilder();
            tmp.append(sequence.getSequence());
            int start = 0;
            int length = 0;
            if (command.string != null && command.string[i] != null) {
                if (command.position >= tmp.length()) {
                    for (int len = command.position - tmp.length(); len > 0; --len) {
                        tmp.append(command.gapChar);
                    }
                }
                tmp.insert(command.position, command.string[i]);
                for (int s = 0; s < command.string[i].length; ++s) {
                    if (Comparison.isGap(command.string[i][s])) continue;
                    ++length;
                    if (!newDSNeeded) {
                        newDSNeeded = true;
                        start = sequence.findPosition(command.position);
                    }
                    if (sequence.getStart() == start) {
                        --newStart;
                        continue;
                    }
                    ++newEnd;
                }
                command.string[i] = null;
            }
            sequence.setSequence(tmp.toString());
            sequence.setStart(newStart);
            sequence.setEnd(newEnd);
            boolean sameDatasetSequence = false;
            if (newDSNeeded) {
                if (sequence.getDatasetSequence() != null) {
                    SequenceI ds;
                    if (newDSWasNeeded) {
                        ds = command.oldds[i];
                    } else {
                        String ungapped = AlignSeq.extractGaps(Comparison.GapChars, sequence.getSequenceAsString());
                        ds = new Sequence(sequence.getName(), ungapped, sequence.getStart(), sequence.getEnd());
                        ds.setDescription(sequence.getDescription());
                    }
                    if (command.oldds == null) {
                        command.oldds = new SequenceI[command.seqs.length];
                    }
                    command.oldds[i] = sequence.getDatasetSequence();
                    sameDatasetSequence = ds == sequence.getDatasetSequence();
                    ds.setSequenceFeatures(sequence.getSequenceFeatures());
                    if (!sameDatasetSequence && command.al.getDataset() != null) {
                        command.al.getDataset().deleteSequence(sequence.getDatasetSequence());
                    }
                    sequence.setDatasetSequence(ds);
                }
                EditCommand.undoCutFeatures(command, command.seqs[i], start, length, sameDatasetSequence);
            }
            ++i;
        }
    }

    static void replace(Edit command) {
        int start = command.position;
        int end = command.number;
        command.number = start + command.string[0].length;
        for (int i = 0; i < command.seqs.length; ++i) {
            boolean newDSWasNeeded = command.oldds != null && command.oldds[i] != null;
            boolean newStartEndWasNeeded = command.oldStartEnd != null && command.oldStartEnd[i] != null;
            ContiguousI beforeEditedPositions = command.seqs[i].findPositions(1, start);
            ContiguousI afterEditedPositions = command.seqs[i].findPositions(end + 1, command.seqs[i].getLength());
            String oldstring = command.seqs[i].getSequenceAsString();
            StringBuilder tmp = new StringBuilder(oldstring.substring(0, start));
            tmp.append(command.string[i]);
            String nogaprep = AlignSeq.extractGaps(Comparison.GapChars, new String(command.string[i]));
            if (end < oldstring.length()) {
                tmp.append(oldstring.substring(end));
            }
            Range oldstartend = new Range(command.seqs[i].getStart(), command.seqs[i].getEnd());
            command.seqs[i].setSequence(tmp.toString());
            command.string[i] = oldstring.substring(start, Math.min(end, oldstring.length())).toCharArray();
            String nogapold = AlignSeq.extractGaps(Comparison.GapChars, new String(command.string[i]));
            if (!nogaprep.toLowerCase().equals(nogapold.toLowerCase())) {
                SequenceI oldds;
                if (newDSWasNeeded || newStartEndWasNeeded) {
                    if (newDSWasNeeded) {
                        oldds = command.seqs[i].getDatasetSequence();
                        command.seqs[i].setDatasetSequence(command.oldds[i]);
                        command.oldds[i] = oldds;
                    }
                    if (newStartEndWasNeeded) {
                        Range newStart = command.oldStartEnd[i];
                        command.oldStartEnd[i] = oldstartend;
                        command.seqs[i].setStart(newStart.getBegin());
                        command.seqs[i].setEnd(newStart.getEnd());
                    }
                } else {
                    oldds = command.seqs[i].getDatasetSequence();
                    String osp = oldds.getSequenceAsString();
                    int beforeStartOfEdit = -oldds.getStart() + 1 + (beforeEditedPositions == null ? (afterEditedPositions != null ? afterEditedPositions.getBegin() - 1 : oldstartend.getBegin() + nogapold.length()) : beforeEditedPositions.getEnd());
                    int afterEndOfEdit = -oldds.getStart() + 1 + (afterEditedPositions == null ? oldstartend.getEnd() : afterEditedPositions.getBegin() - 1);
                    String fullseq = osp.substring(0, beforeStartOfEdit) + nogaprep + osp.substring(afterEndOfEdit);
                    if (!fullseq.equalsIgnoreCase(osp)) {
                        Sequence newds = new Sequence(oldds);
                        newds.setSequence(fullseq.toUpperCase());
                        if (command.oldds == null) {
                            command.oldds = new SequenceI[command.seqs.length];
                        }
                        command.oldds[i] = command.seqs[i].getDatasetSequence();
                        if (command.oldStartEnd == null) {
                            command.oldStartEnd = new Range[command.seqs.length];
                        }
                        command.oldStartEnd[i] = oldstartend;
                        command.seqs[i].setDatasetSequence(newds);
                    } else {
                        if (command.oldStartEnd == null) {
                            command.oldStartEnd = new Range[command.seqs.length];
                        }
                        command.oldStartEnd[i] = new Range(command.seqs[i].getStart(), command.seqs[i].getEnd());
                        if (beforeEditedPositions != null && afterEditedPositions == null) {
                            command.seqs[i].setEnd(beforeEditedPositions.getEnd() + nogaprep.length() - nogapold.length());
                        } else if (afterEditedPositions != null && beforeEditedPositions == null) {
                            command.seqs[i].setStart(afterEditedPositions.getBegin() - nogaprep.length());
                        } else {
                            String nogapalseq = AlignSeq.extractGaps(Comparison.GapChars, command.seqs[i].getSequenceAsString().toUpperCase());
                            int newStart = command.seqs[i].getDatasetSequence().getSequenceAsString().indexOf(nogapalseq);
                            if (newStart == -1) {
                                throw new Error("Implementation Error: could not locate start/end in dataset sequence after an edit of the sequence string");
                            }
                            int newEnd = newStart + nogapalseq.length() - 1;
                            command.seqs[i].setStart(newStart);
                            command.seqs[i].setEnd(newEnd);
                        }
                    }
                }
            }
            tmp = null;
            oldstring = null;
        }
    }

    static final void adjustAnnotations(Edit command, boolean insert, boolean modifyVisibility, AlignmentI[] views) {
        int aSize;
        AlignmentAnnotation[] annotations = null;
        if (modifyVisibility && !insert) {
            command.deletedAnnotationRows = new Hashtable<SequenceI, AlignmentAnnotation[]>();
        }
        if (command.fullAlignmentHeight) {
            annotations = command.al.getAlignmentAnnotation();
        } else {
            aSize = 0;
            for (int s = 0; s < command.seqs.length; ++s) {
                AlignmentAnnotation[] tmp;
                command.seqs[s].sequenceChanged();
                if (modifyVisibility) {
                    int aa;
                    if (!insert) {
                        tmp = command.seqs[s].getAnnotation();
                        if (tmp == null) continue;
                        int alen = tmp.length;
                        for (int aa2 = 0; aa2 < tmp.length; ++aa2) {
                            if (command.al.deleteAnnotation(tmp[aa2])) continue;
                            tmp[aa2] = null;
                            --alen;
                        }
                        command.seqs[s].setAlignmentAnnotation(null);
                        if (alen != tmp.length) {
                            AlignmentAnnotation[] saved = new AlignmentAnnotation[alen];
                            int aapos = 0;
                            for (int aa3 = 0; aa3 < tmp.length; ++aa3) {
                                if (tmp[aa3] == null) continue;
                                saved[aapos++] = tmp[aa3];
                                tmp[aa3] = null;
                            }
                            tmp = saved;
                            command.deletedAnnotationRows.put(command.seqs[s], saved);
                            for (int alview = 0; views != null && alview < views.length; ++alview) {
                                AlignmentAnnotation[] toremove;
                                if (views[alview] == command.al || (toremove = views[alview].getAlignmentAnnotation()) == null || toremove.length == 0) continue;
                                for (int aa4 = 0; aa4 < toremove.length; ++aa4) {
                                    if (toremove[aa4].sequenceRef != command.seqs[s]) continue;
                                    views[alview].deleteAnnotation(toremove[aa4]);
                                }
                            }
                            continue;
                        }
                        command.deletedAnnotationRows.put(command.seqs[s], tmp);
                        continue;
                    }
                    if (command.deletedAnnotationRows == null || !command.deletedAnnotationRows.containsKey(command.seqs[s])) continue;
                    AlignmentAnnotation[] revealed = command.deletedAnnotationRows.get(command.seqs[s]);
                    command.seqs[s].setAlignmentAnnotation(revealed);
                    if (revealed == null) continue;
                    for (aa = 0; aa < revealed.length; ++aa) {
                        command.al.addAnnotation(revealed[aa]);
                    }
                    for (aa = 0; aa < revealed.length; ++aa) {
                        command.al.setAnnotationIndex(revealed[aa], aa);
                    }
                    for (int vnum = 0; views != null && vnum < views.length; ++vnum) {
                        if (views[vnum] == command.al) continue;
                        int avwidth = views[vnum].getWidth() + 1;
                        for (int a = 0; a < revealed.length; ++a) {
                            AlignmentAnnotation newann = new AlignmentAnnotation(revealed[a]);
                            command.seqs[s].addAlignmentAnnotation(newann);
                            newann.padAnnotation(avwidth);
                            views[vnum].addAnnotation(newann);
                            views[vnum].setAnnotationIndex(newann, a);
                        }
                    }
                    continue;
                }
                if (command.seqs[s].getAnnotation() == null) continue;
                if (aSize == 0) {
                    annotations = command.seqs[s].getAnnotation();
                } else {
                    tmp = new AlignmentAnnotation[aSize + command.seqs[s].getAnnotation().length];
                    System.arraycopy(annotations, 0, tmp, 0, aSize);
                    System.arraycopy(command.seqs[s].getAnnotation(), 0, tmp, aSize, command.seqs[s].getAnnotation().length);
                    annotations = tmp;
                }
                aSize = annotations.length;
            }
        }
        if (annotations == null) {
            return;
        }
        if (!insert) {
            command.deletedAnnotations = new Hashtable<String, Annotation[]>();
        }
        for (int a = 0; a < annotations.length; ++a) {
            Annotation[] deleted;
            Annotation[] temp;
            if (annotations[a].autoCalculated || annotations[a].annotations == null) continue;
            int tSize = 0;
            aSize = annotations[a].annotations.length;
            if (insert) {
                temp = new Annotation[aSize + command.number];
                if (annotations[a].padGaps) {
                    for (int aa = 0; aa < temp.length; ++aa) {
                        temp[aa] = new Annotation("" + command.gapChar, null, ' ', 0.0f);
                    }
                }
            } else {
                tSize = command.position < aSize ? (command.position + command.number >= aSize ? aSize : aSize - command.number) : aSize;
                if (tSize < 0) {
                    tSize = aSize;
                }
                temp = new Annotation[tSize];
            }
            if (insert) {
                if (command.position < annotations[a].annotations.length) {
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, command.position);
                    if (command.deletedAnnotations != null && command.deletedAnnotations.containsKey(annotations[a].annotationId)) {
                        Annotation[] restore = command.deletedAnnotations.get(annotations[a].annotationId);
                        System.arraycopy(restore, 0, temp, command.position, command.number);
                    }
                    System.arraycopy(annotations[a].annotations, command.position, temp, command.position + command.number, aSize - command.position);
                } else if (command.deletedAnnotations != null && command.deletedAnnotations.containsKey(annotations[a].annotationId)) {
                    Annotation[] restore = command.deletedAnnotations.get(annotations[a].annotationId);
                    temp = new Annotation[annotations[a].annotations.length + restore.length];
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, annotations[a].annotations.length);
                    System.arraycopy(restore, 0, temp, annotations[a].annotations.length, restore.length);
                } else {
                    temp = annotations[a].annotations;
                }
            } else if (tSize != aSize || command.position < 2) {
                int copylen = Math.min(command.position, annotations[a].annotations.length);
                if (copylen > 0) {
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, copylen);
                }
                deleted = new Annotation[command.number];
                if (copylen >= command.position && (copylen = Math.min(command.number, annotations[a].annotations.length - command.position)) > 0) {
                    System.arraycopy(annotations[a].annotations, command.position, deleted, 0, copylen);
                }
                command.deletedAnnotations.put(annotations[a].annotationId, deleted);
                if (annotations[a].annotations.length > command.position + command.number) {
                    System.arraycopy(annotations[a].annotations, command.position + command.number, temp, command.position, annotations[a].annotations.length - command.position - command.number);
                }
            } else {
                int dSize = aSize - command.position;
                if (dSize > 0) {
                    deleted = new Annotation[command.number];
                    System.arraycopy(annotations[a].annotations, command.position, deleted, 0, dSize);
                    command.deletedAnnotations.put(annotations[a].annotationId, deleted);
                    tSize = Math.min(annotations[a].annotations.length, command.position);
                    temp = new Annotation[tSize];
                    System.arraycopy(annotations[a].annotations, 0, temp, 0, tSize);
                } else {
                    temp = annotations[a].annotations;
                }
            }
            annotations[a].annotations = temp;
        }
    }

    static final void undoCutFeatures(Edit command, SequenceI seq, int start, int length, boolean sameDatasetSequence) {
        SequenceI sequence = seq.getDatasetSequence();
        if (sequence == null) {
            sequence = seq;
        }
        if (!sameDatasetSequence) {
            seq.getFeatures().shiftFeatures(start + 1, length);
            List<SequenceFeature> sfs = seq.getFeatures().findFeatures(start, start, new String[0]);
            for (SequenceFeature sf : sfs) {
                if (sf.getBegin() != start || command.truncatedFeatures.containsKey(seq) && command.truncatedFeatures.get(seq).contains(sf)) continue;
                SequenceFeature shifted = new SequenceFeature(sf, sf.getBegin() + length, sf.getEnd() + length, sf.getFeatureGroup(), sf.getScore());
                seq.addSequenceFeature(shifted);
                seq.deleteFeature(sf);
            }
        }
        if (command.deletedFeatures != null && command.deletedFeatures.containsKey(seq)) {
            for (SequenceFeature deleted : command.deletedFeatures.get(seq)) {
                sequence.addSequenceFeature(deleted);
            }
        }
        if (command.truncatedFeatures != null && command.truncatedFeatures.containsKey(seq)) {
            for (SequenceFeature amended : command.truncatedFeatures.get(seq)) {
                sequence.deleteFeature(amended);
            }
        }
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public Map<SequenceI, SequenceI> priorState(boolean forUndo) {
        HashMap<SequenceI, SequenceI> result = new HashMap<SequenceI, SequenceI>();
        if (this.getEdits() == null) {
            return result;
        }
        if (forUndo) {
            for (Edit e : this.getEdits()) {
                for (SequenceI seq : e.getSequences()) {
                    SequenceI ds = seq.getDatasetSequence();
                    if (result.containsKey(ds)) continue;
                    Sequence preEdit = new Sequence("", seq.getSequenceAsString(), seq.getStart(), seq.getEnd());
                    preEdit.setDatasetSequence(ds);
                    result.put(ds, preEdit);
                }
            }
            return result;
        }
        ReverseListIterator<Edit> editList = new ReverseListIterator<Edit>(this.getEdits());
        while (editList.hasNext()) {
            Edit oldEdit = (Edit)editList.next();
            Action action = oldEdit.getAction();
            int position = oldEdit.getPosition();
            int number = oldEdit.getNumber();
            char gap = oldEdit.getGapCharacter();
            for (SequenceI seq : oldEdit.getSequences()) {
                SequenceI ds = seq.getDatasetSequence();
                SequenceI preEdit = (SequenceI)result.get(ds);
                if (preEdit == null) {
                    preEdit = new Sequence("", seq.getSequenceAsString(), seq.getStart(), seq.getEnd());
                    preEdit.setDatasetSequence(ds);
                    result.put(ds, preEdit);
                }
                if (ds == null) continue;
                if (action == Action.DELETE_GAP) {
                    preEdit.setSequence(new String(StringUtils.insertCharAt(preEdit.getSequence(), position, number, gap)));
                    continue;
                }
                if (action == Action.INSERT_GAP) {
                    preEdit.setSequence(new String(StringUtils.deleteChars(preEdit.getSequence(), position, position + number)));
                    continue;
                }
                System.err.println("Can't undo edit action " + action);
            }
        }
        return result;
    }

    public Iterator<Edit> getEditIterator(boolean forwards) {
        if (forwards) {
            return this.getEdits().iterator();
        }
        return new ReverseListIterator<Edit>(this.getEdits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cutFeatures(Edit command, SequenceI seq, int fromPosition, int toPosition, boolean cutIsInternal) {
        if (!cutIsInternal) {
            return;
        }
        ArrayList<SequenceFeature> added = new ArrayList<SequenceFeature>();
        ArrayList<SequenceFeature> removed = new ArrayList<SequenceFeature>();
        SequenceFeaturesI featureStore = seq.getFeatures();
        if (toPosition < fromPosition || featureStore == null) {
            return;
        }
        int cutStartPos = fromPosition;
        int cutEndPos = toPosition;
        int cutWidth = cutEndPos - cutStartPos + 1;
        SequenceFeaturesI sequenceFeaturesI = featureStore;
        synchronized (sequenceFeaturesI) {
            List<SequenceFeature> toAmend = featureStore.findFeatures(cutStartPos, cutEndPos, new String[0]);
            for (SequenceFeature contact : featureStore.getContactFeatures(new String[0])) {
                if (contact.getBegin() >= cutStartPos || contact.getEnd() <= cutEndPos) continue;
                toAmend.add(contact);
            }
            for (SequenceFeature sf : toAmend) {
                int sfBegin = sf.getBegin();
                int sfEnd = sf.getEnd();
                int newBegin = sfBegin;
                int newEnd = sfEnd;
                boolean toDelete = false;
                boolean follows = false;
                if (sfBegin >= cutStartPos && sfEnd <= cutEndPos) {
                    toDelete = true;
                } else if (sfBegin < cutStartPos && sfEnd > cutEndPos) {
                    newEnd -= cutWidth;
                } else if (sfEnd <= cutEndPos) {
                    newEnd = cutStartPos - 1;
                    if (sf.isContactFeature()) {
                        toDelete = true;
                    }
                } else if (sfBegin >= cutStartPos) {
                    newBegin = cutIsInternal ? cutStartPos : cutEndPos + 1;
                    newEnd = newBegin + sfEnd - cutEndPos - 1;
                    if (sf.isContactFeature()) {
                        toDelete = true;
                    }
                }
                seq.deleteFeature(sf);
                if (!follows) {
                    removed.add(sf);
                }
                if (toDelete) continue;
                SequenceFeature copy = new SequenceFeature(sf, newBegin, newEnd, sf.getFeatureGroup(), sf.getScore());
                seq.addSequenceFeature(copy);
                if (follows) continue;
                added.add(copy);
            }
            featureStore.shiftFeatures(cutEndPos + 1, -cutWidth);
        }
        if (command.deletedFeatures == null) {
            command.deletedFeatures = new HashMap<SequenceI, List<SequenceFeature>>();
        }
        if (command.truncatedFeatures == null) {
            command.truncatedFeatures = new HashMap<SequenceI, List<SequenceFeature>>();
        }
        command.deletedFeatures.put(seq, removed);
        command.truncatedFeatures.put(seq, added);
    }

    public class Edit {
        private SequenceI[] oldds;
        private Range[] oldStartEnd;
        private boolean fullAlignmentHeight = false;
        private Map<SequenceI, AlignmentAnnotation[]> deletedAnnotationRows;
        private Map<String, Annotation[]> deletedAnnotations;
        private Map<SequenceI, List<SequenceFeature>> deletedFeatures;
        private Map<SequenceI, List<SequenceFeature>> truncatedFeatures;
        private AlignmentI al;
        private final Action command;
        char[][] string;
        SequenceI[] seqs;
        private int[] alIndex;
        private int position;
        private int number;
        private char gapChar;
        private boolean systemGenerated;

        public Edit(Action cmd, SequenceI[] sqs, int pos, int count, char gap) {
            this.command = cmd;
            this.seqs = sqs;
            this.position = pos;
            this.number = count;
            this.gapChar = gap;
        }

        Edit(Action cmd, SequenceI[] sqs, int pos, int count, AlignmentI align) {
            this(cmd, sqs, pos, count, align.getGapCharacter());
            this.al = align;
            this.alIndex = new int[sqs.length];
            for (int i = 0; i < sqs.length; ++i) {
                this.alIndex[i] = align.findIndex(sqs[i]);
            }
            this.fullAlignmentHeight = align.getHeight() == sqs.length;
        }

        Edit(Action cmd, SequenceI[] sqs, int pos, int count, AlignmentI align, String replace) {
            this(cmd, sqs, pos, count, align);
            this.string = new char[sqs.length][];
            for (int i = 0; i < sqs.length; ++i) {
                this.string[i] = replace.toCharArray();
            }
        }

        public SequenceI[] getSequences() {
            return this.seqs;
        }

        public int getPosition() {
            return this.position;
        }

        public Action getAction() {
            return this.command;
        }

        public int getNumber() {
            return this.number;
        }

        public char getGapCharacter() {
            return this.gapChar;
        }

        public void setSystemGenerated(boolean b) {
            this.systemGenerated = b;
        }

        public boolean isSystemGenerated() {
            return this.systemGenerated;
        }
    }

    public static enum Action {
        INSERT_GAP{

            @Override
            public Action getUndoAction() {
                return DELETE_GAP;
            }
        }
        ,
        DELETE_GAP{

            @Override
            public Action getUndoAction() {
                return INSERT_GAP;
            }
        }
        ,
        CUT{

            @Override
            public Action getUndoAction() {
                return PASTE;
            }
        }
        ,
        PASTE{

            @Override
            public Action getUndoAction() {
                return CUT;
            }
        }
        ,
        REPLACE{

            @Override
            public Action getUndoAction() {
                return REPLACE;
            }
        }
        ,
        INSERT_NUC{

            @Override
            public Action getUndoAction() {
                return null;
            }
        };


        public abstract Action getUndoAction();
    }
}

