/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.MemorySetting;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;

public class Launcher {
    private static final String startClass = "jalview.bin.Jalview";
    private static final int maxHeapSizePerCent = 90;
    private static final String maxHeapSizePerCentProperty = "jvmmempc";
    private static final String dockIconPath = "JalviewLogo_Huge.png";

    public static void main(String[] args) {
        boolean bl;
        String javaBin = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBin);
        Object memSetting = null;
        boolean isAMac = System.getProperty("os.name").indexOf("Mac") > -1;
        for (String string : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            command.add(string);
        }
        command.add("-cp");
        command.add(ManagementFactory.getRuntimeMXBean().getClassPath());
        ArrayList<String> arguments = new ArrayList<String>();
        for (String arg : args) {
            arguments.add(arg);
        }
        boolean bl2 = false;
        boolean dockIcon = false;
        boolean dockName = false;
        for (int i = 0; i < command.size(); ++i) {
            String arg = (String)command.get(i);
            if (arg.startsWith("-Xmx")) {
                memSetting = arg;
                bl = true;
                continue;
            }
            if (arg.startsWith("-Xdock:icon")) {
                dockIcon = true;
                continue;
            }
            if (!arg.startsWith("-Xdock:name")) continue;
            dockName = true;
        }
        if (!bl) {
            long maxMemLong = -1L;
            int percent = 90;
            String jvmmempc = System.getProperty(maxHeapSizePerCentProperty);
            try {
                if (jvmmempc != null) {
                    int trypercent = Integer.parseInt(jvmmempc);
                    if (0 < trypercent && trypercent <= 100) {
                        percent = trypercent;
                    } else {
                        System.out.println("Property 'jvmmempc' should be in range 1..100");
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Error parsing jvmmempc '" + jvmmempc + "'");
            }
            try {
                maxMemLong = MemorySetting.memPercent(percent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (maxMemLong > 0L) {
                memSetting = "-Xmx" + Long.toString(maxMemLong);
                command.add((String)memSetting);
            }
        }
        if (isAMac) {
            if (!dockIcon) {
                command.add("-Xdock:icon=JalviewLogo_Huge.png");
            }
            if (!dockName) {
                command.add("-Xdock:name=Jalview");
            }
        }
        command.add(startClass);
        command.addAll(arguments);
        ProcessBuilder builder = new ProcessBuilder(command);
        System.out.println("Running jalview.bin.Jalview with " + (String)(memSetting == null ? "no memSetting" : memSetting));
        try {
            builder.inheritIO();
            Process process = builder.start();
            process.waitFor();
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase().contains("memory")) {
                System.out.println("Caught a memory exception: " + e.getMessage());
                ArrayList<String> commandNoMem = new ArrayList<String>();
                for (int i = 0; i < command.size(); ++i) {
                    if (command.get(i).startsWith("-Xmx")) continue;
                    commandNoMem.add(command.get(i));
                }
                ProcessBuilder builderNoMem = new ProcessBuilder(commandNoMem);
                System.out.println("NO MEM COMMAND: " + String.join((CharSequence)" ", builderNoMem.command()));
                try {
                    builderNoMem.inheritIO();
                    Process processNoMem = builderNoMem.start();
                    processNoMem.waitFor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

