/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.datamodel.AlignmentI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileParse;
import jalview.io.IdentifyFile;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;

public class JalviewLiteURLRetrieve
extends Applet {
    private static final long serialVersionUID = 1L;

    @Override
    public void init() {
        this.setSize(300, 200);
        String file = this.getParameter("file");
        if (file == null) {
            System.out.println("Specify a resource to read on the file parameter");
            return;
        }
        DataSourceType protocol = null;
        try {
            System.out.println("Loading thread started with:\n>>file\n" + file + ">>endfile");
            try {
                boolean rtn = false;
                InputStream is = this.getClass().getResourceAsStream("/" + file);
                if (is != null) {
                    rtn = true;
                    is.close();
                }
                System.err.println("Resource '" + file + "' was " + (rtn ? "" : "not") + " located by classloader.");
                if (rtn) {
                    protocol = DataSourceType.CLASSLOADER;
                }
            }
            catch (Exception ex) {
                System.out.println("Exception checking resources: " + file + " " + ex);
            }
            protocol = file.indexOf("://") > -1 ? DataSourceType.URL : DataSourceType.FILE;
            System.out.println("Trying to get contents of resource:");
            FileParse fp = new FileParse(file, protocol);
            if (fp.isValid()) {
                String ln = null;
                while ((ln = fp.nextLine()) != null) {
                    System.out.print(ln);
                }
            } else {
                System.out.println("Resource at " + file + " cannot be read with protocol==" + protocol);
                return;
            }
            fp.close();
            FileFormatI format = FileFormats.getInstance().forName(this.getParameter("format"));
            if (format == null) {
                format = new IdentifyFile().identify(file, protocol);
                System.out.println("Format is " + format);
            } else {
                System.out.println("User specified Format is " + format);
            }
            AlignmentI al = null;
            try {
                al = new AppletFormatAdapter().readFile(file, protocol, format);
            }
            catch (IOException ex) {
                System.err.println("Failed to open the file.");
                ex.printStackTrace();
            }
            if (al != null) {
                System.out.println(new AppletFormatAdapter().formatSequences(FileFormat.Fasta, al, false));
            }
        }
        catch (Exception e) {
            System.err.println("bailing out : Unexpected exception:");
            e.printStackTrace();
        }
    }
}

