/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.BuildDetails;
import jalview.datamodel.PDBEntry;
import jalview.io.PIRFile;
import jalview.jbgui.GDesktop;
import jalview.schemes.ColourSchemeLoader;
import jalview.schemes.ColourSchemes;
import jalview.schemes.UserColourScheme;
import jalview.structure.StructureImportSettings;
import jalview.urls.IdOrgSettings;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.ws.sifts.SiftsSettings;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class Cache {
    public static final String CASTORLOGLEVEL = "logs.Castor.level";
    public static final String AXISLOGLEVEL = "logs.Axis.level";
    public static final String JALVIEWLOGLEVEL = "logs.Jalview.level";
    public static final String DEFAULT_SIFTS_DOWNLOAD_DIR = System.getProperty("user.home") + File.separatorChar + ".sifts_downloads" + File.separatorChar;
    private static final String DEFAULT_CACHE_THRESHOLD_IN_DAYS = "2";
    private static final String DEFAULT_FAIL_SAFE_PID_THRESHOLD = "30";
    private static final String ID_ORG_FILE = System.getProperty("user.home") + File.separatorChar + ".identifiers.org.ids.json";
    private static final String PDB_DOWNLOAD_FORMAT = PDBEntry.Type.MMCIF.toString();
    private static final String DEFAULT_PDB_FILE_PARSER = StructureImportSettings.StructureParser.JMOL_PARSER.toString();
    private static final DateFormat date_format = SimpleDateFormat.getDateTimeInstance(2, 2, Locale.UK);
    public static Logger log;
    public static Properties applicationProperties;
    static String propertiesFile;
    private static boolean propsAreReadOnly;
    private static int vamsasJarsArePresent;
    private static int groovyJarsArePresent;
    protected static Object tracker;
    protected static Class trackerfocus;
    protected static Class jgoogleanalyticstracker;

    public static void initLogger() {
        if (log != null) {
            return;
        }
        try {
            ConsoleAppender ap = new ConsoleAppender((Layout)new SimpleLayout(), "System.err");
            ap.setName("JalviewLogger");
            Logger.getRootLogger().addAppender((Appender)ap);
            Logger laxis = Logger.getLogger((String)"org.apache.axis");
            Logger lcastor = Logger.getLogger((String)"org.exolab.castor");
            log = Logger.getLogger((String)"jalview.bin.Jalview");
            laxis.setLevel(Level.toLevel((String)Cache.getDefault("logs.Axis.Level", Level.INFO.toString())));
            lcastor.setLevel(Level.toLevel((String)Cache.getDefault("logs.Castor.Level", Level.INFO.toString())));
            lcastor = Logger.getLogger((String)"org.exolab.castor.xml");
            lcastor.setLevel(Level.toLevel((String)Cache.getDefault("logs.Castor.Level", Level.INFO.toString())));
            log.setLevel(Level.toLevel((String)Cache.getDefault(JALVIEWLOGLEVEL, Level.INFO.toString())));
            log.debug((Object)"Jalview Debugging Output Follows.");
        }
        catch (Exception ex) {
            System.err.println("Problems initializing the log4j system\n");
            ex.printStackTrace(System.err);
        }
    }

    public static void loadProperties(String propsFile) {
        propertiesFile = propsFile;
        if (propsFile == null) {
            propertiesFile = System.getProperty("user.home") + File.separatorChar + ".jalview_properties";
        } else {
            propsAreReadOnly = true;
        }
        try {
            InputStream fis;
            try {
                fis = new URL(propertiesFile).openStream();
                System.out.println("Loading jalview properties from : " + propertiesFile);
                System.out.println("Disabling Jalview writing to user's local properties file.");
                propsAreReadOnly = true;
            }
            catch (Exception ex) {
                fis = null;
            }
            if (fis == null) {
                fis = new FileInputStream(propertiesFile);
            }
            applicationProperties.clear();
            applicationProperties.load(fis);
            Cache.deleteBuildProperties();
            fis.close();
        }
        catch (Exception ex) {
            System.out.println("Error reading properties file: " + ex);
        }
        if (Cache.getDefault("USE_PROXY", false)) {
            String proxyServer = Cache.getDefault("PROXY_SERVER", "");
            String proxyPort = Cache.getDefault("PROXY_PORT", "8080");
            System.out.println("Using proxyServer: " + proxyServer + " proxyPort: " + proxyPort);
            System.setProperty("http.proxyHost", proxyServer);
            System.setProperty("http.proxyPort", proxyPort);
        }
        try {
            String authorDetails = "jar:".concat(Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!/authors.props"));
            URL localJarFileURL = new URL(authorDetails);
            InputStream in = localJarFileURL.openStream();
            applicationProperties.load(in);
            in.close();
        }
        catch (Exception ex) {
            System.out.println("Error reading author details: " + ex);
            applicationProperties.remove("AUTHORS");
            applicationProperties.remove("AUTHORFNAMES");
            applicationProperties.remove("YEAR");
        }
        Cache.loadBuildProperties(false);
        SiftsSettings.setMapWithSifts(Cache.getDefault("MAP_WITH_SIFTS", false));
        SiftsSettings.setSiftDownloadDirectory(Cache.getDefault("sifts_download_dir", DEFAULT_SIFTS_DOWNLOAD_DIR));
        SiftsSettings.setFailSafePIDThreshold(Cache.getDefault("sifts_fail_safe_pid_threshold", DEFAULT_FAIL_SAFE_PID_THRESHOLD));
        SiftsSettings.setCacheThresholdInDays(Cache.getDefault("sifts_cache_threshold_in_days", DEFAULT_CACHE_THRESHOLD_IN_DAYS));
        IdOrgSettings.setUrl(Cache.getDefault("ID_ORG_HOSTURL", "http://www.jalview.org/services/identifiers"));
        IdOrgSettings.setDownloadLocation(ID_ORG_FILE);
        StructureImportSettings.setDefaultStructureFileFormat(Cache.getDefault("PDB_DOWNLOAD_FORMAT", PDB_DOWNLOAD_FORMAT));
        StructureImportSettings.setDefaultPDBFileParser(DEFAULT_PDB_FILE_PARSER);
        String jnlpVersion = System.getProperty("jalview.version");
        if (jnlpVersion == null && Cache.getDefault("VERSION_CHECK", true) && (System.getProperty("java.awt.headless") == null || System.getProperty("java.awt.headless").equals("false"))) {
            class VersionChecker
            extends Thread {
                VersionChecker() {
                }

                @Override
                public void run() {
                    String orgtimeout = System.getProperty("sun.net.client.defaultConnectTimeout");
                    if (orgtimeout == null) {
                        orgtimeout = Cache.DEFAULT_FAIL_SAFE_PID_THRESHOLD;
                        System.out.println("# INFO: Setting default net timeout to " + orgtimeout + " seconds.");
                    }
                    String remoteVersion = null;
                    try {
                        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
                        URL url = new URL(Cache.getDefault("www.jalview.org", "http://www.jalview.org") + "/webstart/jalview.jnlp");
                        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            if (line.indexOf("jalview.version") == -1) continue;
                            line = line.substring(line.indexOf("value=") + 7);
                            remoteVersion = line = line.substring(0, line.lastIndexOf("\""));
                            break;
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("Non-fatal exception when checking version at www.jalview.org :");
                        System.out.println(ex);
                        remoteVersion = Cache.getProperty("VERSION");
                    }
                    System.setProperty("sun.net.client.defaultConnectTimeout", orgtimeout);
                    Cache.setProperty("LATEST_VERSION", remoteVersion);
                }
            }
            VersionChecker vc = new VersionChecker();
            vc.start();
        } else if (jnlpVersion != null) {
            Cache.setProperty("LATEST_VERSION", jnlpVersion);
        } else {
            applicationProperties.remove("LATEST_VERSION");
        }
        Cache.initUserColourSchemes(Cache.getProperty("USER_DEFINED_COLOURS"));
        PIRFile.useModellerOutput = Cache.getDefault("PIR_MODELLER", false);
    }

    public static void loadBuildProperties(boolean reportVersion) {
        Object codeInstallation = Cache.getProperty("INSTALLATION");
        boolean printV = codeInstallation == null;
        try {
            String buildDetails = "jar:".concat(Cache.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!/.build_properties"));
            URL localJarFileURL = new URL(buildDetails);
            InputStream in = localJarFileURL.openStream();
            applicationProperties.load(in);
            in.close();
        }
        catch (Exception ex) {
            System.out.println("Error reading build details: " + ex);
            applicationProperties.remove("VERSION");
        }
        String codeVersion = Cache.getProperty("VERSION");
        codeInstallation = Cache.getProperty("INSTALLATION");
        if (codeVersion == null) {
            codeVersion = "Test";
            codeInstallation = "";
        } else {
            codeInstallation = " (" + (String)codeInstallation + ")";
        }
        Cache.setProperty("VERSION", codeVersion);
        new BuildDetails(codeVersion, null, (String)codeInstallation);
        if (printV && reportVersion) {
            System.out.println("Jalview Version: " + codeVersion + (String)codeInstallation);
        }
    }

    private static void deleteBuildProperties() {
        applicationProperties.remove("LATEST_VERSION");
        applicationProperties.remove("VERSION");
        applicationProperties.remove("AUTHORS");
        applicationProperties.remove("AUTHORFNAMES");
        applicationProperties.remove("YEAR");
        applicationProperties.remove("BUILD_DATE");
        applicationProperties.remove("INSTALLATION");
    }

    public static String getProperty(String key) {
        return applicationProperties.getProperty(key);
    }

    public static boolean getDefault(String property, boolean def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            def = Boolean.valueOf(string);
        }
        return def;
    }

    public static int getDefault(String property, int def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            try {
                def = Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                System.out.println("Error parsing int property '" + property + "' with value '" + string + "'");
            }
        }
        return def;
    }

    public static String getDefault(String property, String def) {
        String string = Cache.getProperty(property);
        if (string != null) {
            return string;
        }
        return def;
    }

    public static Object setProperty(String key, String obj) {
        Object oldValue = null;
        try {
            oldValue = applicationProperties.setProperty(key, obj);
            if (propertiesFile != null && !propsAreReadOnly) {
                FileOutputStream out = new FileOutputStream(propertiesFile);
                applicationProperties.store(out, "---JalviewX Properties File---");
                out.close();
            }
        }
        catch (Exception ex) {
            System.out.println("Error setting property: " + key + " " + obj + "\n" + ex);
        }
        return oldValue;
    }

    public static void removeProperty(String string) {
        applicationProperties.remove(string);
        Cache.saveProperties();
    }

    public static void saveProperties() {
        if (!propsAreReadOnly) {
            try {
                FileOutputStream out = new FileOutputStream(propertiesFile);
                applicationProperties.store(out, "---JalviewX Properties File---");
                out.close();
            }
            catch (Exception ex) {
                System.out.println("Error saving properties: " + ex);
            }
        }
    }

    public static boolean vamsasJarsPresent() {
        if (vamsasJarsArePresent == -1) {
            try {
                if (GDesktop.class.getClassLoader().loadClass("uk.ac.vamsas.client.VorbaId") != null) {
                    log.debug((Object)"Found Vamsas Classes (uk.ac..vamsas.client.VorbaId can be loaded)");
                    vamsasJarsArePresent = 1;
                    Logger lvclient = Logger.getLogger((String)"uk.ac.vamsas");
                    lvclient.setLevel(Level.toLevel((String)Cache.getDefault("logs.Vamsas.Level", Level.INFO.toString())));
                    lvclient.addAppender(log.getAppender("JalviewLogger"));
                    lvclient.debug((Object)"Jalview Vamsas Client Debugging Output Follows.");
                }
            }
            catch (Exception e) {
                vamsasJarsArePresent = 0;
                log.debug((Object)"Vamsas Classes are not present");
            }
        }
        return vamsasJarsArePresent > 0;
    }

    public static boolean groovyJarsPresent() {
        if (groovyJarsArePresent == -1) {
            try {
                if (Cache.class.getClassLoader().loadClass("groovy.lang.GroovyObject") != null) {
                    log.debug((Object)"Found Groovy (groovy.lang.GroovyObject can be loaded)");
                    groovyJarsArePresent = 1;
                    Logger lgclient = Logger.getLogger((String)"groovy");
                    lgclient.setLevel(Level.toLevel((String)Cache.getDefault("logs.Groovy.Level", Level.INFO.toString())));
                    lgclient.addAppender(log.getAppender("JalviewLogger"));
                    lgclient.debug((Object)"Jalview Groovy Client Debugging Output Follows.");
                }
            }
            catch (Error e) {
                groovyJarsArePresent = 0;
                log.debug((Object)"Groovy Classes are not present", (Throwable)e);
            }
            catch (Exception e) {
                groovyJarsArePresent = 0;
                log.debug((Object)"Groovy Classes are not present");
            }
        }
        return groovyJarsArePresent > 0;
    }

    public static void initGoogleTracker() {
        if (tracker == null) {
            if (jgoogleanalyticstracker == null) {
                try {
                    jgoogleanalyticstracker = Cache.class.getClassLoader().loadClass("com.boxysystems.jgoogleanalytics.JGoogleAnalyticsTracker");
                    trackerfocus = Cache.class.getClassLoader().loadClass("com.boxysystems.jgoogleanalytics.FocusPoint");
                }
                catch (Exception e) {
                    log.debug((Object)"com.boxysystems.jgoogleanalytics package is not present - tracking not enabled.");
                    tracker = null;
                    jgoogleanalyticstracker = null;
                    trackerfocus = null;
                    return;
                }
            }
            RuntimeException re = null;
            Exception ex = null;
            Error err = null;
            Object vrs = "No Version Accessible";
            try {
                tracker = jgoogleanalyticstracker.getConstructor(String.class, String.class, String.class).newInstance("Jalview Desktop", vrs = Cache.getProperty("VERSION") + "_" + Cache.getDefault("BUILD_DATE", "unknown"), "UA-9060947-1");
                jgoogleanalyticstracker.getMethod("trackAsynchronously", trackerfocus).invoke(tracker, trackerfocus.getConstructor(String.class).newInstance("Application Started."));
            }
            catch (RuntimeException e) {
                re = e;
            }
            catch (Exception e) {
                ex = e;
            }
            catch (Error e) {
                err = e;
            }
            if (re != null || ex != null || err != null) {
                if (log != null) {
                    if (re != null) {
                        log.debug((Object)"Caught runtime exception in googletracker init:", (Throwable)re);
                    }
                    if (ex != null) {
                        log.warn((Object)("Failed to initialise GoogleTracker for Jalview Desktop with version " + (String)vrs), (Throwable)ex);
                    }
                    if (err != null) {
                        log.error((Object)("Whilst initing GoogleTracker for Jalview Desktop version " + (String)vrs), (Throwable)err);
                    }
                } else {
                    if (re != null) {
                        System.err.println("Debug: Caught runtime exception in googletracker init:" + (String)vrs);
                        re.printStackTrace();
                    }
                    if (ex != null) {
                        System.err.println("Warning:  Failed to initialise GoogleTracker for Jalview Desktop with version " + (String)vrs);
                        ex.printStackTrace();
                    }
                    if (err != null) {
                        System.err.println("ERROR: Whilst initing GoogleTracker for Jalview Desktop version " + (String)vrs);
                        err.printStackTrace();
                    }
                }
            } else {
                log.debug((Object)"Successfully initialised tracker.");
            }
        }
    }

    public static Color getDefaultColour(String property, Color defcolour) {
        String colprop = Cache.getProperty(property);
        if (colprop == null) {
            return defcolour;
        }
        Color col = ColorUtils.parseColourString(colprop);
        if (col == null) {
            log.warn((Object)("Couldn't parse '" + colprop + "' as a colour for " + property));
        }
        return col == null ? defcolour : col;
    }

    public static void setColourProperty(String property, Color colour) {
        Cache.setProperty(property, Format.getHexString(colour));
    }

    public static String setDateProperty(String propertyName, Date date) {
        String formatted = date_format.format(date);
        Cache.setProperty(propertyName, formatted);
        return formatted;
    }

    public static Date getDateProperty(String propertyName) {
        String val = Cache.getProperty(propertyName);
        if (val != null) {
            try {
                return date_format.parse(val);
            }
            catch (Exception ex) {
                System.err.println("Invalid or corrupt date in property '" + propertyName + "' : value was '" + val + "'");
            }
        }
        return null;
    }

    public static Integer getIntegerProperty(String property) {
        String val = Cache.getProperty(property);
        if (val != null && (val = val.trim()).length() > 0) {
            try {
                return Integer.valueOf(val);
            }
            catch (NumberFormatException x) {
                System.err.println("Invalid integer in property '" + property + "' (value was '" + val + "')");
            }
        }
        return null;
    }

    public static void setOrRemove(String propName, String value) {
        if (propName == null) {
            return;
        }
        if (value == null || value.trim().length() < 1) {
            applicationProperties.remove(propName);
        } else {
            applicationProperties.setProperty(propName, value);
        }
    }

    public static void initUserColourSchemes(String files) {
        if (files == null || files.length() == 0) {
            return;
        }
        StringBuffer coloursFound = new StringBuffer();
        StringTokenizer st = new StringTokenizer(files, "|");
        while (st.hasMoreElements()) {
            String file = st.nextToken();
            try {
                UserColourScheme ucs = ColourSchemeLoader.loadColourScheme(file);
                if (ucs == null) continue;
                if (coloursFound.length() > 0) {
                    coloursFound.append("|");
                }
                coloursFound.append(file);
                ColourSchemes.getInstance().registerColourScheme(ucs);
            }
            catch (Exception ex) {
                System.out.println("Error loading User ColourFile\n" + ex);
            }
        }
        if (!files.equals(coloursFound.toString())) {
            if (coloursFound.toString().length() > 1) {
                Cache.setProperty("USER_DEFINED_COLOURS", coloursFound.toString());
            } else {
                applicationProperties.remove("USER_DEFINED_COLOURS");
            }
        }
    }

    public static String getVersionDetailsForConsole() {
        return "Jalview Version: " + Cache.getDefault("VERSION", "TEST") + "\nJalview Installation: " + Cache.getDefault("INSTALLATION", "unknown") + "\nBuild Date: " + Cache.getDefault("BUILD_DATE", "unknown") + "\nJava version: " + System.getProperty("java.version") + "\n" + System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + (String)(Cache.getDefault("VERSION", "TEST").equals("DEVELOPMENT") ? "\nGetdown appdir: " + System.getProperty("getdownappdir") + "\nJava path: " + System.getProperty("java.home") + File.separator + "bin" + File.separator + "java" : "");
    }

    public static String getBuildDetailsForSplash() {
        return Cache.getDefault("INSTALLATION", "unknown");
    }

    static {
        applicationProperties = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        propsAreReadOnly = false;
        vamsasJarsArePresent = -1;
        groovyJarsArePresent = -1;
        tracker = null;
        trackerfocus = null;
        jgoogleanalyticstracker = null;
    }
}

