/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class TitledPanel
extends Panel {
    private String title;
    private Insets insets = new Insets(10, 10, 10, 10);

    public TitledPanel() {
        this("");
    }

    public TitledPanel(String title) {
        this.setTitle(title);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(this.getForeground());
        g.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        int width = g.getFontMetrics().stringWidth(this.getTitle());
        g.setColor(this.getBackground());
        g.fillRect(10, 0, width, 10);
        g.setColor(this.getForeground());
        g.drawString(this.getTitle(), 10, 10);
    }

    public static void main(String[] args) {
        Frame f = new Frame("TitledPanel Tester");
        TitledPanel p = new TitledPanel("Title of Panel");
        p.add(new Label("Label 1"));
        p.add(new Label("Label 2"));
        p.add(new Label("Label 3"));
        f.add(p);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setBounds(300, 300, 300, 300);
        f.setVisible(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

