/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AnnotationPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.renderer.ScaleRenderer;
import jalview.util.Comparison;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.ViewportListenerI;
import jalview.viewmodel.ViewportRanges;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;

public class SeqCanvas
extends Panel
implements ViewportListenerI {
    FeatureRenderer fr;
    SequenceRenderer sr;
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    AlignViewport av;
    boolean fastPaint = false;
    int cursorX = 0;
    int cursorY = 0;
    int avcharHeight = 0;
    int avcharWidth = 0;
    int lastsr = 0;
    int LABEL_WEST;
    int LABEL_EAST;
    AnnotationPanel annotations;

    public SeqCanvas(AlignViewport av) {
        this.av = av;
        this.fr = new FeatureRenderer(av);
        this.sr = new SequenceRenderer(av);
        PaintRefresher.Register(this, av.getSequenceSetId());
        this.updateViewport();
        av.getRanges().addPropertyChangeListener(this);
    }

    private void updateViewport() {
        this.avcharHeight = this.av.getCharHeight();
        this.avcharWidth = this.av.getCharWidth();
    }

    public AlignmentViewport getViewport() {
        return this.av;
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.fr;
    }

    public SequenceRenderer getSequenceRenderer() {
        return this.sr;
    }

    private void drawNorthScale(Graphics g, int startx, int endx, int ypos) {
        this.updateViewport();
        g.setColor(Color.black);
        for (ScaleRenderer.ScaleMark mark : new ScaleRenderer().calculateMarks(this.av, startx, endx)) {
            int mpos = mark.column;
            if (mpos < 0) continue;
            String mstring = mark.text;
            if (!mark.major) continue;
            if (mstring != null) {
                g.drawString(mstring, mpos * this.avcharWidth, ypos - this.avcharHeight / 2);
            }
            g.drawLine(mpos * this.avcharWidth + this.avcharWidth / 2, ypos + 2 - this.avcharHeight / 2, mpos * this.avcharWidth + this.avcharWidth / 2, ypos - 2);
        }
    }

    private void drawWestScale(Graphics g, int startx, int endx, int ypos) {
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        ypos += this.avcharHeight;
        if (this.av.hasHiddenColumns()) {
            startx = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(startx);
            endx = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(endx);
        }
        for (int i = 0; i < this.av.getAlignment().getHeight(); ++i) {
            SequenceI seq = this.av.getAlignment().getSequenceAt(i);
            int value = -1;
            for (int index = startx; index < endx; ++index) {
                if (Comparison.isGap(seq.getCharAt(index))) {
                    continue;
                }
                value = this.av.getAlignment().getSequenceAt(i).findPosition(index);
                break;
            }
            if (value == -1) continue;
            int x = this.LABEL_WEST - fm.stringWidth(String.valueOf(value)) - this.avcharWidth / 2;
            g.drawString("" + value, x, ypos + i * this.avcharHeight - this.avcharHeight / 5);
        }
    }

    private void drawEastScale(Graphics g, int startx, int endx, int ypos) {
        ypos += this.avcharHeight;
        if (this.av.hasHiddenColumns()) {
            endx = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(endx);
        }
        for (int i = 0; i < this.av.getAlignment().getHeight(); ++i) {
            SequenceI seq = this.av.getAlignment().getSequenceAt(i);
            int value = -1;
            for (int index = endx; index > startx; --index) {
                if (Comparison.isGap(seq.getCharAt(index))) {
                    continue;
                }
                value = seq.findPosition(index);
                break;
            }
            if (value == -1) continue;
            g.drawString(String.valueOf(value), 0, ypos + i * this.avcharHeight - this.avcharHeight / 5);
        }
    }

    void fastPaint(int horizontal, int vertical) {
        if (this.fastPaint || this.gg == null) {
            return;
        }
        ViewportRanges ranges = this.av.getRanges();
        this.updateViewport();
        if (this.lastsr + horizontal != ranges.getStartRes()) {
            horizontal = ranges.getStartRes() - this.lastsr;
        }
        this.lastsr = ranges.getStartRes();
        this.fastPaint = true;
        this.gg.copyArea(horizontal * this.avcharWidth, vertical * this.avcharHeight, this.imgWidth - horizontal * this.avcharWidth, this.imgHeight - vertical * this.avcharHeight, -horizontal * this.avcharWidth, -vertical * this.avcharHeight);
        int sr = ranges.getStartRes();
        int er = ranges.getEndRes();
        int ss = ranges.getStartSeq();
        int es = ranges.getEndSeq();
        int transX = 0;
        int transY = 0;
        if (horizontal > 0) {
            transX = (er - sr - horizontal) * this.avcharWidth;
            sr = er - horizontal;
        } else if (horizontal < 0) {
            er = sr - horizontal;
        } else if (vertical > 0) {
            ss = es - vertical;
            if (ss < ranges.getStartSeq()) {
                ss = ranges.getStartSeq();
            } else {
                transY = this.imgHeight - (vertical + 1) * this.avcharHeight;
            }
        } else if (vertical < 0 && (es = ss - vertical) > ranges.getEndSeq()) {
            es = ranges.getEndSeq();
        }
        this.gg.translate(transX, transY);
        this.drawPanel(this.gg, sr, er, ss, es, 0);
        this.gg.translate(-transX, -transY);
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.img != null && (this.fastPaint || this.getSize().width != g.getClipBounds().width || this.getSize().height != g.getClipBounds().height)) {
            g.drawImage(this.img, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        if (this.fastPaint) {
            g.drawImage(this.img, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.updateViewport();
        this.imgWidth = this.getSize().width;
        this.imgHeight = this.getSize().height;
        this.imgWidth -= this.imgWidth % this.avcharWidth;
        this.imgHeight -= this.imgHeight % this.avcharHeight;
        if (this.imgWidth < 1 || this.imgHeight < 1) {
            return;
        }
        if (this.img == null || this.imgWidth != this.img.getWidth(this) || this.imgHeight != this.img.getHeight(this)) {
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setFont(this.av.getFont());
        }
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.imgWidth, this.imgHeight);
        ViewportRanges ranges = this.av.getRanges();
        if (this.av.getWrapAlignment()) {
            this.drawWrappedPanel(this.gg, this.imgWidth, this.imgHeight, ranges.getStartRes());
        } else {
            this.drawPanel(this.gg, ranges.getStartRes(), ranges.getEndRes(), ranges.getStartSeq(), ranges.getEndSeq(), 0);
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public int getWrappedCanvasWidth(int cwidth) {
        cwidth -= cwidth % this.av.getCharWidth();
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.LABEL_EAST = 0;
        this.LABEL_WEST = 0;
        if (this.av.getScaleRightWrapped()) {
            this.LABEL_EAST = fm.stringWidth(this.getMask());
        }
        if (this.av.getScaleLeftWrapped()) {
            this.LABEL_WEST = fm.stringWidth(this.getMask());
        }
        return (cwidth - this.LABEL_EAST - this.LABEL_WEST) / this.av.getCharWidth();
    }

    String getMask() {
        int i;
        Object mask = "0";
        int maxWidth = 0;
        AlignmentI alignment = this.av.getAlignment();
        for (i = 0; i < alignment.getHeight(); ++i) {
            int tmp = alignment.getSequenceAt(i).getEnd();
            if (tmp <= maxWidth) continue;
            maxWidth = tmp;
        }
        for (i = maxWidth; i > 0; i /= 10) {
            mask = (String)mask + "0";
        }
        return mask;
    }

    private void drawWrappedPanel(Graphics g, int canvasWidth, int canvasHeight, int startRes) {
        AlignmentI al = this.av.getAlignment();
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.LABEL_EAST = 0;
        this.LABEL_WEST = 0;
        if (this.av.getScaleRightWrapped()) {
            this.LABEL_EAST = fm.stringWidth(this.getMask());
        }
        if (this.av.getScaleLeftWrapped()) {
            this.LABEL_WEST = fm.stringWidth(this.getMask());
        }
        int hgap = this.avcharHeight;
        if (this.av.getScaleAboveWrapped()) {
            hgap += this.avcharHeight;
        }
        int cWidth = (canvasWidth - this.LABEL_EAST - this.LABEL_WEST) / this.avcharWidth;
        int cHeight = this.av.getAlignment().getHeight() * this.avcharHeight;
        this.av.setWrappedWidth(cWidth);
        this.av.getRanges().setViewportStartAndWidth(startRes, cWidth);
        int maxwidth = this.av.getAlignment().getVisibleWidth();
        for (int ypos = hgap; ypos <= canvasHeight && startRes < maxwidth; ypos += cHeight + this.getAnnotationHeight() + hgap, startRes += cWidth) {
            int endx = startRes + cWidth - 1;
            if (endx > maxwidth) {
                endx = maxwidth;
            }
            g.setColor(Color.black);
            if (this.av.getScaleLeftWrapped()) {
                this.drawWestScale(g, startRes, endx, ypos);
            }
            if (this.av.getScaleRightWrapped()) {
                g.translate(canvasWidth - this.LABEL_EAST, 0);
                this.drawEastScale(g, startRes, endx, ypos);
                g.translate(-(canvasWidth - this.LABEL_EAST), 0);
            }
            g.translate(this.LABEL_WEST, 0);
            if (this.av.getScaleAboveWrapped()) {
                this.drawNorthScale(g, startRes, endx, ypos);
            }
            if (this.av.hasHiddenColumns() && this.av.getShowHiddenMarkers()) {
                HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
                g.setColor(Color.blue);
                Iterator<Integer> it = hidden.getStartRegionIterator(startRes, endx + 1);
                while (it.hasNext()) {
                    int res = it.next() - startRes;
                    this.gg.fillPolygon(new int[]{res * this.avcharWidth - this.avcharHeight / 4, res * this.avcharWidth + this.avcharHeight / 4, res * this.avcharWidth}, new int[]{ypos - this.avcharHeight / 2, ypos - this.avcharHeight / 2, ypos - this.avcharHeight / 2 + 8}, 3);
                }
            }
            if (g.getClip() == null) {
                g.setClip(0, 0, cWidth * this.avcharWidth, canvasHeight);
            }
            this.drawPanel(g, startRes, endx, 0, al.getHeight() - 1, ypos);
            g.setClip(null);
            if (this.av.isShowAnnotation()) {
                g.translate(0, cHeight + ypos + 4);
                if (this.annotations == null) {
                    this.annotations = new AnnotationPanel(this.av);
                }
                this.annotations.drawComponent(g, startRes, endx + 1);
                g.translate(0, -cHeight - ypos - 4);
            }
            g.translate(-this.LABEL_WEST, 0);
        }
    }

    int getAnnotationHeight() {
        if (!this.av.isShowAnnotation()) {
            return 0;
        }
        if (this.annotations == null) {
            this.annotations = new AnnotationPanel(this.av);
        }
        return this.annotations.adjustPanelHeight();
    }

    private void drawPanel(Graphics g1, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        if (!this.av.hasHiddenColumns()) {
            this.draw(g1, startRes, endRes, startSeq, endSeq, offset);
        } else {
            int screenY = 0;
            HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
            VisibleContigsIterator regions = hidden.getVisContigsIterator(startRes, endRes + 1, true);
            while (regions.hasNext()) {
                int[] region = regions.next();
                int blockEnd = region[1];
                int blockStart = region[0];
                g1.translate(screenY * this.avcharWidth, 0);
                this.draw(g1, blockStart, blockEnd, startSeq, endSeq, offset);
                if (this.av.getShowHiddenMarkers() && (regions.hasNext() || regions.endsAtHidden())) {
                    g1.setColor(Color.blue);
                    g1.drawLine((blockEnd - blockStart + 1) * this.avcharWidth - 1, 0 + offset, (blockEnd - blockStart + 1) * this.avcharWidth - 1, (endSeq - startSeq + 1) * this.avcharHeight + offset);
                }
                g1.translate(-screenY * this.avcharWidth, 0);
                screenY += blockEnd - blockStart + 1;
            }
        }
    }

    void draw(Graphics g, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        g.setFont(this.av.getFont());
        this.sr.prepare(g, this.av.isRenderGaps());
        this.updateViewport();
        for (int i = startSeq; i <= endSeq; ++i) {
            int[] visibleResults;
            SequenceI nextSeq = this.av.getAlignment().getSequenceAt(i);
            if (nextSeq == null) continue;
            this.sr.drawSequence(nextSeq, this.av.getAlignment().findAllGroups(nextSeq), startRes, endRes, offset + (i - startSeq) * this.avcharHeight);
            if (this.av.isShowSequenceFeatures()) {
                this.fr.drawSequence(g, nextSeq, startRes, endRes, offset + (i - startSeq) * this.avcharHeight, false);
            }
            if (this.av.hasSearchResults() && (visibleResults = this.av.getSearchResults().getResults(nextSeq, startRes, endRes)) != null) {
                for (int r = 0; r < visibleResults.length; r += 2) {
                    this.sr.drawHighlightedText(nextSeq, visibleResults[r], visibleResults[r + 1], (visibleResults[r] - startRes) * this.avcharWidth, offset + (i - startSeq) * this.avcharHeight);
                }
            }
            if (!this.av.cursorMode || this.cursorY != i || this.cursorX < startRes || this.cursorX > endRes) continue;
            this.sr.drawCursor(nextSeq, this.cursorX, (this.cursorX - startRes) * this.avcharWidth, offset + (i - startSeq) * this.avcharHeight);
        }
        if (this.av.getSelectionGroup() != null || this.av.getAlignment().getGroups().size() > 0) {
            this.drawGroupsBoundaries(g, startRes, endRes, startSeq, endSeq, offset);
        }
    }

    private void drawGroupsBoundaries(Graphics g, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        SequenceGroup group = this.av.getSelectionGroup();
        int sx = -1;
        int sy = -1;
        int ex = -1;
        int groupIndex = -1;
        if (group == null && this.av.getAlignment().getGroups().size() > 0) {
            group = this.av.getAlignment().getGroups().get(0);
            groupIndex = 0;
        }
        if (group != null) {
            do {
                int oldY = -1;
                int i = 0;
                boolean inGroup = false;
                int top = -1;
                int bottom = -1;
                int alHeight = this.av.getAlignment().getHeight() - 1;
                for (i = startSeq; i <= endSeq; ++i) {
                    sx = (group.getStartRes() - startRes) * this.avcharWidth;
                    sy = offset + (i - startSeq) * this.avcharHeight;
                    ex = (group.getEndRes() + 1 - group.getStartRes()) * this.avcharWidth - 1;
                    if (sx + ex < 0 || sx > this.imgWidth) continue;
                    if (sx <= (endRes - startRes) * this.avcharWidth && group.getSequences(null).contains(this.av.getAlignment().getSequenceAt(i))) {
                        if (!(bottom != -1 || i < alHeight && group.getSequences(null).contains(this.av.getAlignment().getSequenceAt(i + 1)))) {
                            bottom = sy + this.avcharHeight;
                        }
                        if (inGroup) continue;
                        if (top == -1 && i == 0 || !group.getSequences(null).contains(this.av.getAlignment().getSequenceAt(i - 1))) {
                            top = sy;
                        }
                        oldY = sy;
                        inGroup = true;
                        if (group == this.av.getSelectionGroup()) {
                            g.setColor(Color.red);
                            continue;
                        }
                        g.setColor(group.getOutlineColour());
                        continue;
                    }
                    if (!inGroup) continue;
                    if (sx >= 0 && sx < this.imgWidth) {
                        g.drawLine(sx, oldY, sx, sy);
                    }
                    if (sx + ex < this.imgWidth) {
                        g.drawLine(sx + ex, oldY, sx + ex, sy);
                    }
                    if (sx < 0) {
                        ex += sx;
                        sx = 0;
                    }
                    if (sx + ex > this.imgWidth) {
                        ex = this.imgWidth;
                    } else if (sx + ex >= (endRes - startRes + 1) * this.avcharWidth) {
                        ex = (endRes - startRes + 1) * this.avcharWidth;
                    }
                    if (top != -1) {
                        g.drawLine(sx, top, sx + ex, top);
                        top = -1;
                    }
                    if (bottom != -1) {
                        g.drawLine(sx, bottom, sx + ex, bottom);
                        bottom = -1;
                    }
                    inGroup = false;
                }
                if (inGroup) {
                    sy = offset + (i - startSeq) * this.avcharHeight;
                    if (sx >= 0 && sx < this.imgWidth) {
                        g.drawLine(sx, oldY, sx, sy);
                    }
                    if (sx + ex < this.imgWidth) {
                        g.drawLine(sx + ex, oldY, sx + ex, sy);
                    }
                    if (sx < 0) {
                        ex += sx;
                        sx = 0;
                    }
                    if (sx + ex > this.imgWidth) {
                        ex = this.imgWidth;
                    } else if (sx + ex >= (endRes - startRes + 1) * this.avcharWidth) {
                        ex = (endRes - startRes + 1) * this.avcharWidth;
                    }
                    if (top != -1) {
                        g.drawLine(sx, top, sx + ex, top);
                        top = -1;
                    }
                    if (bottom != -1) {
                        g.drawLine(sx, bottom - 1, sx + ex, bottom - 1);
                        bottom = -1;
                    }
                    inGroup = false;
                }
                if (++groupIndex >= this.av.getAlignment().getGroups().size()) break;
                group = this.av.getAlignment().getGroups().get(groupIndex);
            } while (groupIndex < this.av.getAlignment().getGroups().size());
        }
    }

    public void highlightSearchResults(SearchResultsI results) {
        this.av.setSearchResults(results);
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String eventName = evt.getPropertyName();
        if (eventName.equals("Sequence group changed")) {
            this.fastPaint = true;
            this.repaint();
            return;
        }
        if (eventName.equals("move_viewport")) {
            this.fastPaint = false;
            this.repaint();
            return;
        }
        if (!this.av.getWrapAlignment()) {
            int scrollX = 0;
            if (eventName.equals("startres") || eventName.equals("startresandseq")) {
                ViewportRanges vpRanges;
                int range;
                scrollX = eventName.equals("startres") ? (Integer)evt.getNewValue() - (Integer)evt.getOldValue() : ((int[])evt.getNewValue())[0] - ((int[])evt.getOldValue())[0];
                if (scrollX > (range = (vpRanges = this.av.getRanges()).getEndRes() - vpRanges.getStartRes())) {
                    scrollX = range;
                } else if (scrollX < -range) {
                    scrollX = -range;
                }
            }
            if (eventName.equals("startres")) {
                this.fastPaint(scrollX, 0);
            } else if (eventName.equals("startseq")) {
                this.fastPaint(0, (Integer)evt.getNewValue() - (Integer)evt.getOldValue());
            } else if (eventName.equals("startresandseq")) {
                this.fastPaint(scrollX, 0);
            }
        }
    }
}

