/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AlignSeq;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.SliderPanel;
import jalview.bin.JalviewLite;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;

public class RedundancyPanel
extends SliderPanel
implements Runnable,
WindowListener {
    Stack historyList = new Stack();
    float[] redundancy;
    SequenceI[] originalSequences;
    Frame frame;
    Vector redundantSeqs = new Vector();

    public RedundancyPanel(AlignmentPanel ap) {
        super(ap, 0, false, null);
        this.ap = ap;
        this.undoButton.setVisible(true);
        this.applyButton.setVisible(true);
        this.allGroupsCheck.setVisible(false);
        this.label.setText(MessageManager.getString("label.enter_redundancy_threshold"));
        this.valueField.setText("100");
        this.slider.setVisibleAmount(1);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100 + this.slider.getVisibleAmount());
        this.slider.setValue(100);
        this.slider.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent evt) {
                RedundancyPanel.this.valueField.setText(String.valueOf(RedundancyPanel.this.slider.getValue()));
                RedundancyPanel.this.sliderValueChanged();
            }
        });
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, MessageManager.getString("label.redundancy_threshold_selection"), 400, 100);
        this.frame.addWindowListener(this);
        Thread worker = new Thread(this);
        worker.start();
    }

    @Override
    public void run() {
        int end;
        int start;
        this.label.setText(MessageManager.getString("label.calculating"));
        this.slider.setVisible(false);
        this.applyButton.setEnabled(false);
        this.valueField.setVisible(false);
        this.validate();
        String[] omitHidden = null;
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null && sg.getSize() >= 1) {
            this.originalSequences = sg.getSequencesInOrder(this.ap.av.getAlignment());
            start = sg.getStartRes();
            end = sg.getEndRes();
        } else {
            this.originalSequences = this.ap.av.getAlignment().getSequencesArray();
            start = 0;
            end = this.ap.av.getAlignment().getWidth();
        }
        int height = this.originalSequences.length;
        this.redundancy = AlignSeq.computeRedundancyMatrix(this.originalSequences, omitHidden, start, end, false);
        this.label.setText(MessageManager.getString("label.enter_redundancy_threshold"));
        this.slider.setVisible(true);
        this.applyButton.setEnabled(true);
        this.valueField.setVisible(true);
        this.validate();
        this.sliderValueChanged();
    }

    void sliderValueChanged() {
        if (this.redundancy == null) {
            return;
        }
        float value = this.slider.getValue();
        ArrayList<SequenceI> redundantSequences = new ArrayList<SequenceI>();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (!(value <= this.redundancy[i])) continue;
            redundantSequences.add(this.originalSequences[i]);
        }
        this.ap.idPanel.idCanvas.setHighlighted(redundantSequences);
        PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId(), true, true);
    }

    @Override
    public void applyButton_actionPerformed() {
        Vector<SequenceI> del = new Vector<SequenceI>();
        this.undoButton.setEnabled(true);
        float value = this.slider.getValue();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (!(value <= this.redundancy[i])) continue;
            del.addElement(this.originalSequences[i]);
        }
        if (del.size() > 0) {
            SequenceI[] deleted = new SequenceI[del.size()];
            int width = 0;
            for (int i = 0; i < del.size(); ++i) {
                deleted[i] = (SequenceI)del.elementAt(i);
                if (deleted[i].getLength() <= width) continue;
                width = deleted[i].getLength();
            }
            EditCommand cut = new EditCommand(MessageManager.getString("action.remove_redundancy"), EditCommand.Action.CUT, deleted, 0, width, this.ap.av.getAlignment());
            AlignmentI alignment = this.ap.av.getAlignment();
            for (int i = 0; i < del.size(); ++i) {
                alignment.deleteSequence(deleted[i]);
                if (sg == null) continue;
                sg.deleteSequence(deleted[i], false);
            }
            this.historyList.push(cut);
            this.ap.alignFrame.addHistoryItem(cut);
            PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId(), true, true);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    @Override
    public void undoButton_actionPerformed() {
        CommandI command = (CommandI)this.historyList.pop();
        command.undoCommand(null);
        if (this.ap.av.getHistoryList().contains(command)) {
            this.ap.av.getHistoryList().remove(command);
            this.ap.alignFrame.updateEditMenuBar();
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
        this.ap.paintAlignment(true, true);
        if (this.historyList.size() == 0) {
            this.undoButton.setEnabled(false);
        }
    }

    public void valueField_actionPerformed(ActionEvent e) {
        try {
            int i = Integer.parseInt(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (Exception ex) {
            this.valueField.setText("" + this.slider.getValue());
        }
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.ap.idPanel.idCanvas.setHighlighted(null);
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }
}

