/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PaintRefresher {
    static Map<String, Vector<Component>> components;

    public static void Register(Component comp, String seqSetId) {
        if (components == null) {
            components = new Hashtable<String, Vector<Component>>();
        }
        if (components.containsKey(seqSetId)) {
            Vector<Component> comps = components.get(seqSetId);
            if (!comps.contains(comp)) {
                comps.addElement(comp);
            }
        } else {
            Vector<Component> vcoms = new Vector<Component>();
            vcoms.addElement(comp);
            components.put(seqSetId, vcoms);
        }
    }

    public static void RemoveComponent(Component comp) {
        if (components == null) {
            return;
        }
        Iterator<String> it = components.keySet().iterator();
        while (it.hasNext()) {
            Vector<Component> comps = components.get(it.next());
            comps.removeElement(comp);
            if (!comps.isEmpty()) continue;
            it.remove();
        }
    }

    public static void Refresh(Component source, String id) {
        PaintRefresher.Refresh(source, id, false, false);
    }

    public static void Refresh(Component source, String id, boolean alignmentChanged, boolean validateSequences) {
        if (components == null) {
            return;
        }
        Vector<Component> comps = components.get(id);
        if (comps == null) {
            return;
        }
        Iterator<Component> it = comps.iterator();
        while (it.hasNext()) {
            Component comp = it.next();
            if (comp == source) continue;
            if (!comp.isValid()) {
                it.remove();
            } else if (validateSequences && comp instanceof AlignmentPanel && source instanceof AlignmentPanel) {
                PaintRefresher.validateSequences(((AlignmentPanel)source).av.getAlignment(), ((AlignmentPanel)comp).av.getAlignment());
            }
            if (comp instanceof AlignmentPanel && alignmentChanged) {
                ((AlignmentPanel)comp).alignmentChanged();
            }
            comp.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void validateSequences(AlignmentI source, AlignmentI comp) {
        int j;
        SequenceI[] a2;
        int jSize;
        SequenceI[] a1 = source.getHiddenSequences().getSize() > 0 ? source.getHiddenSequences().getFullAlignment().getSequencesArray() : source.getSequencesArray();
        int iSize = a1.length;
        if (iSize == (jSize = (a2 = comp.getHiddenSequences().getSize() > 0 ? comp.getHiddenSequences().getFullAlignment().getSequencesArray() : comp.getSequencesArray()).length)) {
            return;
        }
        boolean exists = false;
        int i = 0;
        while (true) {
            if (i >= iSize) break;
            exists = false;
            for (j = 0; j < jSize; ++j) {
                if (a2[j] != a1[i]) continue;
                exists = true;
                break;
            }
            if (!exists) {
                if (i < comp.getHeight()) {
                    List<SequenceI> alsq;
                    List<SequenceI> list = alsq = comp.getSequences();
                    // MONITORENTER : alsq
                    alsq.add(i, a1[i]);
                    // MONITOREXIT : list
                } else {
                    comp.addSequence(a1[i]);
                }
                a2 = comp.getHiddenSequences().getSize() > 0 ? comp.getHiddenSequences().getFullAlignment().getSequencesArray() : comp.getSequencesArray();
                jSize = a2.length;
            }
            ++i;
        }
        iSize = a1.length;
        jSize = a2.length;
        j = 0;
        while (j < jSize) {
            exists = false;
            for (i = 0; i < iSize; ++i) {
                if (a2[j] != a1[i]) continue;
                exists = true;
                break;
            }
            if (!exists) {
                comp.deleteSequence(a2[j]);
            }
            ++j;
        }
    }

    public static AlignmentPanel[] getAssociatedPanels(String id) {
        Vector<Component> comps = components.get(id);
        Vector<Component> tmp = new Vector<Component>();
        int iSize = comps.size();
        for (int i = 0; i < iSize; ++i) {
            if (!(comps.elementAt(i) instanceof AlignmentPanel)) continue;
            tmp.addElement(comps.elementAt(i));
        }
        AlignmentPanel[] result = new AlignmentPanel[tmp.size()];
        for (int ix = 0; ix < result.length; ++ix) {
            result[ix] = (AlignmentPanel)tmp.elementAt(ix);
        }
        return result;
    }
}

