/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.AlignSeq;
import jalview.analysis.SequenceIdMatcher;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class SeqsetUtils {
    public static Hashtable SeqCharacterHash(SequenceI seq) {
        Hashtable<String, Object> sqinfo = new Hashtable<String, Object>();
        sqinfo.put("Name", seq.getName());
        sqinfo.put("Start", seq.getStart());
        sqinfo.put("End", seq.getEnd());
        if (seq.getDescription() != null) {
            sqinfo.put("Description", seq.getDescription());
        }
        Vector<SequenceFeature> sfeat = new Vector<SequenceFeature>();
        List<SequenceFeature> sfs = seq.getFeatures().getAllFeatures(new String[0]);
        sfeat.addAll(sfs);
        if (seq.getDatasetSequence() == null) {
            sqinfo.put("SeqFeatures", sfeat);
            sqinfo.put("PdbId", seq.getAllPDBEntries() != null ? seq.getAllPDBEntries() : new Vector());
        } else {
            sqinfo.put("datasetSequence", seq.getDatasetSequence() != null ? seq.getDatasetSequence() : new Sequence("THISISAPLACEHOLDER", ""));
        }
        if (seq.hasHMMProfile()) {
            sqinfo.put("HMM", seq.getHMM());
        }
        if (seq.getAnnotation("Search Scores") != null) {
            sqinfo.put("Score", seq.getAnnotation("Search Scores"));
        }
        return sqinfo;
    }

    public static boolean SeqCharacterUnhash(SequenceI sq, Hashtable sqinfo) {
        boolean namePresent = true;
        if (sqinfo == null) {
            return false;
        }
        String oldname = (String)sqinfo.get("Name");
        Integer start = (Integer)sqinfo.get("Start");
        Integer end = (Integer)sqinfo.get("End");
        Vector sfeatures = (Vector)sqinfo.get("SeqFeatures");
        Vector pdbid = (Vector)sqinfo.get("PdbId");
        String description = (String)sqinfo.get("Description");
        Sequence seqds = (Sequence)sqinfo.get("datasetSequence");
        HiddenMarkovModel hmm = (HiddenMarkovModel)sqinfo.get("HMM");
        AlignmentAnnotation[] scores = (AlignmentAnnotation[])sqinfo.get("Score");
        if (oldname == null) {
            namePresent = false;
        } else {
            sq.setName(oldname);
        }
        if (pdbid != null && pdbid.size() > 0) {
            sq.setPDBId(pdbid);
        }
        if (start != null && end != null) {
            sq.setStart(start);
            sq.setEnd(end);
        }
        if (sfeatures != null && !sfeatures.isEmpty()) {
            sq.setSequenceFeatures(sfeatures);
        }
        if (description != null) {
            sq.setDescription(description);
        }
        if (!(seqds == null || seqds.getName().equals("THISISAPLACEHOLDER") && seqds.getLength() == 0)) {
            if (sfeatures != null) {
                System.err.println("Implementation error: setting dataset sequence for a sequence which has sequence features.\n\tDataset sequence features will not be visible.");
            }
            sq.setDatasetSequence(seqds);
        }
        if (hmm != null) {
            sq.setHMM(new HiddenMarkovModel(hmm, sq));
        }
        if (scores != null) {
            for (AlignmentAnnotation score : scores) {
                sq.addAlignmentAnnotation(score);
            }
        }
        return namePresent;
    }

    public static String unique_name(int i) {
        return new String("Sequence" + i);
    }

    public static Hashtable uniquify(SequenceI[] sequences, boolean write_names) {
        Hashtable<String, Hashtable> map = new Hashtable<String, Hashtable>();
        for (int i = 0; i < sequences.length; ++i) {
            String safename = SeqsetUtils.unique_name(i);
            map.put(safename, SeqsetUtils.SeqCharacterHash(sequences[i]));
            if (!write_names) continue;
            sequences[i].setName(safename);
        }
        return map;
    }

    public static boolean deuniquify(Hashtable map, SequenceI[] sequences) {
        return SeqsetUtils.deuniquify(map, sequences, true);
    }

    public static boolean deuniquify(Hashtable map, SequenceI[] sequences, boolean quiet) {
        SequenceIdMatcher matcher = new SequenceIdMatcher(sequences);
        SequenceI msq = null;
        Enumeration keys = map.keys();
        Vector<SequenceI> unmatched = new Vector<SequenceI>();
        int j = sequences.length;
        for (int i = 0; i < j; ++i) {
            unmatched.addElement(sequences[i]);
        }
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            if (!(key instanceof String)) continue;
            msq = matcher.findIdMatch((String)key);
            if (msq != null) {
                Hashtable sqinfo = (Hashtable)map.get(key);
                unmatched.removeElement(msq);
                SeqsetUtils.SeqCharacterUnhash(msq, sqinfo);
                continue;
            }
            if (quiet) continue;
            System.err.println("Can't find '" + (String)key + "' in uniquified alignment");
        }
        if (unmatched.size() > 0 && !quiet) {
            System.err.println("Did not find matches for :");
            Enumeration i = unmatched.elements();
            while (i.hasMoreElements()) {
                System.out.println(((SequenceI)i.nextElement()).getName());
            }
            return false;
        }
        return true;
    }

    public static SequenceI[] getNonEmptySequenceSet(SequenceI[] sequences) {
        boolean[] ungapped = new boolean[sequences.length];
        int msflen = 0;
        int j = sequences.length;
        for (int i = 0; i < j; ++i) {
            String tempseq = AlignSeq.extractGaps(Comparison.GapChars, sequences[i].getSequenceAsString());
            if (tempseq.length() == 0) {
                ungapped[i] = false;
                continue;
            }
            ungapped[i] = true;
            ++msflen;
        }
        if (msflen == 0) {
            return null;
        }
        SequenceI[] mset = new SequenceI[msflen];
        int j2 = sequences.length;
        int k = 0;
        for (int i = 0; i < j2; ++i) {
            if (!ungapped[i]) continue;
            mset[k++] = sequences[i];
        }
        ungapped = null;
        return mset;
    }
}

