/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.SecStrConsensus;
import jalview.analysis.WUSSParseException;
import jalview.datamodel.SequenceFeature;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Rna {
    public static boolean isOpeningParenthesis(char c) {
        return 'A' <= c && c <= 'Z' || c == '(' || c == '[' || c == '{' || c == '<';
    }

    public static boolean isOpeningParenthesis(String s) {
        return s != null && s.length() == 1 && Rna.isOpeningParenthesis(s.charAt(0));
    }

    public static boolean isClosingParenthesis(char c) {
        return 'a' <= c && c <= 'z' || c == ')' || c == ']' || c == '}' || c == '>';
    }

    public static boolean isClosingParenthesis(String s) {
        return s != null && s.length() == 1 && Rna.isClosingParenthesis(s.charAt(0));
    }

    public static char getMatchingOpeningParenthesis(char c) {
        if ('a' <= c && c <= 'z') {
            return (char)(c + 65 - 97);
        }
        switch (c) {
            case ')': {
                return '(';
            }
            case ']': {
                return '[';
            }
            case '}': {
                return '{';
            }
            case '>': {
                return '<';
            }
        }
        return c;
    }

    protected static List<SecStrConsensus.SimpleBP> getSimpleBPs(CharSequence line) throws WUSSParseException {
        Stack stack;
        char opening;
        int i;
        Hashtable stacks = new Hashtable();
        ArrayList<SecStrConsensus.SimpleBP> pairs = new ArrayList<SecStrConsensus.SimpleBP>();
        for (i = 0; i < line.length(); ++i) {
            char base = line.charAt(i);
            if (Rna.isOpeningParenthesis(base)) {
                if (!stacks.containsKey(Character.valueOf(base))) {
                    stacks.put(Character.valueOf(base), new Stack());
                }
                ((Stack)stacks.get(Character.valueOf(base))).push(i);
                continue;
            }
            if (!Rna.isClosingParenthesis(base)) continue;
            opening = Rna.getMatchingOpeningParenthesis(base);
            if (!stacks.containsKey(Character.valueOf(opening))) {
                throw new WUSSParseException(MessageManager.formatMessage("exception.mismatched_unseen_closing_char", new String[]{String.valueOf(base)}), i);
            }
            stack = (Stack)stacks.get(Character.valueOf(opening));
            if (stack.isEmpty()) {
                throw new WUSSParseException(MessageManager.formatMessage("exception.mismatched_closing_char", new String[]{String.valueOf(base)}), i);
            }
            int temp = (Integer)stack.pop();
            pairs.add(new SecStrConsensus.SimpleBP(temp, i));
        }
        Iterator iterator = stacks.keySet().iterator();
        while (iterator.hasNext()) {
            opening = ((Character)iterator.next()).charValue();
            stack = (Stack)stacks.get(Character.valueOf(opening));
            if (stack.empty()) continue;
            throw new WUSSParseException(MessageManager.formatMessage("exception.mismatched_opening_char", new String[]{String.valueOf(opening), String.valueOf(stack.pop())}), i);
        }
        return pairs;
    }

    public static boolean isRnaSecondaryStructureSymbol(char c) {
        return Rna.isOpeningParenthesis(c) || Rna.isClosingParenthesis(c);
    }

    public static boolean isRnaSecondaryStructureSymbol(String s) {
        return Rna.isOpeningParenthesis(s) || Rna.isClosingParenthesis(s);
    }

    public static String getRNASecStrucState(String ssString) {
        if (ssString == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(ssString.length());
        for (int i = 0; i < ssString.length(); ++i) {
            char c = ssString.charAt(i);
            result.append(Rna.isRnaSecondaryStructureSymbol(c) ? Character.valueOf(c) : " ");
        }
        return result.toString();
    }

    public static boolean isCanonicalOrWobblePair(char first, char second) {
        if (first > 'Z') {
            first = (char)(first - 32);
        }
        if (second > 'Z') {
            second = (char)(second - 32);
        }
        switch (first) {
            case 'A': {
                switch (second) {
                    case 'T': 
                    case 'U': {
                        return true;
                    }
                }
                break;
            }
            case 'C': {
                switch (second) {
                    case 'G': {
                        return true;
                    }
                }
                break;
            }
            case 'T': 
            case 'U': {
                switch (second) {
                    case 'A': 
                    case 'G': {
                        return true;
                    }
                }
                break;
            }
            case 'G': {
                switch (second) {
                    case 'C': 
                    case 'T': 
                    case 'U': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isCanonicalPair(char first, char second) {
        if (first > 'Z') {
            first = (char)(first - 32);
        }
        if (second > 'Z') {
            second = (char)(second - 32);
        }
        switch (first) {
            case 'A': {
                switch (second) {
                    case 'T': 
                    case 'U': {
                        return true;
                    }
                }
                break;
            }
            case 'G': {
                switch (second) {
                    case 'C': {
                        return true;
                    }
                }
                break;
            }
            case 'C': {
                switch (second) {
                    case 'G': {
                        return true;
                    }
                }
                break;
            }
            case 'T': 
            case 'U': {
                switch (second) {
                    case 'A': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static char getMatchingClosingParenthesis(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c + 97 - 65);
        }
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
        }
        return c;
    }

    public static SequenceFeature[] getHelixMap(CharSequence rnaAnnotation) throws WUSSParseException {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        int helix = 0;
        int lastopen = 0;
        int lastclose = 9999999;
        HashMap<Integer, Integer> helices = new HashMap<Integer, Integer>();
        List<SecStrConsensus.SimpleBP> bps = Rna.getSimpleBPs(rnaAnnotation);
        for (SecStrConsensus.SimpleBP basePair : bps) {
            int open = basePair.getBP5();
            int close = basePair.getBP3();
            if (open > lastclose) {
                ++helix;
            }
            int j = bps.size();
            while (--j >= 0) {
                int popen = bps.get(j).getBP5();
                if (popen >= lastopen || popen <= open || helices.containsValue(popen) && (Integer)helices.get(popen) == helix) continue;
                ++helix;
                break;
            }
            helices.put(open, helix);
            helices.put(close, helix);
            result.add(new SequenceFeature("RNA helix", "", open, close, String.valueOf(helix)));
            lastopen = open;
            lastclose = close;
        }
        return result.toArray(new SequenceFeature[result.size()]);
    }
}

