/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.TreeBuilder;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.datamodel.SequenceNode;
import jalview.viewmodel.AlignmentViewport;
import java.util.BitSet;

public class AverageDistanceTree
extends TreeBuilder {
    public AverageDistanceTree(AlignmentViewport av, ScoreModelI sm, SimilarityParamsI scoreParameters) {
        super(av, sm, scoreParameters);
    }

    @Override
    protected void findClusterDistance(int i, int j) {
        int noi = ((BitSet)this.clusters.elementAt(i)).cardinality();
        int noj = ((BitSet)this.clusters.elementAt(j)).cardinality();
        double[] newdist = new double[this.noseqs];
        for (int l = 0; l < this.noseqs; ++l) {
            newdist[l] = l != i && l != j ? (this.distances.getValue(i, l) * (double)noi + this.distances.getValue(j, l) * (double)noj) / (double)(noi + noj) : 0.0;
        }
        for (int ii = 0; ii < this.noseqs; ++ii) {
            this.distances.setValue(i, ii, newdist[ii]);
            this.distances.setValue(ii, i, newdist[ii]);
        }
    }

    @Override
    protected double findMinDistance() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.noseqs - 1; ++i) {
            for (int j = i + 1; j < this.noseqs; ++j) {
                if (this.done.get(i) || this.done.get(j) || !(this.distances.getValue(i, j) < min)) continue;
                this.mini = i;
                this.minj = j;
                min = this.distances.getValue(i, j);
            }
        }
        return min;
    }

    @Override
    protected void findNewDistances(SequenceNode nodei, SequenceNode nodej, double dist) {
        double ih = 0.0;
        double jh = 0.0;
        SequenceNode snj = nodej;
        for (SequenceNode sni = nodei; sni != null; sni = (SequenceNode)sni.left()) {
            ih += sni.dist;
        }
        while (snj != null) {
            jh += snj.dist;
            snj = (SequenceNode)snj.left();
        }
        nodei.dist = dist / 2.0 - ih;
        nodej.dist = dist / 2.0 - jh;
    }
}

