/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.AlignmentUtils;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AnnotationSorter {
    private final AlignmentI alignment;
    private boolean showAutocalcAbove;
    private final Map<SequenceI, Integer> sequenceIndices = new HashMap<SequenceI, Integer>();
    private final Comparator<? super AlignmentAnnotation> bySequenceAndLabel = new Comparator<AlignmentAnnotation>(){

        @Override
        public int compare(AlignmentAnnotation o1, AlignmentAnnotation o2) {
            boolean o2auto;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            boolean o1auto = o1.autoCalculated && o1.sequenceRef == null;
            boolean bl = o2auto = o2.autoCalculated && o2.sequenceRef == null;
            if (o1auto && o2auto) {
                return 0;
            }
            if (o1auto) {
                return AnnotationSorter.this.showAutocalcAbove ? -1 : 1;
            }
            if (o2auto) {
                return AnnotationSorter.this.showAutocalcAbove ? 1 : -1;
            }
            int sequenceOrder = AnnotationSorter.this.compareSequences(o1, o2);
            return sequenceOrder == 0 ? AnnotationSorter.this.compareLabels(o1, o2) : sequenceOrder;
        }

        public String toString() {
            return "Sort by sequence and label";
        }
    };
    private final Comparator<? super AlignmentAnnotation> byLabelAndSequence = new Comparator<AlignmentAnnotation>(){

        @Override
        public int compare(AlignmentAnnotation o1, AlignmentAnnotation o2) {
            boolean o2auto;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            boolean o1auto = o1.autoCalculated && o1.sequenceRef == null;
            boolean bl = o2auto = o2.autoCalculated && o2.sequenceRef == null;
            if (o1auto && o2auto) {
                return 0;
            }
            if (o1auto) {
                return AnnotationSorter.this.showAutocalcAbove ? -1 : 1;
            }
            if (o2auto) {
                return AnnotationSorter.this.showAutocalcAbove ? 1 : -1;
            }
            int labelOrder = AnnotationSorter.this.compareLabels(o1, o2);
            return labelOrder == 0 ? AnnotationSorter.this.compareSequences(o1, o2) : labelOrder;
        }

        public String toString() {
            return "Sort by label and sequence";
        }
    };
    private Comparator<? super AlignmentAnnotation> noSort = new Comparator<AlignmentAnnotation>(){

        @Override
        public int compare(AlignmentAnnotation o1, AlignmentAnnotation o2) {
            boolean o2auto;
            boolean o1auto = o1.autoCalculated && o1.sequenceRef == null;
            boolean bl = o2auto = o2.autoCalculated && o2.sequenceRef == null;
            if (o1 != null && o2 != null) {
                if (o1auto && !o2auto) {
                    return AnnotationSorter.this.showAutocalcAbove ? -1 : 1;
                }
                if (!o1auto && o2auto) {
                    return AnnotationSorter.this.showAutocalcAbove ? 1 : -1;
                }
            }
            return 0;
        }

        public String toString() {
            return "No sort";
        }
    };

    public AnnotationSorter(AlignmentI alignmentI, boolean showAutocalculatedAbove) {
        this.alignment = alignmentI;
        this.showAutocalcAbove = showAutocalculatedAbove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sort(AlignmentAnnotation[] alignmentAnnotations, SequenceAnnotationOrder order) {
        if (alignmentAnnotations == null) {
            return;
        }
        this.saveSequenceIndices(alignmentAnnotations);
        Comparator<? super AlignmentAnnotation> comparator = this.getComparator(order);
        if (alignmentAnnotations == null) return;
        AlignmentAnnotation[] alignmentAnnotationArray = alignmentAnnotations;
        synchronized (alignmentAnnotations) {
            Arrays.sort(alignmentAnnotations, comparator);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private void saveSequenceIndices(AlignmentAnnotation[] alignmentAnnotations) {
        this.sequenceIndices.clear();
        for (AlignmentAnnotation ann : alignmentAnnotations) {
            SequenceI seq = ann.sequenceRef;
            if (seq == null) continue;
            int index = AlignmentUtils.getSequenceIndex(this.alignment, seq);
            this.sequenceIndices.put(seq, index);
        }
    }

    private Comparator<? super AlignmentAnnotation> getComparator(SequenceAnnotationOrder order) {
        if (order == null) {
            return this.noSort;
        }
        switch (order) {
            case NONE: {
                return this.noSort;
            }
            case SEQUENCE_AND_LABEL: {
                return this.bySequenceAndLabel;
            }
            case LABEL_AND_SEQUENCE: {
                return this.byLabelAndSequence;
            }
        }
        throw new UnsupportedOperationException(order.toString());
    }

    private int compareLabels(AlignmentAnnotation o1, AlignmentAnnotation o2) {
        if (o1 == null || o2 == null) {
            return 0;
        }
        String label1 = o1.label;
        String label2 = o2.label;
        if (label1 == null && label2 == null) {
            return 0;
        }
        if (label1 == null) {
            return -1;
        }
        if (label2 == null) {
            return 1;
        }
        return label1.toUpperCase().compareTo(label2.toUpperCase());
    }

    private int compareSequences(AlignmentAnnotation o1, AlignmentAnnotation o2) {
        int index2;
        SequenceI seq1 = o1.sequenceRef;
        SequenceI seq2 = o2.sequenceRef;
        if (seq1 == null && seq2 == null) {
            return 0;
        }
        if (seq1 == null) {
            return this.showAutocalcAbove ? -1 : 1;
        }
        if (seq2 == null) {
            return this.showAutocalcAbove ? 1 : -1;
        }
        int index1 = this.sequenceIndices.get(seq1);
        if (index1 == (index2 = this.sequenceIndices.get(seq2).intValue())) {
            return 0;
        }
        if (index1 == -1) {
            return -1;
        }
        if (index2 == -1) {
            return 1;
        }
        return Integer.compare(index1, index2);
    }

    public static enum SequenceAnnotationOrder {
        SEQUENCE_AND_LABEL("Sequence"),
        LABEL_AND_SEQUENCE("Label"),
        NONE("No sort");

        private String description;

        private SequenceAnnotationOrder(String s) {
            this.description = s;
        }

        public String toString() {
            return this.description;
        }

        public static SequenceAnnotationOrder forDescription(String d) {
            for (SequenceAnnotationOrder order : SequenceAnnotationOrder.values()) {
                if (!order.toString().equals(d)) continue;
                return order;
            }
            return null;
        }
    }
}

