/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraChain;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraManager;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraResidue;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraStructuralObject;
import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChimUtils {
    private static Logger logger = LoggerFactory.getLogger(ChimUtils.class);
    static int MAX_SUB_MODELS = 1000;
    public static final HashMap<String, String> aaNames;
    public static String RESIDUE_ATTR;
    public static String RINALYZER_ATTR;
    public static String DEFAULT_STRUCTURE_KEY;

    public static int[] parseModelNumber(String inputLine) {
        int hash = inputLine.indexOf(35);
        int space = inputLine.indexOf(32, hash);
        int decimal = inputLine.substring(hash + 1, space).indexOf(46);
        int modelNumber = -1;
        int subModelNumber = 0;
        try {
            if (decimal > 0) {
                subModelNumber = Integer.parseInt(inputLine.substring(decimal + hash + 2, space));
                space = decimal + hash + 1;
            }
            modelNumber = Integer.parseInt(inputLine.substring(hash + 1, space));
        }
        catch (Exception e) {
            logger.warn("Unexpected return from Chimera: " + inputLine, (Throwable)e);
        }
        return new int[]{modelNumber, subModelNumber};
    }

    public static int[] parseOpenedModelNumber(String inputLine) {
        int hash = inputLine.indexOf(35);
        int space = -1;
        if (hash == -1) {
            hash = inputLine.indexOf("Model");
            if (hash >= 0) {
                hash += 5;
            }
            space = inputLine.indexOf(32, hash + 1);
        } else {
            space = inputLine.indexOf(44, hash);
        }
        int decimal = inputLine.substring(hash + 1, space).indexOf(46);
        int modelNumber = -1;
        int subModelNumber = 0;
        try {
            if (decimal > 0) {
                subModelNumber = Integer.parseInt(inputLine.substring(decimal + hash + 2, space));
                space = decimal + hash + 1;
            }
            modelNumber = Integer.parseInt(inputLine.substring(hash + 1, space));
        }
        catch (Exception e) {
            logger.warn("Unexpected return from Chimera: " + inputLine, (Throwable)e);
        }
        return new int[]{modelNumber, subModelNumber};
    }

    public static String parseModelName(String inputLine) {
        int start = inputLine.indexOf("name ");
        if (start < 0) {
            return null;
        }
        if (inputLine.startsWith("\"", start + 5)) {
            start += 6;
            int end = inputLine.lastIndexOf(34);
            if (end >= 1) {
                return inputLine.substring(start, end);
            }
            return inputLine.substring(start);
        }
        return inputLine.substring(start + 5);
    }

    public static Color parseModelColor(String inputLine) {
        try {
            int colorStart = inputLine.indexOf("color ");
            String colorString = inputLine.substring(colorStart + 6);
            String[] rgbStrings = colorString.split(",");
            float[] rgbValues = new float[4];
            for (int i = 0; i < rgbStrings.length; ++i) {
                Float f = Float.valueOf(rgbStrings[i]);
                rgbValues[i] = f.floatValue();
            }
            if (rgbStrings.length == 4) {
                return new Color(rgbValues[0], rgbValues[1], rgbValues[2], rgbValues[3]);
            }
            return new Color(rgbValues[0], rgbValues[1], rgbValues[2]);
        }
        catch (Exception ex) {
            logger.warn("Unexpected return from Chimera: " + inputLine, (Throwable)ex);
            return Color.white;
        }
    }

    public static Integer makeModelKey(int model, int subModel) {
        return model * MAX_SUB_MODELS + subModel;
    }

    public static ChimeraModel getModel(String atomSpec, ChimeraManager chimeraManager) {
        String[] split = atomSpec.split(":");
        if (split[0].length() == 0) {
            logger.info("Unexpected return from Chimera: " + atomSpec);
            return null;
        }
        int model = 0;
        int submodel = 0;
        try {
            String[] subSplit = split[0].substring(1).split("\\.");
            model = subSplit.length > 0 ? Integer.parseInt(subSplit[0]) : Integer.parseInt(split[0].substring(1));
            if (subSplit.length > 1) {
                submodel = Integer.parseInt(subSplit[1]);
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected return from Chimera: " + atomSpec, (Throwable)e);
        }
        return chimeraManager.getChimeraModel(model, submodel);
    }

    public static ChimeraResidue getResidue(String atomSpec, ChimeraManager chimeraManager) {
        ChimeraModel model = ChimUtils.getModel(atomSpec, chimeraManager);
        if (model == null) {
            model = chimeraManager.getChimeraModel();
        }
        return ChimUtils.getResidue(atomSpec, model);
    }

    public static ChimeraResidue getResidue(String atomSpec, ChimeraModel model) {
        String[] split = atomSpec.split(":|@");
        String[] residueChain = split[1].split("\\.");
        if (residueChain[0].length() == 0) {
            logger.info("Unexpected return from Chimera: " + atomSpec);
            return null;
        }
        if (residueChain.length == 2 && residueChain[1].length() > 0) {
            ChimeraChain chain = model.getChain(residueChain[1]);
            return chain.getResidue(residueChain[0]);
        }
        return model.getResidue("_", residueChain[0]);
    }

    public static ChimeraChain getChain(String atomSpec, ChimeraModel model) {
        String[] split = atomSpec.split(":|@");
        String[] residueChain = split[1].split("\\.");
        if (residueChain.length == 1) {
            logger.info("Unexpected return from Chimera: " + atomSpec);
            return null;
        }
        return model.getChain(residueChain[1]);
    }

    public static String getAtomName(String atomSpec) {
        String[] split = atomSpec.split("@");
        if (split.length > 1) {
            return split[1];
        }
        return atomSpec;
    }

    public static boolean isBackbone(String atom) {
        return atom.equals("C") || atom.equals("CA") || atom.equals("N") || atom.equals("O") || atom.equals("H");
    }

    public static String getIntSubtype(String node, String atom) {
        String[] split = node.split("#| ");
        String resType = "";
        if (split.length == 2) {
            resType = split[0].trim().toUpperCase();
        } else if (split.length == 3) {
            resType = split[1].trim().toUpperCase();
        }
        if (resType.equalsIgnoreCase("HOH") || resType.equalsIgnoreCase("WAT")) {
            return "water";
        }
        if (aaNames.containsKey(resType)) {
            if (atom.equals("C") || atom.equals("CA") || atom.equals("N") || atom.equals("O") || atom.equals("H")) {
                return "mc";
            }
            return "sc";
        }
        return "other";
    }

    public static String[] getResKeyParts(String resKey) {
        String[] resKeyParts = new String[4];
        String[] split = resKey.split("#");
        String resChain = null;
        if (split.length == 1) {
            if (resKey.length() == 4 && resKey.indexOf("\\.") < 0) {
                ChimUtils.parseModelID(resKey, resKeyParts);
            } else if (resKey.startsWith("\"")) {
                ChimUtils.parseModelID(resKey, resKeyParts);
            } else {
                String[] splitSplit = resKey.split("\\.");
                if (splitSplit.length == 1) {
                    resChain = resKey;
                } else {
                    try {
                        Integer.parseInt(splitSplit[1]);
                        ChimUtils.parseModelID(resKey, resKeyParts);
                    }
                    catch (NumberFormatException ex) {
                        resChain = resKey;
                    }
                }
            }
        } else if (split.length == 2) {
            ChimUtils.parseModelID(split[0], resKeyParts);
            resChain = split[1];
        } else {
            ChimUtils.parseModelID(resKey.substring(0, resKey.lastIndexOf("#")), resKeyParts);
            resChain = resKey.substring(resKey.lastIndexOf("#") + 1, resKey.length());
        }
        if (resChain != null) {
            String[] resChainSplit = resChain.split("\\.");
            if (resChainSplit.length == 1) {
                if (resChainSplit[0].length() == 1) {
                    try {
                        Integer.parseInt(resChainSplit[0]);
                        resKeyParts[3] = resChainSplit[0];
                    }
                    catch (NumberFormatException ex) {
                        resKeyParts[2] = resChainSplit[0];
                    }
                } else {
                    resKeyParts[3] = resChainSplit[0];
                }
            } else if (resChainSplit.length == 2) {
                resKeyParts[2] = resChainSplit[0];
                resKeyParts[3] = resChainSplit[1];
            } else {
                logger.info("Could not parse residue identifier: " + resKey);
            }
        }
        return resKeyParts;
    }

    public static void parseModelID(String modelID, String[] resKeyParts) {
        if (modelID.startsWith("\"")) {
            if (modelID.endsWith("\"")) {
                resKeyParts[0] = modelID.substring(1, modelID.length() - 1);
                return;
            }
            try {
                Integer.parseInt(modelID.substring(modelID.lastIndexOf("\"") + 2, modelID.length()));
                resKeyParts[0] = modelID.substring(0, modelID.lastIndexOf("\"") - 1);
                resKeyParts[1] = modelID.substring(modelID.lastIndexOf("\"") + 2, modelID.length());
            }
            catch (NumberFormatException ex) {
                resKeyParts[0] = modelID.substring(1);
            }
        } else {
            String[] modelIDNo = modelID.split("\\.");
            if (modelIDNo.length == 1) {
                resKeyParts[0] = modelIDNo[0];
            } else if (modelIDNo.length == 2) {
                try {
                    Integer.parseInt(modelIDNo[1]);
                    resKeyParts[0] = modelIDNo[0];
                    resKeyParts[1] = modelIDNo[1];
                }
                catch (NumberFormatException ex) {
                    resKeyParts[0] = modelID;
                }
            } else {
                logger.info("Could not parse model identifier: " + modelID);
                resKeyParts[0] = modelID;
            }
        }
    }

    public static ChimeraStructuralObject fromAttributeOld(String attrSpec, ChimeraManager chimeraManager) {
        if (attrSpec == null || attrSpec.indexOf(44) > 0 || attrSpec.indexOf(45) > 0) {
            logger.warn("No support for identifier: " + attrSpec);
            return null;
        }
        String residue = null;
        String model = null;
        String chain = null;
        ChimeraModel chimeraModel = null;
        ChimeraChain chimeraChain = null;
        ChimeraResidue chimeraResidue = null;
        try {
            String[] split = attrSpec.split("#");
            String resChain = null;
            if (split.length == 1) {
                resChain = split[0];
            } else if (split.length == 2) {
                model = split[0];
                resChain = split[1];
            } else {
                model = attrSpec.substring(0, attrSpec.lastIndexOf("#"));
                resChain = attrSpec.substring(attrSpec.lastIndexOf("#") + 1, attrSpec.length());
            }
            if (resChain != null) {
                String[] resChainSplit = resChain.split("\\.");
                if (resChainSplit.length == 1) {
                    residue = resChainSplit[0];
                } else if (resChainSplit.length == 2) {
                    residue = resChainSplit[0];
                    chain = resChainSplit[1];
                } else {
                    logger.warn("No support for identifier: " + attrSpec);
                }
            }
            if (model != null) {
                List<ChimeraModel> models = chimeraManager.getChimeraModels(model, StructureManager.ModelType.PDB_MODEL);
                if (models.size() == 1) {
                    chimeraModel = models.get(0);
                } else {
                    try {
                        chimeraModel = chimeraManager.getChimeraModel(Integer.valueOf(model), 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (chimeraModel == null) {
                chimeraModel = chimeraManager.getChimeraModel();
            }
            if (chain != null) {
                chimeraChain = chimeraModel.getChain(chain);
            }
            if (residue != null) {
                chimeraResidue = chimeraChain != null ? chimeraChain.getResidue(residue) : chimeraModel.getResidue("_", residue);
            }
            if (chimeraResidue != null) {
                return chimeraResidue;
            }
            if (chimeraChain != null) {
                return chimeraChain;
            }
            if (chimeraModel != null) {
                return chimeraModel;
            }
        }
        catch (Exception ex) {
            logger.warn("Could not parse residue identifier: " + attrSpec, (Throwable)ex);
        }
        return null;
    }

    public static ChimeraStructuralObject fromAttribute(String attrSpec, ChimeraManager chimeraManager) {
        if (attrSpec == null || attrSpec.indexOf(44) > 0) {
            logger.warn("No support for identifier: " + attrSpec);
            return null;
        }
        String[] modelIDNoResChain = ChimUtils.getResKeyParts(attrSpec);
        ChimeraModel chimeraModel = null;
        ChimeraChain chimeraChain = null;
        ChimeraResidue chimeraResidue = null;
        try {
            if (modelIDNoResChain[0] != null) {
                String modelID = modelIDNoResChain[0];
                List<ChimeraModel> models = chimeraManager.getChimeraModels(modelID, StructureManager.ModelType.PDB_MODEL);
                if (models.size() == 1) {
                    chimeraModel = models.get(0);
                } else if (models.size() > 1 && modelIDNoResChain[1] != null) {
                    try {
                        int modelNo = Integer.valueOf(modelIDNoResChain[1]);
                        for (ChimeraModel model : models) {
                            if (model.getSubModelNumber() != modelNo) continue;
                            chimeraModel = model;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    try {
                        chimeraModel = chimeraManager.getChimeraModel(Integer.valueOf(modelID), 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (chimeraModel == null) {
                return null;
            }
            if (modelIDNoResChain[3] != null) {
                chimeraChain = chimeraModel.getChain(modelIDNoResChain[3]);
            }
            if (modelIDNoResChain[2] != null) {
                String residue = modelIDNoResChain[2];
                if (chimeraChain != null) {
                    chimeraResidue = chimeraChain.getResidue(residue);
                } else if (chimeraModel.getChain("_") != null) {
                    chimeraResidue = chimeraModel.getResidue("_", residue);
                } else if (chimeraModel.getChainCount() == 1) {
                    chimeraResidue = chimeraModel.getResidue(chimeraModel.getChainNames().iterator().next(), residue);
                }
            }
            if (chimeraResidue != null) {
                return chimeraResidue;
            }
            if (chimeraChain != null) {
                return chimeraChain;
            }
            if (chimeraModel != null) {
                return chimeraModel;
            }
        }
        catch (Exception ex) {
            logger.warn("Could not parse chimera identifier: " + attrSpec, (Throwable)ex);
        }
        return null;
    }

    public static String findStructures(String residueList) {
        if (residueList == null) {
            return null;
        }
        String[] residues = residueList.split(",");
        HashMap<String, String> structureNameMap = new HashMap<String, String>();
        for (int i = 0; i < residues.length; ++i) {
            String[] components = residues[i].split("#");
            if (components.length <= 1) continue;
            structureNameMap.put(components[0], components[1]);
        }
        if (structureNameMap.isEmpty()) {
            return null;
        }
        String structure = null;
        for (String struct : structureNameMap.keySet()) {
            structure = structure == null ? new String() : structure.concat(",");
            structure = structure.concat(struct);
        }
        return structure;
    }

    public static List<String> parseFuncRes(List<String> residueNames, String modelName) {
        ArrayList<String> resRanges = new ArrayList<String>();
        for (int i = 0; i < residueNames.size(); ++i) {
            String residue = residueNames.get(i);
            String[] components = residue.split("#");
            if (components.length > 1 && !modelName.equals(components[0])) continue;
            if (components.length > 1) {
                residue = components[1];
            } else if (components.length == 1) {
                residue = components[0];
            }
            String resRange = "";
            if (residue == null || residue.equals("") || residue.length() == 0) continue;
            String[] range = residue.split("-", 2);
            String chain = null;
            for (int res = 0; res < range.length; ++res) {
                if (res == 1) {
                    resRange = resRange.concat("-");
                    if (chain != null && range[res].indexOf(46) == -1) {
                        range[res] = range[res].concat("." + chain);
                    }
                }
                if (res == 0 && range.length >= 2 && range[res].indexOf(46) > 0) {
                    String[] resChain = range[res].split("\\.");
                    chain = resChain[1];
                    range[res] = resChain[0];
                }
                if (range[res].indexOf(124) > 0 && Character.isDigit(range[res].charAt(0))) {
                    int offset = range[res].indexOf(124);
                    String str = range[res].substring(offset + 1) + range[res].substring(0, offset);
                    range[res] = str;
                }
                resRange = Character.isDigit(range[res].charAt(0)) ? resRange.concat(range[res]) : (Character.isDigit(range[res].charAt(1)) ? resRange.concat(range[res].substring(1)) : (range[res].charAt(0) == '.' ? resRange.concat(range[res]) : resRange.concat(range[res].substring(3))));
            }
            if (resRanges.contains(resRange)) continue;
            resRanges.add(resRange);
        }
        return resRanges;
    }

    public static String toFullName(String aaType) {
        if (!aaNames.containsKey(aaType)) {
            return aaType;
        }
        String[] ids = aaNames.get(aaType).split(" ");
        return ids[2].replace('_', ' ');
    }

    public static String toSingleLetter(String aaType) {
        if (!aaNames.containsKey(aaType)) {
            return aaType;
        }
        String[] ids = aaNames.get(aaType).split(" ");
        return ids[0];
    }

    public static String toThreeLetter(String aaType) {
        if (!aaNames.containsKey(aaType)) {
            return aaType;
        }
        String[] ids = aaNames.get(aaType).split(" ");
        return ids[1];
    }

    public static String toSMILES(String aaType) {
        if (!aaNames.containsKey(aaType)) {
            return null;
        }
        String[] ids = aaNames.get(aaType).split(" ");
        if (ids.length < 4) {
            return null;
        }
        return ids[3];
    }

    public static String getAlignName(ChimeraStructuralObject chimObj) {
        Object name = chimObj.getChimeraModel().toString();
        if (chimObj instanceof ChimeraChain) {
            name = ((ChimeraChain)chimObj).toString() + " [" + (String)name + "]";
        }
        return name;
    }

    static {
        RESIDUE_ATTR = "ChimeraResidue";
        RINALYZER_ATTR = "RINalyzerResidue";
        DEFAULT_STRUCTURE_KEY = "pdbFileName";
        aaNames = new HashMap();
        aaNames.put("ALA", "A Ala Alanine N[C@@H](C)C(O)=O");
        aaNames.put("ARG", "R Arg Arginine N[C@@H](CCCNC(N)=N)C(O)=O");
        aaNames.put("ASN", "N Asn Asparagine N[C@@H](CC(N)=O)C(O)=O");
        aaNames.put("ASP", "D Asp Aspartic_acid N[C@@H](CC(O)=O)C(O)=O");
        aaNames.put("CYS", "C Cys Cysteine N[C@@H](CS)C(O)=O");
        aaNames.put("GLN", "Q Gln Glutamine N[C@H](C(O)=O)CCC(N)=O");
        aaNames.put("GLU", "E Glu Glumatic_acid N[C@H](C(O)=O)CCC(O)=O");
        aaNames.put("GLY", "G Gly Glycine NCC(O)=O");
        aaNames.put("HIS", "H His Histidine N[C@@H](CC1=CN=CN1)C(O)=O");
        aaNames.put("ILE", "I Ile Isoleucine N[C@]([C@H](C)CC)([H])C(O)=O");
        aaNames.put("LEU", "L Leu Leucine N[C@](CC(C)C)([H])C(O)=O");
        aaNames.put("LYS", "K Lys Lysine N[C@](CCCCN)([H])C(O)=O");
        aaNames.put("DLY", "K Dly D-Lysine NCCCC[C@@H](N)C(O)=O");
        aaNames.put("MET", "M Met Methionine N[C@](CCSC)([H])C(O)=O");
        aaNames.put("PHE", "F Phe Phenylalanine N[C@](CC1=CC=CC=C1)([H])C(O)=O");
        aaNames.put("PRO", "P Pro Proline OC([C@@]1([H])NCCC1)=O");
        aaNames.put("SER", "S Ser Serine OC[C@](C(O)=O)([H])N");
        aaNames.put("THR", "T Thr Threonine O[C@H](C)[C@](C(O)=O)([H])N");
        aaNames.put("TRP", "W Trp Tryptophan N[C@@]([H])(CC1=CN([H])C2=C1C=CC=C2)C(O)=O");
        aaNames.put("TYR", "Y Tyr Tyrosine N[C@@](C(O)=O)([H])CC1=CC=C(O)C=C1");
        aaNames.put("VAL", "V Val Valine N[C@@](C(O)=O)([H])C(C)C");
        aaNames.put("ASX", "B Asx Aspartic_acid_or_Asparagine");
        aaNames.put("GLX", "Z Glx Glutamine_or_Glutamic_acid");
        aaNames.put("XAA", "X Xaa Any_or_unknown_amino_acid");
        aaNames.put("HOH", "HOH HOH Water [H]O[H]");
    }
}

