/*
 * Decompiled with CFR 0.152.
 */
package MCview;

import MCview.Atom;
import MCview.PDBChain;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StructureFile;
import jalview.util.MessageManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class PDBfile
extends StructureFile {
    private static String CALC_ID_PREFIX = "JalviewPDB";

    public PDBfile(boolean addAlignmentAnnotations, boolean predictSecondaryStructure, boolean externalSecStr) {
        this.addSettings(addAlignmentAnnotations, predictSecondaryStructure, externalSecStr);
    }

    public PDBfile(boolean addAlignmentAnnotations, boolean predictSecStr, boolean externalSecStr, String dataObject, DataSourceType sourceType) throws IOException {
        super(false, dataObject, sourceType);
        this.addSettings(addAlignmentAnnotations, predictSecStr, externalSecStr);
        this.doParse();
    }

    public PDBfile(boolean addAlignmentAnnotations, boolean predictSecStr, boolean externalSecStr, FileParse source) throws IOException {
        super(false, source);
        this.addSettings(addAlignmentAnnotations, predictSecStr, externalSecStr);
        this.doParse();
    }

    @Override
    public String print(SequenceI[] seqs, boolean jvSuffix) {
        return null;
    }

    @Override
    public void parse() throws IOException {
        block15: {
            this.setDbRefType("PDB");
            this.setId(this.safeName(this.getDataName()));
            this.setChains(new Vector<PDBChain>());
            ArrayList<SequenceI> rna = new ArrayList<SequenceI>();
            ArrayList<SequenceI> prot = new ArrayList<SequenceI>();
            String line = null;
            boolean modelFlag = false;
            boolean terFlag = false;
            String lastID = "";
            boolean indexx = false;
            String atomnam = null;
            try {
                while ((line = this.nextLine()) != null) {
                    if (line.indexOf("HEADER") == 0 && line.length() > 62) {
                        String tid = line.length() > 67 ? line.substring(62, 67).trim() : line.substring(62).trim();
                        if (tid.length() <= 0) continue;
                        this.setId(tid);
                        continue;
                    }
                    if (line.indexOf("SEQRES") == 0) {
                        // empty if block
                    }
                    if (line.indexOf("MODEL") == 0) {
                        modelFlag = true;
                    }
                    if (line.indexOf("TER") == 0) {
                        terFlag = true;
                    }
                    if (modelFlag && line.indexOf("ENDMDL") == 0) break;
                    if (line.indexOf("ATOM") == 0 || line.indexOf("HETATM") == 0 && !terFlag) {
                        PDBChain tmpchain;
                        terFlag = false;
                        atomnam = line.substring(12, 15).trim();
                        if (!atomnam.equals("CA") && !atomnam.equals("P")) continue;
                        Atom tmpatom = new Atom(line);
                        try {
                            tmpchain = this.findChain(tmpatom.chain);
                            if (tmpatom.resNumIns.trim().equals(lastID)) continue;
                            tmpchain.atoms.addElement(tmpatom);
                        }
                        catch (Exception e) {
                            tmpchain = new PDBChain(this.getId(), tmpatom.chain);
                            this.getChains().add(tmpchain);
                            tmpchain.atoms.addElement(tmpatom);
                        }
                        lastID = tmpatom.resNumIns.trim();
                    }
                    ++this.index;
                }
                this.makeResidueList();
                this.makeCaBondList();
                if (this.getId() == null) {
                    this.setId(this.inFile.getName());
                }
                for (PDBChain chain : this.getChains()) {
                    SequenceI chainseq = this.postProcessChain(chain);
                    if (PDBfile.isRNA(chainseq)) {
                        rna.add(chainseq);
                        continue;
                    }
                    prot.add(chainseq);
                }
                if (this.predictSecondaryStructure) {
                    this.addSecondaryStructure(rna, prot);
                }
            }
            catch (OutOfMemoryError er) {
                System.out.println("OUT OF MEMORY LOADING PDB FILE");
                throw new IOException(MessageManager.getString("exception.outofmemory_loading_pdb_file"));
            }
            catch (NumberFormatException ex) {
                if (line == null) break block15;
                System.err.println("Couldn't read number from line:");
                System.err.println(line);
            }
        }
        this.markCalcIds();
    }

    public static boolean isCalcIdHandled(String calcId) {
        return calcId != null && CALC_ID_PREFIX.equals(calcId);
    }

    public static boolean isCalcIdForFile(AlignmentAnnotation alan, String pdbFile) {
        return alan.getCalcId() != null && CALC_ID_PREFIX.equals(alan.getCalcId()) && pdbFile.equals(alan.getProperty("PDBID"));
    }

    public static String relocateCalcId(String calcId, Hashtable<String, String> alreadyLoadedPDB) throws Exception {
        int s = CALC_ID_PREFIX.length();
        int end = calcId.indexOf(CALC_ID_PREFIX, s);
        String between = calcId.substring(s, end - 1);
        return CALC_ID_PREFIX + alreadyLoadedPDB.get(between) + ":" + calcId.substring(end);
    }

    private void markCalcIds() {
        for (SequenceI sq : this.seqs) {
            if (sq.getAnnotation() == null) continue;
            for (AlignmentAnnotation aa : sq.getAnnotation()) {
                String oldId = aa.getCalcId();
                if (oldId == null) {
                    oldId = "";
                }
                aa.setCalcId(CALC_ID_PREFIX);
                aa.setProperty("PDBID", this.getId());
                aa.setProperty("oldCalcId", oldId);
            }
        }
    }
}

